# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt
from pieces._vendor.pieces_os_client.models.applet_serving_handler_type import AppletServingHandlerType
from pieces._vendor.pieces_os_client.models.application import Application
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.os_applet_enum import OSAppletEnum

class InactiveOSServerApplet(BaseModel):
    """
    Note: parent is optional here in the case that (parent here is the integration that wants the module launched(VSCode))  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    parent: Optional[Application] = None
    port: Optional[StrictInt] = Field(default=None, description="This is the port number in which we want to serve the copilot at.")
    type: OSAppletEnum = Field(...)
    handler: Optional[AppletServingHandlerType] = None
    __properties = ["schema", "parent", "port", "type", "handler"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InactiveOSServerApplet:
        """Create an instance of InactiveOSServerApplet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of parent
        if self.parent:
            _dict['parent'] = self.parent.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of handler
        if self.handler:
            _dict['handler'] = self.handler.to_dict()
        # set to None if port (nullable) is None
        # and __fields_set__ contains the field
        if self.port is None and "port" in self.__fields_set__:
            _dict['port'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InactiveOSServerApplet:
        """Create an instance of InactiveOSServerApplet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InactiveOSServerApplet.parse_obj(obj)

        _obj = InactiveOSServerApplet.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "parent": Application.from_dict(obj.get("parent")) if obj.get("parent") is not None else None,
            "port": obj.get("port"),
            "type": obj.get("type"),
            "handler": AppletServingHandlerType.from_dict(obj.get("handler")) if obj.get("handler") is not None else None
        })
        return _obj


