# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool
from pieces._vendor.pieces_os_client.models.anonymous_temporal_range import AnonymousTemporalRange
from pieces._vendor.pieces_os_client.models.classification import Classification
from pieces._vendor.pieces_os_client.models.document_contributors import DocumentContributors
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.ide_selections import IDESelections
from pieces._vendor.pieces_os_client.models.language_server_protocol import LanguageServerProtocol
from pieces._vendor.pieces_os_client.models.transferable_string import TransferableString

class IDETab(BaseModel):
    """
    This is a representation of an IDE Tab  value: is the value of the entire file(that being said we do not recomment passing this over as we can read this file on PieceOS side of things) classification: this is the classifcation of this file  selection: this is a represention of a copy/paste/selection of a bit of code  anchor: this is the file path  range: this is the duration that this user has been on this Tab  current: is a boolean that will let us know if this is the current active tab  contributors: is the people that are extracted via git  lsp: this is the languageserverprotocol this is used for may things such as error,stackstrces, mainly information extracted from the lang server  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    value: Optional[TransferableString] = None
    classification: Optional[Classification] = None
    selections: Optional[IDESelections] = None
    anchor: SeededAnchor = Field(...)
    range: Optional[AnonymousTemporalRange] = None
    current: Optional[StrictBool] = None
    contributors: Optional[DocumentContributors] = None
    lsp: Optional[LanguageServerProtocol] = None
    __properties = ["schema", "value", "classification", "selections", "anchor", "range", "current", "contributors", "lsp"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IDETab:
        """Create an instance of IDETab from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of value
        if self.value:
            _dict['value'] = self.value.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of classification
        if self.classification:
            _dict['classification'] = self.classification.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of selections
        if self.selections:
            _dict['selections'] = self.selections.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of anchor
        if self.anchor:
            _dict['anchor'] = self.anchor.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of range
        if self.range:
            _dict['range'] = self.range.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of contributors
        if self.contributors:
            _dict['contributors'] = self.contributors.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of lsp
        if self.lsp:
            _dict['lsp'] = self.lsp.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IDETab:
        """Create an instance of IDETab from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IDETab.parse_obj(obj)

        _obj = IDETab.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "value": TransferableString.from_dict(obj.get("value")) if obj.get("value") is not None else None,
            "classification": Classification.from_dict(obj.get("classification")) if obj.get("classification") is not None else None,
            "selections": IDESelections.from_dict(obj.get("selections")) if obj.get("selections") is not None else None,
            "anchor": SeededAnchor.from_dict(obj.get("anchor")) if obj.get("anchor") is not None else None,
            "range": AnonymousTemporalRange.from_dict(obj.get("range")) if obj.get("range") is not None else None,
            "current": obj.get("current"),
            "contributors": DocumentContributors.from_dict(obj.get("contributors")) if obj.get("contributors") is not None else None,
            "lsp": LanguageServerProtocol.from_dict(obj.get("lsp")) if obj.get("lsp") is not None else None
        })
        return _obj

from pieces._vendor.pieces_os_client.models.seeded_anchor import SeededAnchor
IDETab.update_forward_refs()

