# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.foundry_deployment import FoundryDeployment
from pieces._vendor.pieces_os_client.models.foundry_recommendation import FoundryRecommendation

class FoundryStatus(BaseModel):
    """
    This will get used in the Websocket and in the get request for Foundry Note:  - updating (nullable) will be used in the case an update is underway  - installing (nullable) will be used in the case an installation is underway  - updateRequired (nullable) will be used in the case an update is required  - installation (nullable) will be provided in the case Foundry is installed.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    updating: Optional[FoundryDeployment] = None
    installing: Optional[FoundryDeployment] = None
    update_required: Optional[FoundryDeployment] = Field(default=None, alias="updateRequired")
    installation: Optional[FoundryDeployment] = None
    recommendation: Optional[FoundryRecommendation] = None
    __properties = ["schema", "updating", "installing", "updateRequired", "installation", "recommendation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FoundryStatus:
        """Create an instance of FoundryStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of updating
        if self.updating:
            _dict['updating'] = self.updating.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of installing
        if self.installing:
            _dict['installing'] = self.installing.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of update_required
        if self.update_required:
            _dict['updateRequired'] = self.update_required.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of installation
        if self.installation:
            _dict['installation'] = self.installation.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of recommendation
        if self.recommendation:
            _dict['recommendation'] = self.recommendation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FoundryStatus:
        """Create an instance of FoundryStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FoundryStatus.parse_obj(obj)

        _obj = FoundryStatus.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "updating": FoundryDeployment.from_dict(obj.get("updating")) if obj.get("updating") is not None else None,
            "installing": FoundryDeployment.from_dict(obj.get("installing")) if obj.get("installing") is not None else None,
            "update_required": FoundryDeployment.from_dict(obj.get("updateRequired")) if obj.get("updateRequired") is not None else None,
            "installation": FoundryDeployment.from_dict(obj.get("installation")) if obj.get("installation") is not None else None,
            "recommendation": FoundryRecommendation.from_dict(obj.get("recommendation")) if obj.get("recommendation") is not None else None
        })
        return _obj


