# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.grouped_timestamp import GroupedTimestamp
from pieces._vendor.pieces_os_client.models.score import Score

class FlattenedRange(BaseModel):
    """
    This is a DAG-Safe minimal representation of a Range.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    id: StrictStr = Field(...)
    score: Optional[Score] = None
    created: GroupedTimestamp = Field(...)
    updated: GroupedTimestamp = Field(...)
    to: Optional[GroupedTimestamp] = None
    var_from: Optional[GroupedTimestamp] = Field(default=None, alias="from")
    between: Optional[StrictBool] = None
    summaries: Optional[FlattenedWorkstreamSummaries] = None
    conversations: Optional[FlattenedConversations] = None
    messages: Optional[FlattenedConversationMessages] = None
    __properties = ["schema", "id", "score", "created", "updated", "to", "from", "between", "summaries", "conversations", "messages"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FlattenedRange:
        """Create an instance of FlattenedRange from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of score
        if self.score:
            _dict['score'] = self.score.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of created
        if self.created:
            _dict['created'] = self.created.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of updated
        if self.updated:
            _dict['updated'] = self.updated.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of to
        if self.to:
            _dict['to'] = self.to.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of var_from
        if self.var_from:
            _dict['from'] = self.var_from.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of summaries
        if self.summaries:
            _dict['summaries'] = self.summaries.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of conversations
        if self.conversations:
            _dict['conversations'] = self.conversations.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of messages
        if self.messages:
            _dict['messages'] = self.messages.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FlattenedRange:
        """Create an instance of FlattenedRange from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FlattenedRange.parse_obj(obj)

        _obj = FlattenedRange.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "id": obj.get("id"),
            "score": Score.from_dict(obj.get("score")) if obj.get("score") is not None else None,
            "created": GroupedTimestamp.from_dict(obj.get("created")) if obj.get("created") is not None else None,
            "updated": GroupedTimestamp.from_dict(obj.get("updated")) if obj.get("updated") is not None else None,
            "to": GroupedTimestamp.from_dict(obj.get("to")) if obj.get("to") is not None else None,
            "var_from": GroupedTimestamp.from_dict(obj.get("from")) if obj.get("from") is not None else None,
            "between": obj.get("between"),
            "summaries": FlattenedWorkstreamSummaries.from_dict(obj.get("summaries")) if obj.get("summaries") is not None else None,
            "conversations": FlattenedConversations.from_dict(obj.get("conversations")) if obj.get("conversations") is not None else None,
            "messages": FlattenedConversationMessages.from_dict(obj.get("messages")) if obj.get("messages") is not None else None
        })
        return _obj

from pieces._vendor.pieces_os_client.models.flattened_conversation_messages import FlattenedConversationMessages
from pieces._vendor.pieces_os_client.models.flattened_conversations import FlattenedConversations
from pieces._vendor.pieces_os_client.models.flattened_workstream_summaries import FlattenedWorkstreamSummaries
FlattenedRange.update_forward_refs()

