# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from pieces._vendor.pieces_os_client.models.application import Application
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.flattened_user_profile import FlattenedUserProfile
from pieces._vendor.pieces_os_client.models.grouped_timestamp import GroupedTimestamp
from pieces._vendor.pieces_os_client.models.mechanism_enum import MechanismEnum

class FlattenedActivity(BaseModel):
    """
    Note: - if mechanism == internal we will not display to the user.  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    id: StrictStr = Field(...)
    created: GroupedTimestamp = Field(...)
    updated: GroupedTimestamp = Field(...)
    event: SeededConnectorTracking = Field(...)
    application: Application = Field(...)
    deleted: Optional[GroupedTimestamp] = None
    asset: Optional[ReferencedAsset] = None
    format: Optional[ReferencedFormat] = None
    user: Optional[FlattenedUserProfile] = None
    mechanism: MechanismEnum = Field(...)
    rank: Optional[StrictInt] = None
    __properties = ["schema", "id", "created", "updated", "event", "application", "deleted", "asset", "format", "user", "mechanism", "rank"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FlattenedActivity:
        """Create an instance of FlattenedActivity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of created
        if self.created:
            _dict['created'] = self.created.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of updated
        if self.updated:
            _dict['updated'] = self.updated.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of event
        if self.event:
            _dict['event'] = self.event.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of application
        if self.application:
            _dict['application'] = self.application.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of deleted
        if self.deleted:
            _dict['deleted'] = self.deleted.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of asset
        if self.asset:
            _dict['asset'] = self.asset.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of format
        if self.format:
            _dict['format'] = self.format.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FlattenedActivity:
        """Create an instance of FlattenedActivity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FlattenedActivity.parse_obj(obj)

        _obj = FlattenedActivity.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "id": obj.get("id"),
            "created": GroupedTimestamp.from_dict(obj.get("created")) if obj.get("created") is not None else None,
            "updated": GroupedTimestamp.from_dict(obj.get("updated")) if obj.get("updated") is not None else None,
            "event": SeededConnectorTracking.from_dict(obj.get("event")) if obj.get("event") is not None else None,
            "application": Application.from_dict(obj.get("application")) if obj.get("application") is not None else None,
            "deleted": GroupedTimestamp.from_dict(obj.get("deleted")) if obj.get("deleted") is not None else None,
            "asset": ReferencedAsset.from_dict(obj.get("asset")) if obj.get("asset") is not None else None,
            "format": ReferencedFormat.from_dict(obj.get("format")) if obj.get("format") is not None else None,
            "user": FlattenedUserProfile.from_dict(obj.get("user")) if obj.get("user") is not None else None,
            "mechanism": obj.get("mechanism"),
            "rank": obj.get("rank")
        })
        return _obj

from pieces._vendor.pieces_os_client.models.referenced_asset import ReferencedAsset
from pieces._vendor.pieces_os_client.models.referenced_format import ReferencedFormat
from pieces._vendor.pieces_os_client.models.seeded_connector_tracking import SeededConnectorTracking
FlattenedActivity.update_forward_refs()

