# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema
from pieces._vendor.pieces_os_client.models.grouped_timestamp import GroupedTimestamp
from pieces._vendor.pieces_os_client.models.subscription_term_enum import SubscriptionTermEnum

class DescopeUserSubscription(BaseModel):
    """
    This is the descope user subscription  # noqa: E501
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    name: StrictStr = Field(...)
    created_at: GroupedTimestamp = Field(...)
    nextbilled_at: Optional[GroupedTimestamp] = None
    paused_at: Optional[GroupedTimestamp] = None
    canceled_at: Optional[GroupedTimestamp] = None
    active: StrictBool = Field(...)
    term: SubscriptionTermEnum = Field(...)
    quantity: StrictInt = Field(...)
    subscription_id: StrictStr = Field(...)
    product_id: StrictStr = Field(...)
    price_id: StrictStr = Field(...)
    __properties = ["schema", "name", "created_at", "nextbilled_at", "paused_at", "canceled_at", "active", "term", "quantity", "subscription_id", "product_id", "price_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DescopeUserSubscription:
        """Create an instance of DescopeUserSubscription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of created_at
        if self.created_at:
            _dict['created_at'] = self.created_at.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of nextbilled_at
        if self.nextbilled_at:
            _dict['nextbilled_at'] = self.nextbilled_at.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of paused_at
        if self.paused_at:
            _dict['paused_at'] = self.paused_at.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of canceled_at
        if self.canceled_at:
            _dict['canceled_at'] = self.canceled_at.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DescopeUserSubscription:
        """Create an instance of DescopeUserSubscription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DescopeUserSubscription.parse_obj(obj)

        _obj = DescopeUserSubscription.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "name": obj.get("name"),
            "created_at": GroupedTimestamp.from_dict(obj.get("created_at")) if obj.get("created_at") is not None else None,
            "nextbilled_at": GroupedTimestamp.from_dict(obj.get("nextbilled_at")) if obj.get("nextbilled_at") is not None else None,
            "paused_at": GroupedTimestamp.from_dict(obj.get("paused_at")) if obj.get("paused_at") is not None else None,
            "canceled_at": GroupedTimestamp.from_dict(obj.get("canceled_at")) if obj.get("canceled_at") is not None else None,
            "active": obj.get("active"),
            "term": obj.get("term"),
            "quantity": obj.get("quantity"),
            "subscription_id": obj.get("subscription_id"),
            "product_id": obj.get("product_id"),
            "price_id": obj.get("price_id")
        })
        return _obj


