# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from pieces._vendor.pieces_os_client.models.anonymous_temporal_range import AnonymousTemporalRange
from pieces._vendor.pieces_os_client.models.auth0_open_ai_user_metadata import Auth0OpenAIUserMetadata
from pieces._vendor.pieces_os_client.models.auth0_user_allocation_metadata import Auth0UserAllocationMetadata
from pieces._vendor.pieces_os_client.models.descope_user_subscriptions import DescopeUserSubscriptions

class DescopeUser(BaseModel):
    """
    An object representing all of the properties that are available within a DescopeUser  # noqa: E501
    """
    user_id: StrictStr = Field(default=..., alias="userId")
    id: StrictStr = Field(default=..., description="This is the user's global id")
    given_name: StrictStr = Field(default=..., alias="givenName", description="i.e Mark")
    middle_name: Optional[StrictStr] = Field(default=None, alias="middleName", description="i.e '' or Donald")
    family_name: StrictStr = Field(default=..., alias="familyName", description="i.e Widman")
    name: Optional[StrictStr] = Field(default=None, description="i.e Mark Widman")
    email: StrictStr = Field(default=..., description="i.e brian.powell@pieces.app")
    phone: Optional[StrictStr] = Field(default=None, description="a users phone number")
    picture: Optional[StrictStr] = Field(default=None, description="the url of the users picture")
    created_time: Optional[StrictInt] = Field(default=None, alias="createdTime")
    login_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="loginIds", description="these are the ids for the social providers ie google/github")
    oauth: Optional[conlist(StrictStr)] = Field(default=None, description="these are all of the registered social providers")
    is_verified_email: Optional[StrictBool] = Field(default=None, alias="isVerifiedEmail")
    status: Optional[StrictStr] = None
    welcome_email: Optional[StrictBool] = None
    vanity: Optional[StrictStr] = None
    cloud_key: Optional[StrictStr] = None
    allocation: Optional[Auth0UserAllocationMetadata] = None
    open_ai: Optional[Auth0OpenAIUserMetadata] = None
    beta: Optional[AnonymousTemporalRange] = None
    subscriptions: Optional[DescopeUserSubscriptions] = None
    api_keys: Optional[conlist(StrictStr)] = Field(default=None, alias="apiKeys")
    __properties = ["userId", "id", "givenName", "middleName", "familyName", "name", "email", "phone", "picture", "createdTime", "loginIds", "oauth", "isVerifiedEmail", "status", "welcome_email", "vanity", "cloud_key", "allocation", "open_ai", "beta", "subscriptions", "apiKeys"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DescopeUser:
        """Create an instance of DescopeUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of allocation
        if self.allocation:
            _dict['allocation'] = self.allocation.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of open_ai
        if self.open_ai:
            _dict['open_ai'] = self.open_ai.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of beta
        if self.beta:
            _dict['beta'] = self.beta.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of subscriptions
        if self.subscriptions:
            _dict['subscriptions'] = self.subscriptions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DescopeUser:
        """Create an instance of DescopeUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DescopeUser.parse_obj(obj)

        _obj = DescopeUser.parse_obj({
            "user_id": obj.get("userId"),
            "id": obj.get("id"),
            "given_name": obj.get("givenName"),
            "middle_name": obj.get("middleName"),
            "family_name": obj.get("familyName"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "picture": obj.get("picture"),
            "created_time": obj.get("createdTime"),
            "login_ids": obj.get("loginIds"),
            "oauth": obj.get("oauth"),
            "is_verified_email": obj.get("isVerifiedEmail"),
            "status": obj.get("status"),
            "welcome_email": obj.get("welcome_email"),
            "vanity": obj.get("vanity"),
            "cloud_key": obj.get("cloud_key"),
            "allocation": Auth0UserAllocationMetadata.from_dict(obj.get("allocation")) if obj.get("allocation") is not None else None,
            "open_ai": Auth0OpenAIUserMetadata.from_dict(obj.get("open_ai")) if obj.get("open_ai") is not None else None,
            "beta": AnonymousTemporalRange.from_dict(obj.get("beta")) if obj.get("beta") is not None else None,
            "subscriptions": DescopeUserSubscriptions.from_dict(obj.get("subscriptions")) if obj.get("subscriptions") is not None else None,
            "api_keys": obj.get("apiKeys")
        })
        return _obj


