# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr
from pieces._vendor.pieces_os_client.models.asset_filter_phrase_options import AssetFilterPhraseOptions
from pieces._vendor.pieces_os_client.models.embedded_model_schema import EmbeddedModelSchema

class AssetFilterPhrase(BaseModel):
    """
    AssetFilterPhrase
    """
    var_schema: Optional[EmbeddedModelSchema] = Field(default=None, alias="schema")
    value: Optional[StrictStr] = None
    annotation: Optional[StrictBool] = None
    title: Optional[StrictBool] = None
    content: Optional[StrictBool] = None
    options: Optional[AssetFilterPhraseOptions] = None
    __properties = ["schema", "value", "annotation", "title", "content", "options"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AssetFilterPhrase:
        """Create an instance of AssetFilterPhrase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AssetFilterPhrase:
        """Create an instance of AssetFilterPhrase from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AssetFilterPhrase.parse_obj(obj)

        _obj = AssetFilterPhrase.parse_obj({
            "var_schema": EmbeddedModelSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None,
            "value": obj.get("value"),
            "annotation": obj.get("annotation"),
            "title": obj.get("title"),
            "content": obj.get("content"),
            "options": AssetFilterPhraseOptions.from_dict(obj.get("options")) if obj.get("options") is not None else None
        })
        return _obj


