# coding: utf-8

"""
    Pieces Isomorphic OpenAPI

    Endpoints for Assets, Formats, Users, Asset, Format, User.

    The version of the OpenAPI document: 1.0
    Contact: tsavo@pieces.app
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic.v1 import Field, StrictStr

from pieces._vendor.pieces_os_client.models.os_applet_enum import OSAppletEnum

from pieces._vendor.pieces_os_client.api_client import ApiClient
from pieces._vendor.pieces_os_client.api_response import ApiResponse
from pieces._vendor.pieces_os_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AppletApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def stream_applet_version(self, application : Annotated[StrictStr, Field(..., description="This is a uuid that represents an application")], applet_type : Annotated[OSAppletEnum, Field(..., description="The type of applet to stream version updates for. Must match a valid applet type name.")], **kwargs) -> str:  # noqa: E501
        """/os/applet/version/stream [WS]  # noqa: E501

        Establishes a WebSocket connection to stream real-time updates for the specified applet version based on application UUID and applet type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stream_applet_version(application, applet_type, async_req=True)
        >>> result = thread.get()

        :param application: This is a uuid that represents an application (required)
        :type application: str
        :param applet_type: The type of applet to stream version updates for. Must match a valid applet type name. (required)
        :type applet_type: OSAppletEnum
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the stream_applet_version_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.stream_applet_version_with_http_info(application, applet_type, **kwargs)  # noqa: E501

    @validate_arguments
    def stream_applet_version_with_http_info(self, application : Annotated[StrictStr, Field(..., description="This is a uuid that represents an application")], applet_type : Annotated[OSAppletEnum, Field(..., description="The type of applet to stream version updates for. Must match a valid applet type name.")], **kwargs) -> ApiResponse:  # noqa: E501
        """/os/applet/version/stream [WS]  # noqa: E501

        Establishes a WebSocket connection to stream real-time updates for the specified applet version based on application UUID and applet type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stream_applet_version_with_http_info(application, applet_type, async_req=True)
        >>> result = thread.get()

        :param application: This is a uuid that represents an application (required)
        :type application: str
        :param applet_type: The type of applet to stream version updates for. Must match a valid applet type name. (required)
        :type applet_type: OSAppletEnum
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'application',
            'applet_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stream_applet_version" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['application'] is not None:
            _path_params['application'] = _params['application']


        # process the query parameters
        _query_params = []
        if _params.get('applet_type') is not None:  # noqa: E501
            _query_params.append(('applet_type', _params['applet_type'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/websocket', 'application/json', 'text/plain'])  # noqa: E501

        # authentication setting
        _auth_settings = ['application']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "AppletOTAServerError",
            '500': "str",
        }

        return self.api_client.call_api(
            '/os/applet/version/stream', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
