# -*- coding: utf-8 -*-
# pylint: disable=missing-docstring, C0301
from dataskema import util

ES = 'es'
EN = 'en'

DEFAULT = EN

ANONYMOUS_NAME = {
    EN: "It",
    ES: "",
}
PLURAL = {
    EN: "s",
    ES: "es",
}
MORE_MESSAGES = {
    EN: "...and {total} validation error{plural}} more",
    ES: "...y {total} error{plural} más",
}


def get_more_messages(total: int) -> str:
    """
    Message for append to general validation message when more messages were found
    :param total: total messages more
    :return: message or '' if no more messages were found
    """
    if total > 0:
        params = {
            'total': str(total),
            'plural': PLURAL[DEFAULT] if total > 1 else ''
        }
        return ' ' + get_message(MORE_MESSAGES[DEFAULT], params)
    return ''


def get_message(val_message: str, val_params: dict, anonymize: bool or None = False) -> str:
    ex_message = val_message
    for (key, value) in val_params.items():
        if key == 'name':
            value = "'" + value + "'" if not anonymize else ANONYMOUS_NAME[DEFAULT]
        ex_message = util.trim(ex_message.replace('{' + key + '}', str(value)))
        ex_message = ex_message[0].upper() + ex_message[1:]
    return ex_message


VAL_ERROR_PARAM_IS_MANDATORY = {
    EN: "{name} is mandatory",
    ES: "{name} es obligatorio",
}
VAL_ERROR_PARAM_HAS_INVALID_TYPE = {
    EN: "{name} has an invalid data type",
    ES: "{name} tiene un tipo de dato no válido",
}
VAL_ERROR_PARAM_HAS_INVALID_FORMAT = {
    EN: "{name} has an invalid format",
    ES: "{name} tiene un formato no válido",
}
VAL_ERROR_PARAM_HAS_INVALID_EMAIL = {
    EN: "{name} has an invalid e-mail format",
    ES: "{name} tiene un formato de URL no válido",
}
VAL_ERROR_PARAM_HAS_INVALID_URL = {
    EN: "{name} has an invalid URL format",
    ES: "{name} tiene un formato de URL no válido",
}
VAL_ERROR_PARAM_IS_TOO_SHORT = {
    EN: "{name} is too short (min. {minsize})",
    ES: "{name} es demasiado corto (mín. {minsize})"
}
VAL_ERROR_PARAM_IS_TOO_LONG = {
    EN: "{name} is too long (max. {maxsize})",
    ES: "{name} es demasiado largo (máx. {maxsize})",
}
VAL_ERROR_PARAM_IS_TOO_SMALL = {
    EN: "{name} is too small (min. {minvalue})",
    ES: "{name} es demasiado pequeño (mín. {minvalue})",
}
VAL_ERROR_PARAM_IS_TOO_BIG = {
    EN: "{name} is too big (min. {maxvalue})",
    ES: "{name} es demasiado grande (máx. {maxvalue})",
}
VAL_ERROR_LIST_ITEM_HAS_INVALID_ELEMENT = {
    EN: "{name} has an invalid element. {message}",
    ES: "{name} tiene un elemento no váldio. {message}",
}
VAL_ERROR_PARAM_HAS_INVALID_VALUE = {
    EN: "{name} has a not valid value",
    ES: "{name} tiene un valor no válido",
}
VAL_ERROR_PARAM_HAS_TOO_MUCH_LINES = {
    EN: "{name} has too much lines (max. {maxlines} lines)",
    ES: "{name} tiene demasiadas lineas (máx. {maxlines} lineas)",
}
