# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/parameters.ipynb (unless otherwise specified).

__all__ = ['ParameterKey', 'RHO_KEY', 'HFA_KEY', 'AVG_KEY', 'TeamParameterKey', 'OffenceParameterKey',
           'DefenceParameterKey']

# Cell
import dataclasses
import typing

# Cell


@dataclasses.dataclass(frozen=True)
class ParameterKey:
    label: typing.Hashable


# Basic model constants
RHO_KEY = ParameterKey('Rho')
HFA_KEY = ParameterKey('Home-field advantage')
AVG_KEY = ParameterKey('Average rate')

# Cell


class TeamParameterKey(ParameterKey):
    """
    Parent class of `OffenceParameterKey` and `DefenceParameterKey`.

    Can be used to extract team offence/defence parameters with `isinstance`.
    """
    pass


class OffenceParameterKey(TeamParameterKey):
    """
    Team offence parameter key
    """
    pass


class DefenceParameterKey(TeamParameterKey):
    """
    Team Defence parameter key
    """
    pass