# Orange Button Python Library (pyoblib)

[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![TravisCI](https://travis-ci.com/SunSpecOrangeButton/pyoblib.svg?branch=master)]( https://travis-ci.com/SunSpecOrangeButton/pyoblib)
[![Documentation Status](https://readthedocs.org/projects/pyoblib/badge/?version=latest)](https://pyoblib.readthedocs.io/en/latest/?badge=latest)
[![codecov](https://codecov.io/gh/SunSpecOrangeButton/pyoblib/branch/master/graph/badge.svg)](https://codecov.io/gh/SunSpecOrangeButton/pyoblib)


The Orange Button Python Library, also called, pyoblib, provides functions to interact and work with the SunSpec Orange
Button Taxonomy and provides capabilities that simplify working with Orange Button data.

Full Documentation can be found at [Read the Docs](https://pyoblib.readthedocs.io/en/latest/).

## Getting Started

### Requirements

Python 3.4 - 3.6.

### Installation

For instructions on how to install, refer to the [Installation section](https://pyoblib.readthedocs.io/en/latest/overview.html#installation)
on Read the Docs.

## Contributing

Please read [CONTRIBUTING.md](CONTRIBUTING.md) for details on our code of conduct, and the process for submitting pull
requests.

## Authors

See the list of [contributors](https://github.com/SunSpecOrangeButton/pyoblib/graphs/contributors) who have participated
in this project.

## License

This project is licensed under the Apache 2.0 License - see the [LICENSE.md](LICENSE.md) file for details

## Acknowledgments

We are greatly thankful to the [contributors](https://github.com/SunSpecOrangeButton/pyoblib/graphs/contributors) of
the Orange Button Python Library for their hard work and dedication.

* The Orange Button Specification was built by several organizations in the [Orange Button Implementors Network](https://sunspec.org/thank-signing-orange-button-implementor/) with guidance by [XBRL US](https://xbrl.us/home/about/).
* Orange Button GitHub and tool accounts are supplied by [SunSpec Alliance](https://sunspec.org/sunspec-about/).
* The procedures and infrastructure for this library are based upon pvlib.  For more information see William F. Holmgren, Clifford W. Hansen, and Mark A. Mikofski. "pvlib python: a python package for modeling solar energy systems." Journal of Open Source Software, 3(29), 884, (2018). [https://doi.org/10.21105/joss.00884](https://doi.org/10.21105/joss.00884)


