# -*- coding: utf-8 -*-
"""
-------------------------------------------------
   File Name：     cache
   Description :
   Author :       艾登科技 Asdil
   date：          2020/7/9
-------------------------------------------------
   Change Activity:
                   2020/7/9:
-------------------------------------------------
"""
__author__ = 'Asdil'
import sys


class Cache:
    """
    Cache类用于懒惰加载数据, 这是全局的
    """
    def get(self, attr):
        """get方法用于取数据(类似字典)

        Parameters
        ----------
        attr : str
            需要取出的字段名
        Returns
        ----------
        """
        if attr in self.__dict__.keys():
            return self.__getattribute__(attr)
        else:
            return None

    def set(self, key, value):
        """set方法用于存储数据

        Parameters
        ----------
        key : str
            关键字
        value : anything
            需要存储的数据,任意类型
        Returns
        ----------
        """
        self.__setattr__(key, value)

    def upset(self, key, value):
        """upset方法用于插入或者更新存储数据

        Parameters
        ----------
        key : str
            关键字
        value : anything
            需要存储的数据,任意类型
        Returns
        ----------
        """
        if key in self.__dict__.keys():
            self.__dict__[key] = value
        else:
            self.__setattr__(key, value)


sys.modules[__name__] = Cache()  # 加入系统识别
