# Summary

[Introduction](introduction/overview.md)

# Foundations

- [Domain-Driven Design Principles](foundations/ddd.md)
- [Reactive Architecture](foundations/reactive.md)
- [Language Models](foundations/language-models.md)
    - [Prompt Engineering](foundations/language-models/prompt-engineering.md)
    - [In-Context Learning](foundations/language-models/in-context-learning.md)
    - [Sparse Representations](foundations/language-models/sparse-representations.md)
# System Architecture

- [Domain Model](architecture/domain-model.md)
    - [Student Modeling](architecture/student-modeling.md)
    - [Question Generation](architecture/question-generation.md)
    - [Feedback Generation](architecture/feedback-generation.md)
    - [Content Management](architecture/content-management.md)
- [Event-Driven Architecture](architecture/event-driven.md)
- [Actor Model](architecture/actor-model.md)
# Implementation

- [Project Structure](implementation/project-structure.md)
- [Domain Services](implementation/domain-services.md)
- [Application Services](implementation/application-services.md)
- [Infrastructure](implementation/infrastructure.md)
    - [Persistence](implementation/infrastructure/persistence.md)
    - [Message Brokers](implementation/infrastructure/message-brokers.md)
- [Language Model Integration](implementation/language-model-integration.md)
- [Code Generation and Automation](implementation/code-generation.md)
# Testing and Deployment

- [Unit Testing](testing/unit-testing.md)
- [Integration Testing](testing/integration-testing.md)
- [Continuous Integration and Delivery](testing/ci-cd.md)
- [Monitoring and Observability](testing/monitoring.md)
# Best Practices and Lessons Learned

- [Domain Modeling Techniques](best-practices/domain-modeling.md)
- [Collaboration Between Domain Experts and Developers](best-practices/collaboration.md)
- [Error Handling and Resilience](best-practices/error-handling.md)
- [Performance Optimization](best-practices/performance.md)
- [Future Enhancements](best-practices/future-enhancements.md)
- [Appendices](appendices/README.md)
    - [Glossary](appendices/glossary.md)
    - [Further Reading](appendices/further-reading.md)
