"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsTPSTokenBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sqs = require("aws-cdk-lib/aws-sqs");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
class StepFunctionsTPSTokenBucket extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var dynamoDBTableName;
        var dynamoDBTableID;
        var sqsQueue;
        if (!props.tokenBucketDDBTableID || !props.tokenBucketDDBTableName) {
            const dynamoDBTableClass = new dynamodb.Table(this, 'TextractConcurrencyTable', {
                partitionKey: {
                    name: 'tpsTokenBucketDefault',
                    type: dynamodb.AttributeType.NUMBER,
                },
                billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            });
            dynamoDBTableName = dynamoDBTableClass.tableName;
            dynamoDBTableID = 'tpsTokenBucketDefault';
        }
        else {
            dynamoDBTableName = props.tokenBucketDDBTableName;
            dynamoDBTableID = props.tokenBucketDDBTableID;
        }
        if (!props.sqsQueue || !props.sqsQueue) {
            // should avoid using a different SQS queue for the same token bucket
            sqsQueue = new sqs.Queue(this, 'TokenBucketQueue');
        }
        else {
            sqsQueue = props.sqsQueue;
        }
        // TODO: check on string ARN reference to existing token-bucket instead creating one each time we use this
        const tpsTokenBucketFunction = new lambda.DockerImageFunction(this, 'TokenBucketFunction', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/tokenbucket/')),
            memorySize: 128,
            environment: {
                TOKEN_LIMIT: props.tokenLimit.toString(),
                DDB_TOKEN_ID: dynamoDBTableID,
                DDB_TOKEN_TABLE: dynamoDBTableName,
            },
        });
        tpsTokenBucketFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['dynamodb:*'], resources: ['*'] }));
        const tpsTokenBucketFunctionInvoke = new tasks.LambdaInvoke(this, 'TPSTokenBucketFunction', {
            lambdaFunction: tpsTokenBucketFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(900),
            outputPath: '$.Payload',
        });
        tpsTokenBucketFunctionInvoke.addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(1),
            maxAttempts: 6,
            backoffRate: 2,
            errors: [sfn.Errors.ALL],
        });
        const sqsTokenBucketTask = new tasks.SqsSendMessage(this, 'SqsTokenBucketTask', {
            queue: sqsQueue,
            messageBody: sfn.TaskInput.fromObject({ field1: 'somedata', TaskToken: sfn.JsonPath.taskToken }),
            integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
        });
        // const workflow_chain = sfn.Chain.start(sqsTokenBucketTask);
        // // detectText.next(releaseLockClass);
        // // textractAsyncLambdaInvoke.next(releaseLockClass);
        // const stateMachine = new sfn.StateMachine(this, 'StateMachine', {
        //   definition: workflow_chain,
        //   timeout: Duration.hours(4),
        // });
        this.endStates = [sqsTokenBucketTask];
        this.startState = sqsTokenBucketTask;
    }
}
exports.StepFunctionsTPSTokenBucket = StepFunctionsTPSTokenBucket;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsTPSTokenBucket[_a] = { fqn: "schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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