import os
import logging
import json
import boto3

logger = logging.getLogger(__name__)

sqs_client = boto3.client('sqs')
dynamo_db_client = boto3.client("dynamodb")
step_functions_client = boto3.client(service_name='stepfunctions')


def lambda_handler(event, _):
    log_level = os.environ.get('LOG_LEVEL', 'INFO')
    logger.setLevel(log_level)
    logger.info(json.dumps(event))
    logger.info(f"LOG_LEVEL: {log_level} ")

    token = event['Token']
    execution_id = event['ExecutionId']

    logger.info(f"token: {token} \n \
                execution_id: {execution_id}")

    step_functions_client.send_task_success(
        taskToken=token,
        output=json.dumps(
            {'message': f'this works'}))
