"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParseTree = exports.Node = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const print_tree_structure_visitor_1 = require("./print-tree-structure-visitor");
const print_visitor_1 = require("./print-visitor");
/**
 * @stability stable
 */
class Node {
    /**
     * @stability stable
     */
    constructor(node, parent, children) {
        this._originalNode = node;
        this._nodePath = node.path;
        this._nodeId = node.id;
        if (parent) {
            this._parentNode = parent;
        }
        if (children) {
            this._childrenNodes = children;
        }
        else {
            this._childrenNodes = [];
        }
    }
    /**
     * @stability stable
     */
    set parentNode(node) {
        this._parentNode = node;
    }
    /**
     * @stability stable
     */
    get parentNode() {
        return this._parentNode;
    }
    /**
     * @stability stable
     */
    set childrenNodes(nodes) {
        this._childrenNodes = nodes;
    }
    /**
     * @stability stable
     */
    get childrenNodes() {
        return this._childrenNodes;
    }
    /**
     * @stability stable
     */
    get originalNode() {
        return this._originalNode;
    }
    /**
     * @stability stable
     */
    addChild(node) {
        this._childrenNodes.push(node);
    }
    /**
     * @stability stable
     */
    get nodePath() {
        return this._nodePath;
    }
    /**
     * @stability stable
     */
    get nodeId() {
        return this._nodeId;
    }
    /**
     * @stability stable
     */
    accept(visitor) {
        visitor.preVisit(this);
        this._childrenNodes.forEach(child => {
            child.accept(visitor);
        });
        visitor.visit(this);
        visitor.postVisit(this);
    }
}
exports.Node = Node;
_a = JSII_RTTI_SYMBOL_1;
Node[_a] = { fqn: "cdk-utilities.Node", version: "0.0.7" };
/**
 * @stability stable
 */
class ParseTree {
    /**
     * @stability stable
     */
    constructor(app) {
        app.synth();
        this._root = new Node(app.node);
        app.node.children.forEach(child => {
            this.createTree(child.node, this._root);
        });
    }
    /**
     * Create The Tree.
     *
     * @stability stable
     */
    createTree(constructNode, parent) {
        let node = new Node(constructNode, parent);
        if (parent) {
            parent.addChild(node);
        }
        constructNode.children.forEach(child => {
            this.createTree(child.node, node);
        });
    }
    /**
     * @stability stable
     */
    findPaths() {
        const printVisitor = new print_visitor_1.PrintVisitor();
        this._root.accept(printVisitor);
        return printVisitor.paths;
    }
    /**
     * @stability stable
     */
    genTreeStructure() {
        const printStructureVisitor = new print_tree_structure_visitor_1.PrintTreeStructureVisitor();
        this._root.accept(printStructureVisitor);
        return printStructureVisitor.output;
    }
}
exports.ParseTree = ParseTree;
_b = JSII_RTTI_SYMBOL_1;
ParseTree[_b] = { fqn: "cdk-utilities.ParseTree", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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