# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiKeyArgs', 'ApiKey']

@pulumi.input_type
class ApiKeyArgs:
    def __init__(__self__, *,
                 customer_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 generate_distinct_id: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 stage_keys: Optional[pulumi.Input[Sequence[pulumi.Input['ApiKeyStageKeyArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ApiKeyTagArgs']]]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApiKey resource.
        :param pulumi.Input[str] customer_id: An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
        :param pulumi.Input[str] description: A description of the purpose of the API key.
        :param pulumi.Input[bool] enabled: Indicates whether the API key can be used by clients.
        :param pulumi.Input[bool] generate_distinct_id: Specifies whether the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
        :param pulumi.Input[str] name: A name for the API key. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
        :param pulumi.Input[Sequence[pulumi.Input['ApiKeyStageKeyArgs']]] stage_keys: A list of stages to associate with this API key.
        :param pulumi.Input[Sequence[pulumi.Input['ApiKeyTagArgs']]] tags: An array of arbitrary tags (key-value pairs) to associate with the API key.
        :param pulumi.Input[str] value: The value of the API key. Must be at least 20 characters long.
        """
        if customer_id is not None:
            pulumi.set(__self__, "customer_id", customer_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if generate_distinct_id is not None:
            pulumi.set(__self__, "generate_distinct_id", generate_distinct_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stage_keys is not None:
            pulumi.set(__self__, "stage_keys", stage_keys)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> Optional[pulumi.Input[str]]:
        """
        An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
        """
        return pulumi.get(self, "customer_id")

    @customer_id.setter
    def customer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the purpose of the API key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the API key can be used by clients.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="generateDistinctId")
    def generate_distinct_id(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
        """
        return pulumi.get(self, "generate_distinct_id")

    @generate_distinct_id.setter
    def generate_distinct_id(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_distinct_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the API key. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="stageKeys")
    def stage_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiKeyStageKeyArgs']]]]:
        """
        A list of stages to associate with this API key.
        """
        return pulumi.get(self, "stage_keys")

    @stage_keys.setter
    def stage_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiKeyStageKeyArgs']]]]):
        pulumi.set(self, "stage_keys", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiKeyTagArgs']]]]:
        """
        An array of arbitrary tags (key-value pairs) to associate with the API key.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiKeyTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the API key. Must be at least 20 characters long.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class ApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 generate_distinct_id: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 stage_keys: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiKeyStageKeyArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiKeyTagArgs']]]]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ApiGateway::ApiKey

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customer_id: An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
        :param pulumi.Input[str] description: A description of the purpose of the API key.
        :param pulumi.Input[bool] enabled: Indicates whether the API key can be used by clients.
        :param pulumi.Input[bool] generate_distinct_id: Specifies whether the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
        :param pulumi.Input[str] name: A name for the API key. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiKeyStageKeyArgs']]]] stage_keys: A list of stages to associate with this API key.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiKeyTagArgs']]]] tags: An array of arbitrary tags (key-value pairs) to associate with the API key.
        :param pulumi.Input[str] value: The value of the API key. Must be at least 20 characters long.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApiKeyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ApiGateway::ApiKey

        :param str resource_name: The name of the resource.
        :param ApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 generate_distinct_id: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 stage_keys: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiKeyStageKeyArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiKeyTagArgs']]]]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiKeyArgs.__new__(ApiKeyArgs)

            __props__.__dict__["customer_id"] = customer_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["generate_distinct_id"] = generate_distinct_id
            __props__.__dict__["name"] = name
            __props__.__dict__["stage_keys"] = stage_keys
            __props__.__dict__["tags"] = tags
            __props__.__dict__["value"] = value
            __props__.__dict__["a_pi_key_id"] = None
        super(ApiKey, __self__).__init__(
            'aws-native:apigateway:ApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ApiKey':
        """
        Get an existing ApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApiKeyArgs.__new__(ApiKeyArgs)

        __props__.__dict__["a_pi_key_id"] = None
        __props__.__dict__["customer_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["generate_distinct_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["stage_keys"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["value"] = None
        return ApiKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aPIKeyId")
    def a_pi_key_id(self) -> pulumi.Output[str]:
        """
        A Unique Key ID which identifies the API Key. Generated by the Create API and returned by the Read and List APIs 
        """
        return pulumi.get(self, "a_pi_key_id")

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> pulumi.Output[Optional[str]]:
        """
        An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
        """
        return pulumi.get(self, "customer_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the purpose of the API key.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the API key can be used by clients.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="generateDistinctId")
    def generate_distinct_id(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
        """
        return pulumi.get(self, "generate_distinct_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        A name for the API key. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="stageKeys")
    def stage_keys(self) -> pulumi.Output[Optional[Sequence['outputs.ApiKeyStageKey']]]:
        """
        A list of stages to associate with this API key.
        """
        return pulumi.get(self, "stage_keys")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ApiKeyTag']]]:
        """
        An array of arbitrary tags (key-value pairs) to associate with the API key.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[str]]:
        """
        The value of the API key. Must be at least 20 characters long.
        """
        return pulumi.get(self, "value")

