# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import typing

class Bounds:
    r"""
    Bounds for element coordinates
    """
    x: builtins.float
    y: builtins.float
    width: builtins.float
    height: builtins.float
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class ClickResult:
    r"""
    Result of a click operation.
    """
    method: builtins.str
    coordinates: typing.Optional[Coordinates]
    details: builtins.str
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class CommandOutput:
    r"""
    Result of a command execution.
    """
    exit_status: typing.Optional[builtins.int]
    stdout: builtins.str
    stderr: builtins.str
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class Coordinates:
    r"""
    Coordinates for mouse operations
    """
    x: builtins.float
    y: builtins.float
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class Desktop:
    r"""
    Main entry point for desktop automation.
    """
    def __new__(cls, use_background_apps:typing.Optional[builtins.bool]=None, activate_app:typing.Optional[builtins.bool]=None, log_level:typing.Optional[builtins.str]=None) -> Desktop:
        r"""
        Create a new Desktop automation instance with configurable options.
        
        Args:
            use_background_apps (bool, optional): Enable background apps support. Defaults to False.
            activate_app (bool, optional): Enable app activation support. Defaults to False.
            log_level (str, optional): Logging level (e.g., 'info', 'debug', 'warn', 'error'). Defaults to 'info'.
        
        Returns:
            Desktop: A new Desktop automation instance.
        """
    def root(self) -> UIElement:
        r"""
        Get the root UI element of the desktop.
        
        Returns:
            UIElement: The root UI element.
        """
    def applications(self) -> builtins.list[UIElement]:
        r"""
        Get a list of all running applications.
        
        Returns:
            List[UIElement]: List of application UI elements.
        """
    def application(self, name:builtins.str) -> UIElement:
        r"""
        Get a running application by name.
        
        Args:
            name (str): The name of the application to find.
        
        Returns:
            UIElement: The application UI element.
        """
    def open_application(self, name:builtins.str) -> UIElement:
        r"""
        Open an application by name.
        
        Args:
            name (str): The name of the application to open.
        """
    def activate_application(self, name:builtins.str) -> None:
        r"""
        Activate an application by name.
        
        Args:
            name (str): The name of the application to activate.
        """
    def locator(self, selector:builtins.str) -> Locator:
        r"""
        Create a locator for finding UI elements.
        
        Args:
            selector (str): The selector string to find elements.
        
        Returns:
            Locator: A locator for finding elements.
        """
    async def run_command(self, windows_command:typing.Optional[builtins.str]=None, unix_command:typing.Optional[builtins.str]=None) -> CommandOutput:
        r"""
        (async) Run a shell command.

        Args:
            windows_command (Optional[str]): Command to run on Windows.
            unix_command (Optional[str]): Command to run on Unix.

        Returns:
            CommandOutput: The command output.
        """
    async def run(self, command:builtins.str, shell:typing.Optional[builtins.str]=None, working_directory:typing.Optional[builtins.str]=None) -> CommandOutput:
        r"""
        (async) Execute a shell command using GitHub Actions-style syntax.

        Args:
            command (str): The command to run (can be single or multi-line).
            shell (Optional[str]): Optional shell to use (defaults to PowerShell on Windows, bash on Unix).
            working_directory (Optional[str]): Optional working directory for the command.

        Returns:
            CommandOutput: The command output.
        """
    async def ocr_image_path(self, image_path:builtins.str) -> str:
        r"""
        (async) Perform OCR on an image file.
        
        Args:
            image_path (str): Path to the image file.
        
        Returns:
            str: The extracted text.
        """
    async def ocr_screenshot(self, screenshot:ScreenshotResult) -> str:
        r"""
        (async) Perform OCR on a screenshot.
        
        Args:
            screenshot (ScreenshotResult): The screenshot to process.
        
        Returns:
            str: The extracted text.
        """
    async def get_current_browser_window(self) -> UIElement:
        r"""
        (async) Get the currently focused browser window.
        
        Returns:
            UIElement: The current browser window element.
        """
    async def get_current_window(self) -> UIElement:
        r"""
        (async) Get the currently focused window.
        
        Returns:
            UIElement: The current window element.
        """
    async def get_current_application(self) -> UIElement:
        r"""
        (async) Get the currently focused application.
        
        Returns:
            UIElement: The current application element.
        """
    def open_url(self, url:builtins.str, browser:typing.Optional[builtins.str]=None) -> UIElement:
        r"""
        Open a URL in a browser.
        
        Args:
            url (str): The URL to open.
            browser (Optional[str]): The browser to use. Can be "Default", "Chrome", "Firefox", "Edge", "Brave", "Opera", "Vivaldi", "Arc", or a custom browser path.
        """
    def open_file(self, file_path:builtins.str) -> None:
        r"""
        Open a file with its default application.
        
        Args:
            file_path (str): Path to the file to open.
        """
    def activate_browser_window_by_title(self, title:builtins.str) -> None:
        r"""
        Activate a browser window by title.
        
        Args:
            title (str): The window title to match.
        """
    def focused_element(self) -> UIElement:
        r"""
        Get the currently focused element.
        
        Returns:
            UIElement: The focused element.
        """
    def get_window_tree(self, pid:builtins.int, title:typing.Optional[builtins.str]=None, config:typing.Optional[TreeBuildConfig]=None) -> UINode:
        r"""
        Get the UI tree for a window identified by process ID and optional title.
        
        Args:
            pid (int): Process ID of the target application.
            title (Optional[str]): Optional window title filter.
            config (Optional[TreeBuildConfig]): Optional configuration for tree building.
        
        Returns:
            UINode: Complete UI tree starting from the identified window.
        """
    async def list_monitors(self) -> typing.List[Monitor]:
        r"""
        (async) List all available monitors/displays.
        
        Returns:
            List[Monitor]: List of monitor information.
        """
    async def get_primary_monitor(self) -> Monitor:
        r"""
        (async) Get the primary monitor.
        
        Returns:
            Monitor: Primary monitor information.
        """
    async def get_active_monitor(self) -> Monitor:
        r"""
        (async) Get the monitor containing the currently focused window.
        
        Returns:
            Monitor: Active monitor information.
        """
    async def get_monitor_by_id(self, id:builtins.str) -> Monitor:
        r"""
        (async) Get a monitor by its ID.
        
        Args:
            id (str): The monitor ID to find.
        
        Returns:
            Monitor: Monitor information.
        """
    async def get_monitor_by_name(self, name:builtins.str) -> Monitor:
        r"""
        (async) Get a monitor by its name.
        
        Args:
            name (str): The monitor name to find.
        
        Returns:
            Monitor: Monitor information.
        """
    async def capture_monitor(self, monitor:Monitor) -> ScreenshotResult:
        r"""
        (async) Capture a screenshot of a specific monitor.
        
        Args:
            monitor (Monitor): The monitor to capture.
        
        Returns:
            ScreenshotResult: The screenshot data.
        """
    async def capture_all_monitors(self) -> typing.List[Tuple[Monitor, ScreenshotResult]]:
        r"""
        (async) Capture screenshots of all monitors.
        
        Returns:
            List[Tuple[Monitor, ScreenshotResult]]: List of monitor and screenshot pairs.
        """
    async def get_all_applications_tree(self) -> typing.List[UINode]:
        r"""
        (async) Get the UI tree for all open applications in parallel.
        
        Returns:
            List[UINode]: List of UI trees for all applications.
        """
    async def windows_for_application(self, name:builtins.str) -> typing.List[UIElement]:
        r"""
        (async) Get all window elements for a given application name.
        
        Args:
            name (str): The name of the application whose windows will be retrieved.
        
        Returns:
            List[UIElement]: A list of window elements belonging to the application.
        """
    async def press_key(self, key:builtins.str) -> None:
        r"""
        (async) Press a key globally.
        
        Args:
            key (str): The key to press (e.g., "Enter", "Ctrl+C", "F1").
        """
    async def zoom_in(self, level:builtins.int) -> None:
        r"""
        (async) Zoom in by a specified number of levels.
        
        Args:
            level (int): Number of zoom-in steps to perform.
        """
    async def zoom_out(self, level:builtins.int) -> None:
        r"""
        (async) Zoom out by a specified number of levels.
        
        Args:
            level (int): Number of zoom-out steps to perform.
        """
    async def set_zoom(self, percentage:builtins.int) -> None:
        r"""
        (async) Set the zoom level to a specific percentage.
        
        Args:
            percentage (int): The zoom percentage (e.g., 100 for 100%, 150 for 150%, 50 for 50%).
        """

class ExploreResponse:
    r"""
    Response from exploring an element
    """
    parent: UIElement
    children: builtins.list[ExploredElementDetail]
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class ExploredElementDetail:
    r"""
    Details about an explored element
    """
    role: builtins.str
    name: typing.Optional[builtins.str]
    id: typing.Optional[builtins.str]
    bounds: typing.Optional[Bounds]
    value: typing.Optional[builtins.str]
    description: typing.Optional[builtins.str]
    text: typing.Optional[builtins.str]
    parent_id: typing.Optional[builtins.str]
    children_ids: builtins.list[builtins.str]
    suggested_selector: builtins.str
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class Locator:
    r"""
    Locator for finding UI elements by selector.
    """
    async def first(self) -> UIElement:
        r"""
        (async) Get the first matching element.
        
        Returns:
            UIElement: The first matching element.
        """
    async def all(self, timeout_ms:typing.Optional[builtins.int]=None, depth:typing.Optional[builtins.int]=None) -> typing.List[UIElement]:
        r"""
        (async) Get all matching elements.
        
        Args:
            timeout_ms (Optional[int]): Timeout in milliseconds.
            depth (Optional[int]): Maximum depth to search.
        
        Returns:
            List[UIElement]: List of matching elements.
        """
    async def wait(self, timeout_ms:typing.Optional[builtins.int]=None) -> UIElement:
        r"""
        (async) Wait for the first matching element.
        
        Args:
            timeout_ms (Optional[int]): Timeout in milliseconds.
        
        Returns:
            UIElement: The first matching element.
        """
    def timeout(self, timeout_ms:builtins.int) -> Locator:
        r"""
        Set a default timeout for this locator.
        
        Args:
            timeout_ms (int): Timeout in milliseconds.
        
        Returns:
            Locator: A new locator with the specified timeout.
        """
    def locator(self, selector:builtins.str) -> Locator:
        r"""
        Chain another selector.
        
        Args:
            selector (str): The selector string.
        
        Returns:
            Locator: A new locator with the chained selector.
        """
    def within(self, element:UIElement) -> Locator:
        r"""
        Set the root element for this locator.
        
        Args:
            element (UIElement): The root element.
        
        Returns:
            Locator: A new locator with the specified root element.
        """

class Monitor:
    r"""
    Monitor/display information.
    """
    id: builtins.str
    name: builtins.str
    is_primary: builtins.bool
    width: builtins.int
    height: builtins.int
    x: builtins.int
    y: builtins.int
    scale_factor: builtins.float
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class PropertyLoadingMode:
    r"""
    Property loading strategy for tree building
    """
    mode: builtins.str
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class ScreenshotResult:
    r"""
    Result of a screenshot operation.
    """
    width: builtins.int
    height: builtins.int
    image_data: builtins.list[builtins.int]
    monitor: typing.Optional[Monitor]
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class TreeBuildConfig:
    r"""
    Configuration for tree building performance and completeness
    """
    property_mode: PropertyLoadingMode
    timeout_per_operation_ms: typing.Optional[builtins.int]
    yield_every_n_elements: typing.Optional[builtins.int]
    batch_size: typing.Optional[builtins.int]
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class UIElement:
    r"""
    Represents a UI element in the desktop UI tree.
    """
    def role(self) -> builtins.str:
        r"""
        Get the element's role (e.g., "button", "textfield").
        
        Returns:
            str: The element's role.
        """
    def name(self) -> typing.Optional[builtins.str]:
        r"""
        Get the element's name.
        
        Returns:
            Optional[str]: The element's name, if available.
        """
    def id(self) -> typing.Optional[builtins.str]:
        r"""
        Get the element's ID.
        
        Returns:
            Optional[str]: The element's ID, if available.
        """
    def attributes(self) -> UIElementAttributes:
        r"""
        Get all attributes of the element.
        
        Returns:
            UIElementAttributes: The element's attributes.
        """
    def children(self) -> builtins.list[UIElement]:
        r"""
        Get child elements.
        
        Returns:
            List[UIElement]: List of child elements.
        """
    def parent(self) -> typing.Optional[UIElement]:
        r"""
        Get parent element.
        
        Returns:
            Optional[UIElement]: The parent element, if available.
        """
    def bounds(self) -> Bounds:
        r"""
        Get element bounds (x, y, width, height).
        
        Returns:
            Bounds: The element's bounds.
        """
    def click(self) -> ClickResult:
        r"""
        Click on this element.
        
        Returns:
            ClickResult: Result of the click operation.
        """
    def double_click(self) -> ClickResult:
        r"""
        Double click on this element.
        
        Returns:
            ClickResult: Result of the click operation.
        """
    def right_click(self) -> None:
        r"""
        Right click on this element.
        
        Returns:
            None
        """
    def hover(self) -> None:
        r"""
        Hover over this element.
        
        Returns:
            None
        """
    def is_visible(self) -> builtins.bool:
        r"""
        Check if element is visible.
        
        Returns:
            bool: True if the element is visible.
        """
    def is_enabled(self) -> builtins.bool:
        r"""
        Check if element is enabled.
        
        Returns:
            bool: True if the element is enabled.
        """
    def focus(self) -> None:
        r"""
        Focus this element.
        
        Returns:
            None
        """
    def text(self, max_depth:typing.Optional[builtins.int]=None) -> builtins.str:
        r"""
        Get text content of this element.
        
        Args:
            max_depth (Optional[int]): Maximum depth to search for text.
        
        Returns:
            str: The element's text content.
        """
    def type_text(self, text:builtins.str, use_clipboard:typing.Optional[builtins.bool]=None) -> None:
        r"""
        Type text into this element.
        
        Args:
            text (str): The text to type.
            use_clipboard (Optional[bool]): Whether to use clipboard for pasting.
        
        Returns:
            None
        """
    def press_key(self, key:builtins.str) -> None:
        r"""
        Press a key while this element is focused.
        
        Args:
            key (str): The key to press.
        
        Returns:
            None
        """
    def set_value(self, value:builtins.str) -> None:
        r"""
        Set value of this element.
        
        Args:
            value (str): The value to set.
        
        Returns:
            None
        """
    def perform_action(self, action:builtins.str) -> None:
        r"""
        Perform a named action on this element.
        
        Args:
            action (str): The action to perform.
        
        Returns:
            None
        """
    def scroll(self, direction:builtins.str, amount:builtins.float) -> None:
        r"""
        Scroll the element in a given direction.
        
        Args:
            direction (str): The direction to scroll.
            amount (float): The amount to scroll.
        
        Returns:
            None
        """
    def activate_window(self) -> None:
        r"""
        Activate the window containing this element.
        
        Returns:
            None
        """
    def minimize_window(self) -> None:
        r"""
        Minimize the window containing this element.
        
        Returns:
            None
        """
    def maximize_window(self) -> None:
        r"""
        Maximize the window containing this element.
        
        Returns:
            None
        """
    def is_focused(self) -> builtins.bool:
        r"""
        Check if element is focused.
        
        Returns:
            bool: True if the element is focused.
        """
    def is_keyboard_focusable(self) -> builtins.bool:
        r"""
        Check if element is keyboard focusable.
        
        Returns:
            bool: True if the element can receive keyboard focus.
        """
    def mouse_drag(self, start_x:builtins.float, start_y:builtins.float, end_x:builtins.float, end_y:builtins.float) -> None:
        r"""
        Drag mouse from start to end coordinates.
        
        Args:
            start_x (float): Starting X coordinate.
            start_y (float): Starting Y coordinate.
            end_x (float): Ending X coordinate.
            end_y (float): Ending Y coordinate.
        
        Returns:
            None
        """
    def mouse_click_and_hold(self, x:builtins.float, y:builtins.float) -> None:
        r"""
        Press and hold mouse at coordinates.
        
        Args:
            x (float): X coordinate.
            y (float): Y coordinate.
        
        Returns:
            None
        """
    def mouse_move(self, x:builtins.float, y:builtins.float) -> None:
        r"""
        Move mouse to coordinates.
        
        Args:
            x (float): X coordinate.
            y (float): Y coordinate.
        
        Returns:
            None
        """
    def mouse_release(self) -> None:
        r"""
        Release mouse button.
        
        Returns:
            None
        """
    def application(self) -> typing.Optional[UIElement]:
        r"""
        Get the containing application element.
        
        Returns:
            Optional[UIElement]: The containing application element, if available.
        """
    def window(self) -> typing.Optional[UIElement]:
        r"""
        Get the containing window element.
        
        Returns:
            Optional[UIElement]: The containing window element, if available.
        """
    def locator(self, selector:builtins.str) -> Locator:
        r"""
        Create a locator from this element.
        
        Args:
            selector (str): The selector string.
        
        Returns:
            Locator: A new locator for finding elements.
        """
    def process_id(self) -> builtins.int:
        r"""
        Get the process ID of the application containing this element.
        
        Returns:
            int: The process ID.
        """
    def highlight(self, color:typing.Optional[builtins.int]=None, duration_ms:typing.Optional[builtins.int]=None) -> None:
        r"""
        Highlights the element with a colored border.
        
        Args:
            color (Optional[int]): BGR color code (32-bit integer). Default: 0x0000FF (red)
            duration_ms (Optional[int]): Duration in milliseconds.
        
        Returns:
            None
        """
    def capture(self) -> ScreenshotResult:
        r"""
        Capture a screenshot of this element.
        
        Returns:
            ScreenshotResult: The screenshot data containing image data and dimensions.
        """
    def set_transparency(self, percentage:builtins.int) -> None:
        r"""
        Sets the transparency of the window.
        
        Args:
            percentage (int): The transparency percentage from 0 (completely transparent) to 100 (completely opaque).
        
        Returns:
            None
        """
    def close(self) -> None:
        r"""
        Close the element if it's closable (like windows, applications).
        Does nothing for non-closable elements (like buttons, text, etc.).
        
        Returns:
            None
        """
    def monitor(self) -> Monitor:
        r"""
        Get the monitor containing this element.
        
        Returns:
            Monitor: The monitor information for the display containing this element.
        """
    def select_option(self, option_name:builtins.str) -> None:
        r"""
        Selects an option in a dropdown or combobox by its visible text.
        
        Args:
            option_name (str): The visible text of the option to select.
        
        Returns:
            None
        """
    def list_options(self) -> builtins.list[builtins.str]:
        r"""
        Lists all available option strings from a dropdown or list box.
        
        Returns:
            List[str]: List of available option strings.
        """
    def is_toggled(self) -> builtins.bool:
        r"""
        Checks if a control (like a checkbox or toggle switch) is currently toggled on.
        
        Returns:
            bool: True if the control is toggled on.
        """
    def set_toggled(self, state:builtins.bool) -> None:
        r"""
        Sets the state of a toggleable control.
        It only performs an action if the control is not already in the desired state.
        
        Args:
            state (bool): The desired toggle state.
        
        Returns:
            None
        """
    async def execute_browser_script(self, script:builtins.str) -> builtins.str:
        r"""
        Execute JavaScript in web browser using dev tools console.
        Returns the result of script execution.
        
        Args:
            script (str): The JavaScript code to execute.
        
        Returns:
            str: The result of script execution.
        """
    def url(self) -> typing.Optional[builtins.str]:
        r"""
        Get the URL if the element is in a browser window.
        
        Returns:
            Optional[str]: The URL, if available.
        """

    def get_range_value(self) -> builtins.float:
        r"""
        Gets the current value from a range-based control like a slider or progress bar.
        
        Returns:
            float: The current range value.
        """
    def set_range_value(self, value:builtins.float) -> None:
        r"""
        Sets the value of a range-based control like a slider.
        
        Args:
            value (float): The value to set.
        
        Returns:
            None
        """
    def is_selected(self) -> builtins.bool:
        r"""
        Checks if a selectable item (e.g., in a calendar, list, or tab) is currently selected.
        
        Returns:
            bool: True if the item is selected.
        """
    async def ocr(self) -> builtins.str:
        r"""
        (async) Capture a screenshot of the element and perform OCR to extract text.
        
        Returns:
            str: The extracted text from the element screenshot.
        """

class UIElementAttributes:
    r"""
    UI Element attributes
    """
    role: builtins.str
    name: typing.Optional[builtins.str]
    label: typing.Optional[builtins.str]
    value: typing.Optional[builtins.str]
    description: typing.Optional[builtins.str]
    properties: builtins.dict[builtins.str, typing.Optional[builtins.str]]
    is_keyboard_focusable: typing.Optional[builtins.bool]
    bounds: typing.Optional[Bounds]
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class UINode:
    r"""
    UI Node representing a tree structure of UI elements
    """
    id: typing.Optional[builtins.str]
    attributes: UIElementAttributes
    children: builtins.list[UINode]
    def __repr__(self) -> builtins.str: ...
    def __str__(self) -> builtins.str: ...

class ElementNotFoundError(RuntimeError): ...

class InternalError(RuntimeError): ...

class InvalidArgumentError(RuntimeError): ...

class PermissionDeniedError(RuntimeError): ...

class PlatformError(RuntimeError): ...

class TimeoutError(RuntimeError): ...

class UnsupportedOperationError(RuntimeError): ...

class UnsupportedPlatformError(RuntimeError): ...
