"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchResult = exports.Matcher = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a matcher that can perform special data matching
 * capabilities between a given pattern and a target.
 */
class Matcher {
    /**
     * Check whether the provided object is a subtype of the `IMatcher`.
     */
    static isMatcher(x) {
        return x && x instanceof Matcher;
    }
}
exports.Matcher = Matcher;
_a = JSII_RTTI_SYMBOL_1;
Matcher[_a] = { fqn: "@aws-cdk/assertions.Matcher", version: "1.175.0" };
/**
 * The result of `Match.test()`.
 */
class MatchResult {
    constructor(target) {
        this.failures = [];
        this.captures = new Map();
        this.finalized = false;
        this.target = target;
    }
    /**
     * DEPRECATED
     * @deprecated use recordFailure()
     */
    push(matcher, path, message) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/assertions.MatchResult#push", "use recordFailure()");
            jsiiDeprecationWarnings._aws_cdk_assertions_Matcher(matcher);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.push);
            }
            throw error;
        }
        return this.recordFailure({ matcher, path, message });
    }
    /**
     * Record a new failure into this result at a specific path.
     */
    recordFailure(failure) {
        try {
            jsiiDeprecationWarnings._aws_cdk_assertions_MatchFailure(failure);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.recordFailure);
            }
            throw error;
        }
        this.failures.push(failure);
        return this;
    }
    /** Does the result contain any failures. If not, the result is a success */
    hasFailed() {
        return this.failures.length !== 0;
    }
    /** The number of failures */
    get failCount() {
        return this.failures.length;
    }
    /**
     * Compose the results of a previous match as a subtree.
     * @param id the id of the parent tree.
     */
    compose(id, inner) {
        try {
            jsiiDeprecationWarnings._aws_cdk_assertions_MatchResult(inner);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.compose);
            }
            throw error;
        }
        const innerF = inner.failures;
        this.failures.push(...innerF.map(f => {
            return { path: [id, ...f.path], message: f.message, matcher: f.matcher };
        }));
        inner.captures.forEach((vals, capture) => {
            vals.forEach(value => this.recordCapture({ capture, value }));
        });
        return this;
    }
    /**
     * Prepare the result to be analyzed.
     * This API *must* be called prior to analyzing these results.
     */
    finished() {
        if (this.finalized) {
            return this;
        }
        if (this.failCount === 0) {
            this.captures.forEach((vals, cap) => cap._captured.push(...vals));
        }
        this.finalized = true;
        return this;
    }
    /**
     * Get the list of failures as human readable strings
     */
    toHumanStrings() {
        return this.failures.map(r => {
            const loc = r.path.length === 0 ? '' : ` at ${r.path.join('')}`;
            return '' + r.message + loc + ` (using ${r.matcher.name} matcher)`;
        });
    }
    /**
     * Record a capture against in this match result.
     */
    recordCapture(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_assertions_MatchCapture(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.recordCapture);
            }
            throw error;
        }
        let values = this.captures.get(options.capture);
        if (values === undefined) {
            values = [];
        }
        values.push(options.value);
        this.captures.set(options.capture, values);
    }
}
exports.MatchResult = MatchResult;
_b = JSII_RTTI_SYMBOL_1;
MatchResult[_b] = { fqn: "@aws-cdk/assertions.MatchResult", version: "1.175.0" };
//# sourceMappingURL=data:application/json;base64,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