"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.singletonSnsTopic = void 0;
const aws_sns_1 = require("@aws-cdk/aws-sns");
const aws_iam_1 = require("@aws-cdk/aws-iam");
function singletonSnsTopic(scope) {
    const id = 'MSTeamsTopic';
    const existing = scope.node.tryFindChild(id);
    if (existing) {
        return existing;
    }
    const msTeamsTopic = new aws_sns_1.Topic(scope, id);
    msTeamsTopic.grantPublish(new aws_iam_1.ServicePrincipal('codestar-notifications.amazonaws.com'));
    return msTeamsTopic;
}
exports.singletonSnsTopic = singletonSnsTopic;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsOENBQWlEO0FBQ2pELDhDQUFvRDtBQUVwRCxTQUFnQixpQkFBaUIsQ0FBQyxLQUFpQjtJQUNqRCxNQUFNLEVBQUUsR0FBRyxjQUFjLENBQUM7SUFDMUIsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFXLENBQUM7SUFDdkQsSUFBSSxRQUFRLEVBQUU7UUFDWixPQUFPLFFBQVEsQ0FBQztLQUNqQjtJQUVELE1BQU0sWUFBWSxHQUFHLElBQUksZUFBSyxDQUFDLEtBQWtCLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFFdkQsWUFBWSxDQUFDLFlBQVksQ0FDdkIsSUFBSSwwQkFBZ0IsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUM3RCxDQUFDO0lBRUYsT0FBTyxZQUFZLENBQUM7QUFDdEIsQ0FBQztBQWRELDhDQWNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSUNvbnN0cnVjdCwgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBJVG9waWMsIFRvcGljIH0gZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5pbXBvcnQgeyBTZXJ2aWNlUHJpbmNpcGFsIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5cbmV4cG9ydCBmdW5jdGlvbiBzaW5nbGV0b25TbnNUb3BpYyhzY29wZTogSUNvbnN0cnVjdCk6IElUb3BpYyB7XG4gIGNvbnN0IGlkID0gJ01TVGVhbXNUb3BpYyc7XG4gIGNvbnN0IGV4aXN0aW5nID0gc2NvcGUubm9kZS50cnlGaW5kQ2hpbGQoaWQpIGFzIElUb3BpYztcbiAgaWYgKGV4aXN0aW5nKSB7XG4gICAgcmV0dXJuIGV4aXN0aW5nO1xuICB9XG5cbiAgY29uc3QgbXNUZWFtc1RvcGljID0gbmV3IFRvcGljKHNjb3BlIGFzIENvbnN0cnVjdCwgaWQpO1xuXG4gIG1zVGVhbXNUb3BpYy5ncmFudFB1Ymxpc2goXG4gICAgbmV3IFNlcnZpY2VQcmluY2lwYWwoJ2NvZGVzdGFyLW5vdGlmaWNhdGlvbnMuYW1hem9uYXdzLmNvbScpLFxuICApO1xuXG4gIHJldHVybiBtc1RlYW1zVG9waWM7XG59XG4iXX0=