"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetType = exports.MSTeamsIncomingWebhook = exports.SlackChannel = exports.SnsTopic = void 0;
const aws_sns_1 = require("@aws-cdk/aws-sns");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
class SnsTopic {
    constructor(topic) {
        this.topic = topic;
    }
    bind(_scope, _rule) {
        this.topic.grantPublish(new aws_iam_1.ServicePrincipal('codestar-notifications.amazonaws.com'));
        return {
            targetType: TargetType.SNS,
            targetAddress: this.topic.topicArn,
        };
    }
}
exports.SnsTopic = SnsTopic;
class SlackChannel {
    constructor(channel) {
        this.channel = channel;
    }
    bind(_scope, _rule) {
        return {
            targetType: TargetType.AWS_CHATBOT_SLACK,
            targetAddress: this.channel.configurationArn,
        };
    }
}
exports.SlackChannel = SlackChannel;
class MSTeamsIncomingWebhook {
    constructor(webhook) {
        this.webhook = webhook;
    }
    bind(scope, _rule) {
        const msTeamsTopic = new aws_sns_1.Topic(scope, `${scope.node.id}MSTeamsTopic`);
        msTeamsTopic.grantPublish(new aws_iam_1.ServicePrincipal('codestar-notifications.amazonaws.com'));
        this.webhook.addEventSource(new aws_lambda_event_sources_1.SnsEventSource(msTeamsTopic));
        return {
            targetType: TargetType.SNS,
            targetAddress: msTeamsTopic.topicArn,
        };
    }
}
exports.MSTeamsIncomingWebhook = MSTeamsIncomingWebhook;
var TargetType;
(function (TargetType) {
    TargetType["SNS"] = "SNS";
    TargetType["AWS_CHATBOT_SLACK"] = "AWSChatbotSlack";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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