import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HostSetStaticConfig extends cdktf.TerraformMetaArguments {
    /**
    * The host set description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_static#description HostSetStatic#description}
    */
    readonly description?: string;
    /**
    * The catalog for the host set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_static#host_catalog_id HostSetStatic#host_catalog_id}
    */
    readonly hostCatalogId: string;
    /**
    * The list of host IDs contained in this set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_static#host_ids HostSetStatic#host_ids}
    */
    readonly hostIds?: string[];
    /**
    * The host set name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_static#name HostSetStatic#name}
    */
    readonly name?: string;
    /**
    * The type of host set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_static#type HostSetStatic#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/host_set_static boundary_host_set_static}
*/
export declare class HostSetStatic extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_host_set_static";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/host_set_static boundary_host_set_static} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostSetStaticConfig
    */
    constructor(scope: Construct, id: string, config: HostSetStaticConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hostCatalogId?;
    get hostCatalogId(): string;
    set hostCatalogId(value: string);
    get hostCatalogIdInput(): string | undefined;
    private _hostIds?;
    get hostIds(): string[];
    set hostIds(value: string[]);
    resetHostIds(): void;
    get hostIdsInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
