import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HostSetPluginConfig extends cdktf.TerraformMetaArguments {
    /**
    * The attributes for the host set. Either values encoded with the "jsonencode" function, pre-escaped JSON string, or a file:// or env:// path. Set to a string "null" or remove the block to clear all attributes in the host set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_plugin#attributes_json HostSetPlugin#attributes_json}
    */
    readonly attributesJson?: string;
    /**
    * The host set description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_plugin#description HostSetPlugin#description}
    */
    readonly description?: string;
    /**
    * The catalog for the host set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_plugin#host_catalog_id HostSetPlugin#host_catalog_id}
    */
    readonly hostCatalogId: string;
    /**
    * The host set name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_plugin#name HostSetPlugin#name}
    */
    readonly name?: string;
    /**
    * The ordered list of preferred endpoints.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_plugin#preferred_endpoints HostSetPlugin#preferred_endpoints}
    */
    readonly preferredEndpoints?: string[];
    /**
    * The value to set for the sync interval seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_plugin#sync_interval_seconds HostSetPlugin#sync_interval_seconds}
    */
    readonly syncIntervalSeconds?: number;
    /**
    * The type of host set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/host_set_plugin#type HostSetPlugin#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/host_set_plugin boundary_host_set_plugin}
*/
export declare class HostSetPlugin extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_host_set_plugin";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/host_set_plugin boundary_host_set_plugin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostSetPluginConfig
    */
    constructor(scope: Construct, id: string, config: HostSetPluginConfig);
    private _attributesJson?;
    get attributesJson(): string;
    set attributesJson(value: string);
    resetAttributesJson(): void;
    get attributesJsonInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hostCatalogId?;
    get hostCatalogId(): string;
    set hostCatalogId(value: string);
    get hostCatalogIdInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _preferredEndpoints?;
    get preferredEndpoints(): string[];
    set preferredEndpoints(value: string[]);
    resetPreferredEndpoints(): void;
    get preferredEndpointsInput(): string[] | undefined;
    private _syncIntervalSeconds?;
    get syncIntervalSeconds(): number;
    set syncIntervalSeconds(value: number);
    resetSyncIntervalSeconds(): void;
    get syncIntervalSecondsInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
