import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * The auth method description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method#description AuthMethod#description}
    */
    readonly description?: string;
    /**
    * The minimum login name length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method#min_login_name_length AuthMethod#min_login_name_length}
    */
    readonly minLoginNameLength?: number;
    /**
    * The minimum password length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method#min_password_length AuthMethod#min_password_length}
    */
    readonly minPasswordLength?: number;
    /**
    * The auth method name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method#name AuthMethod#name}
    */
    readonly name?: string;
    /**
    * The scope ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method#scope_id AuthMethod#scope_id}
    */
    readonly scopeId: string;
    /**
    * The resource type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method#type AuthMethod#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/auth_method boundary_auth_method}
*/
export declare class AuthMethod extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_auth_method";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/auth_method boundary_auth_method} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _minLoginNameLength?;
    get minLoginNameLength(): number;
    set minLoginNameLength(value: number);
    resetMinLoginNameLength(): void;
    get minLoginNameLengthInput(): number | undefined;
    private _minPasswordLength?;
    get minPasswordLength(): number;
    set minPasswordLength(value: number);
    resetMinPasswordLength(): void;
    get minPasswordLengthInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
