VERSION = (2, 0, 0)
PRERELEASE = "beta"  # "alpha", "beta" or "rc"
REVISION = 1


def generate_version(version, prerelease=None, revision=None):
    version_parts = [".".join(map(str, version))]
    if prerelease is not None:
        version_parts.append("-{}".format(prerelease))
    if revision is not None:
        version_parts.append(".{}".format(revision))
    return "".join(version_parts)


__title__ = "ExtractTable"
__description__ = "Extract tabular data from images and scanned PDFs. Easily convert image to table, convert pdf to table"
__url__ = "https://github.com/ExtractTable/ExtractTable-py"
__version__ = generate_version(VERSION, prerelease=PRERELEASE, revision=REVISION)
__author__ = "Saradhi"
__author_email__ = "saradhi@extracttable.com"
__license__ = "Apache License 2.0"
