"""Initial migration

Revision ID: 839d46550586
Revises:
Create Date: 2025-05-08 15:40:43.515197

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "839d46550586"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "datafile",
        sa.Column("account_uuid", sa.Uuid(), nullable=False),
        sa.Column("file_id", sa.Uuid(), nullable=False),
        sa.Column("content_type", sa.String(), nullable=True),
        sa.Column("recorded_at", sa.DateTime(), nullable=False),
        sa.Column("media_frame_index", sa.Integer(), nullable=False),
        sa.Column("original_source_url", sa.String(), nullable=True),
        sa.Column("file_hash", sa.String(), nullable=True),
        sa.Column("data_source_uuid", sa.Uuid(), nullable=False),
        sa.ForeignKeyConstraint(
            ["data_source_uuid"],
            ["datasource.uuid"],
        ),
        sa.PrimaryKeyConstraint("file_id"),
    )
    op.create_index(op.f("ix_datafile_account_uuid"), "datafile", ["account_uuid"], unique=False)
    op.create_table(
        "datafilesource",
        sa.Column("account_uuid", sa.Uuid(), nullable=False),
        sa.Column("id", sa.String(), nullable=False),
        sa.Column("url", sa.String(), nullable=False),
        sa.Column("payload", sa.String(), nullable=False),
        sa.Column("path_to_response_file", sa.String(), nullable=False),
        sa.Column("request_hash", sa.String(), nullable=False),
        sa.Column("data_file_id", sa.Uuid(), nullable=True),
        sa.ForeignKeyConstraint(
            ["data_file_id"],
            ["datafile.file_id"],
        ),
        sa.PrimaryKeyConstraint("id", "url", "payload", "path_to_response_file", "request_hash"),
    )
    op.create_index(op.f("ix_datafilesource_account_uuid"), "datafilesource", ["account_uuid"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_datafilesource_account_uuid"), table_name="datafilesource")
    op.drop_table("datafilesource")
    op.drop_index(op.f("ix_datafile_account_uuid"), table_name="datafile")
    op.drop_table("datafile")
    # ### end Alembic commands ###
