"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * (experimental) Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @experimental
 */
class AwsLoadBalancerController extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super(scope, id);
        this.serviceAccountName = (_b = options === null || options === void 0 ? void 0 : options.serviceAccountName) !== null && _b !== void 0 ? _b : 'aws-load-balancer-controller';
        this.deploymentName = 'aws-load-balancer-controller';
        this.clusterName = options.clusterName;
        this.namespace = (_c = options === null || options === void 0 ? void 0 : options.namespace) !== null && _c !== void 0 ? _c : 'kube-system';
        this.createServiceAccount = (_d = options === null || options === void 0 ? void 0 : options.createServiceAccount) !== null && _d !== void 0 ? _d : true;
        this.certManager = (_e = options === null || options === void 0 ? void 0 : options.certManager) !== null && _e !== void 0 ? _e : true;
        if (this.certManager === true) {
            new cdk8s.Include(this, 'certificate-manager', {
                url: 'https://github.com/jetstack/cert-manager/releases/download/v1.1.1/cert-manager.yaml',
            });
            new k8s.KubeMutatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-webhook', {
                metadata: {
                    annotations: {
                        'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert',
                    },
                    labels: {
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    name: 'aws-load-balancer-webhook',
                },
                webhooks: [
                    {
                        clientConfig: {
                            caBundle: 'Cg==',
                            service: {
                                name: 'aws-load-balancer-webhook-service',
                                namespace: this.namespace,
                                path: '/mutate-v1-pod',
                            },
                        },
                        failurePolicy: 'Fail',
                        name: 'mpod.elbv2.k8s.aws',
                        namespaceSelector: {
                            matchExpressions: [
                                {
                                    key: 'elbv2.k8s.aws/pod-readiness-gate-inject',
                                    operator: 'In',
                                    values: ['enabled'],
                                },
                            ],
                        },
                        rules: [{
                                apiGroups: [''],
                                apiVersions: ['v1'],
                                operations: [
                                    'CREATE',
                                ],
                                resources: ['pods'],
                            }],
                        sideEffects: 'None',
                    },
                    {
                        clientConfig: {
                            caBundle: 'Cg==',
                            service: {
                                name: 'aws-load-balancer-webhook-service',
                                namespace: this.namespace,
                                path: '/mutate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                            },
                        },
                        failurePolicy: 'Fail',
                        name: 'mtargetgroupbinding.elbv2.k8s.aws',
                        rules: [{
                                apiGroups: ['elbv2.k8s.aws'],
                                apiVersions: ['v1beta1'],
                                operations: [
                                    'CREATE',
                                    'UPDATE',
                                ],
                                resources: ['targetgroupbindings'],
                            }],
                        sideEffects: 'None',
                    },
                ],
            });
            new k8s.KubeDeployment(this, 'aws-load-balancer-controller-deployment', {
                metadata: {
                    labels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    namespace: this.namespace,
                    name: this.deploymentName,
                },
                spec: {
                    replicas: (_f = options === null || options === void 0 ? void 0 : options.replicas) !== null && _f !== void 0 ? _f : 1,
                    selector: {
                        matchLabels: {
                            'app.kubernetes.io/component': 'controller',
                            'app.kubernetes.io/name': this.serviceAccountName,
                            ...options.labels,
                        },
                    },
                    template: {
                        metadata: {
                            labels: {
                                'app.kubernetes.io/component': 'controller',
                                'app.kubernetes.io/name': this.serviceAccountName,
                                ...options.labels,
                            },
                        },
                        spec: {
                            containers: [{
                                    name: 'controller',
                                    image: (_g = options === null || options === void 0 ? void 0 : options.image) !== null && _g !== void 0 ? _g : 'amazon/aws-alb-ingress-controller:v2.1.3',
                                    args: this.argsFunc(options.args),
                                    env: this.envFunc(options.env),
                                    livenessProbe: {
                                        failureThreshold: 2,
                                        httpGet: {
                                            path: '/healthz',
                                            port: 61779,
                                            scheme: 'HTTP',
                                        },
                                        initialDelaySeconds: 30,
                                        timeoutSeconds: 10,
                                    },
                                    ports: [
                                        {
                                            containerPort: 9443,
                                            name: 'webhook-server',
                                            protocol: 'TCP',
                                        },
                                    ],
                                    resources: {
                                        limits: {
                                            cpu: '200m',
                                            memory: '500Mi',
                                        },
                                        requests: {
                                            cpu: '100m',
                                            memory: '200Mi',
                                        },
                                    },
                                    securityContext: {
                                        allowPrivilegeEscalation: false,
                                        readOnlyRootFilesystem: true,
                                        runAsNonRoot: true,
                                    },
                                    volumeMounts: [
                                        {
                                            mountPath: '/tmp/k8s-webhook-server/serving-certs',
                                            name: 'cert',
                                            readOnly: true,
                                        },
                                    ],
                                }],
                            securityContext: {
                                fsGroup: 1337,
                            },
                            serviceAccountName: `${this.serviceAccountName}`,
                            terminationGracePeriodSeconds: 10,
                            volumes: [{
                                    name: 'cert',
                                    secret: {
                                        defaultMode: 420,
                                        secretName: 'aws-load-balancer-webhook-tls',
                                    },
                                }],
                        },
                    },
                },
            });
            new cdk8s.ApiObject(this, 'aws-load-balancer-serving-cert', {
                apiVersion: 'cert-manager.io/v1alpha2',
                kind: 'Certificate',
                metadata: {
                    labels: {
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    name: 'aws-load-balancer-serving-cert',
                    namespace: this.namespace,
                },
                spec: {
                    dnsNames: [
                        'aws-load-balancer-webhook-service.kube-system.svc',
                        'aws-load-balancer-webhook-service.kube-system.svc.cluster.local',
                    ],
                    issuerRef: {
                        kind: 'Issuer',
                        name: 'aws-load-balancer-selfsigned-issuer',
                    },
                    secretName: 'aws-load-balancer-webhook-tls',
                },
            });
            new cdk8s.ApiObject(this, 'aws-load-balancer-selfsigned-issuer', {
                apiVersion: 'cert-manager.io/v1alpha2',
                kind: 'Issuer',
                metadata: {
                    labels: {
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    name: 'aws-load-balancer-selfsigned-issuer',
                    namespace: this.namespace,
                },
                spec: {
                    selfSigned: {},
                },
            });
            new k8s.KubeValidatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-selfsigned-issuer-valid', {
                metadata: {
                    annotations: {
                        'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert',
                    },
                    labels: {
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    name: 'aws-load-balancer-webhook',
                },
                webhooks: [
                    {
                        clientConfig: {
                            caBundle: 'Cg==',
                            service: {
                                name: 'aws-load-balancer-webhook-service',
                                namespace: this.namespace,
                                path: '/validate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                            },
                        },
                        failurePolicy: 'Fail',
                        name: 'vtargetgroupbinding.elbv2.k8s.aws',
                        rules: [{
                                apiGroups: ['elbv2.k8s.aws'],
                                apiVersions: ['v1beta1'],
                                operations: [
                                    'CREATE',
                                    'UPDATE',
                                ],
                                resources: ['targetgroupbindings'],
                            }],
                        sideEffects: 'None',
                    },
                ],
            });
        }
        else {
            new k8s.KubeDeployment(this, 'aws-load-balancer-controller-deployment', {
                metadata: {
                    labels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    namespace: this.namespace,
                    name: this.deploymentName,
                },
                spec: {
                    replicas: (_h = options === null || options === void 0 ? void 0 : options.replicas) !== null && _h !== void 0 ? _h : 1,
                    selector: {
                        matchLabels: {
                            'app.kubernetes.io/component': 'controller',
                            'app.kubernetes.io/name': this.serviceAccountName,
                            ...options.labels,
                        },
                    },
                    template: {
                        metadata: {
                            labels: {
                                'app.kubernetes.io/component': 'controller',
                                'app.kubernetes.io/name': this.serviceAccountName,
                                ...options.labels,
                            },
                        },
                        spec: {
                            containers: [{
                                    name: 'controller',
                                    image: (_j = options === null || options === void 0 ? void 0 : options.image) !== null && _j !== void 0 ? _j : 'amazon/aws-alb-ingress-controller:v2.1.3',
                                    args: this.argsFunc(options.args),
                                    env: this.envFunc(options.env),
                                    livenessProbe: {
                                        failureThreshold: 2,
                                        httpGet: {
                                            path: '/healthz',
                                            port: 61779,
                                            scheme: 'HTTP',
                                        },
                                        initialDelaySeconds: 30,
                                        timeoutSeconds: 10,
                                    },
                                    ports: [
                                        {
                                            containerPort: 9443,
                                            name: 'webhook-server',
                                            protocol: 'TCP',
                                        },
                                    ],
                                    resources: {
                                        limits: {
                                            cpu: '200m',
                                            memory: '500Mi',
                                        },
                                        requests: {
                                            cpu: '100m',
                                            memory: '200Mi',
                                        },
                                    },
                                    securityContext: {
                                        allowPrivilegeEscalation: false,
                                        readOnlyRootFilesystem: true,
                                        runAsNonRoot: true,
                                    },
                                }],
                            securityContext: {
                                fsGroup: 1337,
                            },
                            serviceAccountName: `${this.serviceAccountName}`,
                            terminationGracePeriodSeconds: 10,
                        },
                    },
                },
            });
        }
        new cdk8s.ApiObject(this, 'aws-load-balancer-controller-crd', {
            apiVersion: 'apiextensions.k8s.io/v1beta1',
            kind: 'CustomResourceDefinition',
            metadata: {
                annotations: {
                    'controller-gen.kubebuilder.io/version': 'v0.4.0',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
                name: 'targetgroupbindings.elbv2.k8s.aws',
            },
            spec: {
                additionalPrinterColumns: [
                    {
                        JSONPath: '.spec.serviceRef.name',
                        description: "The Kubernetes Service's name",
                        name: 'SERVICE-NAME',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.serviceRef.port',
                        description: "The Kubernetes Service's port",
                        name: 'SERVICE-PORT',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.targetType',
                        description: "The AWS TargetGroup's TargetType",
                        name: 'TARGET-TYPE',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.targetGroupARN',
                        description: "The AWS TargetGroup's Amazon Resource Name",
                        name: 'ARN',
                        priority: 1,
                        type: 'string',
                    },
                    {
                        JSONPath: '.metadata.creationTimestamp',
                        name: 'AGE',
                        type: 'date',
                    },
                ],
                group: 'elbv2.k8s.aws',
                names: {
                    categories: [
                        'all',
                    ],
                    kind: 'TargetGroupBinding',
                    listKind: 'TargetGroupBindingList',
                    plural: 'targetgroupbindings',
                    singular: 'targetgroupbinding',
                },
                scope: 'Namespaced',
                subresources: {
                    status: {},
                },
                validation: {
                    openAPIV3Schema: {
                        description: 'TargetGroupBinding is the Schema for the TargetGroupBinding API',
                        properties: {
                            apiVersion: {
                                description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                type: 'string',
                            },
                            kind: {
                                description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                type: 'string',
                            },
                            metadata: {
                                type: 'object',
                            },
                            spec: {
                                description: 'TargetGroupBindingSpec defines the desired state of TargetGroupBinding',
                                properties: {
                                    networking: {
                                        description: 'networking provides the networking setup for ELBV2 LoadBalancer to access targets in TargetGroup.',
                                        properties: {
                                            ingress: {
                                                description: 'List of ingress rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                items: {
                                                    properties: {
                                                        from: {
                                                            description: 'List of peers which should be able to access the targets in TargetGroup. At least one NetworkingPeer should be specified.',
                                                            items: {
                                                                description: 'NetworkingPeer defines the source/destination peer for networking rules.',
                                                                properties: {
                                                                    ipBlock: {
                                                                        description: 'IPBlock defines an IPBlock peer. If specified, none of the other fields can be set.',
                                                                        properties: {
                                                                            cidr: {
                                                                                description: 'CIDR is the network CIDR. Both IPV4 or IPV6 CIDR are accepted.',
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        required: [
                                                                            'cidr',
                                                                        ],
                                                                        type: 'object',
                                                                    },
                                                                    securityGroup: {
                                                                        description: 'SecurityGroup defines a SecurityGroup peer. If specified, none of the other fields can be set.',
                                                                        properties: {
                                                                            groupID: {
                                                                                description: 'GroupID is the EC2 SecurityGroupID.',
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        required: [
                                                                            'groupID',
                                                                        ],
                                                                        type: 'object',
                                                                    },
                                                                },
                                                                type: 'object',
                                                            },
                                                            type: 'array',
                                                        },
                                                        ports: {
                                                            description: 'List of ports which should be made accessible on the targets in TargetGroup. If ports is empty or unspecified, it defaults to all ports with TCP.',
                                                            items: {
                                                                properties: {
                                                                    port: {
                                                                        'anyOf': [
                                                                            {
                                                                                type: 'integer',
                                                                            },
                                                                            {
                                                                                type: 'string',
                                                                            },
                                                                        ],
                                                                        'description': 'The port which traffic must match. When NodePort endpoints(instance TargetType) is used, this must be a numerical port. When Port endpoints(ip TargetType) is used, this can be either numerical or named port on pods. if port is unspecified, it defaults to all ports.',
                                                                        'x-kubernetes-int-or-string': true,
                                                                    },
                                                                    protocol: {
                                                                        description: 'The protocol which traffic must match. If protocol is unspecified, it defaults to TCP.',
                                                                        enum: [
                                                                            'TCP',
                                                                            'UDP',
                                                                        ],
                                                                        type: 'string',
                                                                    },
                                                                },
                                                                type: 'object',
                                                            },
                                                            type: 'array',
                                                        },
                                                    },
                                                    required: [
                                                        'from',
                                                        'ports',
                                                    ],
                                                    type: 'object',
                                                },
                                                type: 'array',
                                            },
                                        },
                                        type: 'object',
                                    },
                                    serviceRef: {
                                        description: 'serviceRef is a reference to a Kubernetes Service and ServicePort.',
                                        properties: {
                                            name: {
                                                description: 'Name is the name of the Service.',
                                                type: 'string',
                                            },
                                            port: {
                                                'anyOf': [
                                                    {
                                                        type: 'integer',
                                                    },
                                                    {
                                                        type: 'string',
                                                    },
                                                ],
                                                'description': 'Port is the port of the ServicePort.',
                                                'x-kubernetes-int-or-string': true,
                                            },
                                        },
                                        required: [
                                            'name',
                                            'port',
                                        ],
                                        type: 'object',
                                    },
                                    targetGroupARN: {
                                        description: 'targetGroupARN is the Amazon Resource Name (ARN) for the TargetGroup.',
                                        type: 'string',
                                    },
                                    targetType: {
                                        description: 'targetType is the TargetType of TargetGroup. If unspecified, it will be automatically inferred.',
                                        enum: [
                                            'instance',
                                            'ip',
                                        ],
                                        type: 'string',
                                    },
                                },
                                required: [
                                    'serviceRef',
                                    'targetGroupARN',
                                ],
                                type: 'object',
                            },
                            status: {
                                description: 'TargetGroupBindingStatus defines the observed state of TargetGroupBinding',
                                properties: {
                                    observedGeneration: {
                                        description: 'The generation observed by the TargetGroupBinding controller.',
                                        format: 'int64',
                                        type: 'integer',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        type: 'object',
                    },
                },
                version: 'v1alpha1',
                versions: [
                    {
                        name: 'v1alpha1',
                        served: true,
                        storage: false,
                    },
                    {
                        name: 'v1beta1',
                        served: true,
                        storage: true,
                    },
                ],
            },
            status: {
                acceptedNames: {
                    kind: '',
                    plural: '',
                },
                conditions: [],
                storedVersions: [],
            },
        });
        if (options.createServiceAccount === true) {
            new k8s.KubeServiceAccount(this, 'aws-load-balancer-controller-sa', {
                metadata: {
                    labels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            });
        }
        new k8s.KubeRole(this, 'aws-load-balancer-controller-leader-election-role', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-role',
                namespace: this.namespace,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    verbs: ['create'],
                }, {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    resourceNames: ['aws-load-balancer-controller-leader'],
                    verbs: ['get', 'update', 'patch'],
                },
            ],
        });
        new k8s.KubeClusterRole(this, 'aws-load-balancer-controller-cluster-role', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: `${this.serviceAccountName}-role`,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['endpoints'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['events'],
                    verbs: ['create', 'patch'],
                },
                {
                    apiGroups: [''],
                    resources: ['namespaces'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['nodes'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['pods'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: [''],
                    resources: ['secrets'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['services'],
                    verbs: ['get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: [''],
                    resources: ['services/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings'],
                    verbs: ['create', 'delete', 'get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses'],
                    verbs: ['get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses/status'],
                    verbs: ['patch', 'update'],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses'],
                    verbs: ['get', 'list', 'patch', 'update', 'watch'],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingressclasses'],
                    verbs: ['get', 'list', 'watch'],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses/status'],
                    verbs: ['patch', 'update'],
                },
            ],
        });
        new k8s.KubeRoleBinding(this, 'aws-load-balancer-controller-leader-election-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-rolebinding',
                namespace: this.namespace,
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'Role',
                name: 'aws-load-balancer-controller-leader-election-role',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new k8s.KubeClusterRoleBinding(this, 'aws-load-balancer-controller-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-rolebinding',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: `${this.serviceAccountName}-role`,
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    namespace: this.namespace,
                    name: this.serviceAccountName,
                },
            ],
        });
        new k8s.KubeService(this, 'aws-load-balancer-webhook-service', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook-service',
                namespace: this.namespace,
            },
            spec: {
                ports: [
                    {
                        port: 443,
                        targetPort: 9443,
                    },
                ],
                selector: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
            },
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--ingress-class=alb', `--cluster-name=${this.clusterName}`];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
    envFunc(envSet) {
        return envSet;
    }
}
exports.AwsLoadBalancerController = AwsLoadBalancerController;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerController[_a] = { fqn: "@opencdk8s/cdk8s-aws-lb-controller.AwsLoadBalancerController", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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