"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
SPDX-License-Identifier: Apache-2.0"""
import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
from ... import substrait
import sys
import typing
if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AggregationPhase:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AggregationPhaseEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AggregationPhase.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AGGREGATION_PHASE_UNSPECIFIED: _AggregationPhase.ValueType
    'Implies `INTERMEDIATE_TO_RESULT`.'
    AGGREGATION_PHASE_INITIAL_TO_INTERMEDIATE: _AggregationPhase.ValueType
    'Specifies that the function should be run only up to the point of\n    generating an intermediate value, to be further aggregated later using\n    INTERMEDIATE_TO_INTERMEDIATE or INTERMEDIATE_TO_RESULT.\n    '
    AGGREGATION_PHASE_INTERMEDIATE_TO_INTERMEDIATE: _AggregationPhase.ValueType
    'Specifies that the inputs of the aggregate or window function are the\n    intermediate values of the function, and that the output should also be\n    an intermediate value, to be further aggregated later using\n    INTERMEDIATE_TO_INTERMEDIATE or INTERMEDIATE_TO_RESULT.\n    '
    AGGREGATION_PHASE_INITIAL_TO_RESULT: _AggregationPhase.ValueType
    'A complete invocation: the function should aggregate the given set of\n    inputs to yield a single return value. This style must be used for\n    aggregate or window functions that are not decomposable.\n    '
    AGGREGATION_PHASE_INTERMEDIATE_TO_RESULT: _AggregationPhase.ValueType
    'Specifies that the inputs of the aggregate or window function are the\n    intermediate values of the function, generated previously using\n    INITIAL_TO_INTERMEDIATE and possibly INTERMEDIATE_TO_INTERMEDIATE calls.\n    This call should combine the intermediate values to yield the final\n    return value.\n    '

class AggregationPhase(_AggregationPhase, metaclass=_AggregationPhaseEnumTypeWrapper):
    """Describes which part of an aggregation or window function to perform within
    the context of distributed algorithms.
    """
AGGREGATION_PHASE_UNSPECIFIED: AggregationPhase.ValueType
'Implies `INTERMEDIATE_TO_RESULT`.'
AGGREGATION_PHASE_INITIAL_TO_INTERMEDIATE: AggregationPhase.ValueType
'Specifies that the function should be run only up to the point of\ngenerating an intermediate value, to be further aggregated later using\nINTERMEDIATE_TO_INTERMEDIATE or INTERMEDIATE_TO_RESULT.\n'
AGGREGATION_PHASE_INTERMEDIATE_TO_INTERMEDIATE: AggregationPhase.ValueType
'Specifies that the inputs of the aggregate or window function are the\nintermediate values of the function, and that the output should also be\nan intermediate value, to be further aggregated later using\nINTERMEDIATE_TO_INTERMEDIATE or INTERMEDIATE_TO_RESULT.\n'
AGGREGATION_PHASE_INITIAL_TO_RESULT: AggregationPhase.ValueType
'A complete invocation: the function should aggregate the given set of\ninputs to yield a single return value. This style must be used for\naggregate or window functions that are not decomposable.\n'
AGGREGATION_PHASE_INTERMEDIATE_TO_RESULT: AggregationPhase.ValueType
'Specifies that the inputs of the aggregate or window function are the\nintermediate values of the function, generated previously using\nINITIAL_TO_INTERMEDIATE and possibly INTERMEDIATE_TO_INTERMEDIATE calls.\nThis call should combine the intermediate values to yield the final\nreturn value.\n'
global___AggregationPhase = AggregationPhase

class RelCommon(google.protobuf.message.Message):
    """Common fields for all relational operators"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Direct(google.protobuf.message.Message):
        """Direct indicates no change on presence and ordering of fields in the output"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(self) -> None:
            ...

    class Emit(google.protobuf.message.Message):
        """Remap which fields are output and in which order"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        OUTPUT_MAPPING_FIELD_NUMBER: builtins.int

        @property
        def output_mapping(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            ...

        def __init__(self, *, output_mapping: collections.abc.Iterable[builtins.int] | None=...) -> None:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['output_mapping', b'output_mapping']) -> None:
            ...

    class Hint(google.protobuf.message.Message):
        """Changes to the operation that can influence efficiency/performance but
        should not impact correctness.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Stats(google.protobuf.message.Message):
            """The statistics related to a hint (physical properties of records)"""
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            ROW_COUNT_FIELD_NUMBER: builtins.int
            RECORD_SIZE_FIELD_NUMBER: builtins.int
            ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int
            row_count: builtins.float
            record_size: builtins.float

            @property
            def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
                ...

            def __init__(self, *, row_count: builtins.float=..., record_size: builtins.float=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'record_size', b'record_size', 'row_count', b'row_count']) -> None:
                ...

        class RuntimeConstraint(google.protobuf.message.Message):
            """TODO: nodes, cpu threads/%, memory, iops, etc."""
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

            @property
            def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
                ...

            def __init__(self, *, advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension']) -> None:
                ...
        STATS_FIELD_NUMBER: builtins.int
        CONSTRAINT_FIELD_NUMBER: builtins.int
        ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

        @property
        def stats(self) -> global___RelCommon.Hint.Stats:
            ...

        @property
        def constraint(self) -> global___RelCommon.Hint.RuntimeConstraint:
            ...

        @property
        def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
            ...

        def __init__(self, *, stats: global___RelCommon.Hint.Stats | None=..., constraint: global___RelCommon.Hint.RuntimeConstraint | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'constraint', b'constraint', 'stats', b'stats']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'constraint', b'constraint', 'stats', b'stats']) -> None:
            ...
    DIRECT_FIELD_NUMBER: builtins.int
    EMIT_FIELD_NUMBER: builtins.int
    HINT_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def direct(self) -> global___RelCommon.Direct:
        """The underlying relation is output as is (no reordering or projection of columns)"""

    @property
    def emit(self) -> global___RelCommon.Emit:
        """Allows to control for order and inclusion of fields"""

    @property
    def hint(self) -> global___RelCommon.Hint:
        ...

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, direct: global___RelCommon.Direct | None=..., emit: global___RelCommon.Emit | None=..., hint: global___RelCommon.Hint | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'direct', b'direct', 'emit', b'emit', 'emit_kind', b'emit_kind', 'hint', b'hint']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'direct', b'direct', 'emit', b'emit', 'emit_kind', b'emit_kind', 'hint', b'hint']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['emit_kind', b'emit_kind']) -> typing_extensions.Literal['direct', 'emit'] | None:
        ...
global___RelCommon = RelCommon

class ReadRel(google.protobuf.message.Message):
    """The scan operator of base data (physical or virtual), including filtering and projection."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class NamedTable(google.protobuf.message.Message):
        """A base table. The list of string is used to represent namespacing (e.g., mydb.mytable).
        This assumes shared catalog between systems exchanging a message.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAMES_FIELD_NUMBER: builtins.int
        ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

        @property
        def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            ...

        @property
        def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
            ...

        def __init__(self, *, names: collections.abc.Iterable[builtins.str] | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'names', b'names']) -> None:
            ...

    class VirtualTable(google.protobuf.message.Message):
        """A table composed of literals."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        VALUES_FIELD_NUMBER: builtins.int

        @property
        def values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.Literal.Struct]:
            ...

        def __init__(self, *, values: collections.abc.Iterable[global___Expression.Literal.Struct] | None=...) -> None:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['values', b'values']) -> None:
            ...

    class ExtensionTable(google.protobuf.message.Message):
        """A stub type that can be used to extend/introduce new table types outside
        the specification.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        DETAIL_FIELD_NUMBER: builtins.int

        @property
        def detail(self) -> google.protobuf.any_pb2.Any:
            ...

        def __init__(self, *, detail: google.protobuf.any_pb2.Any | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['detail', b'detail']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['detail', b'detail']) -> None:
            ...

    class LocalFiles(google.protobuf.message.Message):
        """Represents a list of files in input of a scan operation"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class FileOrFiles(google.protobuf.message.Message):
            """Many files consist of indivisible chunks (e.g. parquet row groups
            or CSV rows).  If a slice partially selects an indivisible chunk
            then the consumer should employ some rule to decide which slice to
            include the chunk in (e.g. include it in the slice that contains
            the midpoint of the chunk)
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class ParquetReadOptions(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                def __init__(self) -> None:
                    ...

            class ArrowReadOptions(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                def __init__(self) -> None:
                    ...

            class OrcReadOptions(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                def __init__(self) -> None:
                    ...

            class DwrfReadOptions(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                def __init__(self) -> None:
                    ...
            URI_PATH_FIELD_NUMBER: builtins.int
            URI_PATH_GLOB_FIELD_NUMBER: builtins.int
            URI_FILE_FIELD_NUMBER: builtins.int
            URI_FOLDER_FIELD_NUMBER: builtins.int
            PARTITION_INDEX_FIELD_NUMBER: builtins.int
            START_FIELD_NUMBER: builtins.int
            LENGTH_FIELD_NUMBER: builtins.int
            PARQUET_FIELD_NUMBER: builtins.int
            ARROW_FIELD_NUMBER: builtins.int
            ORC_FIELD_NUMBER: builtins.int
            EXTENSION_FIELD_NUMBER: builtins.int
            DWRF_FIELD_NUMBER: builtins.int
            uri_path: builtins.str
            'A URI that can refer to either a single folder or a single file'
            uri_path_glob: builtins.str
            'A URI where the path portion is a glob expression that can\n            identify zero or more paths.\n            Consumers should support the POSIX syntax.  The recursive\n            globstar (**) may not be supported.\n            '
            uri_file: builtins.str
            'A URI that refers to a single file'
            uri_folder: builtins.str
            'A URI that refers to a single folder'
            partition_index: builtins.int
            'The index of the partition this item belongs to'
            start: builtins.int
            'The start position in byte to read from this item'
            length: builtins.int
            'The length in byte to read from this item'

            @property
            def parquet(self) -> global___ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions:
                ...

            @property
            def arrow(self) -> global___ReadRel.LocalFiles.FileOrFiles.ArrowReadOptions:
                ...

            @property
            def orc(self) -> global___ReadRel.LocalFiles.FileOrFiles.OrcReadOptions:
                ...

            @property
            def extension(self) -> google.protobuf.any_pb2.Any:
                ...

            @property
            def dwrf(self) -> global___ReadRel.LocalFiles.FileOrFiles.DwrfReadOptions:
                ...

            def __init__(self, *, uri_path: builtins.str=..., uri_path_glob: builtins.str=..., uri_file: builtins.str=..., uri_folder: builtins.str=..., partition_index: builtins.int=..., start: builtins.int=..., length: builtins.int=..., parquet: global___ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions | None=..., arrow: global___ReadRel.LocalFiles.FileOrFiles.ArrowReadOptions | None=..., orc: global___ReadRel.LocalFiles.FileOrFiles.OrcReadOptions | None=..., extension: google.protobuf.any_pb2.Any | None=..., dwrf: global___ReadRel.LocalFiles.FileOrFiles.DwrfReadOptions | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['arrow', b'arrow', 'dwrf', b'dwrf', 'extension', b'extension', 'file_format', b'file_format', 'orc', b'orc', 'parquet', b'parquet', 'path_type', b'path_type', 'uri_file', b'uri_file', 'uri_folder', b'uri_folder', 'uri_path', b'uri_path', 'uri_path_glob', b'uri_path_glob']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['arrow', b'arrow', 'dwrf', b'dwrf', 'extension', b'extension', 'file_format', b'file_format', 'length', b'length', 'orc', b'orc', 'parquet', b'parquet', 'partition_index', b'partition_index', 'path_type', b'path_type', 'start', b'start', 'uri_file', b'uri_file', 'uri_folder', b'uri_folder', 'uri_path', b'uri_path', 'uri_path_glob', b'uri_path_glob']) -> None:
                ...

            @typing.overload
            def WhichOneof(self, oneof_group: typing_extensions.Literal['file_format', b'file_format']) -> typing_extensions.Literal['parquet', 'arrow', 'orc', 'extension', 'dwrf'] | None:
                ...

            @typing.overload
            def WhichOneof(self, oneof_group: typing_extensions.Literal['path_type', b'path_type']) -> typing_extensions.Literal['uri_path', 'uri_path_glob', 'uri_file', 'uri_folder'] | None:
                ...
        ITEMS_FIELD_NUMBER: builtins.int
        ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

        @property
        def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ReadRel.LocalFiles.FileOrFiles]:
            ...

        @property
        def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
            ...

        def __init__(self, *, items: collections.abc.Iterable[global___ReadRel.LocalFiles.FileOrFiles] | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'items', b'items']) -> None:
            ...
    COMMON_FIELD_NUMBER: builtins.int
    BASE_SCHEMA_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    BEST_EFFORT_FILTER_FIELD_NUMBER: builtins.int
    PROJECTION_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int
    VIRTUAL_TABLE_FIELD_NUMBER: builtins.int
    LOCAL_FILES_FIELD_NUMBER: builtins.int
    NAMED_TABLE_FIELD_NUMBER: builtins.int
    EXTENSION_TABLE_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def base_schema(self) -> substrait.ibis.type_pb2.NamedStruct:
        ...

    @property
    def filter(self) -> global___Expression:
        ...

    @property
    def best_effort_filter(self) -> global___Expression:
        ...

    @property
    def projection(self) -> global___Expression.MaskExpression:
        ...

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    @property
    def virtual_table(self) -> global___ReadRel.VirtualTable:
        ...

    @property
    def local_files(self) -> global___ReadRel.LocalFiles:
        ...

    @property
    def named_table(self) -> global___ReadRel.NamedTable:
        ...

    @property
    def extension_table(self) -> global___ReadRel.ExtensionTable:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., base_schema: substrait.ibis.type_pb2.NamedStruct | None=..., filter: global___Expression | None=..., best_effort_filter: global___Expression | None=..., projection: global___Expression.MaskExpression | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=..., virtual_table: global___ReadRel.VirtualTable | None=..., local_files: global___ReadRel.LocalFiles | None=..., named_table: global___ReadRel.NamedTable | None=..., extension_table: global___ReadRel.ExtensionTable | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'base_schema', b'base_schema', 'best_effort_filter', b'best_effort_filter', 'common', b'common', 'extension_table', b'extension_table', 'filter', b'filter', 'local_files', b'local_files', 'named_table', b'named_table', 'projection', b'projection', 'read_type', b'read_type', 'virtual_table', b'virtual_table']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'base_schema', b'base_schema', 'best_effort_filter', b'best_effort_filter', 'common', b'common', 'extension_table', b'extension_table', 'filter', b'filter', 'local_files', b'local_files', 'named_table', b'named_table', 'projection', b'projection', 'read_type', b'read_type', 'virtual_table', b'virtual_table']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['read_type', b'read_type']) -> typing_extensions.Literal['virtual_table', 'local_files', 'named_table', 'extension_table'] | None:
        ...
global___ReadRel = ReadRel

class ProjectRel(google.protobuf.message.Message):
    """This operator allows to represent calculated expressions of fields (e.g., a+b). Direct/Emit are used to represent classical relational projections"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    EXPRESSIONS_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def input(self) -> global___Rel:
        ...

    @property
    def expressions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
        ...

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., input: global___Rel | None=..., expressions: collections.abc.Iterable[global___Expression] | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'input', b'input']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'expressions', b'expressions', 'input', b'input']) -> None:
        ...
global___ProjectRel = ProjectRel

class JoinRel(google.protobuf.message.Message):
    """The binary JOIN relational operator left-join-right, including various join types, a join condition and post_join_filter expression"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _JoinType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _JoinTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[JoinRel._JoinType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        JOIN_TYPE_UNSPECIFIED: JoinRel._JoinType.ValueType
        JOIN_TYPE_INNER: JoinRel._JoinType.ValueType
        JOIN_TYPE_OUTER: JoinRel._JoinType.ValueType
        JOIN_TYPE_LEFT: JoinRel._JoinType.ValueType
        JOIN_TYPE_RIGHT: JoinRel._JoinType.ValueType
        JOIN_TYPE_SEMI: JoinRel._JoinType.ValueType
        JOIN_TYPE_ANTI: JoinRel._JoinType.ValueType
        JOIN_TYPE_SINGLE: JoinRel._JoinType.ValueType
        'This join is useful for nested sub-queries where we need exactly one tuple in output (or throw exception)\n        See Section 3.2 of https://15721.courses.cs.cmu.edu/spring2018/papers/16-optimizer2/hyperjoins-btw2017.pdf\n        '

    class JoinType(_JoinType, metaclass=_JoinTypeEnumTypeWrapper):
        ...
    JOIN_TYPE_UNSPECIFIED: JoinRel.JoinType.ValueType
    JOIN_TYPE_INNER: JoinRel.JoinType.ValueType
    JOIN_TYPE_OUTER: JoinRel.JoinType.ValueType
    JOIN_TYPE_LEFT: JoinRel.JoinType.ValueType
    JOIN_TYPE_RIGHT: JoinRel.JoinType.ValueType
    JOIN_TYPE_SEMI: JoinRel.JoinType.ValueType
    JOIN_TYPE_ANTI: JoinRel.JoinType.ValueType
    JOIN_TYPE_SINGLE: JoinRel.JoinType.ValueType
    'This join is useful for nested sub-queries where we need exactly one tuple in output (or throw exception)\n    See Section 3.2 of https://15721.courses.cs.cmu.edu/spring2018/papers/16-optimizer2/hyperjoins-btw2017.pdf\n    '
    COMMON_FIELD_NUMBER: builtins.int
    LEFT_FIELD_NUMBER: builtins.int
    RIGHT_FIELD_NUMBER: builtins.int
    EXPRESSION_FIELD_NUMBER: builtins.int
    POST_JOIN_FILTER_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def left(self) -> global___Rel:
        ...

    @property
    def right(self) -> global___Rel:
        ...

    @property
    def expression(self) -> global___Expression:
        ...

    @property
    def post_join_filter(self) -> global___Expression:
        ...
    type: global___JoinRel.JoinType.ValueType

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., left: global___Rel | None=..., right: global___Rel | None=..., expression: global___Expression | None=..., post_join_filter: global___Expression | None=..., type: global___JoinRel.JoinType.ValueType=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'expression', b'expression', 'left', b'left', 'post_join_filter', b'post_join_filter', 'right', b'right']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'expression', b'expression', 'left', b'left', 'post_join_filter', b'post_join_filter', 'right', b'right', 'type', b'type']) -> None:
        ...
global___JoinRel = JoinRel

class CrossRel(google.protobuf.message.Message):
    """Cartesian product relational operator of two tables (left and right)"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_FIELD_NUMBER: builtins.int
    LEFT_FIELD_NUMBER: builtins.int
    RIGHT_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def left(self) -> global___Rel:
        ...

    @property
    def right(self) -> global___Rel:
        ...

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., left: global___Rel | None=..., right: global___Rel | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'left', b'left', 'right', b'right']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'left', b'left', 'right', b'right']) -> None:
        ...
global___CrossRel = CrossRel

class FetchRel(google.protobuf.message.Message):
    """The relational operator representing LIMIT/OFFSET or TOP type semantics."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def input(self) -> global___Rel:
        ...
    offset: builtins.int
    'the offset expressed in number of records'
    count: builtins.int
    'the amount of records to return'

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., input: global___Rel | None=..., offset: builtins.int=..., count: builtins.int=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'input', b'input']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'count', b'count', 'input', b'input', 'offset', b'offset']) -> None:
        ...
global___FetchRel = FetchRel

class AggregateRel(google.protobuf.message.Message):
    """The relational operator representing a GROUP BY Aggregate"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Grouping(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        GROUPING_EXPRESSIONS_FIELD_NUMBER: builtins.int

        @property
        def grouping_expressions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
            ...

        def __init__(self, *, grouping_expressions: collections.abc.Iterable[global___Expression] | None=...) -> None:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['grouping_expressions', b'grouping_expressions']) -> None:
            ...

    class Measure(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        MEASURE_FIELD_NUMBER: builtins.int
        FILTER_FIELD_NUMBER: builtins.int

        @property
        def measure(self) -> global___AggregateFunction:
            ...

        @property
        def filter(self) -> global___Expression:
            """An optional boolean expression that acts to filter which records are
            included in the measure. True means include this record for calculation
            within the measure.
            Helps to support SUM(<c>) FILTER(WHERE...) syntax without masking opportunities for optimization
            """

        def __init__(self, *, measure: global___AggregateFunction | None=..., filter: global___Expression | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['filter', b'filter', 'measure', b'measure']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['filter', b'filter', 'measure', b'measure']) -> None:
            ...
    COMMON_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    GROUPINGS_FIELD_NUMBER: builtins.int
    MEASURES_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def input(self) -> global___Rel:
        """Input of the aggregation"""

    @property
    def groupings(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AggregateRel.Grouping]:
        """A list of expression grouping that the aggregation measured should be calculated for."""

    @property
    def measures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AggregateRel.Measure]:
        """A list of one or more aggregate expressions along with an optional filter."""

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., input: global___Rel | None=..., groupings: collections.abc.Iterable[global___AggregateRel.Grouping] | None=..., measures: collections.abc.Iterable[global___AggregateRel.Measure] | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'input', b'input']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'groupings', b'groupings', 'input', b'input', 'measures', b'measures']) -> None:
        ...
global___AggregateRel = AggregateRel

class SortRel(google.protobuf.message.Message):
    """The ORDERY BY (or sorting) relational operator. Beside describing a base relation, it includes a list of fields to sort on"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    SORTS_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def input(self) -> global___Rel:
        ...

    @property
    def sorts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SortField]:
        ...

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., input: global___Rel | None=..., sorts: collections.abc.Iterable[global___SortField] | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'input', b'input']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'input', b'input', 'sorts', b'sorts']) -> None:
        ...
global___SortRel = SortRel

class FilterRel(google.protobuf.message.Message):
    """The relational operator capturing simple FILTERs (as in the WHERE clause of SQL)"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    CONDITION_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def input(self) -> global___Rel:
        ...

    @property
    def condition(self) -> global___Expression:
        ...

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., input: global___Rel | None=..., condition: global___Expression | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'condition', b'condition', 'input', b'input']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'condition', b'condition', 'input', b'input']) -> None:
        ...
global___FilterRel = FilterRel

class SetRel(google.protobuf.message.Message):
    """The relational set operators (intersection/union/etc..)"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SetOp:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SetOpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SetRel._SetOp.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SET_OP_UNSPECIFIED: SetRel._SetOp.ValueType
        SET_OP_MINUS_PRIMARY: SetRel._SetOp.ValueType
        SET_OP_MINUS_MULTISET: SetRel._SetOp.ValueType
        SET_OP_INTERSECTION_PRIMARY: SetRel._SetOp.ValueType
        SET_OP_INTERSECTION_MULTISET: SetRel._SetOp.ValueType
        SET_OP_UNION_DISTINCT: SetRel._SetOp.ValueType
        SET_OP_UNION_ALL: SetRel._SetOp.ValueType

    class SetOp(_SetOp, metaclass=_SetOpEnumTypeWrapper):
        ...
    SET_OP_UNSPECIFIED: SetRel.SetOp.ValueType
    SET_OP_MINUS_PRIMARY: SetRel.SetOp.ValueType
    SET_OP_MINUS_MULTISET: SetRel.SetOp.ValueType
    SET_OP_INTERSECTION_PRIMARY: SetRel.SetOp.ValueType
    SET_OP_INTERSECTION_MULTISET: SetRel.SetOp.ValueType
    SET_OP_UNION_DISTINCT: SetRel.SetOp.ValueType
    SET_OP_UNION_ALL: SetRel.SetOp.ValueType
    COMMON_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    OP_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rel]:
        """The first input is the primary input, the remaining are secondary
        inputs.  There must be at least two inputs.
        """
    op: global___SetRel.SetOp.ValueType

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., inputs: collections.abc.Iterable[global___Rel] | None=..., op: global___SetRel.SetOp.ValueType=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'common', b'common', 'inputs', b'inputs', 'op', b'op']) -> None:
        ...
global___SetRel = SetRel

class ExtensionSingleRel(google.protobuf.message.Message):
    """Stub to support extension with a single input"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    DETAIL_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def input(self) -> global___Rel:
        ...

    @property
    def detail(self) -> google.protobuf.any_pb2.Any:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., input: global___Rel | None=..., detail: google.protobuf.any_pb2.Any | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['common', b'common', 'detail', b'detail', 'input', b'input']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['common', b'common', 'detail', b'detail', 'input', b'input']) -> None:
        ...
global___ExtensionSingleRel = ExtensionSingleRel

class ExtensionLeafRel(google.protobuf.message.Message):
    """Stub to support extension with a zero inputs"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_FIELD_NUMBER: builtins.int
    DETAIL_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def detail(self) -> google.protobuf.any_pb2.Any:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., detail: google.protobuf.any_pb2.Any | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['common', b'common', 'detail', b'detail']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['common', b'common', 'detail', b'detail']) -> None:
        ...
global___ExtensionLeafRel = ExtensionLeafRel

class ExtensionMultiRel(google.protobuf.message.Message):
    """Stub to support extension with multiple inputs"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    DETAIL_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rel]:
        ...

    @property
    def detail(self) -> google.protobuf.any_pb2.Any:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., inputs: collections.abc.Iterable[global___Rel] | None=..., detail: google.protobuf.any_pb2.Any | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['common', b'common', 'detail', b'detail']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['common', b'common', 'detail', b'detail', 'inputs', b'inputs']) -> None:
        ...
global___ExtensionMultiRel = ExtensionMultiRel

class ExchangeRel(google.protobuf.message.Message):
    """A redistribution operation"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ScatterFields(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        FIELDS_FIELD_NUMBER: builtins.int

        @property
        def fields(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.FieldReference]:
            ...

        def __init__(self, *, fields: collections.abc.Iterable[global___Expression.FieldReference] | None=...) -> None:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['fields', b'fields']) -> None:
            ...

    class SingleBucketExpression(google.protobuf.message.Message):
        """Returns a single bucket number per record."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        EXPRESSION_FIELD_NUMBER: builtins.int

        @property
        def expression(self) -> global___Expression:
            ...

        def __init__(self, *, expression: global___Expression | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['expression', b'expression']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['expression', b'expression']) -> None:
            ...

    class MultiBucketExpression(google.protobuf.message.Message):
        """Returns zero or more bucket numbers per record"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        EXPRESSION_FIELD_NUMBER: builtins.int
        CONSTRAINED_TO_COUNT_FIELD_NUMBER: builtins.int

        @property
        def expression(self) -> global___Expression:
            ...
        constrained_to_count: builtins.bool

        def __init__(self, *, expression: global___Expression | None=..., constrained_to_count: builtins.bool=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['expression', b'expression']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['constrained_to_count', b'constrained_to_count', 'expression', b'expression']) -> None:
            ...

    class Broadcast(google.protobuf.message.Message):
        """Send all data to every target."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(self) -> None:
            ...

    class RoundRobin(google.protobuf.message.Message):
        """Route approximately"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        EXACT_FIELD_NUMBER: builtins.int
        exact: builtins.bool
        'whether the round robin behavior is required to exact (per record) or\n        approximate. Defaults to approximate.\n        '

        def __init__(self, *, exact: builtins.bool=...) -> None:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['exact', b'exact']) -> None:
            ...

    class ExchangeTarget(google.protobuf.message.Message):
        """The message to describe partition targets of an exchange"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        PARTITION_ID_FIELD_NUMBER: builtins.int
        URI_FIELD_NUMBER: builtins.int
        EXTENDED_FIELD_NUMBER: builtins.int

        @property
        def partition_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """Describes the partition id(s) to send. If this is empty, all data is sent
            to this target.
            """
        uri: builtins.str

        @property
        def extended(self) -> google.protobuf.any_pb2.Any:
            ...

        def __init__(self, *, partition_id: collections.abc.Iterable[builtins.int] | None=..., uri: builtins.str=..., extended: google.protobuf.any_pb2.Any | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['extended', b'extended', 'target_type', b'target_type', 'uri', b'uri']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['extended', b'extended', 'partition_id', b'partition_id', 'target_type', b'target_type', 'uri', b'uri']) -> None:
            ...

        def WhichOneof(self, oneof_group: typing_extensions.Literal['target_type', b'target_type']) -> typing_extensions.Literal['uri', 'extended'] | None:
            ...
    COMMON_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    PARTITION_COUNT_FIELD_NUMBER: builtins.int
    TARGETS_FIELD_NUMBER: builtins.int
    SCATTER_BY_FIELDS_FIELD_NUMBER: builtins.int
    SINGLE_TARGET_FIELD_NUMBER: builtins.int
    MULTI_TARGET_FIELD_NUMBER: builtins.int
    ROUND_ROBIN_FIELD_NUMBER: builtins.int
    BROADCAST_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def common(self) -> global___RelCommon:
        ...

    @property
    def input(self) -> global___Rel:
        ...
    partition_count: builtins.int

    @property
    def targets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ExchangeRel.ExchangeTarget]:
        ...

    @property
    def scatter_by_fields(self) -> global___ExchangeRel.ScatterFields:
        ...

    @property
    def single_target(self) -> global___ExchangeRel.SingleBucketExpression:
        ...

    @property
    def multi_target(self) -> global___ExchangeRel.MultiBucketExpression:
        ...

    @property
    def round_robin(self) -> global___ExchangeRel.RoundRobin:
        ...

    @property
    def broadcast(self) -> global___ExchangeRel.Broadcast:
        ...

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, common: global___RelCommon | None=..., input: global___Rel | None=..., partition_count: builtins.int=..., targets: collections.abc.Iterable[global___ExchangeRel.ExchangeTarget] | None=..., scatter_by_fields: global___ExchangeRel.ScatterFields | None=..., single_target: global___ExchangeRel.SingleBucketExpression | None=..., multi_target: global___ExchangeRel.MultiBucketExpression | None=..., round_robin: global___ExchangeRel.RoundRobin | None=..., broadcast: global___ExchangeRel.Broadcast | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'broadcast', b'broadcast', 'common', b'common', 'exchange_kind', b'exchange_kind', 'input', b'input', 'multi_target', b'multi_target', 'round_robin', b'round_robin', 'scatter_by_fields', b'scatter_by_fields', 'single_target', b'single_target']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'broadcast', b'broadcast', 'common', b'common', 'exchange_kind', b'exchange_kind', 'input', b'input', 'multi_target', b'multi_target', 'partition_count', b'partition_count', 'round_robin', b'round_robin', 'scatter_by_fields', b'scatter_by_fields', 'single_target', b'single_target', 'targets', b'targets']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['exchange_kind', b'exchange_kind']) -> typing_extensions.Literal['scatter_by_fields', 'single_target', 'multi_target', 'round_robin', 'broadcast'] | None:
        ...
global___ExchangeRel = ExchangeRel

class RelRoot(google.protobuf.message.Message):
    """A relation with output field names.

    This is for use at the root of a `Rel` tree.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    INPUT_FIELD_NUMBER: builtins.int
    NAMES_FIELD_NUMBER: builtins.int

    @property
    def input(self) -> global___Rel:
        """A relation"""

    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Field names in depth-first order"""

    def __init__(self, *, input: global___Rel | None=..., names: collections.abc.Iterable[builtins.str] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['input', b'input']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['input', b'input', 'names', b'names']) -> None:
        ...
global___RelRoot = RelRoot

class Rel(google.protobuf.message.Message):
    """A relation (used internally in a plan)"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    READ_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    FETCH_FIELD_NUMBER: builtins.int
    AGGREGATE_FIELD_NUMBER: builtins.int
    SORT_FIELD_NUMBER: builtins.int
    JOIN_FIELD_NUMBER: builtins.int
    PROJECT_FIELD_NUMBER: builtins.int
    SET_FIELD_NUMBER: builtins.int
    EXTENSION_SINGLE_FIELD_NUMBER: builtins.int
    EXTENSION_MULTI_FIELD_NUMBER: builtins.int
    EXTENSION_LEAF_FIELD_NUMBER: builtins.int
    CROSS_FIELD_NUMBER: builtins.int

    @property
    def read(self) -> global___ReadRel:
        ...

    @property
    def filter(self) -> global___FilterRel:
        ...

    @property
    def fetch(self) -> global___FetchRel:
        ...

    @property
    def aggregate(self) -> global___AggregateRel:
        ...

    @property
    def sort(self) -> global___SortRel:
        ...

    @property
    def join(self) -> global___JoinRel:
        ...

    @property
    def project(self) -> global___ProjectRel:
        ...

    @property
    def set(self) -> global___SetRel:
        ...

    @property
    def extension_single(self) -> global___ExtensionSingleRel:
        ...

    @property
    def extension_multi(self) -> global___ExtensionMultiRel:
        ...

    @property
    def extension_leaf(self) -> global___ExtensionLeafRel:
        ...

    @property
    def cross(self) -> global___CrossRel:
        ...

    def __init__(self, *, read: global___ReadRel | None=..., filter: global___FilterRel | None=..., fetch: global___FetchRel | None=..., aggregate: global___AggregateRel | None=..., sort: global___SortRel | None=..., join: global___JoinRel | None=..., project: global___ProjectRel | None=..., set: global___SetRel | None=..., extension_single: global___ExtensionSingleRel | None=..., extension_multi: global___ExtensionMultiRel | None=..., extension_leaf: global___ExtensionLeafRel | None=..., cross: global___CrossRel | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['aggregate', b'aggregate', 'cross', b'cross', 'extension_leaf', b'extension_leaf', 'extension_multi', b'extension_multi', 'extension_single', b'extension_single', 'fetch', b'fetch', 'filter', b'filter', 'join', b'join', 'project', b'project', 'read', b'read', 'rel_type', b'rel_type', 'set', b'set', 'sort', b'sort']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['aggregate', b'aggregate', 'cross', b'cross', 'extension_leaf', b'extension_leaf', 'extension_multi', b'extension_multi', 'extension_single', b'extension_single', 'fetch', b'fetch', 'filter', b'filter', 'join', b'join', 'project', b'project', 'read', b'read', 'rel_type', b'rel_type', 'set', b'set', 'sort', b'sort']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['rel_type', b'rel_type']) -> typing_extensions.Literal['read', 'filter', 'fetch', 'aggregate', 'sort', 'join', 'project', 'set', 'extension_single', 'extension_multi', 'extension_leaf', 'cross'] | None:
        ...
global___Rel = Rel

class NamedObjectWrite(google.protobuf.message.Message):
    """A base object for writing (e.g., a table or a view)."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAMES_FIELD_NUMBER: builtins.int
    ADVANCED_EXTENSION_FIELD_NUMBER: builtins.int

    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The list of string is used to represent namespacing (e.g., mydb.mytable).
        This assumes shared catalog between systems exchanging a message.
        """

    @property
    def advanced_extension(self) -> substrait.ibis.extensions.extensions_pb2.AdvancedExtension:
        ...

    def __init__(self, *, names: collections.abc.Iterable[builtins.str] | None=..., advanced_extension: substrait.ibis.extensions.extensions_pb2.AdvancedExtension | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['advanced_extension', b'advanced_extension', 'names', b'names']) -> None:
        ...
global___NamedObjectWrite = NamedObjectWrite

class ExtensionObject(google.protobuf.message.Message):
    """A stub type that can be used to extend/introduce new table types outside
    the specification.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DETAIL_FIELD_NUMBER: builtins.int

    @property
    def detail(self) -> google.protobuf.any_pb2.Any:
        ...

    def __init__(self, *, detail: google.protobuf.any_pb2.Any | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['detail', b'detail']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['detail', b'detail']) -> None:
        ...
global___ExtensionObject = ExtensionObject

class DdlRel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DdlObject:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DdlObjectEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DdlRel._DdlObject.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DDL_OBJECT_UNSPECIFIED: DdlRel._DdlObject.ValueType
        DDL_OBJECT_TABLE: DdlRel._DdlObject.ValueType
        'A Table object in the system'
        DDL_OBJECT_VIEW: DdlRel._DdlObject.ValueType
        'A View object in the system'

    class DdlObject(_DdlObject, metaclass=_DdlObjectEnumTypeWrapper):
        ...
    DDL_OBJECT_UNSPECIFIED: DdlRel.DdlObject.ValueType
    DDL_OBJECT_TABLE: DdlRel.DdlObject.ValueType
    'A Table object in the system'
    DDL_OBJECT_VIEW: DdlRel.DdlObject.ValueType
    'A View object in the system'

    class _DdlOp:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DdlOpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DdlRel._DdlOp.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DDL_OP_UNSPECIFIED: DdlRel._DdlOp.ValueType
        DDL_OP_CREATE: DdlRel._DdlOp.ValueType
        'A create operation (for any object)'
        DDL_OP_CREATE_OR_REPLACE: DdlRel._DdlOp.ValueType
        'A create operation if the object does not exist, or replaces it (equivalent to a DROP + CREATE) if the object already exists'
        DDL_OP_ALTER: DdlRel._DdlOp.ValueType
        'An operation that modifies the schema (e.g., column names, types, default values) for the target object'
        DDL_OP_DROP: DdlRel._DdlOp.ValueType
        'An operation that removes an object from the system'
        DDL_OP_DROP_IF_EXIST: DdlRel._DdlOp.ValueType
        'An operation that removes an object from the system (without throwing an exception if the object did not exist)'

    class DdlOp(_DdlOp, metaclass=_DdlOpEnumTypeWrapper):
        ...
    DDL_OP_UNSPECIFIED: DdlRel.DdlOp.ValueType
    DDL_OP_CREATE: DdlRel.DdlOp.ValueType
    'A create operation (for any object)'
    DDL_OP_CREATE_OR_REPLACE: DdlRel.DdlOp.ValueType
    'A create operation if the object does not exist, or replaces it (equivalent to a DROP + CREATE) if the object already exists'
    DDL_OP_ALTER: DdlRel.DdlOp.ValueType
    'An operation that modifies the schema (e.g., column names, types, default values) for the target object'
    DDL_OP_DROP: DdlRel.DdlOp.ValueType
    'An operation that removes an object from the system'
    DDL_OP_DROP_IF_EXIST: DdlRel.DdlOp.ValueType
    'An operation that removes an object from the system (without throwing an exception if the object did not exist)'
    NAMED_OBJECT_FIELD_NUMBER: builtins.int
    EXTENSION_OBJECT_FIELD_NUMBER: builtins.int
    TABLE_SCHEMA_FIELD_NUMBER: builtins.int
    TABLE_DEFAULTS_FIELD_NUMBER: builtins.int
    OBJECT_FIELD_NUMBER: builtins.int
    OP_FIELD_NUMBER: builtins.int
    VIEW_DEFINITION_FIELD_NUMBER: builtins.int

    @property
    def named_object(self) -> global___NamedObjectWrite:
        ...

    @property
    def extension_object(self) -> global___ExtensionObject:
        ...

    @property
    def table_schema(self) -> substrait.ibis.type_pb2.NamedStruct:
        """The columns that will be modified (representing after-image of a schema change)"""

    @property
    def table_defaults(self) -> global___Expression.Literal.Struct:
        """The default values for the columns (representing after-image of a schema change)
        E.g., in case of an ALTER TABLE that changes some of the column default values, we expect
        the table_defaults Struct to report a full list of default values reflecting the result of applying
        the ALTER TABLE operator successfully
        """
    object: global___DdlRel.DdlObject.ValueType
    'Which type of object we operate on'
    op: global___DdlRel.DdlOp.ValueType
    'The type of operation to perform'

    @property
    def view_definition(self) -> global___Rel:
        """The body of the CREATE VIEW"""

    def __init__(self, *, named_object: global___NamedObjectWrite | None=..., extension_object: global___ExtensionObject | None=..., table_schema: substrait.ibis.type_pb2.NamedStruct | None=..., table_defaults: global___Expression.Literal.Struct | None=..., object: global___DdlRel.DdlObject.ValueType=..., op: global___DdlRel.DdlOp.ValueType=..., view_definition: global___Rel | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['extension_object', b'extension_object', 'named_object', b'named_object', 'table_defaults', b'table_defaults', 'table_schema', b'table_schema', 'view_definition', b'view_definition', 'write_type', b'write_type']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['extension_object', b'extension_object', 'named_object', b'named_object', 'object', b'object', 'op', b'op', 'table_defaults', b'table_defaults', 'table_schema', b'table_schema', 'view_definition', b'view_definition', 'write_type', b'write_type']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['write_type', b'write_type']) -> typing_extensions.Literal['named_object', 'extension_object'] | None:
        ...
global___DdlRel = DdlRel

class WriteRel(google.protobuf.message.Message):
    """The operator that modifies the content of a database (operates on 1 table at a time, but tuple-selection/source can be
    based on joining of multiple tables).
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _WriteOp:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _WriteOpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[WriteRel._WriteOp.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        WRITE_OP_UNSPECIFIED: WriteRel._WriteOp.ValueType
        WRITE_OP_INSERT: WriteRel._WriteOp.ValueType
        'The insert of new tuples in a table'
        WRITE_OP_DELETE: WriteRel._WriteOp.ValueType
        'The removal of tuples from a table'
        WRITE_OP_UPDATE: WriteRel._WriteOp.ValueType
        'The modification of existing tuples within a table'
        WRITE_OP_CTAS: WriteRel._WriteOp.ValueType
        'The Creation of a new table, and the insert of new tuples in the table'

    class WriteOp(_WriteOp, metaclass=_WriteOpEnumTypeWrapper):
        ...
    WRITE_OP_UNSPECIFIED: WriteRel.WriteOp.ValueType
    WRITE_OP_INSERT: WriteRel.WriteOp.ValueType
    'The insert of new tuples in a table'
    WRITE_OP_DELETE: WriteRel.WriteOp.ValueType
    'The removal of tuples from a table'
    WRITE_OP_UPDATE: WriteRel.WriteOp.ValueType
    'The modification of existing tuples within a table'
    WRITE_OP_CTAS: WriteRel.WriteOp.ValueType
    'The Creation of a new table, and the insert of new tuples in the table'

    class _OutputMode:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _OutputModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[WriteRel._OutputMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OUTPUT_MODE_UNSPECIFIED: WriteRel._OutputMode.ValueType
        OUTPUT_MODE_NO_OUTPUT: WriteRel._OutputMode.ValueType
        'return no tuples at all'
        OUTPUT_MODE_MODIFIED_TUPLES: WriteRel._OutputMode.ValueType
        'this mode makes the operator return all the tuple INSERTED/DELETED/UPDATED by the operator.\n        The operator returns the AFTER-image of any change. This can be further manipulated by operators upstreams\n        (e.g., retunring the typical "count of modified tuples").\n        For scenarios in which the BEFORE image is required, the user must implement a spool (via references to\n        subplans in the body of the Rel input) and return those with anounter PlanRel.relations.\n        '

    class OutputMode(_OutputMode, metaclass=_OutputModeEnumTypeWrapper):
        ...
    OUTPUT_MODE_UNSPECIFIED: WriteRel.OutputMode.ValueType
    OUTPUT_MODE_NO_OUTPUT: WriteRel.OutputMode.ValueType
    'return no tuples at all'
    OUTPUT_MODE_MODIFIED_TUPLES: WriteRel.OutputMode.ValueType
    'this mode makes the operator return all the tuple INSERTED/DELETED/UPDATED by the operator.\n    The operator returns the AFTER-image of any change. This can be further manipulated by operators upstreams\n    (e.g., retunring the typical "count of modified tuples").\n    For scenarios in which the BEFORE image is required, the user must implement a spool (via references to\n    subplans in the body of the Rel input) and return those with anounter PlanRel.relations.\n    '
    NAMED_TABLE_FIELD_NUMBER: builtins.int
    EXTENSION_TABLE_FIELD_NUMBER: builtins.int
    TABLE_SCHEMA_FIELD_NUMBER: builtins.int
    OP_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    OUTPUT_FIELD_NUMBER: builtins.int

    @property
    def named_table(self) -> global___NamedObjectWrite:
        ...

    @property
    def extension_table(self) -> global___ExtensionObject:
        ...

    @property
    def table_schema(self) -> substrait.ibis.type_pb2.NamedStruct:
        """The schema of the table (must align with Rel input (e.g., number of leaf fields must match))"""
    op: global___WriteRel.WriteOp.ValueType
    'The type of operation to perform'

    @property
    def input(self) -> global___Rel:
        """The relation that determines the tuples to add/remove/modify
        the schema must match with table_schema. Default values must be explicitly stated
        in a ProjectRel at the top of the input. The match must also
        occur in case of DELETE to ensure multi-engine plans are unequivocal.
        """
    output: global___WriteRel.OutputMode.ValueType
    'Output mode determines what is the output of executing this rel'

    def __init__(self, *, named_table: global___NamedObjectWrite | None=..., extension_table: global___ExtensionObject | None=..., table_schema: substrait.ibis.type_pb2.NamedStruct | None=..., op: global___WriteRel.WriteOp.ValueType=..., input: global___Rel | None=..., output: global___WriteRel.OutputMode.ValueType=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['extension_table', b'extension_table', 'input', b'input', 'named_table', b'named_table', 'table_schema', b'table_schema', 'write_type', b'write_type']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['extension_table', b'extension_table', 'input', b'input', 'named_table', b'named_table', 'op', b'op', 'output', b'output', 'table_schema', b'table_schema', 'write_type', b'write_type']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['write_type', b'write_type']) -> typing_extensions.Literal['named_table', 'extension_table'] | None:
        ...
global___WriteRel = WriteRel

class FunctionArgument(google.protobuf.message.Message):
    """The argument of a function"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ENUM_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    enum: builtins.str

    @property
    def type(self) -> substrait.ibis.type_pb2.Type:
        ...

    @property
    def value(self) -> global___Expression:
        ...

    def __init__(self, *, enum: builtins.str=..., type: substrait.ibis.type_pb2.Type | None=..., value: global___Expression | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['arg_type', b'arg_type', 'enum', b'enum', 'type', b'type', 'value', b'value']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['arg_type', b'arg_type', 'enum', b'enum', 'type', b'type', 'value', b'value']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['arg_type', b'arg_type']) -> typing_extensions.Literal['enum', 'type', 'value'] | None:
        ...
global___FunctionArgument = FunctionArgument

class FunctionOption(google.protobuf.message.Message):
    """An optional function argument.  Typically used for specifying behavior in
    invalid or corner cases.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    PREFERENCE_FIELD_NUMBER: builtins.int
    name: builtins.str
    'Name of the option to set. If the consumer does not recognize the\n    option, it must reject the plan. The name is matched case-insensitively\n    with option names defined for the function.\n    '

    @property
    def preference(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of behavior options allowed by the producer. At least one must be
        specified; to leave an option unspecified, simply don't add an entry to
        `options`. The consumer must use the first option from the list that it
        supports. If the consumer supports none of the specified options, it
        must reject the plan. The name is matched case-insensitively and must
        match one of the option values defined for the option.
        """

    def __init__(self, *, name: builtins.str=..., preference: collections.abc.Iterable[builtins.str] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['name', b'name', 'preference', b'preference']) -> None:
        ...
global___FunctionOption = FunctionOption

class Expression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Enum(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Empty(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            def __init__(self) -> None:
                ...
        SPECIFIED_FIELD_NUMBER: builtins.int
        UNSPECIFIED_FIELD_NUMBER: builtins.int
        specified: builtins.str

        @property
        def unspecified(self) -> global___Expression.Enum.Empty:
            ...

        def __init__(self, *, specified: builtins.str=..., unspecified: global___Expression.Enum.Empty | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['enum_kind', b'enum_kind', 'specified', b'specified', 'unspecified', b'unspecified']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['enum_kind', b'enum_kind', 'specified', b'specified', 'unspecified', b'unspecified']) -> None:
            ...

        def WhichOneof(self, oneof_group: typing_extensions.Literal['enum_kind', b'enum_kind']) -> typing_extensions.Literal['specified', 'unspecified'] | None:
            ...

    class Literal(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class VarChar(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            VALUE_FIELD_NUMBER: builtins.int
            LENGTH_FIELD_NUMBER: builtins.int
            value: builtins.str
            length: builtins.int

            def __init__(self, *, value: builtins.str=..., length: builtins.int=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['length', b'length', 'value', b'value']) -> None:
                ...

        class Decimal(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            VALUE_FIELD_NUMBER: builtins.int
            PRECISION_FIELD_NUMBER: builtins.int
            SCALE_FIELD_NUMBER: builtins.int
            value: builtins.bytes
            'little-endian twos-complement integer representation of complete value\n            (ignoring precision) Always 16 bytes in length\n            '
            precision: builtins.int
            'The maximum number of digits allowed in the value.\n            the maximum precision is 38.\n            '
            scale: builtins.int
            'declared scale of decimal literal'

            def __init__(self, *, value: builtins.bytes=..., precision: builtins.int=..., scale: builtins.int=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['precision', b'precision', 'scale', b'scale', 'value', b'value']) -> None:
                ...

        class Map(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class KeyValue(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor
                KEY_FIELD_NUMBER: builtins.int
                VALUE_FIELD_NUMBER: builtins.int

                @property
                def key(self) -> global___Expression.Literal:
                    ...

                @property
                def value(self) -> global___Expression.Literal:
                    ...

                def __init__(self, *, key: global___Expression.Literal | None=..., value: global___Expression.Literal | None=...) -> None:
                    ...

                def HasField(self, field_name: typing_extensions.Literal['key', b'key', 'value', b'value']) -> builtins.bool:
                    ...

                def ClearField(self, field_name: typing_extensions.Literal['key', b'key', 'value', b'value']) -> None:
                    ...
            KEY_VALUES_FIELD_NUMBER: builtins.int

            @property
            def key_values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.Literal.Map.KeyValue]:
                ...

            def __init__(self, *, key_values: collections.abc.Iterable[global___Expression.Literal.Map.KeyValue] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['key_values', b'key_values']) -> None:
                ...

        class IntervalYearToMonth(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            YEARS_FIELD_NUMBER: builtins.int
            MONTHS_FIELD_NUMBER: builtins.int
            years: builtins.int
            months: builtins.int

            def __init__(self, *, years: builtins.int=..., months: builtins.int=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['months', b'months', 'years', b'years']) -> None:
                ...

        class IntervalDayToSecond(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            DAYS_FIELD_NUMBER: builtins.int
            SECONDS_FIELD_NUMBER: builtins.int
            MICROSECONDS_FIELD_NUMBER: builtins.int
            days: builtins.int
            seconds: builtins.int
            microseconds: builtins.int

            def __init__(self, *, days: builtins.int=..., seconds: builtins.int=..., microseconds: builtins.int=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['days', b'days', 'microseconds', b'microseconds', 'seconds', b'seconds']) -> None:
                ...

        class Struct(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            FIELDS_FIELD_NUMBER: builtins.int

            @property
            def fields(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.Literal]:
                """A possibly heterogeneously typed list of literals"""

            def __init__(self, *, fields: collections.abc.Iterable[global___Expression.Literal] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['fields', b'fields']) -> None:
                ...

        class List(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            VALUES_FIELD_NUMBER: builtins.int

            @property
            def values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.Literal]:
                """A homogeneously typed list of literals"""

            def __init__(self, *, values: collections.abc.Iterable[global___Expression.Literal] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['values', b'values']) -> None:
                ...

        class UserDefined(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            TYPE_REFERENCE_FIELD_NUMBER: builtins.int
            TYPE_PARAMETERS_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            type_reference: builtins.int
            'points to a type_anchor defined in this plan'

            @property
            def type_parameters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[substrait.ibis.type_pb2.Type.Parameter]:
                """The parameters to be bound to the type class, if the type class is
                parameterizable.
                """

            @property
            def value(self) -> google.protobuf.any_pb2.Any:
                """the value of the literal, serialized using some type-specific
                protobuf message
                """

            def __init__(self, *, type_reference: builtins.int=..., type_parameters: collections.abc.Iterable[substrait.ibis.type_pb2.Type.Parameter] | None=..., value: google.protobuf.any_pb2.Any | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['value', b'value']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['type_parameters', b'type_parameters', 'type_reference', b'type_reference', 'value', b'value']) -> None:
                ...
        BOOLEAN_FIELD_NUMBER: builtins.int
        I8_FIELD_NUMBER: builtins.int
        I16_FIELD_NUMBER: builtins.int
        I32_FIELD_NUMBER: builtins.int
        I64_FIELD_NUMBER: builtins.int
        FP32_FIELD_NUMBER: builtins.int
        FP64_FIELD_NUMBER: builtins.int
        STRING_FIELD_NUMBER: builtins.int
        BINARY_FIELD_NUMBER: builtins.int
        TIMESTAMP_FIELD_NUMBER: builtins.int
        DATE_FIELD_NUMBER: builtins.int
        TIME_FIELD_NUMBER: builtins.int
        INTERVAL_YEAR_TO_MONTH_FIELD_NUMBER: builtins.int
        INTERVAL_DAY_TO_SECOND_FIELD_NUMBER: builtins.int
        FIXED_CHAR_FIELD_NUMBER: builtins.int
        VAR_CHAR_FIELD_NUMBER: builtins.int
        FIXED_BINARY_FIELD_NUMBER: builtins.int
        DECIMAL_FIELD_NUMBER: builtins.int
        STRUCT_FIELD_NUMBER: builtins.int
        MAP_FIELD_NUMBER: builtins.int
        TIMESTAMP_TZ_FIELD_NUMBER: builtins.int
        UUID_FIELD_NUMBER: builtins.int
        NULL_FIELD_NUMBER: builtins.int
        LIST_FIELD_NUMBER: builtins.int
        EMPTY_LIST_FIELD_NUMBER: builtins.int
        EMPTY_MAP_FIELD_NUMBER: builtins.int
        USER_DEFINED_FIELD_NUMBER: builtins.int
        NULLABLE_FIELD_NUMBER: builtins.int
        TYPE_VARIATION_REFERENCE_FIELD_NUMBER: builtins.int
        boolean: builtins.bool
        i8: builtins.int
        i16: builtins.int
        i32: builtins.int
        i64: builtins.int
        fp32: builtins.float
        fp64: builtins.float
        string: builtins.str
        binary: builtins.bytes
        timestamp: builtins.int
        'Timestamp in units of microseconds since the UNIX epoch.'
        date: builtins.int
        'Date in units of days since the UNIX epoch.'
        time: builtins.int
        'Time in units of microseconds past midnight'

        @property
        def interval_year_to_month(self) -> global___Expression.Literal.IntervalYearToMonth:
            ...

        @property
        def interval_day_to_second(self) -> global___Expression.Literal.IntervalDayToSecond:
            ...
        fixed_char: builtins.str

        @property
        def var_char(self) -> global___Expression.Literal.VarChar:
            ...
        fixed_binary: builtins.bytes

        @property
        def decimal(self) -> global___Expression.Literal.Decimal:
            ...

        @property
        def struct(self) -> global___Expression.Literal.Struct:
            ...

        @property
        def map(self) -> global___Expression.Literal.Map:
            ...
        timestamp_tz: builtins.int
        'Timestamp in units of microseconds since the UNIX epoch.'
        uuid: builtins.bytes

        @property
        def null(self) -> substrait.ibis.type_pb2.Type:
            """a typed null literal"""

        @property
        def list(self) -> global___Expression.Literal.List:
            ...

        @property
        def empty_list(self) -> substrait.ibis.type_pb2.Type.List:
            ...

        @property
        def empty_map(self) -> substrait.ibis.type_pb2.Type.Map:
            ...

        @property
        def user_defined(self) -> global___Expression.Literal.UserDefined:
            ...
        nullable: builtins.bool
        'whether the literal type should be treated as a nullable type. Applies to\n        all members of union other than the Typed null (which should directly\n        declare nullability).\n        '
        type_variation_reference: builtins.int
        'optionally points to a type_variation_anchor defined in this plan.\n        Applies to all members of union other than the Typed null (which should\n        directly declare the type variation).\n        '

        def __init__(self, *, boolean: builtins.bool=..., i8: builtins.int=..., i16: builtins.int=..., i32: builtins.int=..., i64: builtins.int=..., fp32: builtins.float=..., fp64: builtins.float=..., string: builtins.str=..., binary: builtins.bytes=..., timestamp: builtins.int=..., date: builtins.int=..., time: builtins.int=..., interval_year_to_month: global___Expression.Literal.IntervalYearToMonth | None=..., interval_day_to_second: global___Expression.Literal.IntervalDayToSecond | None=..., fixed_char: builtins.str=..., var_char: global___Expression.Literal.VarChar | None=..., fixed_binary: builtins.bytes=..., decimal: global___Expression.Literal.Decimal | None=..., struct: global___Expression.Literal.Struct | None=..., map: global___Expression.Literal.Map | None=..., timestamp_tz: builtins.int=..., uuid: builtins.bytes=..., null: substrait.ibis.type_pb2.Type | None=..., list: global___Expression.Literal.List | None=..., empty_list: substrait.ibis.type_pb2.Type.List | None=..., empty_map: substrait.ibis.type_pb2.Type.Map | None=..., user_defined: global___Expression.Literal.UserDefined | None=..., nullable: builtins.bool=..., type_variation_reference: builtins.int=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['binary', b'binary', 'boolean', b'boolean', 'date', b'date', 'decimal', b'decimal', 'empty_list', b'empty_list', 'empty_map', b'empty_map', 'fixed_binary', b'fixed_binary', 'fixed_char', b'fixed_char', 'fp32', b'fp32', 'fp64', b'fp64', 'i16', b'i16', 'i32', b'i32', 'i64', b'i64', 'i8', b'i8', 'interval_day_to_second', b'interval_day_to_second', 'interval_year_to_month', b'interval_year_to_month', 'list', b'list', 'literal_type', b'literal_type', 'map', b'map', 'null', b'null', 'string', b'string', 'struct', b'struct', 'time', b'time', 'timestamp', b'timestamp', 'timestamp_tz', b'timestamp_tz', 'user_defined', b'user_defined', 'uuid', b'uuid', 'var_char', b'var_char']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['binary', b'binary', 'boolean', b'boolean', 'date', b'date', 'decimal', b'decimal', 'empty_list', b'empty_list', 'empty_map', b'empty_map', 'fixed_binary', b'fixed_binary', 'fixed_char', b'fixed_char', 'fp32', b'fp32', 'fp64', b'fp64', 'i16', b'i16', 'i32', b'i32', 'i64', b'i64', 'i8', b'i8', 'interval_day_to_second', b'interval_day_to_second', 'interval_year_to_month', b'interval_year_to_month', 'list', b'list', 'literal_type', b'literal_type', 'map', b'map', 'null', b'null', 'nullable', b'nullable', 'string', b'string', 'struct', b'struct', 'time', b'time', 'timestamp', b'timestamp', 'timestamp_tz', b'timestamp_tz', 'type_variation_reference', b'type_variation_reference', 'user_defined', b'user_defined', 'uuid', b'uuid', 'var_char', b'var_char']) -> None:
            ...

        def WhichOneof(self, oneof_group: typing_extensions.Literal['literal_type', b'literal_type']) -> typing_extensions.Literal['boolean', 'i8', 'i16', 'i32', 'i64', 'fp32', 'fp64', 'string', 'binary', 'timestamp', 'date', 'time', 'interval_year_to_month', 'interval_day_to_second', 'fixed_char', 'var_char', 'fixed_binary', 'decimal', 'struct', 'map', 'timestamp_tz', 'uuid', 'null', 'list', 'empty_list', 'empty_map', 'user_defined'] | None:
            ...

    class Nested(google.protobuf.message.Message):
        """Expression to dynamically construct nested types."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Map(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class KeyValue(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor
                KEY_FIELD_NUMBER: builtins.int
                VALUE_FIELD_NUMBER: builtins.int

                @property
                def key(self) -> global___Expression:
                    """Mandatory key/value expressions."""

                @property
                def value(self) -> global___Expression:
                    ...

                def __init__(self, *, key: global___Expression | None=..., value: global___Expression | None=...) -> None:
                    ...

                def HasField(self, field_name: typing_extensions.Literal['key', b'key', 'value', b'value']) -> builtins.bool:
                    ...

                def ClearField(self, field_name: typing_extensions.Literal['key', b'key', 'value', b'value']) -> None:
                    ...
            KEY_VALUES_FIELD_NUMBER: builtins.int

            @property
            def key_values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.Nested.Map.KeyValue]:
                """One or more key-value pairs. To specify an empty map, use
                Literal.empty_map (otherwise type information would be missing).
                """

            def __init__(self, *, key_values: collections.abc.Iterable[global___Expression.Nested.Map.KeyValue] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['key_values', b'key_values']) -> None:
                ...

        class Struct(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            FIELDS_FIELD_NUMBER: builtins.int

            @property
            def fields(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
                """Zero or more possibly heterogeneously-typed list of expressions that
                form the struct fields.
                """

            def __init__(self, *, fields: collections.abc.Iterable[global___Expression] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['fields', b'fields']) -> None:
                ...

        class List(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            VALUES_FIELD_NUMBER: builtins.int

            @property
            def values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
                """A homogeneously-typed list of one or more expressions that form the
                list entries. To specify an empty list, use Literal.empty_list
                (otherwise type information would be missing).
                """

            def __init__(self, *, values: collections.abc.Iterable[global___Expression] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['values', b'values']) -> None:
                ...
        NULLABLE_FIELD_NUMBER: builtins.int
        TYPE_VARIATION_REFERENCE_FIELD_NUMBER: builtins.int
        STRUCT_FIELD_NUMBER: builtins.int
        LIST_FIELD_NUMBER: builtins.int
        MAP_FIELD_NUMBER: builtins.int
        nullable: builtins.bool
        'Whether the returned nested type is nullable.'
        type_variation_reference: builtins.int
        'Optionally points to a type_variation_anchor defined in this plan for\n        the returned nested type.\n        '

        @property
        def struct(self) -> global___Expression.Nested.Struct:
            ...

        @property
        def list(self) -> global___Expression.Nested.List:
            ...

        @property
        def map(self) -> global___Expression.Nested.Map:
            ...

        def __init__(self, *, nullable: builtins.bool=..., type_variation_reference: builtins.int=..., struct: global___Expression.Nested.Struct | None=..., list: global___Expression.Nested.List | None=..., map: global___Expression.Nested.Map | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['list', b'list', 'map', b'map', 'nested_type', b'nested_type', 'struct', b'struct']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['list', b'list', 'map', b'map', 'nested_type', b'nested_type', 'nullable', b'nullable', 'struct', b'struct', 'type_variation_reference', b'type_variation_reference']) -> None:
            ...

        def WhichOneof(self, oneof_group: typing_extensions.Literal['nested_type', b'nested_type']) -> typing_extensions.Literal['struct', 'list', 'map'] | None:
            ...

    class ScalarFunction(google.protobuf.message.Message):
        """A scalar function call."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        FUNCTION_REFERENCE_FIELD_NUMBER: builtins.int
        ARGUMENTS_FIELD_NUMBER: builtins.int
        OPTIONS_FIELD_NUMBER: builtins.int
        OUTPUT_TYPE_FIELD_NUMBER: builtins.int
        ARGS_FIELD_NUMBER: builtins.int
        function_reference: builtins.int
        'Points to a function_anchor defined in this plan, which must refer\n        to a scalar function in the associated YAML file. Required; avoid\n        using anchor/reference zero.\n        '

        @property
        def arguments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FunctionArgument]:
            """The arguments to be bound to the function. This must have exactly the
            number of arguments specified in the function definition, and the
            argument types must also match exactly:

             - Value arguments must be bound using FunctionArgument.value, and
               the expression in that must yield a value of a type that a function
               overload is defined for.
             - Type arguments must be bound using FunctionArgument.type.
             - Enum arguments must be bound using FunctionArgument.enum
               followed by Enum.specified, with a string that case-insensitively
               matches one of the allowed options.
            """

        @property
        def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FunctionOption]:
            """Options to specify behavior for corner cases, or leave behavior
            unspecified if the consumer does not need specific behavior in these
            cases.
            """

        @property
        def output_type(self) -> substrait.ibis.type_pb2.Type:
            """Must be set to the return type of the function, exactly as derived
            using the declaration in the extension.
            """

        @property
        def args(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
            """Deprecated; use arguments instead."""

        def __init__(self, *, function_reference: builtins.int=..., arguments: collections.abc.Iterable[global___FunctionArgument] | None=..., options: collections.abc.Iterable[global___FunctionOption] | None=..., output_type: substrait.ibis.type_pb2.Type | None=..., args: collections.abc.Iterable[global___Expression] | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['output_type', b'output_type']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['args', b'args', 'arguments', b'arguments', 'function_reference', b'function_reference', 'options', b'options', 'output_type', b'output_type']) -> None:
            ...

    class WindowFunction(google.protobuf.message.Message):
        """A window function call."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Bound(google.protobuf.message.Message):
            """Defines one of the two boundaries for the window of a window function."""
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class Preceding(google.protobuf.message.Message):
                """Defines that the bound extends this far back from the current record."""
                DESCRIPTOR: google.protobuf.descriptor.Descriptor
                OFFSET_FIELD_NUMBER: builtins.int
                offset: builtins.int
                'A strictly positive integer specifying the number of records that\n                the window extends back from the current record. Required. Use\n                CurrentRow for offset zero and Following for negative offsets.\n                '

                def __init__(self, *, offset: builtins.int=...) -> None:
                    ...

                def ClearField(self, field_name: typing_extensions.Literal['offset', b'offset']) -> None:
                    ...

            class Following(google.protobuf.message.Message):
                """Defines that the bound extends this far ahead of the current record."""
                DESCRIPTOR: google.protobuf.descriptor.Descriptor
                OFFSET_FIELD_NUMBER: builtins.int
                offset: builtins.int
                'A strictly positive integer specifying the number of records that\n                the window extends ahead of the current record. Required. Use\n                CurrentRow for offset zero and Preceding for negative offsets.\n                '

                def __init__(self, *, offset: builtins.int=...) -> None:
                    ...

                def ClearField(self, field_name: typing_extensions.Literal['offset', b'offset']) -> None:
                    ...

            class CurrentRow(google.protobuf.message.Message):
                """Defines that the bound extends to or from the current record."""
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                def __init__(self) -> None:
                    ...

            class Unbounded(google.protobuf.message.Message):
                """Defines an "unbounded bound": for lower bounds this means the start
                of the partition, and for upper bounds this means the end of the
                partition.
                """
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                def __init__(self) -> None:
                    ...
            PRECEDING_FIELD_NUMBER: builtins.int
            FOLLOWING_FIELD_NUMBER: builtins.int
            CURRENT_ROW_FIELD_NUMBER: builtins.int
            UNBOUNDED_FIELD_NUMBER: builtins.int

            @property
            def preceding(self) -> global___Expression.WindowFunction.Bound.Preceding:
                """The bound extends some number of records behind the current record."""

            @property
            def following(self) -> global___Expression.WindowFunction.Bound.Following:
                """The bound extends some number of records ahead of the current
                record.
                """

            @property
            def current_row(self) -> global___Expression.WindowFunction.Bound.CurrentRow:
                """The bound extends to the current record."""

            @property
            def unbounded(self) -> global___Expression.WindowFunction.Bound.Unbounded:
                """The bound extends to the start of the partition or the end of the
                partition, depending on whether this represents the upper or lower
                bound.
                """

            def __init__(self, *, preceding: global___Expression.WindowFunction.Bound.Preceding | None=..., following: global___Expression.WindowFunction.Bound.Following | None=..., current_row: global___Expression.WindowFunction.Bound.CurrentRow | None=..., unbounded: global___Expression.WindowFunction.Bound.Unbounded | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['current_row', b'current_row', 'following', b'following', 'kind', b'kind', 'preceding', b'preceding', 'unbounded', b'unbounded']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['current_row', b'current_row', 'following', b'following', 'kind', b'kind', 'preceding', b'preceding', 'unbounded', b'unbounded']) -> None:
                ...

            def WhichOneof(self, oneof_group: typing_extensions.Literal['kind', b'kind']) -> typing_extensions.Literal['preceding', 'following', 'current_row', 'unbounded'] | None:
                ...
        FUNCTION_REFERENCE_FIELD_NUMBER: builtins.int
        ARGUMENTS_FIELD_NUMBER: builtins.int
        OPTIONS_FIELD_NUMBER: builtins.int
        OUTPUT_TYPE_FIELD_NUMBER: builtins.int
        PHASE_FIELD_NUMBER: builtins.int
        SORTS_FIELD_NUMBER: builtins.int
        INVOCATION_FIELD_NUMBER: builtins.int
        PARTITIONS_FIELD_NUMBER: builtins.int
        LOWER_BOUND_FIELD_NUMBER: builtins.int
        UPPER_BOUND_FIELD_NUMBER: builtins.int
        ARGS_FIELD_NUMBER: builtins.int
        function_reference: builtins.int
        'Points to a function_anchor defined in this plan, which must refer\n        to a window function in the associated YAML file. Required; 0 is\n        considered to be a valid anchor/reference.\n        '

        @property
        def arguments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FunctionArgument]:
            """The arguments to be bound to the function. This must have exactly the
            number of arguments specified in the function definition, and the
            argument types must also match exactly:

             - Value arguments must be bound using FunctionArgument.value, and
               the expression in that must yield a value of a type that a function
               overload is defined for.
             - Type arguments must be bound using FunctionArgument.type, and a
               function overload must be defined for that type.
             - Enum arguments must be bound using FunctionArgument.enum
               followed by Enum.specified, with a string that case-insensitively
               matches one of the allowed options.
            """

        @property
        def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FunctionOption]:
            """Options to specify behavior for corner cases, or leave behavior
            unspecified if the consumer does not need specific behavior in these
            cases.
            """

        @property
        def output_type(self) -> substrait.ibis.type_pb2.Type:
            """Must be set to the return type of the function, exactly as derived
            using the declaration in the extension.
            """
        phase: global___AggregationPhase.ValueType
        'Describes which part of the window function to perform within the\n        context of distributed algorithms. Required. Must be set to\n        INITIAL_TO_RESULT for window functions that are not decomposable.\n        '

        @property
        def sorts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SortField]:
            """If specified, the records that are part of the window defined by
            upper_bound and lower_bound are ordered according to this list
            before they are aggregated. The first sort field has the highest
            priority; only if a sort field determines two records to be equivalent
            is the next field queried. This field is optional, and is only allowed
            if the window function is defined to support sorting.
            """
        invocation: global___AggregateFunction.AggregationInvocation.ValueType
        'Specifies whether equivalent records are merged before being aggregated.\n        Optional, defaults to AGGREGATION_INVOCATION_ALL.\n        '

        @property
        def partitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
            """When one or more partition expressions are specified, two records are
            considered to be in the same partition if and only if these expressions
            yield an equal tuple of values for both. When computing the window
            function, only the subset of records within the bounds that are also in
            the same partition as the current record are aggregated.
            """

        @property
        def lower_bound(self) -> global___Expression.WindowFunction.Bound:
            """Defines the record relative to the current record from which the window
            extends. The bound is inclusive. If the lower bound indexes a record
            greater than the upper bound, TODO (null range/no records passed?
            wrapping around as if lower/upper were swapped? error? null?).
            Optional; defaults to the start of the partition.
            """

        @property
        def upper_bound(self) -> global___Expression.WindowFunction.Bound:
            """Defines the record relative to the current record up to which the window
            extends. The bound is inclusive. If the upper bound indexes a record
            less than the lower bound, TODO (null range/no records passed?
            wrapping around as if lower/upper were swapped? error? null?).
            Optional; defaults to the end of the partition.
            """

        @property
        def args(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
            """Deprecated; use arguments instead."""

        def __init__(self, *, function_reference: builtins.int=..., arguments: collections.abc.Iterable[global___FunctionArgument] | None=..., options: collections.abc.Iterable[global___FunctionOption] | None=..., output_type: substrait.ibis.type_pb2.Type | None=..., phase: global___AggregationPhase.ValueType=..., sorts: collections.abc.Iterable[global___SortField] | None=..., invocation: global___AggregateFunction.AggregationInvocation.ValueType=..., partitions: collections.abc.Iterable[global___Expression] | None=..., lower_bound: global___Expression.WindowFunction.Bound | None=..., upper_bound: global___Expression.WindowFunction.Bound | None=..., args: collections.abc.Iterable[global___Expression] | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['lower_bound', b'lower_bound', 'output_type', b'output_type', 'upper_bound', b'upper_bound']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['args', b'args', 'arguments', b'arguments', 'function_reference', b'function_reference', 'invocation', b'invocation', 'lower_bound', b'lower_bound', 'options', b'options', 'output_type', b'output_type', 'partitions', b'partitions', 'phase', b'phase', 'sorts', b'sorts', 'upper_bound', b'upper_bound']) -> None:
            ...

    class IfThen(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class IfClause(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            IF_FIELD_NUMBER: builtins.int
            THEN_FIELD_NUMBER: builtins.int

            @property
            def then(self) -> global___Expression:
                ...

            def __init__(self, *, then: global___Expression | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['if', b'if', 'then', b'then']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['if', b'if', 'then', b'then']) -> None:
                ...
        IFS_FIELD_NUMBER: builtins.int
        ELSE_FIELD_NUMBER: builtins.int

        @property
        def ifs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.IfThen.IfClause]:
            ...

        def __init__(self, *, ifs: collections.abc.Iterable[global___Expression.IfThen.IfClause] | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['else', b'else']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['else', b'else', 'ifs', b'ifs']) -> None:
            ...

    class Cast(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _FailureBehavior:
            ValueType = typing.NewType('ValueType', builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _FailureBehaviorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Expression.Cast._FailureBehavior.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            FAILURE_BEHAVIOR_UNSPECIFIED: Expression.Cast._FailureBehavior.ValueType
            FAILURE_BEHAVIOR_RETURN_NULL: Expression.Cast._FailureBehavior.ValueType
            FAILURE_BEHAVIOR_THROW_EXCEPTION: Expression.Cast._FailureBehavior.ValueType

        class FailureBehavior(_FailureBehavior, metaclass=_FailureBehaviorEnumTypeWrapper):
            ...
        FAILURE_BEHAVIOR_UNSPECIFIED: Expression.Cast.FailureBehavior.ValueType
        FAILURE_BEHAVIOR_RETURN_NULL: Expression.Cast.FailureBehavior.ValueType
        FAILURE_BEHAVIOR_THROW_EXCEPTION: Expression.Cast.FailureBehavior.ValueType
        TYPE_FIELD_NUMBER: builtins.int
        INPUT_FIELD_NUMBER: builtins.int
        FAILURE_BEHAVIOR_FIELD_NUMBER: builtins.int

        @property
        def type(self) -> substrait.ibis.type_pb2.Type:
            ...

        @property
        def input(self) -> global___Expression:
            ...
        failure_behavior: global___Expression.Cast.FailureBehavior.ValueType

        def __init__(self, *, type: substrait.ibis.type_pb2.Type | None=..., input: global___Expression | None=..., failure_behavior: global___Expression.Cast.FailureBehavior.ValueType=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['input', b'input', 'type', b'type']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['failure_behavior', b'failure_behavior', 'input', b'input', 'type', b'type']) -> None:
            ...

    class SwitchExpression(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class IfValue(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            IF_FIELD_NUMBER: builtins.int
            THEN_FIELD_NUMBER: builtins.int

            @property
            def then(self) -> global___Expression:
                ...

            def __init__(self, *, then: global___Expression | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['if', b'if', 'then', b'then']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['if', b'if', 'then', b'then']) -> None:
                ...
        MATCH_FIELD_NUMBER: builtins.int
        IFS_FIELD_NUMBER: builtins.int
        ELSE_FIELD_NUMBER: builtins.int

        @property
        def match(self) -> global___Expression:
            ...

        @property
        def ifs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.SwitchExpression.IfValue]:
            ...

        def __init__(self, *, match: global___Expression | None=..., ifs: collections.abc.Iterable[global___Expression.SwitchExpression.IfValue] | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['else', b'else', 'match', b'match']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['else', b'else', 'ifs', b'ifs', 'match', b'match']) -> None:
            ...

    class SingularOrList(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        VALUE_FIELD_NUMBER: builtins.int
        OPTIONS_FIELD_NUMBER: builtins.int

        @property
        def value(self) -> global___Expression:
            ...

        @property
        def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
            ...

        def __init__(self, *, value: global___Expression | None=..., options: collections.abc.Iterable[global___Expression] | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['value', b'value']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['options', b'options', 'value', b'value']) -> None:
            ...

    class MultiOrList(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Record(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            FIELDS_FIELD_NUMBER: builtins.int

            @property
            def fields(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
                ...

            def __init__(self, *, fields: collections.abc.Iterable[global___Expression] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['fields', b'fields']) -> None:
                ...
        VALUE_FIELD_NUMBER: builtins.int
        OPTIONS_FIELD_NUMBER: builtins.int

        @property
        def value(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
            ...

        @property
        def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.MultiOrList.Record]:
            ...

        def __init__(self, *, value: collections.abc.Iterable[global___Expression] | None=..., options: collections.abc.Iterable[global___Expression.MultiOrList.Record] | None=...) -> None:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['options', b'options', 'value', b'value']) -> None:
            ...

    class EmbeddedFunction(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class PythonPickleFunction(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            FUNCTION_FIELD_NUMBER: builtins.int
            PREREQUISITE_FIELD_NUMBER: builtins.int
            function: builtins.bytes

            @property
            def prerequisite(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
                ...

            def __init__(self, *, function: builtins.bytes=..., prerequisite: collections.abc.Iterable[builtins.str] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['function', b'function', 'prerequisite', b'prerequisite']) -> None:
                ...

        class WebAssemblyFunction(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            SCRIPT_FIELD_NUMBER: builtins.int
            PREREQUISITE_FIELD_NUMBER: builtins.int
            script: builtins.bytes

            @property
            def prerequisite(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
                ...

            def __init__(self, *, script: builtins.bytes=..., prerequisite: collections.abc.Iterable[builtins.str] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['prerequisite', b'prerequisite', 'script', b'script']) -> None:
                ...
        ARGUMENTS_FIELD_NUMBER: builtins.int
        OUTPUT_TYPE_FIELD_NUMBER: builtins.int
        PYTHON_PICKLE_FUNCTION_FIELD_NUMBER: builtins.int
        WEB_ASSEMBLY_FUNCTION_FIELD_NUMBER: builtins.int

        @property
        def arguments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
            ...

        @property
        def output_type(self) -> substrait.ibis.type_pb2.Type:
            ...

        @property
        def python_pickle_function(self) -> global___Expression.EmbeddedFunction.PythonPickleFunction:
            ...

        @property
        def web_assembly_function(self) -> global___Expression.EmbeddedFunction.WebAssemblyFunction:
            ...

        def __init__(self, *, arguments: collections.abc.Iterable[global___Expression] | None=..., output_type: substrait.ibis.type_pb2.Type | None=..., python_pickle_function: global___Expression.EmbeddedFunction.PythonPickleFunction | None=..., web_assembly_function: global___Expression.EmbeddedFunction.WebAssemblyFunction | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['kind', b'kind', 'output_type', b'output_type', 'python_pickle_function', b'python_pickle_function', 'web_assembly_function', b'web_assembly_function']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['arguments', b'arguments', 'kind', b'kind', 'output_type', b'output_type', 'python_pickle_function', b'python_pickle_function', 'web_assembly_function', b'web_assembly_function']) -> None:
            ...

        def WhichOneof(self, oneof_group: typing_extensions.Literal['kind', b'kind']) -> typing_extensions.Literal['python_pickle_function', 'web_assembly_function'] | None:
            ...

    class ReferenceSegment(google.protobuf.message.Message):
        """A way to reference the inner property of a complex record. Can reference
        either a map key by literal, a struct field by the ordinal position of
        the desired field or a particular element in an array. Supports
        expressions that would roughly translate to something similar to:
        a.b[2].c['my_map_key'].x where a,b,c and x are struct field references
        (ordinalized in the internal representation here), [2] is a list offset
        and ['my_map_key'] is a reference into a map field.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class MapKey(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            MAP_KEY_FIELD_NUMBER: builtins.int
            CHILD_FIELD_NUMBER: builtins.int

            @property
            def map_key(self) -> global___Expression.Literal:
                """literal based reference to specific possible value in map."""

            @property
            def child(self) -> global___Expression.ReferenceSegment:
                """Optional child segment"""

            def __init__(self, *, map_key: global___Expression.Literal | None=..., child: global___Expression.ReferenceSegment | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['child', b'child', 'map_key', b'map_key']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['child', b'child', 'map_key', b'map_key']) -> None:
                ...

        class StructField(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            FIELD_FIELD_NUMBER: builtins.int
            CHILD_FIELD_NUMBER: builtins.int
            field: builtins.int
            'zero-indexed ordinal position of field in struct'

            @property
            def child(self) -> global___Expression.ReferenceSegment:
                """Optional child segment"""

            def __init__(self, *, field: builtins.int=..., child: global___Expression.ReferenceSegment | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['child', b'child']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['child', b'child', 'field', b'field']) -> None:
                ...

        class ListElement(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            OFFSET_FIELD_NUMBER: builtins.int
            CHILD_FIELD_NUMBER: builtins.int
            offset: builtins.int
            'zero-indexed ordinal position of element in list'

            @property
            def child(self) -> global___Expression.ReferenceSegment:
                """Optional child segment"""

            def __init__(self, *, offset: builtins.int=..., child: global___Expression.ReferenceSegment | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['child', b'child']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['child', b'child', 'offset', b'offset']) -> None:
                ...
        MAP_KEY_FIELD_NUMBER: builtins.int
        STRUCT_FIELD_FIELD_NUMBER: builtins.int
        LIST_ELEMENT_FIELD_NUMBER: builtins.int

        @property
        def map_key(self) -> global___Expression.ReferenceSegment.MapKey:
            ...

        @property
        def struct_field(self) -> global___Expression.ReferenceSegment.StructField:
            ...

        @property
        def list_element(self) -> global___Expression.ReferenceSegment.ListElement:
            ...

        def __init__(self, *, map_key: global___Expression.ReferenceSegment.MapKey | None=..., struct_field: global___Expression.ReferenceSegment.StructField | None=..., list_element: global___Expression.ReferenceSegment.ListElement | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['list_element', b'list_element', 'map_key', b'map_key', 'reference_type', b'reference_type', 'struct_field', b'struct_field']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['list_element', b'list_element', 'map_key', b'map_key', 'reference_type', b'reference_type', 'struct_field', b'struct_field']) -> None:
            ...

        def WhichOneof(self, oneof_group: typing_extensions.Literal['reference_type', b'reference_type']) -> typing_extensions.Literal['map_key', 'struct_field', 'list_element'] | None:
            ...

    class MaskExpression(google.protobuf.message.Message):
        """A reference that takes an existing subtype and selectively removes fields
        from it. For example, one might initially have an inner struct with 100
        fields but a a particular operation only needs to interact with only 2 of
        those 100 fields. In this situation, one would use a mask expression to
        eliminate the 98 fields that are not relevant to the rest of the operation
        pipeline.

        Note that this does not fundamentally alter the structure of data beyond
        the elimination of unecessary elements.
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Select(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            STRUCT_FIELD_NUMBER: builtins.int
            LIST_FIELD_NUMBER: builtins.int
            MAP_FIELD_NUMBER: builtins.int

            @property
            def struct(self) -> global___Expression.MaskExpression.StructSelect:
                ...

            @property
            def list(self) -> global___Expression.MaskExpression.ListSelect:
                ...

            @property
            def map(self) -> global___Expression.MaskExpression.MapSelect:
                ...

            def __init__(self, *, struct: global___Expression.MaskExpression.StructSelect | None=..., list: global___Expression.MaskExpression.ListSelect | None=..., map: global___Expression.MaskExpression.MapSelect | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['list', b'list', 'map', b'map', 'struct', b'struct', 'type', b'type']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['list', b'list', 'map', b'map', 'struct', b'struct', 'type', b'type']) -> None:
                ...

            def WhichOneof(self, oneof_group: typing_extensions.Literal['type', b'type']) -> typing_extensions.Literal['struct', 'list', 'map'] | None:
                ...

        class StructSelect(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            STRUCT_ITEMS_FIELD_NUMBER: builtins.int

            @property
            def struct_items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.MaskExpression.StructItem]:
                ...

            def __init__(self, *, struct_items: collections.abc.Iterable[global___Expression.MaskExpression.StructItem] | None=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['struct_items', b'struct_items']) -> None:
                ...

        class StructItem(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            FIELD_FIELD_NUMBER: builtins.int
            CHILD_FIELD_NUMBER: builtins.int
            field: builtins.int

            @property
            def child(self) -> global___Expression.MaskExpression.Select:
                ...

            def __init__(self, *, field: builtins.int=..., child: global___Expression.MaskExpression.Select | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['child', b'child']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['child', b'child', 'field', b'field']) -> None:
                ...

        class ListSelect(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class ListSelectItem(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                class ListElement(google.protobuf.message.Message):
                    DESCRIPTOR: google.protobuf.descriptor.Descriptor
                    FIELD_FIELD_NUMBER: builtins.int
                    field: builtins.int

                    def __init__(self, *, field: builtins.int=...) -> None:
                        ...

                    def ClearField(self, field_name: typing_extensions.Literal['field', b'field']) -> None:
                        ...

                class ListSlice(google.protobuf.message.Message):
                    DESCRIPTOR: google.protobuf.descriptor.Descriptor
                    START_FIELD_NUMBER: builtins.int
                    END_FIELD_NUMBER: builtins.int
                    start: builtins.int
                    end: builtins.int

                    def __init__(self, *, start: builtins.int=..., end: builtins.int=...) -> None:
                        ...

                    def ClearField(self, field_name: typing_extensions.Literal['end', b'end', 'start', b'start']) -> None:
                        ...
                ITEM_FIELD_NUMBER: builtins.int
                SLICE_FIELD_NUMBER: builtins.int

                @property
                def item(self) -> global___Expression.MaskExpression.ListSelect.ListSelectItem.ListElement:
                    ...

                @property
                def slice(self) -> global___Expression.MaskExpression.ListSelect.ListSelectItem.ListSlice:
                    ...

                def __init__(self, *, item: global___Expression.MaskExpression.ListSelect.ListSelectItem.ListElement | None=..., slice: global___Expression.MaskExpression.ListSelect.ListSelectItem.ListSlice | None=...) -> None:
                    ...

                def HasField(self, field_name: typing_extensions.Literal['item', b'item', 'slice', b'slice', 'type', b'type']) -> builtins.bool:
                    ...

                def ClearField(self, field_name: typing_extensions.Literal['item', b'item', 'slice', b'slice', 'type', b'type']) -> None:
                    ...

                def WhichOneof(self, oneof_group: typing_extensions.Literal['type', b'type']) -> typing_extensions.Literal['item', 'slice'] | None:
                    ...
            SELECTION_FIELD_NUMBER: builtins.int
            CHILD_FIELD_NUMBER: builtins.int

            @property
            def selection(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression.MaskExpression.ListSelect.ListSelectItem]:
                ...

            @property
            def child(self) -> global___Expression.MaskExpression.Select:
                ...

            def __init__(self, *, selection: collections.abc.Iterable[global___Expression.MaskExpression.ListSelect.ListSelectItem] | None=..., child: global___Expression.MaskExpression.Select | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['child', b'child']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['child', b'child', 'selection', b'selection']) -> None:
                ...

        class MapSelect(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class MapKey(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor
                MAP_KEY_FIELD_NUMBER: builtins.int
                map_key: builtins.str

                def __init__(self, *, map_key: builtins.str=...) -> None:
                    ...

                def ClearField(self, field_name: typing_extensions.Literal['map_key', b'map_key']) -> None:
                    ...

            class MapKeyExpression(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor
                MAP_KEY_EXPRESSION_FIELD_NUMBER: builtins.int
                map_key_expression: builtins.str

                def __init__(self, *, map_key_expression: builtins.str=...) -> None:
                    ...

                def ClearField(self, field_name: typing_extensions.Literal['map_key_expression', b'map_key_expression']) -> None:
                    ...
            KEY_FIELD_NUMBER: builtins.int
            EXPRESSION_FIELD_NUMBER: builtins.int
            CHILD_FIELD_NUMBER: builtins.int

            @property
            def key(self) -> global___Expression.MaskExpression.MapSelect.MapKey:
                ...

            @property
            def expression(self) -> global___Expression.MaskExpression.MapSelect.MapKeyExpression:
                ...

            @property
            def child(self) -> global___Expression.MaskExpression.Select:
                ...

            def __init__(self, *, key: global___Expression.MaskExpression.MapSelect.MapKey | None=..., expression: global___Expression.MaskExpression.MapSelect.MapKeyExpression | None=..., child: global___Expression.MaskExpression.Select | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['child', b'child', 'expression', b'expression', 'key', b'key', 'select', b'select']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['child', b'child', 'expression', b'expression', 'key', b'key', 'select', b'select']) -> None:
                ...

            def WhichOneof(self, oneof_group: typing_extensions.Literal['select', b'select']) -> typing_extensions.Literal['key', 'expression'] | None:
                ...
        SELECT_FIELD_NUMBER: builtins.int
        MAINTAIN_SINGULAR_STRUCT_FIELD_NUMBER: builtins.int

        @property
        def select(self) -> global___Expression.MaskExpression.StructSelect:
            ...
        maintain_singular_struct: builtins.bool

        def __init__(self, *, select: global___Expression.MaskExpression.StructSelect | None=..., maintain_singular_struct: builtins.bool=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['select', b'select']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['maintain_singular_struct', b'maintain_singular_struct', 'select', b'select']) -> None:
            ...

    class FieldReference(google.protobuf.message.Message):
        """A reference to an inner part of a complex object. Can reference reference a
        single element or a masked version of elements
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class RootReference(google.protobuf.message.Message):
            """Singleton that expresses this FieldReference is rooted off the root
            incoming record type
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            def __init__(self) -> None:
                ...

        class OuterReference(google.protobuf.message.Message):
            """A root reference for the outer relation's subquery"""
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            STEPS_OUT_FIELD_NUMBER: builtins.int
            steps_out: builtins.int
            "number of subquery boundaries to traverse up for this field's reference\n\n            This value must be >= 1\n            "

            def __init__(self, *, steps_out: builtins.int=...) -> None:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['steps_out', b'steps_out']) -> None:
                ...
        DIRECT_REFERENCE_FIELD_NUMBER: builtins.int
        MASKED_REFERENCE_FIELD_NUMBER: builtins.int
        EXPRESSION_FIELD_NUMBER: builtins.int
        ROOT_REFERENCE_FIELD_NUMBER: builtins.int
        OUTER_REFERENCE_FIELD_NUMBER: builtins.int

        @property
        def direct_reference(self) -> global___Expression.ReferenceSegment:
            ...

        @property
        def masked_reference(self) -> global___Expression.MaskExpression:
            ...

        @property
        def expression(self) -> global___Expression:
            ...

        @property
        def root_reference(self) -> global___Expression.FieldReference.RootReference:
            ...

        @property
        def outer_reference(self) -> global___Expression.FieldReference.OuterReference:
            ...

        def __init__(self, *, direct_reference: global___Expression.ReferenceSegment | None=..., masked_reference: global___Expression.MaskExpression | None=..., expression: global___Expression | None=..., root_reference: global___Expression.FieldReference.RootReference | None=..., outer_reference: global___Expression.FieldReference.OuterReference | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['direct_reference', b'direct_reference', 'expression', b'expression', 'masked_reference', b'masked_reference', 'outer_reference', b'outer_reference', 'reference_type', b'reference_type', 'root_reference', b'root_reference', 'root_type', b'root_type']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['direct_reference', b'direct_reference', 'expression', b'expression', 'masked_reference', b'masked_reference', 'outer_reference', b'outer_reference', 'reference_type', b'reference_type', 'root_reference', b'root_reference', 'root_type', b'root_type']) -> None:
            ...

        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal['reference_type', b'reference_type']) -> typing_extensions.Literal['direct_reference', 'masked_reference'] | None:
            ...

        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal['root_type', b'root_type']) -> typing_extensions.Literal['expression', 'root_reference', 'outer_reference'] | None:
            ...

    class Subquery(google.protobuf.message.Message):
        """Subquery relation expression"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class Scalar(google.protobuf.message.Message):
            """A subquery with one row and one column. This is often an aggregate
            though not required to be.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            INPUT_FIELD_NUMBER: builtins.int

            @property
            def input(self) -> global___Rel:
                ...

            def __init__(self, *, input: global___Rel | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['input', b'input']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['input', b'input']) -> None:
                ...

        class InPredicate(google.protobuf.message.Message):
            """Predicate checking that the left expression is contained in the right
            subquery

            Examples:

            x IN (SELECT * FROM t)
            (x, y) IN (SELECT a, b FROM t)
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor
            NEEDLES_FIELD_NUMBER: builtins.int
            HAYSTACK_FIELD_NUMBER: builtins.int

            @property
            def needles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
                ...

            @property
            def haystack(self) -> global___Rel:
                ...

            def __init__(self, *, needles: collections.abc.Iterable[global___Expression] | None=..., haystack: global___Rel | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['haystack', b'haystack']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['haystack', b'haystack', 'needles', b'needles']) -> None:
                ...

        class SetPredicate(google.protobuf.message.Message):
            """A predicate over a set of rows in the form of a subquery
            EXISTS and UNIQUE are common SQL forms of this operation.
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _PredicateOp:
                ValueType = typing.NewType('ValueType', builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _PredicateOpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Expression.Subquery.SetPredicate._PredicateOp.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                PREDICATE_OP_UNSPECIFIED: Expression.Subquery.SetPredicate._PredicateOp.ValueType
                PREDICATE_OP_EXISTS: Expression.Subquery.SetPredicate._PredicateOp.ValueType
                PREDICATE_OP_UNIQUE: Expression.Subquery.SetPredicate._PredicateOp.ValueType

            class PredicateOp(_PredicateOp, metaclass=_PredicateOpEnumTypeWrapper):
                ...
            PREDICATE_OP_UNSPECIFIED: Expression.Subquery.SetPredicate.PredicateOp.ValueType
            PREDICATE_OP_EXISTS: Expression.Subquery.SetPredicate.PredicateOp.ValueType
            PREDICATE_OP_UNIQUE: Expression.Subquery.SetPredicate.PredicateOp.ValueType
            PREDICATE_OP_FIELD_NUMBER: builtins.int
            TUPLES_FIELD_NUMBER: builtins.int
            predicate_op: global___Expression.Subquery.SetPredicate.PredicateOp.ValueType
            'TODO: should allow expressions'

            @property
            def tuples(self) -> global___Rel:
                ...

            def __init__(self, *, predicate_op: global___Expression.Subquery.SetPredicate.PredicateOp.ValueType=..., tuples: global___Rel | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['tuples', b'tuples']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['predicate_op', b'predicate_op', 'tuples', b'tuples']) -> None:
                ...

        class SetComparison(google.protobuf.message.Message):
            """A subquery comparison using ANY or ALL.
            Examples:

            SELECT *
            FROM t1
            WHERE x < ANY(SELECT y from t2)
            """
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _ComparisonOp:
                ValueType = typing.NewType('ValueType', builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _ComparisonOpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Expression.Subquery.SetComparison._ComparisonOp.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                COMPARISON_OP_UNSPECIFIED: Expression.Subquery.SetComparison._ComparisonOp.ValueType
                COMPARISON_OP_EQ: Expression.Subquery.SetComparison._ComparisonOp.ValueType
                COMPARISON_OP_NE: Expression.Subquery.SetComparison._ComparisonOp.ValueType
                COMPARISON_OP_LT: Expression.Subquery.SetComparison._ComparisonOp.ValueType
                COMPARISON_OP_GT: Expression.Subquery.SetComparison._ComparisonOp.ValueType
                COMPARISON_OP_LE: Expression.Subquery.SetComparison._ComparisonOp.ValueType
                COMPARISON_OP_GE: Expression.Subquery.SetComparison._ComparisonOp.ValueType

            class ComparisonOp(_ComparisonOp, metaclass=_ComparisonOpEnumTypeWrapper):
                ...
            COMPARISON_OP_UNSPECIFIED: Expression.Subquery.SetComparison.ComparisonOp.ValueType
            COMPARISON_OP_EQ: Expression.Subquery.SetComparison.ComparisonOp.ValueType
            COMPARISON_OP_NE: Expression.Subquery.SetComparison.ComparisonOp.ValueType
            COMPARISON_OP_LT: Expression.Subquery.SetComparison.ComparisonOp.ValueType
            COMPARISON_OP_GT: Expression.Subquery.SetComparison.ComparisonOp.ValueType
            COMPARISON_OP_LE: Expression.Subquery.SetComparison.ComparisonOp.ValueType
            COMPARISON_OP_GE: Expression.Subquery.SetComparison.ComparisonOp.ValueType

            class _ReductionOp:
                ValueType = typing.NewType('ValueType', builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _ReductionOpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Expression.Subquery.SetComparison._ReductionOp.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                REDUCTION_OP_UNSPECIFIED: Expression.Subquery.SetComparison._ReductionOp.ValueType
                REDUCTION_OP_ANY: Expression.Subquery.SetComparison._ReductionOp.ValueType
                REDUCTION_OP_ALL: Expression.Subquery.SetComparison._ReductionOp.ValueType

            class ReductionOp(_ReductionOp, metaclass=_ReductionOpEnumTypeWrapper):
                ...
            REDUCTION_OP_UNSPECIFIED: Expression.Subquery.SetComparison.ReductionOp.ValueType
            REDUCTION_OP_ANY: Expression.Subquery.SetComparison.ReductionOp.ValueType
            REDUCTION_OP_ALL: Expression.Subquery.SetComparison.ReductionOp.ValueType
            REDUCTION_OP_FIELD_NUMBER: builtins.int
            COMPARISON_OP_FIELD_NUMBER: builtins.int
            LEFT_FIELD_NUMBER: builtins.int
            RIGHT_FIELD_NUMBER: builtins.int
            reduction_op: global___Expression.Subquery.SetComparison.ReductionOp.ValueType
            'ANY or ALL'
            comparison_op: global___Expression.Subquery.SetComparison.ComparisonOp.ValueType
            'A comparison operator'

            @property
            def left(self) -> global___Expression:
                """left side of the expression"""

            @property
            def right(self) -> global___Rel:
                """right side of the expression"""

            def __init__(self, *, reduction_op: global___Expression.Subquery.SetComparison.ReductionOp.ValueType=..., comparison_op: global___Expression.Subquery.SetComparison.ComparisonOp.ValueType=..., left: global___Expression | None=..., right: global___Rel | None=...) -> None:
                ...

            def HasField(self, field_name: typing_extensions.Literal['left', b'left', 'right', b'right']) -> builtins.bool:
                ...

            def ClearField(self, field_name: typing_extensions.Literal['comparison_op', b'comparison_op', 'left', b'left', 'reduction_op', b'reduction_op', 'right', b'right']) -> None:
                ...
        SCALAR_FIELD_NUMBER: builtins.int
        IN_PREDICATE_FIELD_NUMBER: builtins.int
        SET_PREDICATE_FIELD_NUMBER: builtins.int
        SET_COMPARISON_FIELD_NUMBER: builtins.int

        @property
        def scalar(self) -> global___Expression.Subquery.Scalar:
            """Scalar subquery"""

        @property
        def in_predicate(self) -> global___Expression.Subquery.InPredicate:
            """x IN y predicate"""

        @property
        def set_predicate(self) -> global___Expression.Subquery.SetPredicate:
            """EXISTS/UNIQUE predicate"""

        @property
        def set_comparison(self) -> global___Expression.Subquery.SetComparison:
            """ANY/ALL predicate"""

        def __init__(self, *, scalar: global___Expression.Subquery.Scalar | None=..., in_predicate: global___Expression.Subquery.InPredicate | None=..., set_predicate: global___Expression.Subquery.SetPredicate | None=..., set_comparison: global___Expression.Subquery.SetComparison | None=...) -> None:
            ...

        def HasField(self, field_name: typing_extensions.Literal['in_predicate', b'in_predicate', 'scalar', b'scalar', 'set_comparison', b'set_comparison', 'set_predicate', b'set_predicate', 'subquery_type', b'subquery_type']) -> builtins.bool:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['in_predicate', b'in_predicate', 'scalar', b'scalar', 'set_comparison', b'set_comparison', 'set_predicate', b'set_predicate', 'subquery_type', b'subquery_type']) -> None:
            ...

        def WhichOneof(self, oneof_group: typing_extensions.Literal['subquery_type', b'subquery_type']) -> typing_extensions.Literal['scalar', 'in_predicate', 'set_predicate', 'set_comparison'] | None:
            ...
    LITERAL_FIELD_NUMBER: builtins.int
    SELECTION_FIELD_NUMBER: builtins.int
    SCALAR_FUNCTION_FIELD_NUMBER: builtins.int
    WINDOW_FUNCTION_FIELD_NUMBER: builtins.int
    IF_THEN_FIELD_NUMBER: builtins.int
    SWITCH_EXPRESSION_FIELD_NUMBER: builtins.int
    SINGULAR_OR_LIST_FIELD_NUMBER: builtins.int
    MULTI_OR_LIST_FIELD_NUMBER: builtins.int
    CAST_FIELD_NUMBER: builtins.int
    SUBQUERY_FIELD_NUMBER: builtins.int
    NESTED_FIELD_NUMBER: builtins.int
    ENUM_FIELD_NUMBER: builtins.int

    @property
    def literal(self) -> global___Expression.Literal:
        ...

    @property
    def selection(self) -> global___Expression.FieldReference:
        ...

    @property
    def scalar_function(self) -> global___Expression.ScalarFunction:
        ...

    @property
    def window_function(self) -> global___Expression.WindowFunction:
        ...

    @property
    def if_then(self) -> global___Expression.IfThen:
        ...

    @property
    def switch_expression(self) -> global___Expression.SwitchExpression:
        ...

    @property
    def singular_or_list(self) -> global___Expression.SingularOrList:
        ...

    @property
    def multi_or_list(self) -> global___Expression.MultiOrList:
        ...

    @property
    def cast(self) -> global___Expression.Cast:
        ...

    @property
    def subquery(self) -> global___Expression.Subquery:
        ...

    @property
    def nested(self) -> global___Expression.Nested:
        ...

    @property
    def enum(self) -> global___Expression.Enum:
        """deprecated: enum literals are only sensible in the context of
        function arguments, for which FunctionArgument should now be
        used
        """

    def __init__(self, *, literal: global___Expression.Literal | None=..., selection: global___Expression.FieldReference | None=..., scalar_function: global___Expression.ScalarFunction | None=..., window_function: global___Expression.WindowFunction | None=..., if_then: global___Expression.IfThen | None=..., switch_expression: global___Expression.SwitchExpression | None=..., singular_or_list: global___Expression.SingularOrList | None=..., multi_or_list: global___Expression.MultiOrList | None=..., cast: global___Expression.Cast | None=..., subquery: global___Expression.Subquery | None=..., nested: global___Expression.Nested | None=..., enum: global___Expression.Enum | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['cast', b'cast', 'enum', b'enum', 'if_then', b'if_then', 'literal', b'literal', 'multi_or_list', b'multi_or_list', 'nested', b'nested', 'rex_type', b'rex_type', 'scalar_function', b'scalar_function', 'selection', b'selection', 'singular_or_list', b'singular_or_list', 'subquery', b'subquery', 'switch_expression', b'switch_expression', 'window_function', b'window_function']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['cast', b'cast', 'enum', b'enum', 'if_then', b'if_then', 'literal', b'literal', 'multi_or_list', b'multi_or_list', 'nested', b'nested', 'rex_type', b'rex_type', 'scalar_function', b'scalar_function', 'selection', b'selection', 'singular_or_list', b'singular_or_list', 'subquery', b'subquery', 'switch_expression', b'switch_expression', 'window_function', b'window_function']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['rex_type', b'rex_type']) -> typing_extensions.Literal['literal', 'selection', 'scalar_function', 'window_function', 'if_then', 'switch_expression', 'singular_or_list', 'multi_or_list', 'cast', 'subquery', 'nested', 'enum'] | None:
        ...
global___Expression = Expression

class SortField(google.protobuf.message.Message):
    """The description of a field to sort on (including the direction of sorting and null semantics)"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SortDirection:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SortDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SortField._SortDirection.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SORT_DIRECTION_UNSPECIFIED: SortField._SortDirection.ValueType
        SORT_DIRECTION_ASC_NULLS_FIRST: SortField._SortDirection.ValueType
        SORT_DIRECTION_ASC_NULLS_LAST: SortField._SortDirection.ValueType
        SORT_DIRECTION_DESC_NULLS_FIRST: SortField._SortDirection.ValueType
        SORT_DIRECTION_DESC_NULLS_LAST: SortField._SortDirection.ValueType
        SORT_DIRECTION_CLUSTERED: SortField._SortDirection.ValueType

    class SortDirection(_SortDirection, metaclass=_SortDirectionEnumTypeWrapper):
        ...
    SORT_DIRECTION_UNSPECIFIED: SortField.SortDirection.ValueType
    SORT_DIRECTION_ASC_NULLS_FIRST: SortField.SortDirection.ValueType
    SORT_DIRECTION_ASC_NULLS_LAST: SortField.SortDirection.ValueType
    SORT_DIRECTION_DESC_NULLS_FIRST: SortField.SortDirection.ValueType
    SORT_DIRECTION_DESC_NULLS_LAST: SortField.SortDirection.ValueType
    SORT_DIRECTION_CLUSTERED: SortField.SortDirection.ValueType
    EXPR_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    COMPARISON_FUNCTION_REFERENCE_FIELD_NUMBER: builtins.int

    @property
    def expr(self) -> global___Expression:
        ...
    direction: global___SortField.SortDirection.ValueType
    comparison_function_reference: builtins.int

    def __init__(self, *, expr: global___Expression | None=..., direction: global___SortField.SortDirection.ValueType=..., comparison_function_reference: builtins.int=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['comparison_function_reference', b'comparison_function_reference', 'direction', b'direction', 'expr', b'expr', 'sort_kind', b'sort_kind']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['comparison_function_reference', b'comparison_function_reference', 'direction', b'direction', 'expr', b'expr', 'sort_kind', b'sort_kind']) -> None:
        ...

    def WhichOneof(self, oneof_group: typing_extensions.Literal['sort_kind', b'sort_kind']) -> typing_extensions.Literal['direction', 'comparison_function_reference'] | None:
        ...
global___SortField = SortField

class AggregateFunction(google.protobuf.message.Message):
    """An aggregate function."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AggregationInvocation:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AggregationInvocationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AggregateFunction._AggregationInvocation.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AGGREGATION_INVOCATION_UNSPECIFIED: AggregateFunction._AggregationInvocation.ValueType
        'This default value implies AGGREGATION_INVOCATION_ALL.'
        AGGREGATION_INVOCATION_ALL: AggregateFunction._AggregationInvocation.ValueType
        'Use all values in the aggregation calculation.'
        AGGREGATION_INVOCATION_DISTINCT: AggregateFunction._AggregationInvocation.ValueType
        'Use only distinct values in the aggregation calculation.'

    class AggregationInvocation(_AggregationInvocation, metaclass=_AggregationInvocationEnumTypeWrapper):
        """Method in which equivalent records are merged before being aggregated."""
    AGGREGATION_INVOCATION_UNSPECIFIED: AggregateFunction.AggregationInvocation.ValueType
    'This default value implies AGGREGATION_INVOCATION_ALL.'
    AGGREGATION_INVOCATION_ALL: AggregateFunction.AggregationInvocation.ValueType
    'Use all values in the aggregation calculation.'
    AGGREGATION_INVOCATION_DISTINCT: AggregateFunction.AggregationInvocation.ValueType
    'Use only distinct values in the aggregation calculation.'

    class ReferenceRel(google.protobuf.message.Message):
        """This rel is used  to create references,
        in case we refer to a RelRoot field names will be ignored
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        SUBTREE_ORDINAL_FIELD_NUMBER: builtins.int
        subtree_ordinal: builtins.int

        def __init__(self, *, subtree_ordinal: builtins.int=...) -> None:
            ...

        def ClearField(self, field_name: typing_extensions.Literal['subtree_ordinal', b'subtree_ordinal']) -> None:
            ...
    FUNCTION_REFERENCE_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    OUTPUT_TYPE_FIELD_NUMBER: builtins.int
    PHASE_FIELD_NUMBER: builtins.int
    SORTS_FIELD_NUMBER: builtins.int
    INVOCATION_FIELD_NUMBER: builtins.int
    ARGS_FIELD_NUMBER: builtins.int
    function_reference: builtins.int
    'Points to a function_anchor defined in this plan, which must refer\n    to an aggregate function in the associated YAML file. Required; 0 is\n    considered to be a valid anchor/reference.\n    '

    @property
    def arguments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FunctionArgument]:
        """The arguments to be bound to the function. This must have exactly the
        number of arguments specified in the function definition, and the
        argument types must also match exactly:

         - Value arguments must be bound using FunctionArgument.value, and
           the expression in that must yield a value of a type that a function
           overload is defined for.
         - Type arguments must be bound using FunctionArgument.type, and a
           function overload must be defined for that type.
         - Enum arguments must be bound using FunctionArgument.enum
           followed by Enum.specified, with a string that case-insensitively
           matches one of the allowed options.
         - Optional enum arguments must be bound using FunctionArgument.enum
           followed by either Enum.specified or Enum.unspecified. If specified,
           the string must case-insensitively match one of the allowed options.
        """

    @property
    def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FunctionOption]:
        """Options to specify behavior for corner cases, or leave behavior
        unspecified if the consumer does not need specific behavior in these
        cases.
        """

    @property
    def output_type(self) -> substrait.ibis.type_pb2.Type:
        """Must be set to the return type of the function, exactly as derived
        using the declaration in the extension.
        """
    phase: global___AggregationPhase.ValueType
    'Describes which part of the aggregation to perform within the context of\n    distributed algorithms. Required. Must be set to INITIAL_TO_RESULT for\n    aggregate functions that are not decomposable.\n    '

    @property
    def sorts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SortField]:
        """If specified, the aggregated records are ordered according to this list
        before they are aggregated. The first sort field has the highest
        priority; only if a sort field determines two records to be equivalent is
        the next field queried. This field is optional.
        """
    invocation: global___AggregateFunction.AggregationInvocation.ValueType
    'Specifies whether equivalent records are merged before being aggregated.\n    Optional, defaults to AGGREGATION_INVOCATION_ALL.\n    '

    @property
    def args(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
        """deprecated; use arguments instead"""

    def __init__(self, *, function_reference: builtins.int=..., arguments: collections.abc.Iterable[global___FunctionArgument] | None=..., options: collections.abc.Iterable[global___FunctionOption] | None=..., output_type: substrait.ibis.type_pb2.Type | None=..., phase: global___AggregationPhase.ValueType=..., sorts: collections.abc.Iterable[global___SortField] | None=..., invocation: global___AggregateFunction.AggregationInvocation.ValueType=..., args: collections.abc.Iterable[global___Expression] | None=...) -> None:
        ...

    def HasField(self, field_name: typing_extensions.Literal['output_type', b'output_type']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing_extensions.Literal['args', b'args', 'arguments', b'arguments', 'function_reference', b'function_reference', 'invocation', b'invocation', 'options', b'options', 'output_type', b'output_type', 'phase', b'phase', 'sorts', b'sorts']) -> None:
        ...
global___AggregateFunction = AggregateFunction