"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaAuthorizer = exports.HttpLambdaResponseType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Specifies the type responses the lambda returns
 */
var HttpLambdaResponseType;
(function (HttpLambdaResponseType) {
    /** Returns simple boolean response */
    HttpLambdaResponseType[HttpLambdaResponseType["SIMPLE"] = 0] = "SIMPLE";
    /** Returns an IAM Policy */
    HttpLambdaResponseType[HttpLambdaResponseType["IAM"] = 1] = "IAM";
})(HttpLambdaResponseType = exports.HttpLambdaResponseType || (exports.HttpLambdaResponseType = {}));
/**
 * Authorize Http Api routes via a lambda function
 */
class HttpLambdaAuthorizer {
    /**
     * Initialize a lambda authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param pool The lambda function handler to use for authorization
     * @param props Properties to configure the authorizer
     */
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_HttpLambdaAuthorizerProps(props);
    }
    bind(options) {
        var _b, _c, _d, _e;
        if (this.httpApi && (this.httpApi.apiId !== options.route.httpApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            const responseTypes = (_b = this.props.responseTypes) !== null && _b !== void 0 ? _b : [HttpLambdaResponseType.IAM];
            const enableSimpleResponses = responseTypes.includes(HttpLambdaResponseType.SIMPLE) || undefined;
            this.httpApi = options.route.httpApi;
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_c = this.props.identitySource) !== null && _c !== void 0 ? _c : [
                    '$request.header.Authorization',
                ],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.LAMBDA,
                authorizerName: (_d = this.props.authorizerName) !== null && _d !== void 0 ? _d : this.id,
                enableSimpleResponses,
                payloadFormatVersion: enableSimpleResponses ? aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_2_0 : aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_1_0,
                authorizerUri: lambdaAuthorizerArn(this.handler),
                resultsCacheTtl: (_e = this.props.resultsCacheTtl) !== null && _e !== void 0 ? _e : aws_cdk_lib_1.Duration.minutes(5),
            });
            this.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: aws_cdk_lib_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.httpApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.HttpLambdaAuthorizer = HttpLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpLambdaAuthorizer", version: "2.20.0-alpha.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${aws_cdk_lib_1.Stack.of(handler).partition}:apigateway:${aws_cdk_lib_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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