"use strict";
// Copyright (c) wangsijie
// Distributed under the terms of the Modified BSD License.
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const axios_1 = __importDefault(require("axios"));
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
require("./aliplayer-components.js");
class PlayerModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign({}, super.defaults(), { _model_name: PlayerModel.model_name, _model_module: PlayerModel.model_module, _model_module_version: PlayerModel.model_module_version, _view_name: PlayerModel.view_name, _view_module: PlayerModel.view_module, _view_module_version: PlayerModel.view_module_version });
    }
}
PlayerModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
PlayerModel.model_name = 'PlayerModel';
PlayerModel.model_module = version_1.MODULE_NAME;
PlayerModel.model_module_version = version_1.MODULE_VERSION;
PlayerModel.view_name = 'PlayerView'; // Set to null if no view
PlayerModel.view_module = version_1.MODULE_NAME; // Set to null if no view
PlayerModel.view_module_version = version_1.MODULE_VERSION;
exports.PlayerModel = PlayerModel;
const skinLayout = [
    {
        name: 'bigPlayButton',
        align: 'blabs',
        x: 30,
        y: 80,
    },
    {
        name: 'H5Loading',
        align: 'cc',
    },
    {
        name: 'errorDisplay',
        align: 'tlabs',
        x: 0,
        y: 0,
    },
    {
        name: 'infoDisplay',
    },
    {
        name: 'tooltip',
        align: 'blabs',
        x: 0,
        y: 56,
    },
    {
        name: 'thumbnail',
    },
    {
        name: 'controlBar',
        align: 'blabs',
        x: 0,
        y: 0,
        children: [
            {
                name: 'progress',
                align: 'blabs',
                x: 0,
                y: 44,
            },
            {
                name: 'playButton',
                align: 'tl',
                x: 15,
                y: 12,
            },
            {
                name: 'timeDisplay',
                align: 'tl',
                x: 10,
                y: 7,
            },
            {
                name: 'fullScreenButton',
                align: 'tr',
                x: 10,
                y: 12,
            },
            {
                name: 'volume',
                align: 'tr',
                x: 5,
                y: 10,
            },
        ],
    },
];
class PlayerView extends base_1.DOMWidgetView {
    render() {
        this.el.htmlContent = '';
        if (!window.Aliplayer) {
            // jQuery的define会导致这里无法正常加载hls组件
            window.__define = window.define;
            window.define = undefined;
            const hm = document.createElement('script');
            hm.src = 'https://g.alicdn.com/de/prismplayer/2.8.2/aliplayer-h5-min.js';
            hm.type = 'text/javascript';
            hm.charset = 'utf-8';
            this.el.appendChild(hm);
        }
        const wrapper = document.createElement('div');
        wrapper.id = `player-con-${Date.now()}`;
        wrapper.className = 'prism-player';
        wrapper.textContent = '正在加载播放器...';
        this.el.appendChild(wrapper);
        this.wrapperId = wrapper.id;
        setTimeout(() => this.renderPlayer(), 100);
        // this.model.on('change:value', this.value_changed, this);
    }
    getUrls() {
        return __awaiter(this, void 0, void 0, function* () {
            const vid = this.model.get('value');
            const res = yield axios_1.default.get(`https://www.boyuai.com/api/v1/common/public-videos/${vid}`);
            return res.data;
        });
    }
    renderPlayer() {
        if (!window.Aliplayer) {
            setTimeout(() => this.renderPlayer(), 100);
        }
        else {
            this.getUrls().then(urls => {
                if (!Object.keys(urls).length) {
                    this.el.textContent = '视频正在转码,请稍后重试';
                    return;
                }
                new window.Aliplayer({
                    id: this.wrapperId,
                    source: JSON.stringify(urls),
                    width: this.model.get('_width') + 'px',
                    height: this.model.get('_height') + 'px',
                    autoplay: false,
                    isLive: false,
                    rePlay: false,
                    playsinline: true,
                    preload: false,
                    language: 'zh-cn',
                    controlBarVisibility: 'hover',
                    useH5Prism: true,
                    skinLayout,
                    components: [
                        {
                            name: 'RateComponent',
                            type: window.AliPlayerComponent.RateComponent,
                        },
                        {
                            name: 'QualityComponent',
                            type: window.AliPlayerComponent.QualityComponent,
                        },
                    ],
                }, () => {
                    // 恢复
                    window.define = window.__define;
                });
            }).catch(e => {
                console.log(e);
                this.el.textContent = '获取视频播放地址失败';
            });
        }
    }
}
exports.PlayerView = PlayerView;
//# sourceMappingURL=widget.js.map