# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .corr_prov_key import tCorrProvKey

class tCorrProv(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 id: str = '',
                 corrtype_id: str = '',
                 descr: str = '',
                 status: str = '',
                 cfg_schema: dict = None,
                 cfg: dict = None,
                 lastcfg_id: int = 0,
                 modified_by: str = ''):
        """
        Constructor.

        :param id: str
        :param corrtype_id: str
        :param descr: str
        :param status: str
        :param cfg_schema: dict
        :param cfg: dict
        :param lastcfg_id: int
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.id = id
        self.corrtype_id = corrtype_id
        self.descr = descr
        self.status = status
        self.cfg_schema = cfg_schema
        self.cfg = cfg
        self.lastcfg_id = lastcfg_id
        self.modified_by = modified_by
        self.tm_stamp = None

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = ''
        self.corrtype_id = ''
        self.descr = ''
        self.status = ''
        self.cfg_schema = None
        self.cfg = None
        self.lastcfg_id = 0
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tCorrProv'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_string("id", self.id)
        _w.write_string("corrtype_id", self.corrtype_id)
        _w.write_string("descr", self.descr)
        _w.write_char("status", self.status)
        _w.write_json("cfg_schema", self.cfg_schema)
        _w.write_json("cfg", self.cfg)
        _w.write_int64("lastcfg_id", self.lastcfg_id)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_string("id")
        self.corrtype_id = _r.read_string("corrtype_id")
        self.descr = _r.read_string("descr")
        self.status = _r.read_char("status")
        self.cfg_schema = _r.read_json("cfg_schema")
        self.cfg = _r.read_json("cfg")
        self.lastcfg_id = _r.read_int64("lastcfg_id")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tCorrProv"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.corrtype_id = rec.corrtype_id
        self.descr = rec.descr
        self.status = rec.status
        self.cfg_schema = rec.cfg_schema
        self.cfg = rec.cfg
        self.lastcfg_id = rec.lastcfg_id
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tCorrProv"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tCorrProv"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tCorrProvKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tCorrProvKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        dvc.add_targ("corrtype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corrtype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        if key_only:
            return dvc

        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['A','D','F']))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tCorrProv._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tCorrProvKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id
        _key.corrtype_id = self.corrtype_id

    def _read_key(self, _key: tCorrProvKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id
        self.corrtype_id = _key.corrtype_id

    class Status_Couplet(dict):
        key_active = "A"
        key_disabled = "D"
        key_future = "F"

        value_active = "Active"
        value_disabled = "Disabled"
        value_future = "Future"

        def __init__(self):
            self[self.key_active] = self.value_active
            self[self.key_disabled] = self.value_disabled
            self[self.key_future] = self.value_future

        @staticmethod
        def get_value(key):
            if key == tCorrProv.Status_Couplet.key_active:
                return tCorrProv.Status_Couplet.value_active

            if key == tCorrProv.Status_Couplet.key_disabled:
                return tCorrProv.Status_Couplet.value_disabled

            if key == tCorrProv.Status_Couplet.key_future:
                return tCorrProv.Status_Couplet.value_future

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        rc = (x.id > y.id) - (x.id < y.id)

        if rc != 0:
            return rc

        rc = (x.corrtype_id > y.corrtype_id) - (x.corrtype_id < y.corrtype_id)

        return rc

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<CorrProv [id:%.32s, corrtype_id:%.32s, descr:%.32s, status:%.32s, cfg_schema:%.32s, cfg:%.32s, lastcfg_id:%r, modified_by:%.32s, tm_stamp:%s]>' % (
            self.id, self.corrtype_id, self.descr, self.status, self.cfg_schema, self.cfg, self.lastcfg_id, self.modified_by, self.tm_stamp)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tCorrProv.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tCorrProv()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tCorrProv.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tCorrProv._cache_davs(dvc, for_ins, key_only)

