# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.imsg_hist_search import iMsgHistSearch
from bs_loco.db.tables.msg_hist import tMsgHist

class dMsgHistSearch:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iMsgHistSearch()
        self.orec     = tMsgHist()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        date_from: datetime.datetime,
                        date_to: datetime.datetime) -> "dMsgHistSearch":
        """
        Execute the query by setting all the inputs.

        :param date_from: datetime.datetime
        :param date_to: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.date_from = date_from
        self.irec.date_to = date_to

        return await self.exec()

    async def exec(self, irec: iMsgHistSearch = None) -> "dMsgHistSearch":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("MsgHistSearch", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  m.*
from
  loco.msghist m
where
  m.msgdate  >= :datefrom and
  m.msgdate  <= :dateto
order by
  m.id""")

        self._dbstmnt.bind_in("dateFrom", self.irec.date_from, datetime.datetime)
        self._dbstmnt.bind_in("dateTo", self.irec.date_to, datetime.datetime)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("msgdate", datetime.datetime)
        self._dbstmnt.bind_out("msg", dict)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.status = self._dbstmnt.result[1]
        self.orec.msgdate = self._dbstmnt.result[2]
        self.orec.msg = self._dbstmnt.result[3]

        return True

    async def fetch_all(self, outList: tMsgHist.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

