import datetime
from collections.abc import Callable, Container, Iterable
from contextlib import AbstractContextManager as ContextManager
from re import Pattern
from types import TracebackType
from typing import Any, Generic, NoReturn, TypeVar

_E = TypeVar("_E", bound=BaseException)
_S = TypeVar("_S")

class AssertRaisesContext(Generic[_E]):
    exception: type[_E]
    msg_fmt: str
    def __init__(self, exception: type[_E], msg_fmt: str = ...) -> None: ...
    def __enter__(self: _S) -> _S: ...
    def __exit__(
        self,
        exc_type: type[BaseException] | None,
        exc_val: BaseException | None,
        exc_tb: TracebackType | None,
    ) -> bool: ...
    def format_message(self, default_msg: str) -> str: ...
    def add_test(self, cb: Callable[[_E], object]) -> None: ...
    @property
    def exc_val(self) -> _E: ...

class AssertRaisesErrnoContext(AssertRaisesContext[_E]):
    expected_errno: int
    def __init__(
        self, exception: type[_E], expected_errno: int, msg_fmt: str = ...
    ) -> None: ...

class AssertRaisesRegexContext(AssertRaisesContext[_E]):
    pattern: str
    def __init__(
        self, exception: type[_E], pattern: str, msg_fmt: str = ...
    ) -> None: ...

class AssertWarnsContext:
    def __init__(
        self, warning_class: type[Warning], msg_fmt: str = ...
    ) -> None: ...
    def __enter__(self: _S) -> _S: ...
    def __exit__(
        self,
        exc_type: type[BaseException] | None,
        exc_val: BaseException | None,
        exc_tb: TracebackType | None,
    ) -> None: ...
    def format_message(self) -> str: ...
    def add_test(self, cb: Callable[[Warning], bool]) -> None: ...

class AssertWarnsRegexContext(AssertWarnsContext):
    pattern: str
    def __init__(
        self, warning_class: type[Warning], msg_fmt: str = ...
    ) -> None: ...

def fail(msg: str = ...) -> NoReturn: ...
def assert_true(expr: object, msg_fmt: str = ...) -> None: ...
def assert_false(expr: object, msg_fmt: str = ...) -> None: ...
def assert_boolean_true(expr: object, msg_fmt: str = ...) -> None: ...
def assert_boolean_false(expr: object, msg_fmt: str = ...) -> None: ...
def assert_is_none(expr: object, msg_fmt: str = ...) -> None: ...
def assert_is_not_none(expr: object, msg_fmt: str = ...) -> None: ...
def assert_equal(
    first: object, second: object, msg_fmt: str = ...
) -> None: ...
def assert_not_equal(
    first: object, second: object, msg_fmt: str = ...
) -> None: ...
def assert_almost_equal(
    first: float,
    second: float,
    msg_fmt: str = ...,
    places: int = ...,
    delta: float = ...,
) -> None: ...
def assert_not_almost_equal(
    first: float,
    second: float,
    msg_fmt: str = ...,
    places: int = ...,
    delta: float = ...,
) -> None: ...
def assert_dict_equal(
    first: dict,
    second: dict,
    key_msg_fmt: str = ...,
    value_msg_fmt: str = ...,
) -> None: ...
def assert_dict_superset(
    first: dict,
    second: dict,
    key_msg_fmt: str = ...,
    value_msg_fmt: str = ...,
) -> None: ...
def assert_less(first: Any, second: Any, msg_fmt: str = ...) -> None: ...
def assert_less_equal(first: Any, second: Any, msg_fmt: str = ...) -> None: ...
def assert_greater(first: Any, second: Any, msg_fmt: str = ...) -> None: ...
def assert_greater_equal(
    first: Any, second: Any, msg_fmt: str = ...
) -> None: ...
def assert_regex(
    text: str, regex: str | Pattern[str], msg_fmt: str = ...
) -> None: ...
def assert_not_regex(
    text: str, regex: str | Pattern[str], msg_fmt: str = ...
) -> None: ...
def assert_is(first: object, second: object, msg_fmt: str = ...) -> None: ...
def assert_is_not(
    first: object, second: object, msg_fmt: str = ...
) -> None: ...
def assert_in(
    first: Any, second: Container[Any], msg_fmt: str = ...
) -> None: ...
def assert_not_in(
    first: Any, second: Container[Any], msg_fmt: str = ...
) -> None: ...
def assert_between(
    lower_bound: Any, upper_bound: Any, expr: Any, msg_fmt: str = ...
) -> None: ...
def assert_is_instance(
    obj: object, cls: type | tuple[type, ...], msg_fmt: str = ...
) -> None: ...
def assert_not_is_instance(
    obj: object, cls: type | tuple[type, ...], msg_fmt: str = ...
) -> None: ...
def assert_count_equal(
    sequence1: Iterable[Any], sequence2: Iterable[Any], msg_fmt: str = ...
) -> None: ...
def assert_has_attr(
    obj: object, attribute: str, msg_fmt: str = ...
) -> None: ...
def assert_datetime_about_now(
    actual: datetime.datetime | None, msg_fmt: str = ...
) -> None: ...
def assert_datetime_about_now_utc(
    actual: datetime.datetime | None, msg_fmt: str = ...
) -> None: ...
def assert_raises(
    exception: type[BaseException], msg_fmt: str = ...
) -> AssertRaisesContext: ...
def assert_raises_regex(
    exception: type[BaseException],
    regex: str | Pattern[str],
    msg_fmt: str = ...,
) -> AssertRaisesContext: ...
def assert_raises_errno(
    exception: type[BaseException], errno: int, msg_fmt: str = ...
) -> AssertRaisesContext: ...
def assert_succeeds(
    exception: type[BaseException], msg_fmt: str = ...
) -> ContextManager: ...
def assert_warns(
    warning_type: type[Warning], msg_fmt: str = ...
) -> AssertWarnsContext: ...
def assert_warns_regex(
    warning_type: type[Warning], regex: str, msg_fmt: str = ...
) -> AssertWarnsContext: ...
def assert_json_subset(
    first: dict[Any, Any] | list[Any],  # dict key can be 'str' or 'Exists'
    second: dict[str, Any] | list[Any] | str | bytes,
) -> None: ...

class Exists:
    member_name: str
    def __init__(self, member_name: str) -> None: ...
