"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const auto_merge_1 = require("./github/auto-merge");
const ignore_file_1 = require("./ignore-file");
const projenrc_1 = require("./javascript/projenrc");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const projen_upgrade_1 = require("./projen-upgrade");
const publisher_1 = require("./publisher");
const tasks_1 = require("./tasks");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_b = options.workflowNodeVersion) !== null && _b !== void 0 ? _b : this.package.minNodeVersion;
        this._version = new version_1.Version(this, {
            initialVersion: options.initialVersion,
        });
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
            category: tasks_1.TaskCategory.BUILD,
        });
        // first, execute projen as the first thing during build
        if ((_c = options.projenDuringBuild) !== null && _c !== void 0 ? _c : true) {
            // skip for sub-projects (i.e. "parent" is defined) since synthing the
            // root project will include the subprojects.
            if (!this.parent) {
                this.buildTask.exec(this.projenCommand);
            }
        }
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_d = options.npmignoreEnabled) !== null && _d !== void 0 ? _d : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_e = options.gitignore) === null || _e === void 0 ? void 0 : _e.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_f = options.npmignore) === null || _f === void 0 ? void 0 : _f.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        this.setScript('start', `${this.package.projenCommand} start`);
        (_g = this.npmignore) === null || _g === void 0 ? void 0 : _g.exclude(`/${common_1.PROJEN_RC}`);
        (_h = this.npmignore) === null || _h === void 0 ? void 0 : _h.exclude(`/${common_1.PROJEN_DIR}`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_j = options.projenDevDependency) !== null && _j !== void 0 ? _j : true;
        if (projen) {
            const projenVersion = (_k = options.projenVersion) !== null && _k !== void 0 ? _k : `^${common_1.PROJEN_VERSION}`;
            this.addDevDeps(`projen@${projenVersion}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const buildEnabled = (_l = options.buildWorkflow) !== null && _l !== void 0 ? _l : (this.parent ? false : true);
        const mutableBuilds = (_m = options.mutableBuild) !== null && _m !== void 0 ? _m : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_o = options.antitamper) !== null && _o !== void 0 ? _o : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_p = options.jest) !== null && _p !== void 0 ? _p : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if ((_q = options.buildWorkflow) !== null && _q !== void 0 ? _q : (this.parent ? false : true)) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const buildJobId = 'build';
            const updateRepo = new Array();
            const gitDiffStepId = 'git_diff';
            const hasChangesCondName = 'has_changes';
            const hasChanges = `steps.${gitDiffStepId}.outputs.${hasChangesCondName}`;
            const repoFullName = 'github.event.pull_request.head.repo.full_name';
            // use "git diff --exit code" to check if there were changes in the repo
            // and create a step output that will be used in subsequent steps.
            updateRepo.push({
                name: 'Check for changes',
                id: gitDiffStepId,
                run: `git diff --exit-code || echo "::set-output name=${hasChangesCondName}::true"`,
            });
            // only if we had changes, commit them and push to the repo note that for
            // forks, this will fail (because the workflow doesn't have permissions.
            // this indicates to users that they need to update their branch manually.
            updateRepo.push({
                if: hasChanges,
                name: 'Commit and push changes (if changed)',
                run: `git add . && git commit -m "chore: self mutation" && git push origin HEAD:${branch}`,
            });
            // if we pushed changes, we need to manually update the status check so
            // that the PR will be green (we won't get here for forks with updates
            // because the push would have failed).
            updateRepo.push({
                if: hasChanges,
                name: 'Update status check (if changed)',
                run: [
                    'gh api',
                    '-X POST',
                    `/repos/\${{ ${repoFullName} }}/check-runs`,
                    `-F name="${buildJobId}"`,
                    '-F head_sha="$(git rev-parse HEAD)"',
                    '-F status="completed"',
                    '-F conclusion="success"',
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            const workflow = this.createBuildWorkflow('Build', {
                jobId: buildJobId,
                trigger: {
                    pull_request: {},
                },
                checkoutWith: mutableBuilds ? {
                    ref: branch,
                    repository: repo,
                } : undefined,
                postSteps: updateRepo,
                antitamperDisabled: mutableBuilds,
                image: options.workflowContainerImage,
                codeCov: (_r = options.codeCov) !== null && _r !== void 0 ? _r : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
            });
            this.buildWorkflow = workflow;
            this.buildWorkflowJobId = buildJobId;
        }
        if ((_s = options.releaseWorkflow) !== null && _s !== void 0 ? _s : (this.parent ? false : true)) {
            const defaultReleaseBranch = (_t = options.defaultReleaseBranch) !== null && _t !== void 0 ? _t : 'main';
            const releaseBranches = (_u = options.releaseBranches) !== null && _u !== void 0 ? _u : [defaultReleaseBranch];
            const trigger = {};
            if ((_v = options.releaseEveryCommit) !== null && _v !== void 0 ? _v : true) {
                trigger.push = { branches: releaseBranches };
            }
            if (options.releaseSchedule) {
                trigger.schedule = { cron: options.releaseSchedule };
            }
            const artifactDirectory = (_w = options.artifactsDirectory) !== null && _w !== void 0 ? _w : 'dist';
            const getVersion = 'v$(node -p \"require(\'./package.json\').version\")';
            const jobId = 'release';
            const releaseSteps = [];
            // to avoid race conditions between two commits trying to release the same
            // version, we check if the head sha is identical to the remote sha. if
            // not, we will skip the release and just finish the build.
            const gitRemoteStep = 'git_remote';
            const latestCommitOutput = 'latest_commit';
            const noNewCommits = `\${{ steps.${gitRemoteStep}.outputs.${latestCommitOutput} == github.sha }}`;
            releaseSteps.push({
                name: 'Check for new commits',
                id: gitRemoteStep,
                run: `echo ::set-output name=${latestCommitOutput}::"$(git ls-remote origin -h \${{ github.ref }} | cut -f1)"`,
            });
            releaseSteps.push({
                name: 'Create release',
                if: noNewCommits,
                run: [
                    `gh release create ${getVersion}`,
                    `-F ${this._version.changelogFile}`,
                    `-t ${getVersion}`,
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            releaseSteps.push({
                name: 'Unbump',
                run: this.runTaskCommand(this._version.unbumpTask),
            });
            releaseSteps.push({
                name: 'Upload artifact',
                if: noNewCommits,
                uses: 'actions/upload-artifact@v2.1.1',
                with: {
                    name: artifactDirectory,
                    path: artifactDirectory,
                },
            });
            const workflow = this.createBuildWorkflow('Release', {
                jobId: jobId,
                trigger,
                env: {
                    RELEASE: 'true',
                },
                preBuildSteps: [
                    {
                        name: 'Bump to next version',
                        run: this.runTaskCommand(this._version.bumpTask),
                    },
                    ...(_x = options.releaseWorkflowSetupSteps) !== null && _x !== void 0 ? _x : [],
                ],
                postSteps: releaseSteps,
                image: options.workflowContainerImage,
                codeCov: false,
                checkoutWith: {
                    // we must use 'fetch-depth=0' in order to fetch all tags
                    // otherwise tags are not checked out
                    'fetch-depth': 0,
                },
            });
            this.releaseWorkflow = workflow;
            this.publisher = new publisher_1.Publisher(this, {
                workflow: this.releaseWorkflow,
                artifactName: artifactDirectory,
                buildJobId: jobId,
                jsiiReleaseVersion: options.jsiiReleaseVersion,
            });
            if ((_y = options.releaseToNpm) !== null && _y !== void 0 ? _y : false) {
                this.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                    npmTokenSecret: this.package.npmTokenSecret,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseBranches) {
                throw new Error('"releaseBranches" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_z = this.github) === null || _z === void 0 ? void 0 : _z.mergify) {
            this.autoMerge = new auto_merge_1.AutoMerge(this, {
                autoMergeLabel: options.mergifyAutoMergeLabel,
                buildJob: this.buildWorkflowJobId,
            });
            (_0 = this.npmignore) === null || _0 === void 0 ? void 0 : _0.exclude('/.mergify.yml');
        }
        if ((_1 = options.dependabot) !== null && _1 !== void 0 ? _1 : true) {
            (_2 = this.github) === null || _2 === void 0 ? void 0 : _2.addDependabot(options.dependabotOptions);
        }
        const projenAutoMerge = (_3 = options.projenUpgradeAutoMerge) !== null && _3 !== void 0 ? _3 : true;
        new projen_upgrade_1.ProjenUpgrade(this, {
            autoUpgradeSecret: options.projenUpgradeSecret,
            autoUpgradeSchedule: options.projenUpgradeSchedule,
            labels: (projenAutoMerge && ((_4 = this.autoMerge) === null || _4 === void 0 ? void 0 : _4.autoMergeLabel))
                ? [this.autoMerge.autoMergeLabel]
                : [],
        });
        if ((_5 = options.pullRequestTemplate) !== null && _5 !== void 0 ? _5 : true) {
            (_6 = this.github) === null || _6 === void 0 ? void 0 : _6.addPullRequestTemplate(...(_7 = options.pullRequestTemplateContents) !== null && _7 !== void 0 ? _7 : []);
        }
        const projenrcJs = (_8 = options.projenrcJs) !== null && _8 !== void 0 ? _8 : true;
        if (projenrcJs) {
            new projenrc_1.Projenrc(this, options.projenrcJsOptions);
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (deprecated) Determines how tasks are executed when invoked as npm scripts (yarn/npm run xyz).
     *
     * @deprecated use `package.npmTaskExecution`
     */
    get npmTaskExecution() { return this.package.npmTaskExecution; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v1',
                with: { 'node-version': this.nodeVersion },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    addLicense(options) {
        var _b;
        if (this.package.license) {
            new license_1.License(this, this.package.license, {
                copyrightOwner: (_b = options.copyrightOwner) !== null && _b !== void 0 ? _b : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    createBuildWorkflow(name, options) {
        var _b, _c, _d, _e, _f;
        const buildJobId = options.jobId;
        const github = this.github;
        if (!github) {
            throw new Error('no github support');
        }
        const workflow = github.addWorkflow(name);
        if (options.trigger) {
            if (options.trigger.issue_comment) {
                throw new Error('"issue_comment" should not be used as a trigger due to a security issue');
            }
            workflow.on(options.trigger);
        }
        workflow.on({
            workflow_dispatch: {},
        });
        const condition = options.condition ? { if: options.condition } : {};
        const preBuildSteps = (_b = options.preBuildSteps) !== null && _b !== void 0 ? _b : [];
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const postSteps = (_d = options.postSteps) !== null && _d !== void 0 ? _d : [];
        const antitamperSteps = (options.antitamperDisabled || !this.antitamper) ? [] : [{
                name: 'Anti-tamper check',
                run: 'git diff --ignore-space-at-eol --exit-code',
            }];
        const job = {
            'runs-on': 'ubuntu-latest',
            'env': {
                CI: 'true',
                ...(_e = options.env) !== null && _e !== void 0 ? _e : {},
            },
            ...condition,
            'steps': [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // install dependencies
                ...this.installWorkflowSteps,
                // perform an anti-tamper check immediately after we run projen.
                ...antitamperSteps,
                // sets git identity so we can push later
                {
                    name: 'Set git identity',
                    run: [
                        'git config user.name "Automation"',
                        'git config user.email "github-actions@github.com"',
                    ].join('\n'),
                },
                // if there are changes, creates a bump commit
                ...preBuildSteps,
                // build (compile + test)
                {
                    name: 'Build',
                    run: this.runTaskCommand(this.buildTask),
                },
                // run codecov if enabled or a secret token name is passed in
                // AND jest must be configured
                ...(options.codeCov || options.codeCovTokenSecret) && ((_f = this.jest) === null || _f === void 0 ? void 0 : _f.config) ? [{
                        name: 'Upload coverage to Codecov',
                        uses: 'codecov/codecov-action@v1',
                        with: options.codeCovTokenSecret ? {
                            token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                            directory: this.jest.config.coverageDirectory,
                        } : {
                            directory: this.jest.config.coverageDirectory,
                        },
                    }] : [],
                ...postSteps,
                // anti-tamper check (fails if there were changes to committed files)
                // this will identify any non-committed files generated during build (e.g. test snapshots)
                ...antitamperSteps,
            ],
        };
        if (options.image) {
            job.container = { image: options.image };
        }
        workflow.addJobs({ [buildJobId]: job });
        return workflow;
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * If
     * npmTaskExecution is set to PROJEN, the command will be `npx projen TASK`.
     * If it is set to SHELL, the command will be `yarn run TASK` (or `npm run
     * TASK`).
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        switch (this.package.npmTaskExecution) {
            case node_package_1.NpmTaskExecution.PROJEN: return `${this.package.projenCommand} ${task.name}`;
            case node_package_1.NpmTaskExecution.SHELL: return `${this.runScriptCommand} ${task.name}`;
            default:
                throw new Error(`invalid npmTaskExecution mode: ${this.package.npmTaskExecution}`);
        }
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.17.90" };
//# sourceMappingURL=data:application/json;base64,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