"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const file_1 = require("../file");
const dependabot_1 = require("./dependabot");
const mergify_1 = require("./mergify");
const pr_template_1 = require("./pr-template");
const workflows_1 = require("./workflows");
/**
 * @experimental
 */
class GitHub extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project);
        this.gitattributes = new GitattributesFile(project);
        // Contents  of the .projen/ directory are generated by projen
        this.annotateGenerated('/.projen/');
        // The .gitattributes file itself is generated
        this.annotateGenerated(`/${this.gitattributes.path}`);
        if ((_b = options.mergify) !== null && _b !== void 0 ? _b : true) {
            this.mergify = new mergify_1.Mergify(this);
        }
    }
    /**
     * @experimental
     */
    addWorkflow(name) {
        return new workflows_1.GithubWorkflow(this, name);
    }
    /**
     * @experimental
     */
    addPullRequestTemplate(...content) {
        return new pr_template_1.PullRequestTemplate(this, { lines: content });
    }
    /**
     * @experimental
     */
    addDependabot(options) {
        return new dependabot_1.Dependabot(this, options);
    }
    /**
     * (experimental) Marks the provided file(s) as being generated.
     *
     * This is achieved using the
     * github-linguist attributes. Generated files do not count against the
     * repository statistics and language breakdown.
     *
     * @param glob the glob pattern to match (could be a file path).
     * @see https://github.com/github/linguist/blob/master/docs/overrides.md
     * @experimental
     */
    annotateGenerated(glob) {
        this.gitattributes.addAttributes(glob, 'linguist-generated');
    }
}
exports.GitHub = GitHub;
_a = JSII_RTTI_SYMBOL_1;
GitHub[_a] = { fqn: "projen.github.GitHub", version: "0.17.90" };
class GitattributesFile extends file_1.FileBase {
    constructor(project) {
        super(project, '.gitattributes');
        this.attributes = new Map();
    }
    addAttributes(glob, ...attributes) {
        if (!this.attributes.has(glob)) {
            this.attributes.set(glob, new Set());
        }
        const set = this.attributes.get(glob);
        for (const attribute of attributes) {
            set.add(attribute);
        }
    }
    synthesizeContent() {
        // We can assume the file map is never empty.
        const entries = Array.from(this.attributes.entries())
            .sort(([l], [r]) => l.localeCompare(r));
        const maxLen = Math.max(...entries.map(([glob]) => glob.length));
        return [
            `# ${file_1.FileBase.PROJEN_MARKER}`,
            '',
            ...entries.map(([name, attributes]) => `${name.padEnd(maxLen, ' ')}\t${Array.from(attributes).join(' ')}`),
        ].join('\n');
    }
}
//# sourceMappingURL=data:application/json;base64,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