"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const web_1 = require("../../web");
const util_1 = require("../util");
test('defaults', () => {
    const p = new TestNextJsProject();
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('tailwind enabled', () => {
    const p = new TestNextJsProject();
    expect(util_1.synthSnapshot(p)['tailwind.config.json']).toBeDefined();
    expect(util_1.synthSnapshot(p)['postcss.config.json']).toBeDefined();
});
class TestNextJsProject extends web_1.NextJsProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-nextjs-project',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
            defaultReleaseBranch: 'main',
            projenVersion: '^1.2.3',
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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