"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const inventory = require("../inventory");
const result = inventory.discover();
test('project id', () => {
    expect(result.map(x => x.pjid).sort()).toContain('jsii');
    expect(result.map(x => x.pjid).sort()).toContain('awscdk-construct');
    expect(result.map(x => x.pjid).sort()).toContain('typescript');
});
test('inventory', () => {
    expect(result).toMatchSnapshot();
});
test('remote discover project id simulation', () => {
    const remoteDiscoverResult = inventory.discover(path.join(__dirname, '..'));
    expect(remoteDiscoverResult.map(x => x.pjid).sort()).toContain('jsii');
    expect(remoteDiscoverResult.map(x => x.pjid).sort()).toContain('awscdk-construct');
    expect(remoteDiscoverResult.map(x => x.pjid).sort()).toContain('typescript');
});
test('renderable default values simulation', () => {
    const baseOption = {
        path: ['myOption'],
        name: 'myOption',
        switch: 'my-option',
        type: 'boolean',
        parent: 'MyModule',
    };
    expect(() => throwIfNotRenderable(baseOption)).not.toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: 'undefined' })).not.toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: '$BASEDIR' })).not.toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: '{ "a": 3 }' })).not.toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: '2048' })).not.toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: 'true' })).not.toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: 'MyEnum.OptionA', type: 'MyEnum' })).not.toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: 'MyEnum.OptionA' })).toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: 'MyEnum.OptionA', type: 'BaseEnum' })).toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: '- current year' })).not.toThrowError();
    expect(() => throwIfNotRenderable({ ...baseOption, default: 'current year' })).toThrowError();
});
describe('all default values in docstrings are renderable JS values', () => {
    result.forEach((project) => {
        project.options.forEach((option) => {
            test(`${project.pjid}:${option.path.join('.')}=${option.default}`, () => {
                expect(() => throwIfNotRenderable(option)).not.toThrowError();
            });
        });
    });
});
function throwIfNotRenderable(option) {
    return (option.default === undefined) ||
        (option.default === 'undefined') ||
        (option.default.startsWith('$')) ||
        (option.default.startsWith('-')) ||
        (option.type && option.default.startsWith(option.type)) ||
        JSON.parse(option.default);
}
;
//# sourceMappingURL=data:application/json;base64,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