"""
pyGoogleTranslate data module.

© Anime no Sekai - 2020\n
Credit to py-googletrans by ssut for the list of google translate domains.
"""

def language_code_data():
    """
    List of available language code for Google Translate.\n
    Used to check if the correct language code is provided\n
    © Anime no Sekai - 2020
    """
    data_list = [
        "auto",
        "af",
        "sq",
        "am",
        "ar",
        "hy",
        "az",
        "eu",
        "be",
        "bn",
        "bs",
        "bg",
        "ca",
        "ceb",
        "ny",
        "zh-cn",
        "co",
        "hr",
        "cs",
        "da",
        "nl",
        "en",
        "eo",
        "et",
        "tl",
        "fi",
        "fr",
        "fy",
        "gl",
        "ka",
        "de",
        "el",
        "gu",
        "ht",
        "ha",
        "haw",
        "iw",
        "hi",
        "hmn",
        "hu",
        "is",
        "ig",
        "id",
        "ga",
        "it",
        "ja",
        "jw",
        "kn",
        "kk",
        "km",
        "rw",
        "ko",
        "ku",
        "ky",
        "lo",
        "la",
        "lv",
        "lt",
        "lb",
        "mk",
        "mg",
        "ms",
        "ml",
        "mt",
        "mi",
        "mr",
        "mn",
        "my",
        "ne",
        "no",
        "or",
        "ps",
        "fa",
        "pl",
        "pt",
        "pa",
        "ro",
        "ru",
        "sm",
        "gd",
        "sr",
        "st",
        "sn",
        "sd",
        "si",
        "sk",
        "sl",
        "so",
        "es",
        "su",
        "sw",
        "sv",
        "tg",
        "ta",
        "tt",
        "te",
        "th",
        "tr",
        "tk",
        "uk",
        "ur",
        "ug",
        "uz",
        "vi",
        "cy",
        "xh",
        "yi",
        "yo",
        "zu",
        "zh-tw"
    ]
    return data_list


def language_name_to_code():
    """
    English language name to code language for Google Translate.\n
    © Anime no Sekai - 2020
    """
    data_dict = {
        'automatic': 'auto',
        'afrikaans': 'af',
        'albanian': 'sq',
        'amharic': 'am',
        'arabic': 'ar',
        'armenian': 'hy',
        'azerbaijani': 'az',
        'basque': 'eu',
        'belarusian': 'be',
        'bengali': 'bn',
        'bosnian': 'bs',
        'bulgarian': 'bg',
        'catalan': 'ca',
        'cebuano': 'ceb',
        'chichewa': 'ny',
        'chinese': 'zh-CN',
        'chinese (simplified)': 'zh-CN',
        'chinese (traditional)': 'zh-TW',
        'corsican': 'co',
        'croatian': 'hr',
        'czech': 'cs',
        'danish': 'da',
        'dutch': 'nl',
        'english': 'en',
        'esperanto': 'eo',
        'estonian': 'et',
        'filipino': 'tl',
        'finnish': 'fi',
        'french': 'fr',
        'frisian': 'fy',
        'galician': 'gl',
        'georgian': 'ka',
        'german': 'de',
        'greek': 'el',
        'gujarati': 'gu',
        'haitian': 'ht',
        'creole': 'ht',
        'haitian creole': 'ht',
        'hausa': 'ha',
        'hawaiian': 'haw',
        'hebrew': 'iw',
        'hindi': 'hi',
        'hmong': 'hmn',
        'hungarian': 'hu',
        'icelandic': 'is',
        'igbo': 'ig',
        'indonesian': 'id',
        'irish': 'ga',
        'italian': 'it',
        'japanese': 'ja',
        'javanese': 'jw',
        'kannada': 'kn',
        'kazakh': 'kk',
        'khmer': 'km',
        'korean': 'ko',
        'kurdish': 'ku',
        'kurdish (kurmanji)': 'ku',
        'kyrgyz': 'ky',
        'lao': 'lo',
        'latin': 'la',
        'latvian': 'lv',
        'lithuanian': 'lt',
        'luxembourgish': 'lb',
        'macedonian': 'mk',
        'malagasy': 'mg',
        'malay': 'ms',
        'malayalam': 'ml',
        'maltese': 'mt',
        'maori': 'mi',
        'marathi': 'mr',
        'mongolian': 'mn',
        'myanmar': 'my',
        'burmese': 'my',
        'myanmar (burmese)': 'my',
        'nepali': 'ne',
        'norwegian': 'no',
        'odia': 'or',
        'pashto': 'ps',
        'persian': 'fa',
        'polish': 'pl',
        'portuguese': 'pt',
        'punjabi': 'pa',
        'romanian': 'ro',
        'russian': 'ru',
        'samoan': 'sm',
        'scots': 'gd',
        'gaelic': 'gd',
        'scots gaelic': 'gd',
        'serbian': 'sr',
        'sesotho': 'st',
        'shona': 'sn',
        'sindhi': 'sd',
        'sinhala': 'si',
        'slovak': 'sk',
        'slovenian': 'sl',
        'somali': 'so',
        'spanish': 'es',
        'sundanese': 'su',
        'swahili': 'sw',
        'swedish': 'sv',
        'tajik': 'tg',
        'tamil': 'ta',
        'telugu': 'te',
        'thai': 'th',
        'turkish': 'tr',
        'ukrainian': 'uk',
        'urdu': 'ur',
        'uyghur': 'ug',
        'uzbek': 'uz',
        'vietnamese': 'vi',
        'welsh': 'cy',
        'xhosa': 'xh',
        'yiddish': 'yi',
        'yoruba': 'yo',
        'zulu': 'zu'
    }
    return data_dict

def international_language_name_to_code():
    """
    Translation of all the language names into all the languages available on Google Translate (+13740 translations/8〜10 hours of work)\n
    Used to always get the correct language code, even if a language name is provided.\n
    © Anime no Sekai - 2020\n
    © Google Translate by Google LLC
    """
    data_dict = {
        "afrikaans":"af",
        "አፍሪካንስ":"af",
        "الأفارقة":"af",
        "աֆրիկյան":"af",
        "афрыкаанс":"af",
        "আফ্রিকান্স":"af",
        "африканс":"af",
        "mga afrikaan":"af",
        "aafrika":"af",
        "afrikánština":"af",
        "mga afrikaans":"af",
        "afrikaansk":"af",
        "ინფორმაცია":"af",
        "αφρικανοί":"af",
        "હવામાન":"af",
        "yan afirka":"af",
        "apikana":"af",
        "אפריקאית":"af",
        "दी":"af",
        "afrískt":"af",
        "ndị africa":"af",
        "afrikanas":"af",
        "アフリカーンス語":"af",
        "wong afrikaan":"af",
        "ಆಫ್ರಿಕಾನ್ಸ್":"af",
        "африкалықтар":"af",
        "អាហ្វ្រិក":"af",
        "아프리카 어":"af",
        "afrîkansî":"af",
        "африкаансча":"af",
        "ຊາວອາເມລິກາ":"af",
        "africanica":"af",
        "afrikiečių":"af",
        "orang afrika":"af",
        "ആഫ്രിക്കക്കാർ":"af",
        "indja":"af",
        "afrikaana":"af",
        "हवामान":"af",
        "африк":"af",
        "လှိုင်":"af",
        "ठाउ":"af",
        "ଆଫ୍ରିକୀୟ":"af",
        "افریقایی":"af",
        "اطلاعات":"af",
        "ਹਵਾਈ ਅੱਡਾ":"af",
        "африкаанс":"af",
        "faʻa afelika":"af",
        "afrikaanach":"af",
        "ma-afrika":"af",
        "chiafrikaans":"af",
        "آفريڪي":"af",
        "අප්\u200dරිකානු":"af",
        "afrikánčina":"af",
        "afrikaanka":"af",
        "africaans":"af",
        "waafrika":"af",
        "африкоиён":"af",
        "ஆப்பிரிக்கா":"af",
        "แอฟริกาใต้":"af",
        "اراضی":"af",
        "isibhulu":"af",
        "אפריקאנער":"af",
        "ọmọ ilu afirika":"af",
        "abase-afrika":"af",
        "albanian":"sq",
        "shqiptar":"sq",
        "አልበንያኛ":"sq",
        "الألبانية":"sq",
        "ալբանական":"sq",
        "alban":"sq",
        "албанскі":"sq",
        "albanski":"sq",
        "албански":"sq",
        "apolisi":"sq",
        "albanese":"sq",
        "albanac":"sq",
        "albánský":"sq",
        "albansk":"sq",
        "albanees":"sq",
        "albaanlane":"sq",
        "albanialainen":"sq",
        "albanais":"sq",
        "albaneesk":"sq",
        "ალბანური":"sq",
        "αλβανός":"sq",
        "હાઉસિંગ":"sq",
        "albani":"sq",
        "alapania":"sq",
        "אלבנית":"sq",
        "अल्बानियन":"sq",
        "neeg txawv teb chaws":"sq",
        "albán":"sq",
        "albanska":"sq",
        "bahasa albania":"sq",
        "アルバニア語":"sq",
        "ಅಲ್ಬೇನಿಯನ್":"sq",
        "албаниялық":"sq",
        "អាល់បានី":"sq",
        "알바니아":"sq",
        "albanî":"sq",
        "албанча":"sq",
        "ຄົນຕ່າງຊາດ":"sq",
        "illyrica":"sq",
        "albanietis":"sq",
        "albanesch":"sq",
        "albaney":"sq",
        "orang albania":"sq",
        "അൽബേനിയൻ":"sq",
        "taljan":"it",
        "निवासी":"sq",
        "албани":"sq",
        "आवास":"sq",
        "ଆଲବାନ୍":"sq",
        "آلبانیایی":"sq",
        "albański":"sq",
        "albanês":"sq",
        "ਹਾ albanianਸਿੰਗ":"sq",
        "albanez":"sq",
        "албанский":"sq",
        "albànianach":"sq",
        "bafolisi":"sq",
        "chialbanian":"sq",
        "الباني":"sq",
        "ඇල්බේනියානු":"sq",
        "albánsky":"sq",
        "albaniin":"sq",
        "albanesa":"sq",
        "wananchi":"sq",
        "nian":"sq",
        "албания":"sq",
        "அல்பேனிய":"sq",
        "แอลเบเนีย":"sq",
        "arnavut":"sq",
        "албанська":"sq",
        "رہائش":"sq",
        "bia":"sq",
        "albania":"sq",
        "אַלבאַניש":"sq",
        "alibani":"sq",
        "abafowethu":"sq",
        "amharies":"am",
        "amharic":"am",
        "አማርኛ":"am",
        "الأمهرية":"am",
        "ամհարերեն":"am",
        "amharik":"am",
        "амхарскі":"am",
        "আমহারিক":"am",
        "amharski":"am",
        "амхарски":"am",
        "amàric":"am",
        "amaricu":"am",
        "amharský":"am",
        "amharisk":"am",
        "amhaars":"am",
        "amikeco":"am",
        "amhaarne":"am",
        "amhara":"am",
        "amharique":"am",
        "amhaarsk":"am",
        "amárico":"am",
        "ამჰარული":"am",
        "amharisch":"am",
        "αμαρικά":"am",
        "અમ્હારિક":"am",
        "amawik":"am",
        "hausa":"ha",
        "amahapika":"am",
        "אמהרית":"am",
        "अम्हारिक्":"am",
        "amharíska":"am",
        "bekee":"en",
        "amarica":"am",
        "アムハラ語":"am",
        "kenthel":"am",
        "ಅಂಹರಿಕ್":"am",
        "амхар":"am",
        "អាម៉ារិច":"am",
        "암하라 어":"am",
        "amharîkî":"am",
        "амхарча":"am",
        "aethiopica":"am",
        "amharinis":"am",
        "amharesch":"am",
        "amrarika":"am",
        "अम्हारिक":"am",
        "амхарик":"am",
        "ଆମହାରିକ୍ |":"am",
        "امهاریک":"am",
        "آماره":"am",
        "ਅਮਹਾਰਿਕ":"am",
        "amharică":"am",
        "амхарский":"am",
        "chiamharic":"am",
        "امهاري":"am",
        "amharčina":"am",
        "амҳарикӣ":"am",
        "அம்ஹாரிக்":"am",
        "amharca":"am",
        "амхарний":"am",
        "امھارک":"am",
        "amhar tilida":"am",
        "amharig":"am",
        "èdè amẹrika":"am",
        "isi-amharic":"am",
        "arabies":"ar",
        "arab":"ar",
        "አረብኛ":"ar",
        "عربى":"ar",
        "արաբական":"ar",
        "ərəb":"ar",
        "arabic":"ar",
        "арабская":"ar",
        "আরবি":"ar",
        "arapski":"ar",
        "арабски":"ar",
        "àrab":"ar",
        "arabiko":"ar",
        "arabu":"ar",
        "arabština":"ar",
        "arabisk":"ar",
        "arabisch":"ar",
        "la araba":"ar",
        "araabia":"ar",
        "arabialainen":"ar",
        "arabe":"ar",
        "arabysk":"ar",
        "árabe":"ar",
        "არაბული":"ar",
        "αραβικός":"ar",
        "અરબી":"ar",
        "larabci":"ar",
        "apapika":"ar",
        "עֲרָבִית":"ar",
        "अरबी":"ar",
        "neeg arabic":"ar",
        "arabíska":"ar",
        "mkpụrụedemede":"ar",
        "araibis":"ar",
        "araba":"ar",
        "アラビア語":"ar",
        "ಅರೇಬಿಕ್":"ar",
        "араб":"ar",
        "អារ៉ាប់":"ar",
        "아라비아 말":"ar",
        "erebî":"ar",
        "арабча":"ar",
        "ອາຣັບ":"ar",
        "arābu":"ar",
        "arabiškas":"ar",
        "arabesch":"ar",
        "арапски":"ar",
        "arabo":"ar",
        "orang arab":"ar",
        "അറബിക്":"ar",
        "għarbi":"ar",
        "arapi":"ar",
        "အာရဗီ":"ar",
        "ଆରବୀ":"ar",
        "عربي...":"ar",
        "arabski":"ar",
        "ਅਰਬੀ":"ar",
        "арабский":"ar",
        "alapi":"ar",
        "arabach":"ar",
        "chiarabic":"ar",
        "عربي":"ar",
        "අරාබි":"ar",
        "arabčina":"ar",
        "arabsko":"ar",
        "carabi":"ar",
        "arábica":"ar",
        "arabiki":"ar",
        "arabicum":"ar",
        "арабӣ":"ar",
        "அரபு":"ar",
        "అరబిక్":"ar",
        "ภาษาอาหรับ":"ar",
        "arapça":"ar",
        "арабська":"ar",
        "عربی":"ar",
        "ئەرەبچە":"ar",
        "arabcha":"ar",
        "tiếng ả rập":"ar",
        "arabeg":"ar",
        "isiarabhu":"ar",
        "אַראַביש":"ar",
        ".bíbáwá":"ar",
        "i-arabic":"ar",
        "armenian":"hy",
        "armen":"hy",
        "አርመንያኛ":"hy",
        "الأرمينية":"hy",
        "հայերեն":"hy",
        "erməni":"hy",
        "армянскі":"hy",
        "armenski":"hy",
        "арменски":"hy",
        "informar":"hy",
        "armenu":"hy",
        "armenac":"hy",
        "arménský":"hy",
        "armensk":"hy",
        "armeens":"hy",
        "informi":"hy",
        "armeenlane":"hy",
        "arménienne":"hy",
        "armeensk":"hy",
        "სომხური":"hy",
        "armenisch":"hy",
        "αρμενικός":"hy",
        "વનવાસી":"hy",
        "armeniyanci":"hy",
        "ameniana":"hy",
        "אַרְמֶנִי":"hy",
        "örmény":"hy",
        "arabískur":"hy",
        "onye armenia":"hy",
        "armenia":"hy",
        "armena":"hy",
        "アルメニア語":"hy",
        "ಅರ್ಮೇನಿಯನ್":"hy",
        "армян":"hy",
        "អាមេរិច":"hy",
        "아르메니아 사람":"hy",
        "ermenî":"hy",
        "армянча":"hy",
        "ອາແມນ":"hy",
        "armenias":"hy",
        "armēņu":"hy",
        "armėnų":"hy",
        "armenesch":"hy",
        "ерменски":"hy",
        "armeniana":"hy",
        "അർമേനിയൻ":"hy",
        "titlob":"hy",
        "वनवासी":"hy",
        "арменийн":"hy",
        "အာရပ်":"hy",
        "गाउँ":"hy",
        "ଆର୍ମେନିଆ":"hy",
        "ارمنی":"hy",
        "ormiański":"hy",
        "armênio":"hy",
        "ਜੰਗਲੀ":"hy",
        "armean":"hy",
        "армянин":"hy",
        "armenianach":"hy",
        "армени":"hy",
        "آرمينيائي":"hy",
        "ආර්මේනියානු":"hy",
        "armensko":"hy",
        "kiarmenia":"hy",
        "armenian ":"hy",
        "ஆர்மீனியன்":"hy",
        "อาร์เมเนีย":"hy",
        "ermeni":"hy",
        "арм":"hy",
        "دیہی":"hy",
        "mật ong":"hy",
        "ארמעניש":"hy",
        "ara ilu armenia":"hy",
        "armanian":"hy",
        "azerbaijani":"az",
        "አዝበርባይጃኒ":"az",
        "أذربيجان":"az",
        "ղուրան":"az",
        "azerbaycan":"az",
        "азербайджанскія":"az",
        "азербайджански":"az",
        "ebra":"az",
        "wazazali":"az",
        "sfarente":"az",
        "ázerbájdžán":"az",
        "aserbajdsjansk":"az",
        "uza":"az",
        "aserbaidžaani":"az",
        "azerbaïdjanaise":"az",
        "azerbeidzjan":"az",
        "ouria":"az",
        "ოღონდ":"az",
        "aserbaidschaner":"az",
        "αζερμπαϊτζάν":"az",
        "પર્વત":"az",
        "haitian":"sl",
        "אזרביג'אן":"az",
        "a azerbaijaniani":"az",
        "azerbajdzsáni":"az",
        "aserbaídsjan":"az",
        "azero":"az",
        "アゼルバイジャン語":"az",
        "ಅಜೆರ್ಬೈಜಾನಿ":"az",
        "азербайжан":"az",
        "អាហ្សង់ទីន":"az",
        "아제르바이잔":"az",
        "kirdar":"az",
        "азербайжанча":"az",
        "a azerbaijani":"az",
        "azerbaidžāņu":"az",
        "azerbaidžaniečių":"az",
        "aserbaidschan":"az",
        "океан":"az",
        "azerbaijaney":"az",
        "azerbaijan":"az",
        "അസർബൈജാനി":"az",
        "tista '":"az",
        "पर्वत":"az",
        "азэрбани":"az",
        "အဇာဘိုင်ဂျန်":"az",
        "हिउँ":"az",
        "ଆଜେରବାଇଜାନି":"az",
        "سیند":"az",
        "اوکان":"az",
        "azerbejdżański":"az",
        "azerbaijana":"az",
        "ਪਹਾੜ":"az",
        "azeră":"az",
        "азербайджанец":"az",
        "aisani":"az",
        "азербаијани":"az",
        "azarus":"az",
        "azarusian":"az",
        "آذربائيجان...":"az",
        "azerbaiyana":"az",
        "azaba":"az",
        "озарбойҷон":"az",
        "அஜர்பைஜானி":"az",
        "อาเซอร์ไบจัน":"az",
        "azeri":"az",
        "азербайджанці":"az",
        "پہاڑ":"az",
        "ozarbayjon":"az",
        "thuyền":"az",
        "aserbaijani":"az",
        "iazerbaijan":"az",
        "isi-azerbaijani":"az",
        "basque":"eu",
        "bask":"eu",
        "ባስክ":"eu",
        "الباسك":"eu",
        "բասկերեն":"eu",
        "баска":"eu",
        "bas":"eu",
        "basc":"eu",
        "basurahan":"eu",
        "vascu":"eu",
        "baskijski":"eu",
        "baskicko":"eu",
        "baskisch":"eu",
        "eŭska":"eu",
        "baski":"eu",
        "baskysk":"eu",
        "vasco":"eu",
        "ბასკური":"eu",
        "βασκικός":"eu",
        "પ્રવાહી":"eu",
        "pōkē":"eu",
        "בסקית":"eu",
        "baszk":"eu",
        "baskneska":"eu",
        "basach":"eu",
        "basca":"eu",
        "バスク語":"eu",
        "basil":"eu",
        "ಬಾಸ್ಕ್":"eu",
        "баск":"eu",
        "바스크 사람":"eu",
        "baskî":"eu",
        "баскча":"eu",
        "ບົກ":"eu",
        "vasca":"eu",
        "basku":"eu",
        "baskų":"eu",
        "baskesch":"eu",
        "баскиски":"eu",
        "baska":"eu",
        "ബാസ്\u200cക്":"eu",
        "waiwai":"eu",
        "ओतणे":"eu",
        "сагс":"eu",
        "ရက်":"eu",
        "पोखरी":"eu",
        "baskisk":"eu",
        "ବାସ୍କ":"eu",
        "باسک":"eu",
        "باسکی":"eu",
        "basco":"eu",
        "ਫਲੈਟ":"eu",
        "bască":"eu",
        "баскский":"eu",
        "basgach":"eu",
        "бас":"eu",
        "chibasque":"eu",
        "بسڪاني":"eu",
        "බාස්ක්":"eu",
        "ชาวแบสค์":"eu",
        "روانی":"eu",
        "باسك":"eu",
        "cung cấp":"eu",
        "basgeg":"eu",
        "agbọn":"eu",
        "i-basque":"eu",
        "belarusian":"be",
        "bjellorusisht":"be",
        "ቤላሩሲያን":"be",
        "البيلاروسية":"be",
        "բելառուս":"be",
        "belarus":"be",
        "па-беларуску":"be",
        "bjeloruski":"be",
        "беларус":"be",
        "volem":"be",
        "bielorussu":"be",
        "běloruský":"be",
        "hviderussisk":"be",
        "wit-russisch":"be",
        "deziras":"be",
        "valgevenelane":"be",
        "valkovenäjä":"be",
        "biélorusse":"be",
        "wytrussysk":"be",
        "queremos":"be",
        "ბელორუსი":"be",
        "belarussisch":"be",
        "λευκορωσικά":"be",
        "વિદ્યુત":"be",
        "bèljik":"be",
        "belarusiyanci":"be",
        "ōlelo belarusa":"be",
        "בלארוסית":"be",
        "belorusz":"be",
        "hvítrússneska":"be",
        "bahasa belarus":"be",
        "bealarúisis":"be",
        "bielorussa":"be",
        "ベラルーシの":"be",
        "ಬೆಲರೂಸಿಯನ್":"be",
        "беларуссиялық":"be",
        "벨로루시 어":"be",
        "belarûsî":"be",
        "беларусча":"be",
        "belarusica":"be",
        "baltkrievu":"be",
        "baltarusis":"be",
        "wäissrussesch":"be",
        "блок":"be",
        "belarosiana":"be",
        "ബെലാറഷ്യൻ":"be",
        "xewqat":"be",
        "उर्जा":"be",
        "ဘီလာစီ":"be",
        "ବେଲାରସୀୟ":"be",
        "بلاروسي":"be",
        "بلاک":"be",
        "białoruski":"be",
        "bielorrusso":"be",
        "ਬਿਜਲੀ":"be",
        "belarusă":"be",
        "белорусский":"be",
        "pelalusiana":"be",
        "belarusianach":"be",
        "бјелоруски":"be",
        "chiberaruzi":"be",
        "بيلاروسي":"be",
        "බෙලාරුසියානු":"be",
        "beloruski":"be",
        "belarusiyaan":"be",
        "bielorrusa":"be",
        "vitryska":"be",
        "беларусӣ":"be",
        "பெலாரஷ்யன்":"be",
        "เบลารุส":"be",
        "білоруська":"be",
        "گرمی":"be",
        "بېلورۇسىيە":"be",
        "belaruslik":"be",
        "người belarus":"be",
        "belarwseg":"be",
        "isibhelarushiyen":"be",
        "בעלגיע":"be",
        "i-belarusian":"be",
        "bengali":"bn",
        "ቤንጋሊ":"bn",
        "البنغالية":"bn",
        "բենգալի":"bn",
        "бенгальская":"bn",
        "বাংলা":"bn",
        "бенгалски":"bn",
        "bengalski":"bn",
        "bengálský":"bn",
        "bengaals":"bn",
        "bengaalsk":"bn",
        "bengalí":"bn",
        "ბენგალი":"bn",
        "μπενγκάλι":"bn",
        "બેંગાલી":"bn",
        "penekali":"bn",
        "בנגאלי":"bn",
        "बंगाली":"bn",
        "bengáli":"bn",
        "benggala":"bn",
        "bengalese":"bn",
        "ベンガル語":"bn",
        "ಬೆಂಗಾಲಿ":"bn",
        "бенгали":"bn",
        "បេនហ្គាលី":"bn",
        "벵골 사람":"bn",
        "bengalî":"bn",
        "бенгалча":"bn",
        "ເບື່ອ":"bn",
        "bengalica":"bn",
        "bengāļu valoda":"bn",
        "bengalų kalba":"bn",
        "bengalesch":"bn",
        "ബംഗാളി":"bn",
        "ဘင်ဂါလီ":"bn",
        "ବଙ୍ଗାଳୀ":"bn",
        "بنگالی":"bn",
        "ਬੰਗਾਲੀ":"bn",
        "бенгальский":"bn",
        "bengàlach":"bn",
        "chibengali":"bn",
        "بنگالي":"bn",
        "බෙංගාලි":"bn",
        "бенгалй":"bn",
        "பெங்காலி":"bn",
        "బెంగాలీ":"bn",
        "ประเทศบังคลาเทศ":"bn",
        "bengal":"bn",
        "бенгальська":"bn",
        "bosniese":"bs",
        "boshnjake":"bs",
        "ቦስንያን":"bs",
        "البوسنية":"bs",
        "բոսնյան":"bs",
        "bosniyalı":"bs",
        "bosniako":"bs",
        "баснійскі":"bs",
        "বসনীয়":"bs",
        "bosanski":"bs",
        "босненски":"bs",
        "bosnià":"bs",
        "bosnian":"bs",
        "wa pachifuwa":"bs",
        "bosniacu":"bs",
        "bosniske":"bs",
        "bosnisch":"bs",
        "bosno":"bs",
        "bosniaque":"bs",
        "bosnysk":"bs",
        "bosnio":"bs",
        "ბოსნიური":"bs",
        "μποσνιανός":"bs",
        "બોસ્નિઅન":"bs",
        "bosnyen":"bs",
        "ponia":"bs",
        "בוסני":"bs",
        "बोस्नियाई":"bs",
        "bosníska":"bs",
        "bosniaca":"bs",
        "ボスニア語":"bs",
        "ಬೋಸ್ನಿಯನ್":"bs",
        "босния":"bs",
        "보스니아 어":"bs",
        "bosnayî":"bs",
        "бошнакча":"bs",
        "bosnesch":"bs",
        "босански":"bs",
        "bosniaka":"bs",
        "ബോസ്നിയൻ":"bs",
        "bosnjan":"bs",
        "rangatira":"bs",
        "बोसनीयन":"bs",
        "босний":"bs",
        "။ ။":"bs",
        "बोसियन":"bs",
        "bosnisk":"bs",
        "بوسنیایی":"bs",
        "بوسنی":"bs",
        "bośniacki":"bs",
        "bósnio":"bs",
        "ਬੋਸਨੀਅਨ":"bs",
        "bosniac":"bs",
        "боснийский":"bs",
        "bosnianach":"bs",
        "chibosnian":"bs",
        "بوسنيائي":"bs",
        "බොස්නියානු":"bs",
        "bosnianska":"bs",
        "bosnia":"bs",
        "босня":"bs",
        "போஸ்னியன்":"bs",
        "బోస్నియన్":"bs",
        "บอสเนีย":"bs",
        "bosnalı":"bs",
        "боснійський":"bs",
        "بوسنیا":"bs",
        "bosniya":"bs",
        "bosniani":"bs",
        "bulgarian":"bg",
        "ቡልጋርያኛ":"bg",
        "البلغارية":"bg",
        "բուլղարերեն":"bg",
        "bulqar":"bg",
        "балгарская":"bg",
        "বুলগেরীয়":"bg",
        "bugarski":"bg",
        "български":"bg",
        "búlgar":"bg",
        "chibugariya":"bg",
        "bulgaru":"bg",
        "bulharský":"bg",
        "bulgarsk":"bg",
        "bulgaars":"bg",
        "bulgara":"bg",
        "bulgaaria keel":"bg",
        "bulgarialainen":"bg",
        "bulgare":"bg",
        "bulgaarsk":"bg",
        "búlgaro":"bg",
        "ბულგარული":"bg",
        "bulgarisch":"bg",
        "βούλγαρος":"bg",
        "ઇલેક્ટ્રિકલ":"bg",
        "bulgari":"bg",
        "pukalia":"bg",
        "בולגרית":"bg",
        "bolgár":"bg",
        "búlgarska":"bg",
        "bulgaria":"bg",
        "bulgáiris":"bg",
        "ブルガリア語":"bg",
        "ಬಲ್ಗೇರಿಯನ್":"bg",
        "болгар":"bg",
        "불가리아 사람":"bg",
        "bûlgarî":"bg",
        "болгарча":"bg",
        "bulgarica":"bg",
        "bulgāru":"bg",
        "bulgarų":"bg",
        "bulgarescg":"bg",
        "бугарски":"bg",
        "biolgara":"bg",
        "orang bulgaria":"bg",
        "ബൾഗേറിയൻ":"bg",
        "बडबड":"bg",
        "болгар хүн":"bg",
        "ဘူဂေးရီးယား":"bg",
        "ब्लड":"bg",
        "ବୁଲଗେରିଆନ୍ |":"bg",
        "bułgarski":"bg",
        "búlgara":"bg",
        "ਇਲੈਕਟ੍ਰੋਲਿਕ":"bg",
        "bulgară":"bg",
        "болгарский":"bg",
        "bulgàrianach":"bg",
        "chibulgarian":"bg",
        "بلغاريائي":"bg",
        "බල්ගේරියානු":"bg",
        "bolgarščina":"bg",
        "булгарӣ":"bg",
        "பல்கேரியன்":"bg",
        "บัลแกเรีย":"bg",
        "bulgar":"bg",
        "болгарська":"bg",
        "بلغاری":"bg",
        "بۇلغارىيە":"bg",
        "bulgariyalik":"bg",
        "bungari":"bg",
        "bwlgaria":"bg",
        "בולגאַריש":"bg",
        "isi-bulgaria":"bg",
        "catalan":"ca",
        "ካታሊያን":"ca",
        "الكاتالونية":"ca",
        "կատալաներեն":"ca",
        "katalan":"ca",
        "лад":"ca",
        "каталонски":"ca",
        "català":"ca",
        "chikatalani":"ca",
        "catalanu":"ca",
        "katalonski":"ca",
        "katalánština":"ca",
        "catalansk":"ca",
        "catalaans":"ca",
        "kataluna":"ca",
        "katalaani keeles":"ca",
        "catalane":"ca",
        "katalaansk":"ca",
        "catalán":"ca",
        "კატალონიური":"ca",
        "katalanisch":"ca",
        "καταλανικά":"ca",
        "સંપૂર્ણ":"ca",
        "ōlelo katalonia":"ca",
        "קטלאנית":"ca",
        "katalán":"ca",
        "katalónska":"ca",
        "katalogi":"ca",
        "catalóinis":"ca",
        "catalana":"ca",
        "カタロニア語":"ca",
        "ಕ್ಯಾಟಲಾನ್":"ca",
        "каталан":"ca",
        "카탈로니아 사람":"ca",
        "katalanî":"ca",
        "каталанча":"ca",
        "katalāņu":"ca",
        "katalonų":"ca",
        "katalanesch":"ca",
        "katalana":"ca",
        "കറ്റാലൻ":"ca",
        "परिपूर्ण":"ca",
        "ကွမ်းခြံကုန်း":"ca",
        "सिद्ध":"ca",
        "କାଟାଲାନ୍":"ca",
        "کتالین":"ca",
        "كاتاليك":"ca",
        "kataloński":"ca",
        "catalã":"ca",
        "ਸੰਪੂਰਨ":"ca",
        "каталонский":"ca",
        "catalanach":"ca",
        "цаталан":"ca",
        "katatata":"ca",
        "katarani":"ca",
        "කැටලන්":"ca",
        "katalánčina":"ca",
        "kulinarično":"ca",
        "katol":"ca",
        "kikatalani":"ca",
        "katalansk":"ca",
        "கற்றலான்":"ca",
        "คาตาลัน":"ca",
        "каталон":"ca",
        "کامل":"ca",
        "quy mô":"ca",
        "isikhathalan":"ca",
        "ikatalani":"ca",
        "cebuano":"ceb",
        "سيبوانو":"ceb",
        "ցեբուանո":"ceb",
        "চেবুয়ানো":"ceb",
        "себуано":"ceb",
        "tsebuano":"ceb",
        "კებუანო":"ceb",
        "સિબુઆનો":"ceb",
        "קבאו":"ceb",
        "सिबुआनो":"ceb",
        "cebsiab":"ceb",
        "kebúano":"ceb",
        "セブアノ":"ceb",
        "ಸೆಬುವಾನೋ":"ceb",
        "អាហារបំប៉ន":"ceb",
        "세부 아노":"ceb",
        "ຄວາມເບີກບານ":"ceb",
        "цебуано":"ceb",
        "кебуана":"ceb",
        "ସେବୁଆନୋ |":"ceb",
        "سیبانو...":"ceb",
        "cebuana":"ceb",
        "ਸੇਬੂਆਨੋ":"ceb",
        "кебуано":"ceb",
        "ڪيوبوانو":"ceb",
        "సేబుఆనో":"ceb",
        "سیبانو":"ceb",
        "kabuano":"ceb",
        "cevano":"ceb",
        "chichewa":"ny",
        "ቺካዋዋ":"ny",
        "شيشوا":"ny",
        "չիչվա":"ny",
        "çichewa":"ny",
        "чычэва":"ny",
        "চীচেওয়া":"ny",
        "чичеуа":"ny",
        "ჩიჩავა":"ny",
        "ચિચેવા":"ny",
        "צ'יצ'ווה":"ny",
        "चिचेवा":"ny",
        "チチェワ":"ny",
        "ಚಿಚೆವಾ":"ny",
        "чичева":"ny",
        "ឈីហេវ៉ា":"ny",
        "치체와":"ny",
        "жапон":"ja",
        "čičeva":"ny",
        "ചിചേവ":"ny",
        "ချစ်ချစ်":"ny",
        "چيچوا":"ny",
        "چیچوا":"ny",
        "ਚੀਚੇਵਾ":"ny",
        "цхицхева":"ny",
        "چيچي":"ny",
        "චිචෙවා":"ny",
        "చిచెవా":"ny",
        "chicheva":"ny",
        "чічева":"ny",
        "chinees (vereenvoudig)":"zh-CN",
        "chinees":"zh-CN",
        "kineze (e thjeshtuar)":"zh-CN",
        "kineze":"zh-CN",
        "ቻይንኛ (ቀለል ያለ)":"zh-CN",
        "ቻይንኛ":"zh-CN",
        "الصينية المبسطة)":"zh-CN",
        "չինական (պարզեցված)":"zh-cn",
        "չինական":"zh-CN",
        "çin (sadələşdirilmiş)":"zh-CN",
        "çin":"zh-CN",
        "txinera (sinplifikatua)":"zh-CN",
        "txinera":"zh-CN",
        "кітайскі (спрошчаны)":"zh-CN",
        "кітайскі":"zh-CN",
        "সরলীকৃত চীনা)":"zh-CN",
        "kineska (pojednostavljena)":"zh-CN",
        "kineska":"zh-CN",
        "опростен китайски)":"zh-CN",
        "xinès (simplificat)":"zh-CN",
        "xinès":"zh-CN",
        "chinese (gipasimple)":"zh-CN",
        "chinese (chosavuta)":"zh-CN",
        "cinese (simplificatu)":"zh-CN",
        "cinese":"zh-CN",
        "zjednodušená čínština":"zh-CN",
        "kinesisk forenklet":"zh-CN",
        "versimpeld chinees":"zh-CN",
        "chinese (simplified)":"zh-CN",
        "ĉina (simpligita)":"zh-CN",
        "ĉina":"zh-CN",
        "lihtsustatud hiina keel)":"zh-CN",
        "intsik (pinasimple)":"zh-cn",
        "intsik":"zh-CN",
        "yksinkertaistettu kiina)":"zh-cn",
        "chinois":"zh-CN",
        "chinois simplifié":"zh-CN",
        "chinois (simplifié)":"zh-CN",
        "sineesk (ferienfâldige)":"zh-CN",
        "sineesk":"zh-CN",
        "chinés (simplificado)":"zh-CN",
        "chinés":"zh-CN",
        "გამარტივებული ჩინური)":"zh-CN",
        "vereinfachtes chinesisch)":"zh-CN",
        "απλοποιημένα κινέζικα)":"zh-CN",
        "ચાઇનીઝ (સરળ)":"zh-CN",
        "chinwa (senplifye)":"zh-CN",
        "kasar sinanci (a saukake)":"zh-CN",
        "ʻohana":"zh-CN",
        "סינית מופשטת)":"zh-CN",
        "सरलीकृत चीनी)":"zh-CN",
        "suav (yooj yim zog)":"zh-CN",
        "kínai (egyszerűsített)":"zh-CN",
        "kínverska (einfölduð)":"zh-CN",
        "china (simplified)":"zh-CN",
        "bahasa tiongkok yang disederhanakan)":"zh-CN",
        "sínis (simplithe)":"zh-CN",
        "cinese semplificato)":"zh-cn",
        "中国語（簡体字）":"zh-CN",
        "cina (disederhanakake)":"zh-CN",
        "ಚೈನೀಸ್ (ಸರಳೀಕೃತ)":"zh-CN",
        "қытай (жеңілдетілген)":"zh-CN",
        "ចិន (សាមញ្ញ)":"zh-CN",
        "중국어 (간체)":"zh-CN",
        "çînî (sade kirin)":"zh-CN",
        "кытайча (жөнөкөйлөтүлгөн)":"zh-CN",
        "ພາສາຈີນ (ແບບງ່າຍ)":"zh-CN",
        "seres (facilius)":"zh-CN",
        "ķīniešu (vienkāršota)":"zh-CN",
        "kinų (supaprastinta)":"zh-CN",
        "chineesesch (vereinfacht)":"zh-CN",
        "кинески (поедноставен)":"zh-CN",
        "sinoa (natsotra)":"zh-CN",
        "cina (dipermudahkan)":"zh-cn",
        "സുഗമമാക്കിയ ചൈനീസ്)":"zh-CN",
        "ċiniż (simplifikat)":"zh-CN",
        "hainamana (ka whakatauhia)":"zh-cn",
        "चीनी (सरलीकृत)":"zh-CN",
        "хятад (хялбаршуулсан)":"zh-CN",
        "တရုတ် (ရိုးရှင်း)":"zh-CN",
        "चिनियाँ (सरलीकृत)":"zh-CN",
        "forenklet kinesisk)":"zh-CN",
        "ଚାଇନିଜ୍ (ସରଳୀକୃତ)":"zh-CN",
        "چینایی (ساده شوی)":"zh-CN",
        "زبان چینی ساده شده)":"zh-CN",
        "uproszczony chiński)":"zh-CN",
        "chinês simplificado)":"zh-CN",
        "ਚੀਨੀ (ਸਰਲ)":"zh-CN",
        "chineză simplificată)":"zh-CN",
        "китайский упрощенный)":"zh-CN",
        "saina (faʻafaigofie)":"zh-CN",
        "china (simplichte)":"zh-CN",
        "кинеска (поједностављена)":"zh-CN",
        "chinese (e nolofalitsoeng)":"zh-CN",
        "chinese (chinorerutswa)":"zh-CN",
        "چيني (سادگي وارو)":"zh-CN",
        "චීන (සරල)":"zh-CN",
        "kitajska (poenostavljena)":"zh-CN",
        "shiinaha (la fududeeyey)":"zh-cn",
        "china (simplificada)":"zh-CN",
        "cina (disederhanakeun)":"zh-CN",
        "kichina (kilichorahisishwa)":"zh-CN",
        "förenklad kinesiska)":"zh-CN",
        "хитоӣ (соддакардашуда)":"zh-CN",
        "சீன (எளிமைப்படுத்தப்பட்ட)":"zh-CN",
        "సులభమైన చైనా భాష)":"zh-CN",
        "จีน (ตัวย่อ)":"zh-CN",
        "basitleştirilmiş çince)":"zh-CN",
        "китайська (спрощена)":"zh-CN",
        "آسان چینی زبان)":"zh-CN",
        "خەنزۇچە (ئاددىيلاشتۇرۇلغان)":"zh-CN",
        "xitoycha (soddalashtirilgan)":"zh-CN",
        "trung quốc (đơn giản hóa)":"zh-CN",
        "tsieineaidd (wedi'i symleiddio)":"zh-CN",
        "isi-chinese (lula)":"zh-CN",
        "כינעזיש":"zh-CN",
        "kannada (ni irọrun)":"zh-CN",
        "chinees (tradisioneel)":"zh-TW",
        "tradita kineze)":"zh-TW",
        "ቻይንኛ (ባህላዊ)":"zh-TW",
        "تقاليد صينية)":"zh-TW",
        "չինական (ավանդական)":"zh-tw",
        "çin (ənənəvi)":"zh-TW",
        "txinatarra (tradizionala)":"zh-TW",
        "кітайскі (традыцыйны)":"zh-TW",
        "প্রথাগত চীনা)":"zh-TW",
        "kineska (tradicionalna)":"zh-TW",
        "традиционен китайски)":"zh-TW",
        "xinès (tradicional)":"zh-TW",
        "chinese (tradisyonal)":"zh-TW",
        "wachichaina (wachikhalidwe)":"zh-TW",
        "cinese (tradiziunale)":"zh-TW",
        "kinesko tradicionalno)":"zh-TW",
        "čínština (tradiční)":"zh-TW",
        "kinesisk (traditionel)":"zh-tw",
        "chinese traditionele)":"zh-TW",
        "chinese (traditional)":"zh-TW",
        "ĉina (tradicia)":"zh-TW",
        "traditsiooniline hiina keel)":"zh-TW",
        "intsik (tradisyonal)":"zh-tw",
        "kiinalainen perinteinen)":"zh-tw",
        "chinois (traditionnel)":"zh-TW",
        "sineesk (tradisjoneel)":"zh-TW",
        "chinés (tradicional)":"zh-TW",
        "ჩინური (ტრადიციული)":"zh-TW",
        "chinesische tradition)":"zh-TW",
        "παραδοσιακά κινέζικα)":"zh-TW",
        "ચાઇનીઝ (પરંપરાગત)":"zh-TW",
        "chinwa (tradisyonèl)":"zh-TW",
        "harshen kasar sin (na gargajiya)":"zh-TW",
        "laulima":"zh-TW",
        "מסורת סינית)":"zh-TW",
        "चीनी पारंपरिक)":"zh-TW",
        "suav (tsoos)":"zh-TW",
        "kínai (hagyományos)":"zh-TW",
        "kínverska (hefðbundin)":"zh-TW",
        "china (ọdịnala)":"zh-TW",
        "cina tradisional)":"zh-TW",
        "sínis (traidisiúnta)":"zh-TW",
        "cinese tradizionale)":"zh-tw",
        "中国の伝統的な）":"zh-TW",
        "cina (tradisional)":"zh-TW",
        "ಚೈನೀಸ್ (ಸಾಂಪ್ರದಾಯಿಕ)":"zh-TW",
        "қытай (дәстүрлі)":"zh-TW",
        "ប្រពៃណីចិន)":"zh-TW",
        "중국 전통)":"zh-TW",
        "çînî (kevneşopî)":"zh-TW",
        "кытай (салттуу)":"zh-TW",
        "ຈີນ (ດັ້ງເດີມ)":"zh-TW",
        "seres (traditional)":"zh-TW",
        "ķīniešu (tradicionālā)":"zh-TW",
        "kinų tradicinis)":"zh-TW",
        "chineesesch (traditionell)":"zh-TW",
        "кинески (традиционален)":"zh-TW",
        "sinoa (nentin-drazana)":"zh-TW",
        "ചൈനീസ് പാരമ്പര്യമായ)":"zh-TW",
        "ċiniż (tradizzjonali)":"zh-TW",
        "hainamana (tuku iho)":"zh-tw",
        "पारंपारिक चीनी)":"zh-TW",
        "хятадын уламжлалт)":"zh-TW",
        "တရုတ်ရိုးရာ)":"zh-TW",
        "चिनियाँ (परम्परागत)":"zh-TW",
        "tradisjonell kinesisk)":"zh-TW",
        "ଚାଇନିଜ୍ (ପାରମ୍ପାରିକ)":"zh-TW",
        "چینایي":"zh-TW",
        "چینی (سنتی)":"zh-TW",
        "chiński tradycyjny)":"zh-TW",
        "chinês tradicional)":"zh-TW",
        "ਚੀਨੀ (ਰਵਾਇਤੀ)":"zh-TW",
        "tradițional chinezesc)":"zh-TW",
        "китайский традиционный)":"zh-TW",
        "saina (masani)":"zh-TW",
        "sìneach (traidiseanta)":"zh-TW",
        "традиционални кинески)":"zh-TW",
        "chinese (setso)":"zh-TW",
        "chinese (zvetsika)":"zh-TW",
        "چيني (روايتي)":"zh-TW",
        "චීන (සාම්ප්\u200dරදායික)":"zh-TW",
        "tradične čínske)":"zh-TW",
        "kitajska (tradicionalna)":"zh-TW",
        "shiinaha (dhaqameed)":"zh-tw",
        "china (tradicional)":"zh-TW",
        "kichina (cha jadi)":"zh-TW",
        "traditionell kinesisk)":"zh-TW",
        "хитоӣ (анъанавӣ)":"zh-TW",
        "சீன (பாரம்பரிய)":"zh-TW",
        "చైనీస్ (సాంప్రదాయ)":"zh-TW",
        "จีน (ดั้งเดิม)":"zh-TW",
        "çin geleneği)":"zh-TW",
        "китайський традиційний)":"zh-TW",
        "چینی (روایتی)":"zh-TW",
        "خەنزۇچە (ئەنئەنىۋى)":"zh-TW",
        "xitoy (an'anaviy)":"zh-TW",
        "truyền thống trung hoa)":"zh-TW",
        "tsieineaidd (traddodiadol)":"zh-TW",
        "isi-chinese (ngokwesiko)":"zh-TW",
        "כינעזיש (טראַדיציאָנעל)":"zh-TW",
        "kannada (ibile)":"zh-TW",
        "isishayina (ngokwesiko)":"zh-TW",
        "korsikaans":"co",
        "corsican":"co",
        "ኮርሲካን":"co",
        "كورسيكان":"co",
        "կորսիկյան":"co",
        "korsikalı":"co",
        "korsikera":"co",
        "карсіканскі":"co",
        "কর্সিকান":"co",
        "korzikanski":"co",
        "корсикански":"co",
        "corsari":"co",
        "kakhori":"co",
        "corsu":"co",
        "korzički":"co",
        "korsičan":"co",
        "korsikansk":"co",
        "corsicaans":"co",
        "korsikano":"co",
        "korsikalainen":"co",
        "corse":"co",
        "korsikaansk":"co",
        "corsario":"co",
        "კორსიკელი":"co",
        "korsisch":"co",
        "κορσικανός":"co",
        "કોર્સિકન":"co",
        "korsik":"co",
        "ōlelo kokia":"co",
        "קורסיקנית":"co",
        "कोर्सीकन":"co",
        "korzikai":"co",
        "korsíska":"co",
        "korsika":"co",
        "コルシカ":"co",
        "korsikan":"co",
        "ಕಾರ್ಸಿಕನ್":"co",
        "корсик":"co",
        "코르시카 어":"co",
        "korsîkayî":"co",
        "корсикче":"co",
        "corsica":"co",
        "korsikānis":"co",
        "korsikas":"co",
        "korsesch":"co",
        "корзикан":"co",
        "കോർസിക്കൻ":"co",
        "korsikjan":"co",
        "कोर्सिकन":"co",
        "कोर्सिकान":"co",
        "କର୍ସିକାନ୍ |":"co",
        "کورسیکن":"co",
        "کره ای":"ko",
        "korsykański":"co",
        "ਕਾਰਸਿਕਨ":"co",
        "corsicană":"co",
        "корсиканец":"co",
        "kosikana":"co",
        "corsicanach":"co",
        "корзикански":"co",
        "kosikeni":"co",
        "ڪارسيڪائي":"co",
        "korzičan":"co",
        "korziška":"co",
        "corso":"co",
        "korosho":"co",
        "корсикан":"co",
        "கோர்சிகன்":"co",
        "కోర్సికన్":"co",
        "คอร์ซิกา":"co",
        "корсиканський":"co",
        "کارسیکن":"co",
        "korsikalik":"co",
        "isikhorsikhen":"co",
        "kọsitọmu":"co",
        "i-corsican":"co",
        "croatian":"hr",
        "ክሮኤሽያን":"hr",
        "الكرواتية":"hr",
        "խորվաթերեն":"hr",
        "xoruz":"hr",
        "харвацкая":"hr",
        "hrvatska":"hr",
        "хърватски":"hr",
        "croat":"hr",
        "momwemonso":"hr",
        "cruatu":"hr",
        "hrvatski":"hr",
        "chorvatský":"hr",
        "kroatisk":"hr",
        "kroatisch":"hr",
        "kroata":"hr",
        "horvaadi keeles":"hr",
        "kroaatti":"hr",
        "croate":"hr",
        "kroatysk":"hr",
        "croata":"hr",
        "ხორვატული":"hr",
        "κροατία":"hr",
        "કુશળ":"hr",
        "kwoasyen":"hr",
        "koalia":"hr",
        "קרואטי":"hr",
        "क्रोएशियाई":"hr",
        "caj pas":"hr",
        "horvát":"hr",
        "króatíska":"hr",
        "kroasia":"hr",
        "クロアチア語":"hr",
        "ಕ್ರೊಯೇಷಿಯನ್":"hr",
        "хорват":"hr",
        "크로아티아":"hr",
        "xirwatî":"hr",
        "хорватча":"hr",
        "crovatica":"hr",
        "horvātu":"hr",
        "kroatų":"hr",
        "kroatesch":"hr",
        "хрватски":"hr",
        "kroaty":"hr",
        "ക്രൊയേഷ്യൻ":"hr",
        "kroat":"hr",
        "कुशल":"hr",
        "крипиан":"hr",
        "ခရိုဒီးယား":"hr",
        "प्राविधिक":"hr",
        "କ୍ରୋଏସିଆନ୍":"hr",
        "کرواسین":"hr",
        "کرواتی":"hr",
        "chorwacki":"hr",
        "ਕੁਸ਼ਲ":"hr",
        "хорватский":"hr",
        "croatianach":"hr",
        "ka mokhoa o ts'oanang":"hr",
        "chicroatian":"hr",
        "ڪروشيائي":"hr",
        "ක්\u200dරොඒෂියානු":"hr",
        "chorvátsky":"hr",
        "hrvaščina":"hr",
        "vivyo hivyo":"hr",
        "ҳунарманд":"hr",
        "குரோஷியன்":"hr",
        "โครเอเชีย":"hr",
        "hırvat":"hr",
        "хорватська":"hr",
        "ماہر":"hr",
        "xorvatiyalik":"hr",
        "tiếng anh":"en",
        "קראָאַטיאַן":"hr",
        "ngokufanayo":"hr",
        "czech":"cs",
        "çek":"cs",
        "ቼክ":"cs",
        "التشيكية":"cs",
        "չեխերեն":"cs",
        "çex":"cs",
        "чэшская":"cs",
        "চেক":"cs",
        "češki":"cs",
        "чешки":"cs",
        "txec":"cs",
        "ceccu":"cs",
        "čeština":"cs",
        "tjekkisk":"cs",
        "tsjechisch":"cs",
        "ĉe .a":"cs",
        "tšehhi":"cs",
        "tchèque":"cs",
        "tsjechysk":"cs",
        "checo":"cs",
        "ჩეხური":"cs",
        "tschechisch":"cs",
        "τσέχος":"cs",
        "ચેક":"cs",
        "keka":"cs",
        "צ'כית":"cs",
        "चेक":"cs",
        "cseh":"cs",
        "tékknesku":"cs",
        "njikwa":"cs",
        "ceko":"cs",
        "ceca":"cs",
        "チェコ語":"cs",
        "ಜೆಕ್":"cs",
        "чех":"cs",
        "ឆែក":"cs",
        "체코 사람":"cs",
        "çekî":"cs",
        "чехче":"cs",
        "ເຊັກ":"cs",
        "bohemica":"cs",
        "čehu":"cs",
        "čekų":"cs",
        "tschechesch":"cs",
        "bahasa czech":"cs",
        "ചെക്ക്":"cs",
        "ċeka":"cs",
        "ချက်":"cs",
        "tsjekkisk":"cs",
        "ଚେକ୍":"cs",
        "کشور چک":"cs",
        "tcheca":"cs",
        "ਚੈਕ":"cs",
        "ceh":"cs",
        "чешский":"cs",
        "seacach":"cs",
        "chiczech":"cs",
        "چيڪ ٻولي":"cs",
        "චෙක්":"cs",
        "český":"cs",
        "češko":"cs",
        "checa":"cs",
        "tjeck":"cs",
        "чехия":"cs",
        "செக்":"cs",
        "สาธารณรัฐเช็ก":"cs",
        "чеська":"cs",
        "چیک":"cs",
        "chex":"cs",
        "séc":"cs",
        "sosipo":"cs",
        "danish":"da",
        "danez":"da",
        "ዳኒሽ":"da",
        "دانماركي":"da",
        "դանիերեն":"da",
        "датчане":"da",
        "ডেনমার্কের":"da",
        "danski":"da",
        "датски":"da",
        "danès":"da",
        "danese":"da",
        "dánština":"da",
        "dansk":"da",
        "deens":"da",
        "danoj":"da",
        "taanlane":"da",
        "tanskan kieli":"da",
        "danoise":"da",
        "deensk":"da",
        "danés":"da",
        "დანიური":"da",
        "dänisch":"da",
        "δανικός":"da",
        "ડેનિશ":"da",
        "danwa":"da",
        "kenemaka":"da",
        "דַנִי":"da",
        "दानिश":"da",
        "seev cev":"da",
        "dán":"da",
        "dönsku":"da",
        "ịgba egwu":"da",
        "orang denmark":"da",
        "デンマーク語":"da",
        "nari":"da",
        "ಡ್ಯಾನಿಶ್":"da",
        "дат":"da",
        "រាំ":"da",
        "덴마크 말":"da",
        "danîmarkî":"da",
        "датча":"da",
        "ເຕັ້ນ":"da",
        "danica":"da",
        "dāņu":"da",
        "danai":"da",
        "dänesch":"da",
        "дански":"da",
        "danoà":"da",
        "ഡാനിഷ്":"da",
        "daniż":"da",
        "whakangahau":"da",
        "डॅनिश":"da",
        "дани":"da",
        "ဒိန်းမတ်":"da",
        "डेनिस":"da",
        "ଡାନିଶ୍ |":"da",
        "دنمارکي":"da",
        "دانمارکی":"da",
        "duński":"da",
        "dinamarquês":"da",
        "ਡੈਨਿਸ਼":"da",
        "датский язык":"da",
        "dànach":"da",
        "chidanish":"da",
        "ڊينش ٻولي":"da",
        "දානිෂ්":"da",
        "dánsky":"da",
        "dhaanto":"da",
        "danesa":"da",
        "nanjak":"da",
        "даниш":"da",
        "เดนมาร์ก":"da",
        "danimarkalı":"da",
        "датський":"da",
        "ڈینش":"da",
        "daniyalik":"da",
        "người đan mạch":"da",
        "דאַניש":"da",
        "ijó":"da",
        "nederlands":"nl",
        "holandez":"nl",
        "ደች":"nl",
        "هولندي":"nl",
        "հոլանդական":"nl",
        "xəndək":"nl",
        "dutch":"nl",
        "галандская":"nl",
        "ডাচ":"nl",
        "holandski":"nl",
        "холандски":"nl",
        "holandès":"nl",
        "chisilamu":"nl",
        "ulandesa":"nl",
        "nizozemac":"nl",
        "holandský":"nl",
        "hollandske":"nl",
        "nederlanda":"nl",
        "hollandlane":"nl",
        "tulak":"nl",
        "hollannin kieli":"nl",
        "néerlandaise":"nl",
        "nederlânsk":"nl",
        "holandés":"nl",
        "ჰოლანდიური":"nl",
        "niederländisch":"nl",
        "ολλανδός":"nl",
        "ડચ":"nl",
        "olandè":"nl",
        "hōlani":"nl",
        "הוֹלַנדִי":"nl",
        "डच":"nl",
        "lub dutch":"nl",
        "holland":"nl",
        "hollensk":"nl",
        "belanda":"nl",
        "ollainnis":"nl",
        "olandese":"nl",
        "オランダの":"nl",
        "dhuh":"nl",
        "ಡಚ್":"nl",
        "ілмек":"nl",
        "ប្រទេសហូឡង់":"nl",
        "네덜란드 사람":"nl",
        "holandî":"nl",
        "нидерландча":"nl",
        "ໂຮນລັງ":"nl",
        "batavica":"nl",
        "holandiešu":"nl",
        "olandas":"nl",
        "hollänesch":"nl",
        "anarana iombonana":"nl",
        "ഡച്ച്":"nl",
        "olandiż":"nl",
        "horoi":"nl",
        "ဒတ်ချ်":"nl",
        "nederlandsk":"nl",
        "ଡଚ୍":"nl",
        "الماني":"nl",
        "هلندی":"nl",
        "holenderski":"nl",
        "holandesa":"nl",
        "ਡੱਚ":"nl",
        "olandeză":"nl",
        "нидерландский язык":"nl",
        "siamani":"de",
        "duitseach":"nl",
        "borithane":"nl",
        "chidutch":"nl",
        "ڊچ ٻولي":"nl",
        "ලන්දේසි":"nl",
        "nizozemski":"nl",
        "déwék":"nl",
        "jadi":"nl",
        "дандон":"nl",
        "டச்சு":"nl",
        "ดัตช์":"nl",
        "flemenkçe":"nl",
        "голландський":"nl",
        "ڈچ":"nl",
        "hà lan":"nl",
        "isidatshi":"nl",
        "האָלענדיש":"nl",
        "i-arabhu":"nl",
        "engels":"en",
        "anglisht":"en",
        "እንግሊዝኛ":"en",
        "الإنجليزية":"en",
        "անգլերեն":"en",
        "ingilis":"en",
        "ingelesez":"en",
        "англійская":"en",
        "ইংরেজি":"en",
        "engleski":"en",
        "английски":"en",
        "anglès":"en",
        "iningles":"en",
        "chingerezi":"en",
        "inglese":"en",
        "angličtina":"en",
        "engelsk":"en",
        "english":"en",
        "angla":"en",
        "inglise":"en",
        "ingles":"en",
        "englanti":"en",
        "anglaise":"en",
        "ingelsk":"en",
        "inglés":"en",
        "ინგლისური":"en",
        "englisch":"en",
        "αγγλικά":"en",
        "અંગ્રેજી":"en",
        "anglè":"en",
        "turanci":"en",
        "pelekania":"en",
        "אנגלית":"en",
        "अंग्रेज़ी":"en",
        "askiv":"en",
        "angol":"en",
        "enska":"en",
        "inggris":"en",
        "béarla":"en",
        "英語":"en",
        "ಆಂಗ್ಲ":"en",
        "қазақша":"en",
        "ភាសាអង់គ្លេស":"en",
        "영어":"en",
        "îngilîzî":"en",
        "англисче":"en",
        "ອັງກິດ":"en",
        "anglicus":"en",
        "angļu":"en",
        "anglų":"en",
        "englesch":"en",
        "англиски":"en",
        "anglisy":"en",
        "bahasa inggeris":"en",
        "ഇംഗ്ലീഷ്":"en",
        "bl-ingliż":"en",
        "ingarihi":"en",
        "इंग्रजी":"en",
        "англи хэл":"en",
        "အင်္ဂလိပ်":"en",
        "अंग्रेजी":"en",
        "ଇଂରାଜୀ":"en",
        "انګلیسي...":"en",
        "język angielski":"en",
        "inglês":"en",
        "ਅੰਗਰੇਜ਼ੀ":"en",
        "engleză":"en",
        "английский":"en",
        "igilisi":"uz",
        "sasannach":"en",
        "енглески језик":"en",
        "chirungu":"en",
        "انگريزي":"en",
        "ඉංග්රීසි":"en",
        "angleščina":"en",
        "ingiriisi":"en",
        "inglesa":"en",
        "kiingereza":"en",
        "англисӣ":"en",
        "ஆங்கிலம்":"en",
        "ఆంగ్ల":"en",
        "อังกฤษ":"en",
        "ingilizce":"en",
        "англійська":"en",
        "انگریزی":"en",
        "inglizcha":"en",
        "saesneg":"en",
        "isingesi":"en",
        "ענגליש":"en",
        "gẹẹsi":"en",
        "isingisi":"en",
        "esperanto":"eo",
        "እስፔራንቶ":"eo",
        "إسبرانتو":"eo",
        "էսպերանտո":"eo",
        "эсперанта":"eo",
        "এস্পেরান্তো":"eo",
        "есперанто":"eo",
        "esperantu":"eo",
        "espéranto":"eo",
        "ესპერანტო":"eo",
        "εσπεράντο":"eo",
        "એસ્પેરેન્ટો":"eo",
        "ōlelo esperanto":"eo",
        "אֶסְפֵּרַנְטוֹ":"eo",
        "एस्पेरांतो":"eo",
        "eszperantó":"eo",
        "エスペラント":"eo",
        "ಎಸ್ಪೆರಾಂಟೊ":"eo",
        "эсперанто":"eo",
        "에스페란토 말":"eo",
        "esperanto kalba":"eo",
        "എസ്പെരാന്തോ":"eo",
        "အက်စ်တိုးတို":"eo",
        "ایسپیرینټو":"eo",
        "اسپرانتو":"eo",
        "ਐਸਪੇਰਾਂਤੋ":"eo",
        "eseperano":"eo",
        "esiperando":"eo",
        "ايسپرانتو":"eo",
        "එස්පෙරාන්තෝ":"eo",
        "ఎస్పరెన్టొ":"eo",
        "ภาษาโลก":"eo",
        "ایسپرانو":"eo",
        "isiesperanto":"eo",
        "estonian":"et",
        "estonez":"et",
        "ኢስቶኒያን":"et",
        "الإستونية":"et",
        "էստոնական":"et",
        "eston":"et",
        "эст":"et",
        "est":"et",
        "естонски":"et",
        "estonià":"et",
        "estonia":"et",
        "estone":"et",
        "estonski":"et",
        "estonština":"et",
        "estisk":"et",
        "ests":"et",
        "estono":"et",
        "eesti keel":"et",
        "virolainen":"et",
        "estonien":"et",
        "estysk":"et",
        "estonio":"et",
        "ესტონური":"et",
        "estnisch":"et",
        "εσθονικά":"et",
        "ઇંગ્લિશ":"et",
        "estonyen":"et",
        "isonian":"et",
        "ekekonia":"et",
        "אסטורי":"et",
        "észt":"et",
        "eistneska, eisti, eistneskur":"et",
        "estónach":"et",
        "エストニア語":"et",
        "ಎಸ್ಟೋನಿಯನ್":"et",
        "эстондық":"et",
        "អេស្តូន":"et",
        "에스토니아 사람":"et",
        "estonî":"et",
        "эстончо":"et",
        "igauņu":"et",
        "estų":"et",
        "estonesch":"et",
        "estoniana":"et",
        "orang estonia":"et",
        "എസ്റ്റോണിയൻ":"et",
        "estonjan":"et",
        "kariki":"is",
        "कीबोर्ड":"et",
        "эстон":"et",
        "အက်စတိုးနီးယား":"et",
        "इन्डियन":"et",
        "ଇଷ୍ଟୋନିଆନ୍ |":"et",
        "ایستونین":"et",
        "استونیایی":"et",
        "estoński":"et",
        "ਸ਼ਬਦ":"et",
        "эстонский":"et",
        "estòinianach":"et",
        "ест":"et",
        "chiestonian":"et",
        "ايستونائي":"et",
        "එස්තෝනියානු":"et",
        "estónsky":"et",
        "éstonia":"et",
        "kiestonia":"et",
        "estniska":"et",
        "эстонӣ":"et",
        "எஸ்டோனியன்":"et",
        "เอสโตเนีย":"et",
        "estonyalı":"et",
        "اردو":"ur",
        "dân tộc":"et",
        "עסטיש":"et",
        "ara ilu estonia":"et",
        "isi-estonia":"et",
        "filipino":"tl",
        "tagalogisht":"tl",
        "الفلبينية":"tl",
        "դանդաղ":"tl",
        "закід":"tl",
        "филипински":"tl",
        "filipí":"tl",
        "chotsimikizika":"tl",
        "filippinu":"tl",
        "filipijns":"tl",
        "filipina":"tl",
        "philippin":"tl",
        "filipynsk":"tl",
        "filipinas":"tl",
        "ფილიპინურად":"tl",
        "φιλιππίνος":"tl",
        "ઈડિન":"tl",
        "filipin":"tl",
        "פיליפיני":"tl",
        "filippínó":"tl",
        "filippseyska":"tl",
        "filippina":"tl",
        "フィリピン語":"tl",
        "ಫಿಲಿಪಿನೋ":"tl",
        "филипино":"tl",
        "필리핀 사람":"tl",
        "bi hêsanî":"tl",
        "philippinica":"tl",
        "filippinesch":"tl",
        "filipiana":"tl",
        "ഫിലിപ്പിനോ":"tl",
        "filippin":"tl",
        "इपिनियन":"tl",
        "ဖိလစ်ပိုင်":"tl",
        "इपिलियन":"tl",
        "filippinsk":"tl",
        "ଫିଲିପିନୋ":"tl",
        "افلاین":"tl",
        "فیلیلی":"tl",
        "filipiński":"tl",
        "ਓਪਿਨ":"tl",
        "filipineză":"tl",
        "филиппинский":"tl",
        "faila":"tl",
        "tlatsitsoe":"tl",
        "vakatsikirirwa":"tl",
        "فلپينو":"tl",
        "පිලිපීන":"tl",
        "imesawazishwa":"tl",
        "ஃபிலிபினோ":"tl",
        "ฟิลิปปินส์":"tl",
        "пілінг":"tl",
        "بولی":"tl",
        "philippines":"tl",
        "gqibezela":"tl",
        "פיליפּינאָ":"tl",
        "qeda":"tl",
        "finnish":"fi",
        "finlandez":"fi",
        "ፊኒሽ":"fi",
        "الفنلندية":"fi",
        "ֆիններեն":"fi",
        "fin":"fi",
        "фінскія":"fi",
        "finski":"fi",
        "фински":"fi",
        "finès":"fi",
        "chifinishi":"fi",
        "finlandese":"fi",
        "finský":"fi",
        "finsk":"fi",
        "fins":"fi",
        "finno":"fi",
        "soome keel":"fi",
        "suomalainen":"fi",
        "finlandaise":"fi",
        "finés":"fi",
        "ფინური":"fi",
        "finnisch":"fi",
        "φινλανδικός":"fi",
        "ફિનિશ":"fi",
        "pinilana":"fi",
        "פִינִית":"fi",
        "फिनिश":"fi",
        "ua tiav":"fi",
        "finn":"fi",
        "finnska":"fi",
        "finlandia":"fi",
        "フィンランド語":"fi",
        "finalis":"fi",
        "ಫಿನ್ನಿಷ್":"fi",
        "финдік":"fi",
        "បញ្ចប់":"fi",
        "핀란드어":"fi",
        "fînlandî":"fi",
        "финче":"fi",
        "ສຳ ເລັດຮູບ":"fi",
        "fennica":"fi",
        "somu":"fi",
        "suomių":"fi",
        "finnesch":"fi",
        "anarana":"sv",
        "finland":"fi",
        "ഫിന്നിഷ്":"fi",
        "finlandiż":"fi",
        "फिन्निश":"fi",
        "фин":"fi",
        "ဖင်လန်":"fi",
        "ଫିନିଶ୍ |":"fi",
        "فنلاندی":"fi",
        "fiński":"fi",
        "finlandesa":"fi",
        "ਫਿਨਿਸ਼":"fi",
        "finlandeză":"fi",
        "финский язык":"fi",
        "fionnlaineach":"fi",
        "sefinnishe":"fi",
        "chifinish":"fi",
        "فني":"fi",
        "ෆින්ලන්ත":"fi",
        "fínsky":"fi",
        "finansial":"fi",
        "kifini":"fi",
        "finska":"fi",
        "финн":"fi",
        "பின்னிஷ்":"fi",
        "ฟินแลนด์":"fi",
        "fince":"fi",
        "фінські":"fi",
        "فینیش":"fi",
        "fincha":"fi",
        "phần lan":"fi",
        "פֿיניש":"fi",
        "isi-finish":"fi",
        "frans":"fr",
        "frëngjisht":"fr",
        "ፈረንሳይኛ":"fr",
        "فرنسي":"fr",
        "ֆրանսերեն":"fr",
        "fransız dili":"fr",
        "frantziako":"fr",
        "французскі":"fr",
        "ফরাসি":"fr",
        "francuski":"fr",
        "френски":"fr",
        "francès":"fr",
        "pransiya":"fr",
        "french":"fr",
        "francese":"fr",
        "francouzština":"fr",
        "fransk":"fr",
        "franca":"fr",
        "prantsuse keeles":"fr",
        "pranses":"fr",
        "ranskan kieli":"fr",
        "français":"fr",
        "francais":"fr",
        "frânsk":"fr",
        "francés":"fr",
        "ფრანგული":"fr",
        "französisch":"fr",
        "γαλλική γλώσσα":"fr",
        "ફ્રેન્ચ":"fr",
        "franse":"fr",
        "faransa":"fr",
        "palani":"fr",
        "צָרְפָתִית":"fr",
        "फ्रेंच":"fr",
        "fabkis":"fr",
        "francia":"fr",
        "frönsku":"fr",
        "perancis":"fr",
        "fraincis":"fr",
        "フランス語":"fr",
        "ಫ್ರೆಂಚ್":"fr",
        "француз":"fr",
        "បារាំង":"fr",
        "프랑스 국민":"fr",
        "fransî":"fr",
        "франсузча":"fr",
        "ຝຣັ່ງ":"fr",
        "gallico":"fr",
        "franču valoda":"fr",
        "prancūzų kalba":"fr",
        "franséisch":"fr",
        "француски":"fr",
        "frantsay":"fr",
        "ഫ്രഞ്ച്":"fr",
        "franċiż":"fr",
        "kuikani":"fr",
        "франц":"fr",
        "ပြင်သစ်":"fr",
        "फ्रेन्च":"fr",
        "ଫ୍ରେଞ୍ଚ":"fr",
        "فرانسوي":"fr",
        "فرانسوی":"fr",
        "francesa":"fr",
        "ਫ੍ਰੈਂਚ":"fr",
        "limba franceza":"fr",
        "французский язык":"fr",
        "falani":"fr",
        "frangach":"fr",
        "chifrench":"fr",
        "فرانسي":"fr",
        "ප්\u200dරංශ":"fr",
        "francúzsky":"fr",
        "francoski":"fr",
        "faransiis":"fr",
        "kifaransa":"fr",
        "franska":"fr",
        "фаронсавӣ":"fr",
        "பிரஞ்சு":"fr",
        "ఫ్రెంచ్":"fr",
        "ฝรั่งเศส":"fr",
        "fransızca":"fr",
        "французький":"fr",
        "فرانسیسی":"fr",
        "fransuzcha":"fr",
        "người pháp":"fy",
        "ffrangeg":"fr",
        "isifrentshi":"fr",
        "פראנצויזיש":"fr",
        "faranse":"fr",
        "friese":"fy",
        "frisian":"fy",
        "ፍሪስያን":"fy",
        "الفريزية":"fy",
        "ֆրանսիական":"fy",
        "friz":"fy",
        "euskara":"eu",
        "фрызская":"fy",
        "ফ্রিসিয়":"fy",
        "frizijski":"fy",
        "фризийски":"fy",
        "frisiana":"fy",
        "wachi frisian":"fy",
        "frisianu":"fy",
        "van friesland afkomstige":"fy",
        "frisiano":"fy",
        "friisi":"fy",
        "frison":"fy",
        "ფრიზიანი":"fy",
        "γαλλική":"fy",
        "ફ્રિશિયન":"fy",
        "frisyen":"fy",
        "ʻōlani":"fy",
        "פריזית":"fy",
        "फ़्रिसियाई":"fy",
        "faus ntuj":"fy",
        "fríz":"fy",
        "frísneska":"fy",
        "frisona":"fy",
        "フリジア語":"fy",
        "фриз":"fy",
        "ហ្វាំងឡង់":"fi",
        "프리지아 어":"fy",
        "frîsî":"fy",
        "ພາສາລັດເຊຍ":"fy",
        "frisica":"fy",
        "frizieris":"fy",
        "fryzų":"fy",
        "frisesch":"fy",
        "фризијан":"fy",
        "फ्रिसियन":"fy",
        "фрисиан":"fy",
        "frisisk":"fy",
        "ଫ୍ରିଜିଆନ୍":"fy",
        "فروشي":"fy",
        "فرانسه":"fy",
        "fryzyjski":"fy",
        "frisão":"fy",
        "ਫ੍ਰੀਸੀਅਨ":"fy",
        "фризский":"fy",
        "faʻa frisian":"fy",
        "фризијски":"fy",
        "فريسيئن":"fy",
        "frízština":"fy",
        "frisio":"fy",
        "frisiska":"fy",
        "фризан":"fy",
        "ఫ్రిసియన్":"fy",
        "фризька":"fy",
        "umfulentshi":"fy",
        "galician":"gl",
        "ጋላሺያን":"gl",
        "الجاليكية":"gl",
        "պատկերասրահ":"gl",
        "qalisian":"gl",
        "галісійскі":"gl",
        "galicijski":"gl",
        "галисийски":"gl",
        "gallec":"gl",
        "wamatsenga":"gl",
        "galizianu":"gl",
        "galicijský":"gl",
        "galicisch":"gl",
        "galegoj":"gl",
        "galicia":"gl",
        "galicienne":"gl",
        "galyskysk":"gl",
        "galego":"gl",
        "გალერეა":"gl",
        "galizisch":"gl",
        "γαλικίας":"gl",
        "ગૌરવ":"gl",
        "galizyen":"gl",
        "yar galiki":"gl",
        "kalikia":"gl",
        "גליציאנית":"gl",
        "tus ua si galician":"gl",
        "galíciai":"gl",
        "galískur":"gl",
        "onye dibia":"gl",
        "galiziano":"gl",
        "ガリシア語":"gl",
        "ಗ್ಯಾಲಿಶಿಯನ್":"gl",
        "галисик":"gl",
        "អ្នកលេងហ្គីតា":"gl",
        "갈리시아어":"gl",
        "galîsyayî":"gl",
        "галицияча":"gl",
        "ນັກກາຍະສິນ":"gl",
        "gallaeca":"gl",
        "galicianas":"gl",
        "galizesch":"gl",
        "галерија":"gl",
        "ahli galeri":"gl",
        "ഗലീഷ്യൻ":"gl",
        "gallegjan":"gl",
        "tapawaru":"gl",
        "फोर्ड":"gl",
        "галисист":"gl",
        "အဝတ်အစား":"gl",
        "सेना":"gl",
        "ଗାଲିସିଆନ୍":"gl",
        "ګالیسي":"gl",
        "گالری":"gl",
        "galicyjski":"gl",
        "galega":"gl",
        "ਫੋਰਡ":"gl",
        "galiciană":"gl",
        "галисийский":"gl",
        "galicianach":"gl",
        "галицијски":"gl",
        "chigalician":"gl",
        "گاليشين ٻولي":"gl",
        "ගැලීසියානු":"gl",
        "galicij":"gl",
        "gallega":"gl",
        "tukang bégal":"gl",
        "mtaalam":"gl",
        "галик":"gl",
        "காலிசியன்":"gl",
        "กาลิเซีย":"gl",
        "galicia'ya ait":"gl",
        "галичанин":"gl",
        "جماعت":"gl",
        "galaktikalik":"gl",
        "igalofu":"gl",
        "georgian":"ka",
        "ጆርጅያን":"ka",
        "الجورجية":"ka",
        "վրացերեն":"ka",
        "грузінскі":"ka",
        "gruzijski":"ka",
        "грузински":"ka",
        "wolamulira":"ka",
        "georgianu":"ka",
        "gruzínské":"ka",
        "georgisk":"ka",
        "georgisch":"ka",
        "georgiano":"ka",
        "gruusia":"ka",
        "géorgienne":"ka",
        "georgysk":"ka",
        "xeorxiano":"ka",
        "ქართული":"ka",
        "γεωργίας":"ka",
        "શાખા":"ka",
        "jojiyanci":"ka",
        "keokia":"ka",
        "גרדיאית":"ka",
        "grúz":"ka",
        "glæsilegur":"ka",
        "asụsụ ala":"ka",
        "orang georgian":"ka",
        "georgiana":"ka",
        "ジョージア語":"ka",
        "ಜಾರ್ಜಿಯನ್":"ka",
        "георгий":"ka",
        "조르지아 주 사람":"ka",
        "gurcî":"ka",
        "грузинче":"ka",
        "pontica":"ka",
        "gruzīnu":"ka",
        "gruzinas":"ka",
        "georgesch":"ka",
        "грузиски":"ka",
        "zeorziana":"ka",
        "ahli geografi":"ka",
        "ജോർജിയൻ":"ka",
        "ġorġ":"ka",
        "सरकारी":"ka",
        "газарчин":"ka",
        "ဂျော်ဂျီယာ":"ka",
        "हवाइज":"ka",
        "ଜର୍ଜିଆ":"ka",
        "ګرجستاني":"ka",
        "گرجی":"ka",
        "gruziński":"ka",
        "ਸਰਕਾਰੀ":"ka",
        "грузинский":"ka",
        "georgianach":"ka",
        "лита":"ka",
        "chigeorgian":"ka",
        "جيارجي":"ka",
        "ජෝර්ජියානු":"ka",
        "gruzínsky":"ka",
        "joorjiyaanka":"ka",
        "georgiansk":"ka",
        "ஜார்ஜியன்":"ka",
        "จอร์เจีย":"ka",
        "gürcü":"ka",
        "грузинська":"ka",
        "محکمہ":"ka",
        "georgiyalik":"ka",
        "mũi nhọn":"ka",
        "גיאָרגי":"ka",
        "german":"de",
        "gjermanisht":"de",
        "ጀርመንኛ":"de",
        "ألمانية":"de",
        "գերմանական":"de",
        "alman":"de",
        "нямецкі":"de",
        "জার্মান":"de",
        "njemački":"de",
        "немски":"de",
        "alemany":"de",
        "wachijeremani":"de",
        "tedescu":"de",
        "němec":"de",
        "tysk":"de",
        "duitse":"de",
        "germano":"de",
        "sakslane":"de",
        "saksan kieli":"de",
        "allemande":"de",
        "dútsk":"de",
        "alemán":"de",
        "გერმანული":"de",
        "deutsche":"de",
        "γερμανός":"de",
        "જર્મન":"de",
        "jamusawa":"de",
        "alemania":"de",
        "גֶרמָנִיָת":"de",
        "जर्मन":"de",
        "német":"de",
        "þýska, þjóðverji, þýskur":"de",
        "jerman":"de",
        "gearmáinis":"de",
        "tedesca":"de",
        "ドイツ語":"de",
        "ಜರ್ಮನ್":"de",
        "неміс":"de",
        "독일 사람":"de",
        "almanî":"de",
        "немисче":"de",
        "ເຍຍລະມັນ":"de",
        "vācietis":"de",
        "vokietis":"de",
        "däitsch":"de",
        "ജർമ്മൻ":"de",
        "ġermaniż":"de",
        "āpiha":"de",
        "герман хүн":"de",
        "ဂျာမန်":"de",
        "ଜର୍ମାନ":"de",
        "آلمانی":"de",
        "niemiecki":"de",
        "alemã":"de",
        "ਜਰਮਨ":"de",
        "limba germana":"de",
        "немецкий":"de",
        "gearmailteach":"de",
        "немачки":"de",
        "jeremane":"de",
        "chijerimani":"de",
        "جرمني":"de",
        "ජර්මානු":"de",
        "nemec":"de",
        "nemško":"de",
        "alemana":"de",
        "jamani":"jw",
        "немис":"de",
        "ஜெர்மன்":"de",
        "జర్మన్":"de",
        "เยอรมัน":"de",
        "almanca":"de",
        "німецька":"de",
        "جرمن":"de",
        "گېرمان":"de",
        "nemis":"de",
        "tiếng đức":"de",
        "isijamani":"de",
        "דייַטש":"de",
        "jẹmánì":"de",
        "isijalimane":"de",
        "griekse":"el",
        "grek":"el",
        "ግሪክኛ":"el",
        "اليونانية":"el",
        "հունական":"el",
        "yunan":"el",
        "greek":"el",
        "грэчаская мова":"el",
        "গ্রিক":"el",
        "grčki":"el",
        "гръцки":"el",
        "grec":"el",
        "grey":"el",
        "mayeso":"el",
        "grecu":"el",
        "řecký":"el",
        "græsk":"el",
        "grieks":"el",
        "greka":"el",
        "kreeka keel":"el",
        "kreikkalainen":"el",
        "grecque":"el",
        "gryksk":"el",
        "grego":"el",
        "ბერძნული":"el",
        "griechisch":"el",
        "ελληνικά":"el",
        "ગ્રીક":"el",
        "grèk":"el",
        "girgiza kai":"el",
        "helene":"el",
        "יווני":"el",
        "यूनानी":"el",
        "görög":"el",
        "gríska":"el",
        "ọya":"el",
        "yunani":"el",
        "gréigis":"el",
        "greca":"el",
        "ギリシャ語":"el",
        "greja":"el",
        "ಗ್ರೀಕ್":"el",
        "грек":"el",
        "ក្រិក":"el",
        "그리스 어":"el",
        "yewnanî":"el",
        "грекче":"el",
        "ກະເຣັກ":"el",
        "graeca":"zh-CN",
        "grieķu":"el",
        "graikų kalba":"el",
        "griichesch":"el",
        "грчки":"el",
        "bahasa yunani":"el",
        "ഗ്രീക്ക്":"el",
        "grieg":"el",
        "kākariki":"el",
        "ग्रीक":"el",
        "ဂရိ":"el",
        "gresk":"el",
        "ଗ୍ରୀକ୍":"el",
        "یوناني":"el",
        "یونانی":"el",
        "grecki":"el",
        "grega":"el",
        "ਯੂਨਾਨੀ":"el",
        "greacă":"el",
        "греческий":"el",
        "grèigeach":"el",
        "tlhoko":"el",
        "chigiriki":"el",
        "يوناني":"el",
        "ග්\u200dරීක":"el",
        "grécky":"el",
        "grško":"el",
        "cirfiid":"el",
        "griega":"el",
        "héjo":"el",
        "busara":"el",
        "grekisk":"el",
        "กรีก":"el",
        "грецький":"el",
        "grekcha":"el",
        "người hy lạp":"el",
        "isigrike":"el",
        "ọfun":"el",
        "iseluleko":"el",
        "gujarati":"gu",
        "ጉጅራቲ":"gu",
        "الغوجاراتية":"gu",
        "գուարաթի":"gu",
        "гуджараці":"gu",
        "গুজরাটি":"gu",
        "гуджарати":"gu",
        "maguleta":"gu",
        "gujaratioj":"gu",
        "gujaratysk":"gu",
        "გუჯარათი":"gu",
        "γκουτζαράτι":"gu",
        "ગુજરાતી":"gu",
        "kuhalaki":"gu",
        "גוג'ראטי":"gu",
        "गुजराती":"gu",
        "gudzsaráti":"gu",
        "グジャラート語":"gu",
        "ಗುಜರಾತಿ":"gu",
        "гужарати":"gu",
        "구자라트":"gu",
        "gujaratî":"gu",
        "гужаратиче":"gu",
        "gujārati":"gu",
        "гуџарија":"gu",
        "ഗുജറാത്തി":"gu",
        "гужарат хэл":"gu",
        "ဂူဂျာတီ":"gu",
        "ଗୁଜରାଟୀ":"gu",
        "ګجراتي":"gu",
        "گواتواري":"gu",
        "gudżarati":"gu",
        "гујарати":"gu",
        "mojarati":"gu",
        "chigujarati":"gu",
        "گجراتي":"gu",
        "ගුජරාටි":"gu",
        "gijarati":"gu",
        "குஜராத்தி":"gu",
        "คุชราต":"gu",
        "گجراتی":"gu",
        "isigagu":"gu",
        "haïtiese kreol":"ht",
        "kollaj haiti":"ht",
        "ሓይቲያን ክሬኦሌ":"ht",
        "الكريولية الهايتية":"ht",
        "հաջի կրեոլ":"ht",
        "haitian creole":"ht",
        "haitiar kreolera":"ht",
        "гітара крэол":"ht",
        "হাইতিয়ান ক্রেওল":"ht",
        "китари креол":"ht",
        "crioll haitian":"ht",
        "mbiri creole":"ht",
        "creolu haitianu":"ht",
        "haitian kreole":"ht",
        "haitský kreol":"ht",
        "haiti kreolsk":"ht",
        "haïtiaanse creoolse":"ht",
        "haitian kreolo":"ht",
        "haiti kreool":"ht",
        "haitin kreoli":"ht",
        "créole haïtien":"ht",
        "haïtiaansk kreaolsk":"ht",
        "creole haitiano":"ht",
        "ჰაიტი კრეოლი":"ht",
        "haitianisches kreol":"ht",
        "αρετή κρεόλη":"ht",
        "સમાપ્ત ક્રેઓલ":"ht",
        "kreyòl ayisyen":"ht",
        "ōlelo haiki":"ht",
        "קריאולית של האיטי":"ht",
        "हैतियाई क्रेओल":"ht",
        "haiti kreol":"ht",
        "haíí creole":"ht",
        "kreol haitian":"ht",
        "creole haitian":"ht",
        "creolo haitiano":"ht",
        "ハイチのクレオール":"ht",
        "ಹೈಟಿ ಕ್ರಿಯೋಲ್":"ht",
        "гаитикалық креол":"ht",
        "creole ហៃ":"ht",
        "아이티 크리올":"ht",
        "kreoliya haîtiyî":"ht",
        "haiti kreols":"ht",
        "haičio kreolis":"ht",
        "haitescht creole":"ht",
        "хаити креол":"ht",
        "kreol haiti":"ht",
        "ഹെയ്\u200cതിയൻ ക്രിയോൾ":"ht",
        "ħallieni kreol":"ht",
        "haole":"ht",
        "क्रिड क्रिओल":"ht",
        "haitian креол":"ht",
        "ဂီတာ":"ht",
        "समापन क्रियोल":"ht",
        "haitian kreolsk":"ht",
        "ହାଟିଆ କ୍ରେଓଲ୍ |":"ht",
        "پای کریول":"ht",
        "کریول هائیتی":"ht",
        "kreolski haitański":"ht",
        "crioulo haitiano":"ht",
        "ਖਤਮ ਕਰਿਓਲ":"ht",
        "гаитянский креольский":"ht",
        "haiti kereole":"ht",
        "хаићански креол":"ht",
        "tlhokomeliso ea botumo":"ht",
        "kiriyoro yehaiti":"ht",
        "هيٽي ڪرولي":"ht",
        "හයිටි ක්\u200dරෙයෝල්":"ht",
        "igralka kreole":"ht",
        "criollo haitiano":"ht",
        "creole ya jina":"ht",
        "haitisk kreol":"ht",
        "креоли ҳайти":"ht",
        "ஹைட்டியன் கிரியோல்":"ht",
        "హైటియన్ క్రియోల్":"ht",
        "ครีโอลเฮติ":"ht",
        "haiti kreole":"ht",
        "гітара-креоль":"ht",
        "خاتمہ کریول":"ht",
        "haitian kreol":"ht",
        "bánh creole":"ht",
        "isikriyoli sasehayiti":"ht",
        "isihlonipho se -umo":"ht",
        "ሃውሳ":"ha",
        "هوسا":"ha",
        "հաուսա":"ha",
        "хаўса":"ha",
        "হাউসা":"ha",
        "хауса":"ha",
        "haŭso":"ha",
        "ჰაუსა":"ha",
        "χαζά":"ha",
        "હૌસા":"ha",
        "hauka":"ha",
        "חאוסה":"ha",
        "होउसा":"ha",
        "hausza":"ha",
        "ハウサ":"ha",
        "ಹೌಸಾ":"ha",
        "ភេសជ្ជៈa":"ha",
        "하우사":"ha",
        "хаусача":"ha",
        "haussa":"ha",
        "ഹ aus സ":"ha",
        "हौसा":"ha",
        "ဟွာ":"ha",
        "ହାଉସା":"ha",
        "هاوسا":"ha",
        "ਹਉਸਾ":"ha",
        "chihausa":"ha",
        "هوسا ٻولي":"ha",
        "හවුසා":"ha",
        "хаоса":"ha",
        "ஹ aus ஸா":"ha",
        "ہاؤسا":"ha",
        "hawaiian":"haw",
        "ሐዋያን":"haw",
        "هاواي":"haw",
        "հաավայեան":"haw",
        "həvayi":"haw",
        "oiasso":"haw",
        "гавайская":"haw",
        "হাওয়াইয়ান":"haw",
        "havajski":"haw",
        "хавайски":"haw",
        "hawaià":"haw",
        "tradisyon":"haw",
        "hawaiianu":"haw",
        "havajský":"haw",
        "hawaiiaans":"haw",
        "hawaiiano":"haw",
        "havai":"haw",
        "sining":"haw",
        "havaijilainen":"haw",
        "hawaïen":"haw",
        "hawaïaansk":"haw",
        "hawaiano":"haw",
        "ჰავაიანი":"haw",
        "hawaiisch":"haw",
        "χαβάης":"haw",
        "હવાઈ":"haw",
        "hawayi":"haw",
        "ōlelo hawaiʻi":"haw",
        "הוואי":"haw",
        "हवाई":"haw",
        "hawaii":"haw",
        "hawiian":"haw",
        "hawaiana":"haw",
        "ハワイアン":"haw",
        "ngulati":"haw",
        "ಹವಾಯಿಯನ್":"haw",
        "хауайян":"haw",
        "ហាវ៉ាយៀន":"haw",
        "하와이":"haw",
        "hawaiyî":"haw",
        "гавайча":"haw",
        "havajietiškas":"haw",
        "hawaianesch":"haw",
        "хавајски":"haw",
        "hawai":"haw",
        "ഹവായിയൻ":"haw",
        "ħawajjan":"haw",
        "maori":"mi",
        "हवाईयन":"haw",
        "хайвайн":"haw",
        "ဟာဝိုင်ယီ":"haw",
        "हवाइयन":"haw",
        "هوایی":"haw",
        "هاوایی":"haw",
        "hawajski":"haw",
        "havaiana":"haw",
        "ਹਵਾਈਅਨ":"haw",
        "hawaiană":"haw",
        "гавайский":"haw",
        "havaii":"haw",
        "hawaiianach":"haw",
        "chihawayi":"haw",
        "هوائين":"haw",
        "හවායි":"haw",
        "kasenian":"haw",
        "ҳавайӣ":"haw",
        "ஹவாய்":"haw",
        "హవాయి":"haw",
        "ฮาวาย":"haw",
        "гавайський":"haw",
        "حوثیان":"haw",
        "xayvon":"haw",
        "isihawayi":"haw",
        "האַוואַייאַן":"haw",
        "i-hawaiian":"haw",
        "hebreeus":"iw",
        "hebraik":"iw",
        "ሂብሩ":"iw",
        "اللغة العبرية":"iw",
        "եբրայերեն":"iw",
        "hebrew":"iw",
        "іўрыт":"iw",
        "হিব্রু":"iw",
        "hebrejski":"iw",
        "иврит":"iw",
        "hebreu":"iw",
        "kuzungulira":"iw",
        "ebraicu":"iw",
        "hebrejština":"iw",
        "hebraisk":"iw",
        "hebreeuws":"iw",
        "hebreo":"iw",
        "heprealainen":"iw",
        "hébreue":"iw",
        "hebrieuwsk":"iw",
        "ებრაული":"iw",
        "hebräisch":"iw",
        "εβραϊκά":"iw",
        "હેબ્રીબ":"iw",
        "ebrew":"iw",
        "hepela":"iw",
        "עִברִית":"iw",
        "यहूदी":"yi",
        "héber":"iw",
        "hebreska":"iw",
        "ibrani":"iw",
        "ebraica":"iw",
        "ヘブライ語":"iw",
        "ಹೀಬ್ರೂ":"iw",
        "еврей":"iw",
        "ហេប៊ឺរ":"iw",
        "헤브라이 사람":"iw",
        "îbranî":"iw",
        "еврейче":"iw",
        "ivrits":"iw",
        "hebrajiškai":"iw",
        "hebräesch":"iw",
        "хебрејски":"iw",
        "ഹീബ്രു":"iw",
        "हिब्रू":"iw",
        "гүү":"iw",
        "herew":"iw",
        "ହେବ୍ରୁ":"iw",
        "عبري":"iw",
        "هباتی":"iw",
        "hebrajski":"iw",
        "hebraica":"iw",
        "ਹੇਬਰਿw":"iw",
        "ebraică":"iw",
        "eperu":"iw",
        "eabhrach":"iw",
        "chihebhuru":"iw",
        "عبراني":"iw",
        "හෙබ්\u200dරෙව්":"iw",
        "hebrejčina":"iw",
        "hebrejščina":"iw",
        "hebrea":"iw",
        "kizuizi":"iw",
        "hebré":"iw",
        "губернатор":"iw",
        "హిబ్రూ":"iw",
        "ชาวอิสราเอล":"iw",
        "i̇branice":"iw",
        "іврит":"iw",
        "ہیبرو":"iw",
        "shayton":"iw",
        "isihebhere":"iw",
        "i-hebrew":"iw",
        "heebrea keeles":"iw",
        "ஹீப்ரு":"iw",
        "hindi":"hi",
        "ሂንዲ":"hi",
        "الهندية":"hi",
        "հինդի":"hi",
        "хіндзі":"hi",
        "хинди":"hi",
        "hindski":"hi",
        "hindština":"hi",
        "hindoestaansk":"hi",
        "ჰინდი":"hi",
        "χίντι":"hi",
        "હિન્દી":"hi",
        "hiniki":"hi",
        "הינדית":"hi",
        "हिन्दी":"hi",
        "ヒンディー語":"hi",
        "ora":"hi",
        "ហិណ្ឌូ":"hi",
        "힌디 어":"hi",
        "hindî":"hi",
        "хиндиче":"hi",
        "ഹിന്ദി":"hi",
        "kauaka":"hi",
        "हिंदी":"hi",
        "ဟိဒီ":"hi",
        "ହିନ୍ଦୀ":"hi",
        "هندي":"hi",
        "هندی":"hi",
        "hinduski":"hi",
        "ਹਿੰਦੀ":"hi",
        "indeach":"hi",
        "se hindi":"hi",
        "chihindi":"hi",
        "හින්දි":"hi",
        "hindčina":"hi",
        "teu":"hi",
        "இந்தி":"hi",
        "హిందీ":"hi",
        "ภาษาฮินดี":"hi",
        "hintçe":"hi",
        "хінді":"hi",
        "ہندی":"hi",
        "tiếng hin-ddi":"hi",
        "הינדיש":"hi",
        "hmong":"hmn",
        "ሕሞንግ":"hmn",
        "الهمونغ":"hmn",
        "հմոնգ":"hmn",
        "хмонг":"hmn",
        "мон":"hmn",
        "hmonged":"hmn",
        "ჰმონგი":"hmn",
        "χονγκ":"hmn",
        "mona":"hmn",
        "המונג":"hmn",
        "हमोंग":"hmn",
        "kwv tij hmoob":"hmn",
        "モン語":"hmn",
        "បងប្អូនប្រុស":"hmn",
        "몽족":"hmn",
        "hmongî":"hmn",
        "хмонгчо":"hmn",
        "ມົ້ງ":"hmn",
        "hmongi":"hmn",
        "hmongai":"hmn",
        "همونګ":"hmn",
        "هومونگ":"hmn",
        "ਹਮੰਗ":"hmn",
        "мяо":"hmn",
        "chihmong":"hmn",
        "همنگي":"hmn",
        "ม้ง":"hmn",
        "ہمونگ":"hmn",
        "hungarian":"hu",
        "hungarez":"hu",
        "ሃንጋሪያን":"hu",
        "المجري":"hu",
        "հունգարական":"hu",
        "macar":"hu",
        "венгерская":"hu",
        "mađarski":"hu",
        "унгарски":"hu",
        "hongarès":"hu",
        "ungherese":"hu",
        "madžarski":"hu",
        "maďarský":"hu",
        "ungarsk":"hu",
        "hongaars":"hu",
        "hungarian...":"hu",
        "ungarlane":"hu",
        "unkarin kieli":"hu",
        "hongroise":"hu",
        "hongaarsk":"hu",
        "húngaro":"hu",
        "უნგრული":"hu",
        "ungarisch":"hu",
        "ουγγρικός":"hu",
        "હની":"hu",
        "ongri":"hu",
        "maƙiyi":"hu",
        "hunakalia":"hu",
        "הוּנגָרִי":"hu",
        "हंगेरी":"hu",
        "neeg ntxim nyiam":"hu",
        "magyar":"hu",
        "ungverska, ungverji, ungverskt":"hu",
        "onye agu":"hu",
        "hongaria":"hu",
        "ハンガリー語":"hu",
        "ಹಂಗೇರಿಯನ್":"hu",
        "венгерлік":"hu",
        "ឃ្លាន":"hu",
        "헝가리 인":"hu",
        "macarî":"hu",
        "венгерче":"hu",
        "ຄົນຂີ້ຄ້ານ":"hu",
        "ungāru valoda":"hu",
        "vengrų":"hu",
        "ungaresch":"hu",
        "hongariana":"hu",
        "bahasa hungary":"hu",
        "ഹംഗേറിയൻ":"hu",
        "ungeriż":"hu",
        "हानी":"hu",
        "өлгий":"hu",
        "ဟန်ဂေရီယန်":"hu",
        "ଭୋକିଲା":"hu",
        "هنګري":"hu",
        "مجارستانی":"hu",
        "język węgierski":"hu",
        "húngara":"hu",
        "ਹੈਨੀਅਨ":"hu",
        "maghiară":"hu",
        "венгерский язык":"hu",
        "hungàrianach":"hu",
        "мађарски":"hu",
        "chihungarian":"hu",
        "هنگري":"hu",
        "බඩගිනි":"hu",
        "madžarsko":"hu",
        "gaajaysan":"hu",
        "ungerska":"hu",
        "венгерӣ":"hu",
        "பசி":"hu",
        "ฮังการี":"hu",
        "macarca":"hu",
        "угорський":"hu",
        "ہانی":"hu",
        "ئاچارچىلىق":"hu",
        "osilgan":"hu",
        "người hungary":"hu",
        "אונגעריש":"hu",
        "agunrin":"hu",
        "hungary":"hu",
        "icelandic":"is",
        "islandez":"is",
        "አይስላንዲ ክ":"is",
        "الآيسلندية":"is",
        "իսլանդերեն":"is",
        "ісландская":"is",
        "islandski":"is",
        "исландски":"is",
        "denunciat":"is",
        "nzeru":"is",
        "islandesu":"is",
        "islandský":"is",
        "ijslands":"is",
        "denunco":"is",
        "islandi":"is",
        "islantilainen":"is",
        "islandais":"is",
        "yslânsk":"is",
        "denunciado":"is",
        "ისლანდიელი":"is",
        "isländisch":"is",
        "ισλανδικός":"is",
        "સ્ત્રી":"is",
        "āinahau":"is",
        "איסלנדית":"is",
        "आइसलैंड का":"is",
        "izlandi":"is",
        "íslensku":"is",
        "islandia":"is",
        "íoslainnis":"is",
        "islandese":"is",
        "アイスランド語":"is",
        "ionik":"is",
        "ಐಸ್ಲ್ಯಾಂಡಿಕ್":"is",
        "ирландиялық":"is",
        "아이슬란드 어":"is",
        "îzlandî":"is",
        "исландияча":"is",
        "islandiešu":"is",
        "islandai":"is",
        "islännesch":"is",
        "ഐസ്\u200cലാൻഡിക്":"is",
        "il-kliżinjan":"is",
        "स्त्री":"is",
        "အဘိဓာန်":"is",
        "विवाह":"is",
        "islandsk":"is",
        "ଆଇସଲାଣ୍ଡିକ୍ |":"is",
        "ایلینډیک":"is",
        "ایسلندی":"is",
        "islandzki":"is",
        "islandês":"is",
        "ਕੁਮਾਰੀ":"is",
        "исландский":"is",
        "innis tìleach":"is",
        "kutloisiso":"is",
        "chiicelandic":"is",
        "آئس لينڊي":"is",
        "අයිස්ලන්ත":"is",
        "barafka":"is",
        "islandesa":"is",
        "ufahamu":"is",
        "isländsk":"is",
        "ஐஸ்லாந்து":"is",
        "ไอซ์แลนด์":"is",
        "i̇zlandaca":"is",
        "ісландський":"is",
        "شادی":"is",
        "muzlik":"is",
        "quan":"is",
        "gwlad yr iâ":"is",
        "iceland":"is",
        "איסלענדיש":"is",
        "yinyin":"is",
        "ukuzwela":"is",
        "igbo":"ig",
        "ጫካ":"ig",
        "ігба":"ig",
        "ইগ্বো":"ig",
        "игбо":"ig",
        "ઇગ્બો":"ig",
        "daji":"ig",
        "איגבו":"ig",
        "ईग्बो":"ig",
        "イボ":"ig",
        "ಇಗ್ಬೊ":"ig",
        "이 그보":"ig",
        "इग्बो":"ig",
        "ibo":"ig",
        "ਇਗਬੋ":"ig",
        "آئي بيبو":"ig",
        "baadiyaha":"ig",
        "ఇగ్బో":"ig",
        "i̇bo":"ig",
        "ігбо":"ig",
        "ایگبو":"ig",
        "indonesian":"id",
        "indonezian":"id",
        "ኢንዶኔዥያን":"id",
        "الأندونيسية":"id",
        "ինդոնեզերեն":"id",
        "indoneziyalı":"id",
        "інданезійская":"id",
        "indonezijski":"id",
        "индонезийски":"id",
        "indonèsia":"id",
        "indiano":"id",
        "indiya":"id",
        "indonesianu":"id",
        "indonéština":"id",
        "indonesisk":"id",
        "indonesisch":"id",
        "indonezia":"id",
        "indoneeslane":"id",
        "indonesialainen":"id",
        "indonésienne":"id",
        "yndonesysk":"id",
        "indonesio":"id",
        "ინდონეზიური":"id",
        "ινδονησιακά":"id",
        "ઇન્ડોનેશિયા":"id",
        "endonezyen":"id",
        "yar kasar indonesiya":"id",
        "inikonia":"id",
        "אינדונזית":"id",
        "इंडोनेशियाई":"id",
        "indonéz":"id",
        "indónesísku":"id",
        "bahasa indonesia":"id",
        "indinéisis":"id",
        "indonesiana":"id",
        "インドネシア語":"id",
        "ಇಂಡೋನೇಷಿಯನ್":"id",
        "үнділік":"id",
        "ឥណ្ឌូនេស៊ី":"id",
        "인도네시아 인":"id",
        "îndonezî":"id",
        "индонезияча":"id",
        "ອິນໂດເນເຊຍ":"id",
        "indonesiaca":"id",
        "indonēzietis":"id",
        "indonezietis":"id",
        "indonesesch":"id",
        "индонезиски":"id",
        "indonezianina":"id",
        "orang indonesia":"id",
        "ഇന്തോനേഷ്യൻ":"id",
        "indoneżjan":"id",
        "इंडोनेशियन":"id",
        "индонези":"id",
        "အင်ဒိုနီးရှား":"id",
        "इन्डोनेशियाई":"id",
        "ଇଣ୍ଡୋନେସିଆନ୍ |":"id",
        "انډونیزین":"id",
        "اندونزیایی":"id",
        "indonezyjski":"id",
        "indonésia":"id",
        "ਇੰਡੋਨੇਸ਼ੀਆ":"id",
        "indoneziana":"id",
        "индонезийский":"id",
        "and-innseach":"id",
        "индонезијски":"id",
        "index":"id",
        "chiindonesian":"id",
        "انڊونيشي":"id",
        "ඉන්දුනීසියානු":"id",
        "indonézsky":"id",
        "indonezijščina":"id",
        "indonesia":"id",
        "indema":"id",
        "indonesiska":"id",
        "индонезӣ":"id",
        "இந்தோனேசிய":"id",
        "ชาวอินโดนีเซีย":"id",
        "endonezya":"id",
        "індонезійська":"id",
        "انڈونیشیا":"id",
        "indoneziyalik":"id",
        "אינדאָנעזיש":"id",
        "ara ilu indonesian":"id",
        "isi-ind":"id",
        "irish":"ga",
        "irlandez":"ga",
        "አይሪሽ":"ga",
        "الأيرلندية":"ga",
        "իռլանդական":"ga",
        "iriş":"ga",
        "ірландская":"ga",
        "irski":"ga",
        "ирландски":"ga",
        "irlandès":"ga",
        "dziko":"ga",
        "irlandese":"ga",
        "irština":"ga",
        "iers":"ga",
        "irlandano":"ga",
        "iirlane":"ga",
        "irlantilainen":"ga",
        "irlandaise":"ga",
        "iersk":"ga",
        "irlandés":"ga",
        "ირლანდიელი":"ga",
        "irisch":"ga",
        "ιρλανδικός":"ga",
        "આઇરિશ":"ga",
        "ilandè":"ga",
        "ipelana":"ga",
        "אִירִית":"ga",
        "आयरिश":"ga",
        "ír":"ga",
        "írska":"ga",
        "orang irlandia":"ga",
        "gaeilge":"ga",
        "irlandesi":"ga",
        "アイルランド語":"ga",
        "ಐರಿಶ್":"ga",
        "ириш":"ga",
        "아일랜드의":"ga",
        "irlandî":"ga",
        "ирландча":"ga",
        "hibernica":"ga",
        "īru":"ga",
        "airių":"ga",
        "iresch":"ga",
        "ирски":"ga",
        "irlandey":"ga",
        "ഐറിഷ്":"ga",
        "irlandiż":"ga",
        "ирланд":"ga",
        "အိုင်းရစ်":"ga",
        "आयरिस":"ga",
        "irsk":"ga",
        "ایرلینډي":"ga",
        "ایرلندی":"ga",
        "irlandzki":"ga",
        "irlandesa":"ga",
        "ਆਇਰਿਸ਼":"ga",
        "ирландцы":"ga",
        "aialani":"ga",
        "èireannach":"ga",
        "naha":"ga",
        "chiirish":"ga",
        "آئرستاني":"ga",
        "අයිරිෂ්":"ga",
        "írsky":"ga",
        "basa irlandia":"ga",
        "nchi":"ga",
        "irländsk":"ga",
        "ирландӣ":"ga",
        "ஐரிஷ்":"ga",
        "ไอร์แลนด์":"ga",
        "i̇rlandalı":"ga",
        "ірландський":"ga",
        "آئرش":"ga",
        "ailen":"ga",
        "gwyddeleg":"ga",
        "איריש":"ga",
        "izwe":"ga",
        "italian":"it",
        "ጣሊያንኛ":"it",
        "إيطالي":"it",
        "իտալական":"it",
        "italyan":"it",
        "італьянскі":"it",
        "ইতালিয়ান":"it",
        "italijanski":"it",
        "италиански":"it",
        "italià":"it",
        "italya":"it",
        "chitali":"it",
        "talianu":"it",
        "talijanski":"it",
        "italština":"it",
        "italiensk":"it",
        "italiaans":"it",
        "itala":"it",
        "itaalia":"it",
        "italialainen":"it",
        "italienne":"it",
        "italiaansk":"it",
        "italiano":"it",
        "იტალიური":"it",
        "italienisch":"it",
        "ιταλικός":"it",
        "ઇટાલિયન":"it",
        "italyen":"it",
        "italiyanci":"it",
        "ikalia":"it",
        "אִיטַלְקִית":"it",
        "इतालवी":"it",
        "olasz":"it",
        "ítalska":"it",
        "italia":"it",
        "iodáilis":"it",
        "italiana":"it",
        "イタリア語":"it",
        "ಇಟಾಲಿಯನ್":"it",
        "итальяндық":"it",
        "អ៊ីតាលី":"it",
        "이탈리아 사람":"it",
        "îtalî":"it",
        "итальянча":"it",
        "ອິຕາລີ":"it",
        "itālietis":"it",
        "italų kalba":"it",
        "italienesch":"it",
        "италијански":"it",
        "itali":"it",
        "ഇറ്റാലിയൻ":"it",
        "इटालियन":"it",
        "итали":"it",
        "အီတလီ":"it",
        "ଇଟାଲୀୟ":"it",
        "ایټالیوي":"it",
        "ایتالیایی":"it",
        "ਇਤਾਲਵੀ":"it",
        "italiană":"it",
        "итальянский":"it",
        "eadailteach":"it",
        "италијан":"it",
        "setaliana":"it",
        "chiitalian":"it",
        "اطالوي":"it",
        "ඉතාලි":"it",
        "taliansky":"it",
        "итолиёвӣ":"it",
        "இத்தாலிய":"it",
        "ఇటాలియన్":"it",
        "อิตาลี":"it",
        "i̇talyan":"it",
        "італійський":"it",
        "اطالوی":"it",
        "italiyalik":"it",
        "người ý":"it",
        "isitaliyani":"it",
        "איטאַליעניש":"it",
        "e-italy":"it",
        "japanese":"ja",
        "japonez":"ja",
        "ጃፓንኛ":"ja",
        "اليابانية":"ja",
        "ճապոնական":"ja",
        "yapon":"ja",
        "японскі":"ja",
        "জাপানি":"ja",
        "japanski":"ja",
        "японски":"ja",
        "japonès":"ja",
        "phokoso":"ja",
        "ghjappunese":"ja",
        "japonský":"ja",
        "japansk":"ja",
        "japans":"ja",
        "japana":"ja",
        "jaapani":"ja",
        "japanilainen":"ja",
        "japonaise":"ja",
        "xaponés":"ja",
        "იაპონელი":"ja",
        "japanisch":"ja",
        "ιαπωνικά":"ja",
        "જાપાની":"ja",
        "japonè":"ja",
        "japanisanci":"ja",
        "kepanī":"ja",
        "יַפָּנִית":"ja",
        "जापानी":"ja",
        "puskawg":"ja",
        "japán":"ja",
        "japönsku":"ja",
        "jepang":"ja",
        "seapánach":"ja",
        "giapponese":"ja",
        "日本語":"ja",
        "ಜಪಾನೀಸ್":"ja",
        "ជនជាតិជប៉ុន":"ja",
        "일본어":"ja",
        "japonî":"ja",
        "жапончо":"ja",
        "ຍີ່ປຸ່ນ":"ja",
        "iaponica":"ja",
        "japāņu":"ja",
        "japonų":"ja",
        "japanesch":"ja",
        "јапонски":"ja",
        "jepun":"ja",
        "ജാപ്പനീസ്":"ja",
        "ġappuniż":"ja",
        "जपानी":"ja",
        "япон":"ja",
        "ဂျပန်":"ja",
        "ଜାପାନୀ":"ja",
        "جاپاني":"ja",
        "ژاپنی":"ja",
        "język japoński":"ja",
        "japonesa":"ja",
        "ਜਪਾਨੀ":"ja",
        "японский язык":"ja",
        "iapani":"ja",
        "iapanach":"ja",
        "јапански":"ja",
        "chijapanese":"ja",
        "ජපන්":"ja",
        "japonski":"ja",
        "kijapani":"ja",
        "японй":"ja",
        "ஜப்பானிய":"ja",
        "ญี่ปุ่น":"ja",
        "japonca":"ja",
        "японці":"ja",
        "جاپانی":"ja",
        "tiếng nhật":"ja",
        "japan":"ja",
        "isijaphani":"ja",
        "יאַפּאַניש":"ja",
        "ede japan":"ja",
        "ijaphane":"ja",
        "javaanse":"jw",
        "javanese":"jw",
        "ጃቫኒስ":"jw",
        "الجاوية":"jw",
        "yava":"jw",
        "javera":"jw",
        "яванскі":"jw",
        "জাভানি":"jw",
        "javanski":"jw",
        "явански":"jw",
        "javanès":"jw",
        "giavanese":"jw",
        "javanesisk":"jw",
        "javaans":"jw",
        "javananoj":"jw",
        "jaava":"jw",
        "jaavalainen":"jw",
        "javanais":"jw",
        "javaansk":"jw",
        "xavanés":"jw",
        "ჯავანური":"jw",
        "javanisch":"jw",
        "ιάβας":"jw",
        "જાવાની":"jw",
        "javèn":"jw",
        "kawanī":"jw",
        "ג'וואן":"jw",
        "जावानीस":"jw",
        "jávai":"jw",
        "javanska":"jw",
        "jawa":"jw",
        "iávais":"jw",
        "ジャワ語":"jw",
        "wong jawi":"jw",
        "ಜಾವಾನೀಸ್":"jw",
        "ចាវ៉ាន់":"jw",
        "자바어":"jw",
        "javanesî":"jw",
        "жанавизче":"jw",
        "iavanica":"jw",
        "javāns":"jw",
        "javai":"jw",
        "javanesesch":"jw",
        "јаванец":"jw",
        "javaney":"jw",
        "orang jawa":"jw",
        "ജാവനീസ്":"jw",
        "ġavaniż":"jw",
        "жава":"jw",
        "ဂျာဗား":"jw",
        "जाभानीज":"jw",
        "ଯବାନ":"jw",
        "جاوه ای":"jw",
        "ژوانی":"jw",
        "jawajski":"jw",
        "javanesa":"jw",
        "ਜਾਵਨੀਜ਼":"jw",
        "javaneză":"jw",
        "яванский":"jw",
        "iabhaininnseach":"jw",
        "јаванесе":"jw",
        "chijavanese":"jw",
        "جاواني":"jw",
        "jávsky":"jw",
        "javanščina":"jw",
        "чавони":"jw",
        "ஜாவானீஸ்":"jw",
        "జావానెసె":"jw",
        "ชาวชวา":"jw",
        "cava":"jw",
        "яванський":"jw",
        "جاویانی":"jw",
        "java":"jw",
        "jafanese":"jw",
        "ede javanese":"jw",
        "isijavane":"jw",
        "kannada":"kn",
        "ካናዳ":"kn",
        "الكانادا":"kn",
        "կաննադա":"kn",
        "каннада":"kn",
        "কন্নড":"kn",
        "канада":"kn",
        "კანადა":"kn",
        "κανάντα":"kn",
        "કન્નડ":"kn",
        "kanākā":"kn",
        "קנאדה":"kn",
        "कन्नड़":"kn",
        "cannadais":"kn",
        "カンナダ語":"kn",
        "ಕನ್ನಡ":"kn",
        "កន្នដា":"kn",
        "칸나다어":"kn",
        "kanadayî":"kn",
        "каннадача":"kn",
        "ການາດາ":"kn",
        "duis egestas elementum risus":"kn",
        "കന്നഡ":"kn",
        "कन्नड":"kn",
        "ကန္တာရ":"kn",
        "कन्नडा":"kn",
        "କାନ୍ନାଡା |":"kn",
        "کناډا":"kn",
        "کانادایی":"kn",
        "chikannada":"kn",
        "ڪنادي":"kn",
        "කන්නඩ":"kn",
        "ดา":"kn",
        "کناڈا":"kn",
        "kazakh":"kk",
        "ካዛክሀ":"kk",
        "الكازاخ":"kk",
        "ղազախ":"kk",
        "qazax":"kk",
        "казах":"kk",
        "কাজাখ":"kk",
        "казахски":"kk",
        "kazak":"kk",
        "kazach":"kk",
        "kasakhisk":"kk",
        "kazachs":"kk",
        "kasahh":"kk",
        "kazakstanin":"kk",
        "kazakhe":"kk",
        "kazachsk":"kk",
        "ყაზახი":"kk",
        "καζακ":"kk",
        "કાઝાખ":"kk",
        "ōlelo kazaka":"kk",
        "קזאח":"kk",
        "कजाख":"kk",
        "kazah":"kk",
        "カザフ":"kk",
        "ಕ kazakh ಕ್":"kk",
        "қазақ":"kk",
        "카자흐어":"kk",
        "qazakî":"kk",
        "казакча":"kk",
        "kazahs":"kk",
        "kazakas":"kk",
        "kasachesch":"kk",
        "കസാഖ്":"kk",
        "काझाख":"kk",
        "ကချင်":"kk",
        "काजाख":"kk",
        "କାଜାକ୍":"kk",
        "قزاقي":"kk",
        "قزاقی":"kk",
        "kazachski":"kk",
        "cazaque":"kk",
        "ਕਾਜ਼ਾਖ":"kk",
        "kazahă":"kk",
        "kasaka":"kk",
        "kasakh":"kk",
        "казакх":"kk",
        "kazaki":"kk",
        "قازق":"kk",
        "කසක":"kk",
        "kazašský":"kk",
        "казок":"kk",
        "கசாக்":"kk",
        "కజఖ్":"kk",
        "คาซัคสถาน":"kk",
        "کازاخ":"kk",
        "qozoq":"kk",
        "isikazakh":"kk",
        "khmer":"km",
        "ክመር":"km",
        "الخمير":"km",
        "խմեր":"km",
        "xmer":"km",
        "кхмер":"km",
        "খেমের":"km",
        "червените":"km",
        "crvenih":"km",
        "khmeeri":"km",
        "ხამერი":"km",
        "χμερ":"km",
        "ખ્મેર":"km",
        "חמר":"km",
        "खमेर":"km",
        "kwv":"km",
        "クメール":"km",
        "ಖಮೇರ್":"km",
        "크메르":"km",
        "кечки":"km",
        "ລາວ":"lo",
        "khmeru":"km",
        "khmerų":"km",
        "кмер":"km",
        "ഖെമർ":"km",
        "ख्मेर":"km",
        "کمر":"km",
        "خمر":"km",
        "ਖਮੇਰ":"km",
        "khmeră":"km",
        "кхмерский":"km",
        "خميسو":"km",
        "ඛමර්":"km",
        "ఖ్మేర్":"km",
        "ขอม":"km",
        "خمیر":"km",
        "kxmer":"km",
        "kmer":"km",
        "korean":"ko",
        "ኮሪያኛ":"ko",
        "الكورية":"ko",
        "կորեերեն":"ko",
        "koreya":"ko",
        "карэйская":"ko",
        "কোরিয়ান":"ko",
        "korejski":"ko",
        "корейски":"ko",
        "coreà":"ko",
        "mga koreano":"ko",
        "koresi":"ko",
        "coreanu":"ko",
        "korejština":"ko",
        "koreansk":"ko",
        "koreaans":"ko",
        "korea":"ko",
        "korea keel":"ko",
        "korealainen":"ko",
        "coréen":"ko",
        "koreaansk":"ko",
        "coreano":"ko",
        "კორეული":"ko",
        "koreanisch":"ko",
        "κορεάτης":"ko",
        "કોરિયન":"ko",
        "koreyen an":"ko",
        "kolea":"ko",
        "קוריאנית":"ko",
        "कोरियाई":"ko",
        "koreai":"ko",
        "kóreska":"ko",
        "cóiréis":"ko",
        "coreana":"ko",
        "韓国語":"ko",
        "ಕೊರಿಯನ್":"ko",
        "корей":"ko",
        "កូរ៉េ":"ko",
        "한국어":"ko",
        "koreyî":"ko",
        "корейче":"ko",
        "ເກົາຫຼີ":"ko",
        "coreanica":"ko",
        "korejiešu":"ko",
        "korėjiečių":"ko",
        "koreanesch":"ko",
        "корејски":"ko",
        "koreana":"ko",
        "orang korea":"ko",
        "കൊറിയൻ":"ko",
        "koreani":"ko",
        "कोरियन":"ko",
        "солонгос":"ko",
        "ကိုရီးယား":"ko",
        "कोरियाली":"ko",
        "କୋରିଆନ୍":"ko",
        "کوریایی":"ko",
        "koreański":"ko",
        "coreana...":"ko",
        "coreeană":"ko",
        "корейский язык":"ko",
        "corèanach":"ko",
        "chikorean":"ko",
        "ڪورين":"ko",
        "කොරියානු":"ko",
        "kórejský":"ko",
        "kikorea":"ko",
        "koreanska":"ko",
        "корея":"ko",
        "கொரியன்":"ko",
        "เกาหลี":"ko",
        "koreli":"ko",
        "корейський":"ko",
        "کورین":"ko",
        "koreys":"ko",
        "hàn quốc":"ko",
        "corea":"ko",
        "קאָרעיִש":"ko",
        "arabinrin":"so",
        "isikorea":"ko",
        "koerdies (kurmanji)":"ku",
        "kurdish (kurmanji)":"ku",
        "ኩርዲሽ (ኩርማንጂ)":"ku",
        "الكردية (kurmanji)":"ku",
        "քրդերեն (kurmanji)":"ku",
        "kürd (kurmanji)":"ku",
        "курдскі (курманджы)":"ku",
        "কুর্দিশ (কুরমানজি)":"ku",
        "kurdski (kurmanji)":"ku",
        "курдски (курманджи)":"ku",
        "kurdština (kurmanji)":"ku",
        "kurdisk (kurmanji)":"ku",
        "koerdisch (kurmanji)":"ku",
        "kurdi (kurmanji)":"ku",
        "kurde (kurmanji)":"ku",
        "ქურთული (kurmanji)":"ku",
        "kurdisch (kurmanji)":"ku",
        "κουρδικά (kurmanji)":"ku",
        "કુર્દિશ (કુર્મનજી)":"ku",
        "ʻilikai (kurmanji)":"ku",
        "כורדית (kurmanji)":"ku",
        "कुरदीश (कुरमानजी)":"ku",
        "kurd (kurmanji)":"ku",
        "kúrdískt (kurmanji)":"ku",
        "coirdis (kurmanji)":"ku",
        "クルド語（クルマンジー）":"ku",
        "ಕುರ್ದಿಶ್ (ಕುರ್ಮನ್ಜಿ)":"ku",
        "күрд (курманжи)":"ku",
        "쿠르드어 (kurmanji)":"ku",
        "курдиш":"ku",
        "lingua kurdica (kurmanji)":"ku",
        "kurdu (kurmanji)":"ku",
        "kurdas (kurmanji)":"ku",
        "kurdesch (kurmanji)":"ku",
        "курдски (kurmanji)":"ku",
        "sokajin-teny":"ku",
        "കുർദിഷ് (കുർമാൻജി)":"ku",
        "कुर्दिश (कुरमानजी)":"ku",
        "курд (курманжи)":"ku",
        "କୁର୍ଡିସ୍ (କୁରମାନଜୀ)":"ku",
        "کرديش (کرمانجي)":"ku",
        "کردی (kurmanji)":"ku",
        "kurdyjski (kurmanji)":"ku",
        "curdo (kurmanji)":"ku",
        "ਕੁਰਦੀਸ਼ (ਕੁਰਮਨਜੀ)":"ku",
        "курдиш (курманджи)":"ku",
        "курдски (курмањи)":"ku",
        "ڪرديش (ڪرمانجي)":"ku",
        "කුර්දි (කුර්මන්ජි)":"ku",
        "kurdsky (kurmanji)":"ku",
        "kurdo (kurmanji)":"ku",
        "kurudisha (kurmanji)":"ku",
        "kurdiska (kurmanji)":"ku",
        "курдӣ (курмани)":"ku",
        "குர்திஷ் (குர்மன்ஜி)":"ku",
        "కుర్దిష్ (కుర్మంజీ)":"ku",
        "ดิช (kurmanji)":"ku",
        "kürtçe (kurmanci)":"ku",
        "курдський (курманджі)":"ku",
        "کردش (کرمانجی)":"ku",
        "kurdcha (kurmanji)":"ku",
        "người kurd (kurmanji)":"ku",
        "cwrdeg (kurmanji)":"ku",
        "קורדיש (kurmanji)":"ku",
        "kirgisies":"ky",
        "kyrgyz":"ky",
        "ክይርግያዝ":"ky",
        "قيرغيزستان":"ky",
        "քիրգզ":"ky",
        "qırğız":"ky",
        "kirgizera":"ky",
        "кіргіз":"ky",
        "কির্গিজ":"ky",
        "киргизстан":"ky",
        "kirguiz":"ky",
        "miliri":"ky",
        "kirgistanu":"ky",
        "kirgisisk":"ky",
        "kirgizië":"ky",
        "kirgizo":"ky",
        "kirgiisi":"ky",
        "kirgisian":"ky",
        "kirghize":"ky",
        "kirgizysk":"ky",
        "ყირგიზი":"ky",
        "kirgisisch":"ky",
        "κιργιζία":"ky",
        "કિર્ગિઝ":"ky",
        "ōlelo kyrgyz":"ky",
        "קירגיז":"ky",
        "किरगिज़":"ky",
        "kirgiz":"ky",
        "kerabat":"ky",
        "キルギス":"ky",
        "ಕಿರ್ಗಿಜ್":"ky",
        "қырғыз":"ky",
        "키르기스":"ky",
        "qirgizî":"ky",
        "кыргызча":"ky",
        "lingua kirgistana":"ky",
        "kirgīzu":"ky",
        "kirgizas":"ky",
        "kirgisesch":"ky",
        "киргиз":"ky",
        "കിർഗിസ്":"ky",
        "kirgiż":"ky",
        "किर्गिझ":"ky",
        "किर्गिज":"ky",
        "kirgisistan":"ky",
        "କିର୍ଗିଜ୍":"ky",
        "قرغیزي":"ky",
        "کیرگیز":"ky",
        "kirgiski":"ky",
        "quirguiz":"ky",
        "ਕਿਰਗੀਜ਼":"ky",
        "kârgâză":"ky",
        "киргизский":"ky",
        "kirikisi":"ky",
        "kiyagizi":"ky",
        "ڪرغيز":"ky",
        "කිර්ගිස්":"ky",
        "kirgizská":"ky",
        "kirgizi":"ky",
        "kirguisa":"ky",
        "қирғиз":"ky",
        "கிர்கிஸ்":"ky",
        "కిర్గిజ్":"ky",
        "คีร์กีซ":"ky",
        "kırgız":"ky",
        "کرغیز":"ky",
        "قىرغىز":"ky",
        "qirg'iz":"ky",
        "kyrangu":"ky",
        "isikyrgyz":"ky",
        "lao":"lo",
        "ላኦ":"lo",
        "لاو":"lo",
        "լաո":"lo",
        "лаос":"lo",
        "লাও":"lo",
        "лао":"lo",
        "laotjaansk":"lo",
        "ლაო":"lo",
        "λάο":"lo",
        "લાઓ":"lo",
        "ōlelo laosa":"lo",
        "לאו":"lo",
        "लाओ":"lo",
        "laó":"lo",
        "ラオス":"lo",
        "ಲಾವೊ":"lo",
        "ឡាវ":"lo",
        "라오 어":"lo",
        "laoyî":"lo",
        "лаочо":"lo",
        "laomedonteae":"lo",
        "laosas":"lo",
        "laotesch":"lo",
        "ലാവോ":"lo",
        "လာအို":"lo",
        "ଲାଓ":"lo",
        "لائو":"lo",
        "ਲਾਓ":"lo",
        "layo":"lo",
        "ලාඕ":"lo",
        "laoški":"lo",
        "laos":"lo",
        "லாவோ":"lo",
        "లావో":"lo",
        "ลาว":"lo",
        "لاؤ":"lo",
        "isilawo":"lo",
        "i-lao":"lo",
        "latin":"la",
        "ላቲን":"la",
        "اللاتينية":"la",
        "լատիներեն":"la",
        "latın":"la",
        "латынь":"la",
        "ল্যাটিন":"la",
        "latinica":"la",
        "латински":"la",
        "llatí":"la",
        "latini":"la",
        "latinu":"la",
        "latinski":"la",
        "latinský":"la",
        "latijns":"la",
        "latina":"la",
        "ladina keeles":"la",
        "latine":"la",
        "latyn":"la",
        "latín":"la",
        "ლათინური":"la",
        "latein":"la",
        "λατινικά":"la",
        "લેટિન":"la",
        "ōlelo lākni":"la",
        "לָטִינִית":"la",
        "लैटिन":"la",
        "latína":"la",
        "laidin":"la",
        "ラテン":"la",
        "ಲ್ಯಾಟಿನ್":"la",
        "латын":"la",
        "ឡាតាំង":"la",
        "라틴":"la",
        "latînî":"la",
        "латынча":"la",
        "ລາຕິນ":"la",
        "latīņu":"la",
        "lotyniškas":"la",
        "laténgesch":"la",
        "bahasa latin":"la",
        "ലാറ്റിൻ":"la",
        "लॅटिन":"la",
        "латин":"la",
        "လက်တင်":"la",
        "ल्याटिन":"la",
        "ଲାଟିନ୍":"la",
        "لاتین":"la",
        "łacina":"la",
        "latim":"la",
        "ਲਾਤੀਨੀ":"la",
        "латинский":"la",
        "laidinn":"la",
        "ratini":"la",
        "لاطيني":"la",
        "ලතින්":"la",
        "latinčina":"la",
        "latinščina":"la",
        "лотинӣ":"la",
        "லத்தீன்":"la",
        "లాటిన్":"la",
        "ละติน":"la",
        "latince":"la",
        "латинь":"la",
        "لاطینی":"la",
        "lotin":"la",
        "lladin":"la",
        "isilatini":"la",
        "לאַטייַן":"la",
        "latari":"la",
        "i-latin":"la",
        "latvian":"lv",
        "letonisht":"lv",
        "ላትቪያን":"lv",
        "اللاتفية":"lv",
        "լատ":"lv",
        "latviyalı":"lv",
        "адмяніць":"lv",
        "odbiti":"lv",
        "латвийски":"lv",
        "llet":"lv",
        "lettone":"lv",
        "lotyšský":"lv",
        "lettisk":"lv",
        "lets":"lv",
        "latuno":"lv",
        "lätlane":"lv",
        "latvialainen":"lv",
        "letton":"lv",
        "letsk":"lv",
        "letón":"lv",
        "ლატ":"lv",
        "lettisch":"lv",
        "λετονικά":"lv",
        "આંખ":"lv",
        "letoni":"lv",
        "lakiwiana":"lv",
        "לטבית":"lv",
        "lett":"lv",
        "lettneska":"lv",
        "latvia":"lv",
        "ラトビア語":"lv",
        "ಲಟ್ವಿಯನ್":"lv",
        "латвиялық":"lv",
        "라트비아 사람":"lv",
        "letonî":"lv",
        "латвияча":"lv",
        "latvijas":"lv",
        "latvis":"lv",
        "lettesch":"lv",
        "лат":"lv",
        "zavatra tsy":"lv",
        "bahasa latvia":"lv",
        "ലാത്വിയൻ":"lv",
        "ara":"lv",
        "डोळा":"lv",
        "латви":"lv",
        "आँखा":"lv",
        "latvisk":"lv",
        "ଲାଟଭିଆନ୍":"lv",
        "لیتوین":"lv",
        "لتونی":"lv",
        "łotewski":"lv",
        "letã":"lv",
        "ਅੱਖ":"lv",
        "letonă":"lv",
        "латышский":"lv",
        "latbhianach":"lv",
        "латвиан":"lv",
        "chilatvian":"lv",
        "لاتوين ٻولي":"lv",
        "ලැට්වියානු":"lv",
        "upadati":"lv",
        "letona":"lv",
        "латвия":"lv",
        "லாட்வியன்":"lv",
        "ลัตเวีย":"lv",
        "letonyalı":"lv",
        "скоромовка":"lv",
        "پیاری":"lv",
        "latviyalik":"lv",
        "let":"lv",
        "isi-latvian":"lv",
        "lithuanian":"lt",
        "lituanez":"lt",
        "ሊቱኒያን":"lt",
        "اللتوانية":"lt",
        "հնարավոր":"lt",
        "litvalı":"lt",
        "літоўскі":"lt",
        "litvanski":"lt",
        "литовски":"lt",
        "indiscutible":"lt",
        "littuanianu":"lt",
        "litevský":"lt",
        "litauisk":"lt",
        "litouws":"lt",
        "leedulane":"lt",
        "liettualainen":"lt",
        "lituanienne":"lt",
        "litousk":"lt",
        "indio":"lt",
        "შესაძლებელია":"lt",
        "litauisch":"lt",
        "λιθουανικά":"lt",
        "રમત":"lt",
        "lityanyen":"lt",
        "lithuaniyanci":"lt",
        "ōlelo lituania":"lt",
        "ליטאית":"lt",
        "litván":"lt",
        "litháen":"lt",
        "lithuania":"lt",
        "lituana":"lt",
        "リトアニア語":"lt",
        "ljurian":"lt",
        "ಲಿಥುವೇನಿಯನ್":"lt",
        "литвалық":"lt",
        "លីចូយាន":"lt",
        "리투아니아 사람":"lt",
        "lîtvanyayî":"lt",
        "литвача":"lt",
        "lietuviete":"lt",
        "lietuvis":"lt",
        "litauesch":"lt",
        "можна":"lt",
        "litoanianina":"lt",
        "bahasa lithuania":"lt",
        "ലിത്വാനിയൻ":"lt",
        "indika":"lt",
        "खेळ":"mt",
        "литвийн":"lt",
        "လစ်သူ":"lt",
        "खेलौना":"lt",
        "ଲିଥୁଆନିଆ":"lt",
        "لیتوانیایی":"lt",
        "توانا":"lt",
        "litewski":"lt",
        "ਖੇਡ":"lt",
        "lituanian":"lt",
        "литовский":"lt",
        "lituaniana":"lt",
        "lithuanianach":"lt",
        "литвански":"lt",
        "ritunia":"lt",
        "ليٿونيائي":"lt",
        "ලිතුවේනියානු":"lt",
        "litovský":"lt",
        "litovska":"lt",
        "лётчикхо":"lt",
        "லிதுவேனியன்":"lt",
        "ภาษาลิธัวเนีย":"lt",
        "litvanyalı":"lt",
        "литовський":"lt",
        "کھیل":"mt",
        "litvalik":"lt",
        "áo choàng":"lt",
        "isilithuwaniya":"lt",
        "ליטוויש":"lt",
        "isi-lithuanian":"lt",
        "luxemburgs":"lb",
        "luksemburgase":"lb",
        "ሉክዜምብርጊሽ":"lb",
        "لوكسمبورج":"lb",
        "շքեղ":"lb",
        "lüks":"lb",
        "luxenburgera":"lb",
        "люксембургскі":"lb",
        "লুক্সেমবার্গীয়":"lb",
        "luksemburški":"lb",
        "люксембургски":"lb",
        "luxemburguès":"lb",
        "maluho":"lb",
        "zapembourgish":"lb",
        "lussemburghese":"lb",
        "lucembursky":"lb",
        "luxembourgsk":"lb",
        "luxembourgish":"lb",
        "luksaĵo":"lb",
        "luksemburglik":"lb",
        "luxemburg":"lb",
        "luxembourgeois":"lb",
        "lúksemboarchsk":"lb",
        "luxemburgo":"lb",
        "ლუქსემბურგული":"lb",
        "luxemburgisch":"lb",
        "λουξεμβούργο":"lb",
        "લક્ઝમ્બર્ગીશ":"lb",
        "kayan kwalliya":"lb",
        "ōlelo lukemapuka":"lb",
        "לוקסמבורגית":"lb",
        "लक्जमबर्गिश":"lb",
        "nplua nuj":"lb",
        "luxemburgi":"lb",
        "lúxemborgar":"lb",
        "okomoko":"lb",
        "ルクセンブルク語":"lb",
        "ಲಕ್ಸೆಂಬರ್ಗ್":"lb",
        "люкс":"lb",
        "លុចសំបួរ":"lb",
        "룩셈부르크":"lb",
        "luksembûrgî":"lb",
        "люксембургча":"lb",
        "luksemburgietis":"lb",
        "prabangus":"lb",
        "lëtzebuergesch":"lb",
        "луксемкинец":"lb",
        "mewah":"lb",
        "ലക്സംബർഗ്":"lb",
        "लक्झंबर्गिश":"lb",
        "дээд зэрэглэлийн":"lb",
        "လူဇင်ဘတ်":"lb",
        "लक्जम्बर्गिश":"lb",
        "ବିଳାସପୂର୍ଣ୍ଣ":"lb",
        "لوګزامبورګي":"lb",
        "لوکزامبورگ":"lb",
        "luksemburski":"lb",
        "luxemburguês":"lb",
        "ਲਗਜ਼ਬਰਗ":"lb",
        "luxemburgheză":"lb",
        "люксембургский":"lb",
        "lusemipoukisi":"lb",
        "luxembourgach":"lb",
        "луксембуршки":"lb",
        "rukusembogi":"lb",
        "لڪسمبرگي":"lb",
        "luxemburský":"lb",
        "luxemburguesa":"lb",
        "méwah":"lb",
        "kifahari":"lb",
        "லக்ஸம்பர்க்":"lb",
        "లుక్సంబర్గిష్":"lb",
        "ลักเซมเบิร์ก":"lb",
        "lüksemburg'un":"lb",
        "люксембурзький":"lb",
        "لکسبورگش":"lb",
        "ھەشەمەتلىك":"lb",
        "hashamatli":"lb",
        "xa xỉ":"lb",
        "moethus":"lb",
        "isiluksembogu":"lb",
        "לוקסעמבאָורגיש":"lb",
        "adunrere":"lb",
        "i-luxembourgish":"lb",
        "macedonian":"mk",
        "maqedonas":"mk",
        "ማስዶንያን":"mk",
        "المقدونية":"mk",
        "մակեդոնական":"mk",
        "makedoniyalı":"mk",
        "македонская":"mk",
        "makedonski":"mk",
        "македонски":"mk",
        "instal·lada":"mk",
        "macedonia":"mk",
        "macedone":"mk",
        "macedonský":"mk",
        "makedonsk":"mk",
        "macedonisch":"mk",
        "macedonian...":"mk",
        "makedoonia":"mk",
        "macédonien":"mk",
        "masedoanysk":"mk",
        "instalado":"mk",
        "მაკედონიური":"mk",
        "mazedonisch":"mk",
        "μακεδόνας":"mk",
        "બરફ":"mk",
        "mèkredi":"mk",
        "makekoni":"mk",
        "מקדונית":"mk",
        "macedóniai":"mk",
        "makedónska":"mk",
        "onye macedonian":"mk",
        "makedonia":"mk",
        "マケドニアの":"mk",
        "ಮ್ಯಾಸಿಡೋನಿಯನ್":"mk",
        "македониялық":"mk",
        "마케도니아 어":"mk",
        "makedonî":"mk",
        "македонияча":"mk",
        "macedonica":"mk",
        "maķedonietis":"mk",
        "makedonietis":"mk",
        "mazedonesch":"mk",
        "masedoniana":"mk",
        "മാസിഡോണിയൻ":"mk",
        "magħżul":"mk",
        "बर्फ":"mk",
        "македони":"mk",
        "မက်ဒို":"mk",
        "ମାକେଡୋନିଆନ୍ |":"mk",
        "مقدوني":"mk",
        "مقدونی":"mk",
        "macedoński":"mk",
        "macedônia":"mk",
        "ਬਰਫ":"mk",
        "macedonean":"mk",
        "македонский":"mk",
        "macedonianach":"mk",
        "chimacedonian":"mk",
        "මැසිඩෝනියානු":"mk",
        "macedónio":"mk",
        "makedonska":"mk",
        "македонй":"mk",
        "มาซิโดเนีย":"mk",
        "makedonya":"mk",
        "македонський":"mk",
        "برف":"mk",
        "makedoniyalik":"mk",
        "nhà hát":"mk",
        "macedonaidd":"mk",
        "mecedonian":"mk",
        "מאַקעדאָניש":"mk",
        "madagaskar":"mg",
        "malagasy":"mg",
        "مدغشقر":"mg",
        "մալագասերեն":"mg",
        "малагасійскі":"mg",
        "মালাগাসি":"mg",
        "malagaški":"mg",
        "мадагаскарски":"mg",
        "zodandaula":"mg",
        "malaga":"mg",
        "malagasi":"mg",
        "madagaskars":"mg",
        "malgaza":"mg",
        "malagaasia":"mg",
        "madagaskarin":"mg",
        "malgache":"mg",
        "malgaxe":"mg",
        "მალაგური":"mg",
        "madagassisch":"mg",
        "δυστυχία":"mg",
        "મલાગસી":"mg",
        "hawaiʻi":"mg",
        "मालागासी":"mg",
        "malntx":"mg",
        "madagaszkári":"mg",
        "malgascia":"mg",
        "マダガスカル":"mg",
        "ಮಲಗಾಸಿ":"mg",
        "малагаси":"mg",
        "សាហាវ":"mg",
        "마다가스카르 사람":"mg",
        "malavanî":"mg",
        "ມະໂຫ":"mg",
        "madagascar":"myanmar",
        "negalavimas":"mg",
        "малгашки":"mg",
        "മലഗാസി":"mg",
        "malagażi":"mg",
        "ငှက်ဖျား":"mg",
        "gassisk":"mg",
        "ମାଲାଗାସୀ |":"mg",
        "ملاګاسي":"mg",
        "مالاوگا":"mg",
        "malgaski":"mg",
        "ਮਲਗਾਸੀ":"mg",
        "malgașă":"mg",
        "малагасиец":"mg",
        "malaia":"ms",
        "малагашки":"mg",
        "خرابي":"mg",
        "අක්\u200dරමිකතාව":"mg",
        "madagaskaru":"mg",
        "malagaščina":"mg",
        "madagascarí":"mg",
        "balaa":"mg",
        "малагасия":"mg",
        "மலகாஸி":"mg",
        "మాలాగసి":"mg",
        "มาดากัสการ์":"mg",
        "madagaskarlı":"mg",
        "малагасійський":"mg",
        "ملاگاسی":"mg",
        "imalagasy":"mg",
        "מאַלאַגאַסי":"mg",
        "malay":"ms",
        "malajas":"ms",
        "ማላይ":"ms",
        "لغة الملايو":"ms",
        "մալայերեն":"ms",
        "малая":"ms",
        "малайски":"ms",
        "malai":"ms",
        "maldito":"ms",
        "malese":"ms",
        "malajski":"ms",
        "mrzutý":"ms",
        "maleis":"ms",
        "malaja":"ms",
        "malaiji":"ms",
        "malaise":"ms",
        "maleisk":"ms",
        "malayo":"ms",
        "მალაიზი":"ms",
        "malaiisch":"ms",
        "μαλάι":"ms",
        "મલય":"ms",
        "mālei":"ms",
        "מלזית":"ms",
        "मलय":"ms",
        "maláj":"ms",
        "melayu":"ms",
        "athnuachana":"ms",
        "マレー語":"ms",
        "wong lanang":"ms",
        "ಮಲಯ":"ms",
        "малай":"ms",
        "말레이 사람":"ms",
        "malayî":"ms",
        "малайча":"ms",
        "ມະຫິມະ":"ms",
        "malaeorum":"ms",
        "malajietis":"ms",
        "malajų":"ms",
        "malaiesch":"ms",
        "малајски":"ms",
        "മലായ്":"ms",
        "malajan":"ms",
        "မလေး":"ms",
        "माला":"ms",
        "مالایا":"ms",
        "مالایی":"ms",
        "ਮਾਲੇ":"ms",
        "malaezian":"ms",
        "малайский":"ms",
        "malaidheach":"ms",
        "малаи":"ms",
        "mala":"ms",
        "chimalay":"ms",
        "مالائي":"ms",
        "මැලේ":"ms",
        "malajsky":"ms",
        "malega":"ms",
        "malaya":"ms",
        "malayaga":"ms",
        "malaika":"ms",
        "malajiska":"ms",
        "மலாய்":"ms",
        "ภาษามลายู":"ms",
        "малайський":"ms",
        "مالائی":"ms",
        "mã lai":"ms",
        "maleieg":"ms",
        "malabaars":"ml",
        "malayalam":"ml",
        "المالايالامية":"ml",
        "մալամալամ":"ml",
        "малаялам":"ml",
        "মালায়ালম":"ml",
        "malajalam":"ml",
        "malaalam":"ml",
        "malajala":"ml",
        "malabar":"ml",
        "მალაჰალამი":"ml",
        "μαλαγιάλαμ":"ml",
        "મલયાલમ":"ml",
        "mālealama":"ml",
        "מלזאלם":"ml",
        "मलयालम":"ml",
        "athnuachan":"ml",
        "マラヤーラム語":"ml",
        "ಮಲಯಾಳಂ":"ml",
        "ម៉ាលឡាឡាំ":"ml",
        "말라 얄 람어":"ml",
        "malayalamî":"ml",
        "малаяламча":"ml",
        "ມະຫາໄລ":"ml",
        "malajalamas":"ml",
        "малахалам":"ml",
        "മലയാളം":"ml",
        "मल्याळम":"ml",
        "ମାଲାୟାଲମ୍":"ml",
        "ملایلم":"ml",
        "مالالامال":"ml",
        "ਮਲਿਆਲਮ":"ml",
        "малаяла":"ml",
        "malayalamach":"ml",
        "малајалам":"ml",
        "chimalayalam":"ml",
        "مالايالم":"ml",
        "මලයාලම්":"ml",
        "malajálamčina":"ml",
        "மலையாளம்":"ml",
        "మలయాళ":"ml",
        "มาลายาลัม":"ml",
        "ملیالم":"ml",
        "isi-malayalam":"ml",
        "maltese":"mt",
        "maltez":"mt",
        "ማልትስ":"mt",
        "المالطية":"mt",
        "մալթերեն":"mt",
        "мальтыйскі":"mt",
        "malteški":"mt",
        "малтийски":"mt",
        "maltès":"mt",
        "malta":"mt",
        "maltština":"mt",
        "maltesisk":"mt",
        "maltees":"mt",
        "maltalainen":"mt",
        "maltais":"mt",
        "malteesk":"mt",
        "maltés":"mt",
        "მალტური":"mt",
        "maltesisch":"mt",
        "μαλτέζος":"mt",
        "સ્પોટ":"mt",
        "malkī":"mt",
        "מלטזית":"mt",
        "máltai":"mt",
        "maltneska":"mt",
        "mháltais":"mt",
        "マルタ語":"mt",
        "ಮಾಲ್ಟೀಸ್":"mt",
        "мальтеза":"mt",
        "ជនជាតិម៉ាល់ឌីវ":"mt",
        "몰티즈":"mt",
        "maltezî":"mt",
        "малтизче":"mt",
        "ຄົນຕະລົກ":"mt",
        "melitensis":"mt",
        "maltiešu":"mt",
        "maltiečių":"mt",
        "maltesesch":"mt",
        "малтешки":"mt",
        "മാൾട്ടീസ്":"mt",
        "maltin":"mt",
        "малтит":"mt",
        "खेलकुद":"mt",
        "ମାଲ୍ଟି":"mt",
        "مالتیس":"mt",
        "مالتی":"mt",
        "maltański":"mt",
        "maltesa":"mt",
        "ਕਪੜੇ":"mt",
        "мальтийский":"mt",
        "malteseach":"mt",
        "malwetse":"mt",
        "chimaltese":"mt",
        "مالٽي":"mt",
        "මෝල්ටිස්":"mt",
        "maltčina":"mt",
        "малтесе":"mt",
        "மால்டிஸ்":"mt",
        "มอลตา":"mt",
        "мальтійська":"mt",
        "cây nho":"mt",
        "malteg":"mt",
        "מאלטיזיש":"mt",
        "isi-malta":"mt",
        "ማኦሪይ":"mi",
        "الماوري":"mi",
        "маоры":"mi",
        "মাওরি":"mi",
        "маорски":"mi",
        "maor":"mi",
        "maoorid":"mi",
        "maorie":"mi",
        "maorí":"mi",
        "მაორი":"mi",
        "μάορι":"mi",
        "માઓરી":"mi",
        "ōlelo māori":"mi",
        "מאורי":"mi",
        "माओरी":"mi",
        "マオリ":"mi",
        "ಮಾವೊರಿ":"mi",
        "маори":"mi",
        "ម៉ារីអូ":"mi",
        "마오리족":"mi",
        "maorîyî":"mi",
        "маориче":"mi",
        "maorice":"mi",
        "maorių":"mi",
        "maoresch":"mi",
        "മ ori റി":"mi",
        "माऊरी":"mi",
        "माउरी":"mi",
        "ମାଧୁରୀ |":"mi",
        "ماوري":"mi",
        "مائوری":"mi",
        "maoryski":"mi",
        "ਮਾਓਰੀ":"mi",
        "maoli":"mi",
        "مائوري":"mi",
        "ம ori ரி":"mi",
        "మయోరి":"mi",
        "ชาวเมารี":"mi",
        "маорі":"mi",
        "ماوری":"mi",
        "isimawori":"mi",
        "marathi":"mr",
        "ማራቲ":"mr",
        "المهاراتية":"mr",
        "marati":"mr",
        "маратхі":"mr",
        "মারাঠি":"mr",
        "маратхи":"mr",
        "maratysk":"mr",
        "მარათი":"mr",
        "μαράθι":"mr",
        "મરાઠી":"mr",
        "malapi":"mr",
        "מרתי":"mr",
        "मराठी":"mr",
        "マラーティー語":"mr",
        "ಮರಾಠಿ":"mr",
        "ម៉ារ៉ាធី":"mr",
        "마라 티어":"mr",
        "maratî":"mr",
        "маратиче":"mr",
        "maratų":"mr",
        "марати":"mr",
        "മറാത്തി":"mr",
        "марати хэл":"mr",
        "မာရသီ":"mr",
        "माराठी":"mr",
        "ମରାଠୀ":"mr",
        "مراټي":"mr",
        "ماراتی":"mr",
        "ਮਰਾਠੀ":"mr",
        "marathiach":"mr",
        "chimarati":"mr",
        "مراٺي":"mr",
        "මරාති":"mr",
        "maráthčina":"mr",
        "маратҳӣ":"mr",
        "மராத்தி":"mr",
        "మరాఠీ":"mr",
        "ฐี":"mr",
        "مراٹھی":"mr",
        "marafiy":"mr",
        "isimarathi":"mr",
        "mongoolse":"mn",
        "mongolian":"mn",
        "ሞኒጎሊያን":"mn",
        "المنغولية":"mn",
        "monqol":"mn",
        "мангольская":"mn",
        "মঙ্গোলিয়":"mn",
        "mongolski":"mn",
        "монголски":"mn",
        "mongoli":"mn",
        "mongolianu":"mn",
        "mongolský":"mn",
        "mongools":"mn",
        "mongola":"mn",
        "mongoli keel":"mn",
        "mongolialainen":"mn",
        "mongole":"mn",
        "mongoalsk":"mn",
        "mongoliano":"mn",
        "მონღოლური":"mn",
        "mongolisch":"mn",
        "μογγόλος":"mn",
        "મંગોલિયન":"mn",
        "ōlelo monokolia":"mn",
        "מוֹנגוֹלִי":"mn",
        "मंगोलियन":"mn",
        "mongol":"mn",
        "mongólískt":"mn",
        "mongolia":"mn",
        "mongóil":"mn",
        "モンゴル語":"mn",
        "ಮಂಗೋಲಿಯನ್":"mn",
        "моңғол":"mn",
        "몽고 어":"mn",
        "moxolî":"mn",
        "монголчо":"mn",
        "ມົງໂກລີ":"mn",
        "mongolica":"mn",
        "mongoļu":"mn",
        "mongolų":"mn",
        "mongolesch":"mn",
        "mongoliana":"mn",
        "മംഗോളിയൻ":"mn",
        "монгол":"mn",
        "မွန်ဂိုလီးယန်း":"mn",
        "mongolsk":"mn",
        "مغولي":"mn",
        "مغول":"mn",
        "ਮੰਗੋਲੀਅਨ":"mn",
        "монгольский":"mn",
        "mokoliana":"mn",
        "mongolianach":"mn",
        "chimongoria":"mn",
        "منگولي":"mn",
        "මොන්ගෝලියානු":"mn",
        "mongoliska":"mn",
        "муғулистон":"mn",
        "மங்கோலியன்":"mn",
        "มองโกเลีย":"mn",
        "moğolca":"mn",
        "монгольська":"mn",
        "منگولین":"mn",
        "mo'g'ul":"mn",
        "mông cổ":"mn",
        "mongolaidd":"mn",
        "isimongoliya":"mn",
        "ara ilu mongolia":"mn",
        "mianmar (birmaans)":"my",
        "myanmar (burimes)":"my",
        "ሚያንማር (burmese)":"my",
        "ميانمار (بورما)":"my",
        "myanmar (burma)":"my",
        "myanmar (burmeo)":"my",
        "м'янма (бірманская)":"my",
        "মায়ানমার (বার্মিজ)":"my",
        "mjanmar (burma)":"my",
        "мианма (бирма)":"my",
        "myanmar (burmaia)":"my",
        "myanmar (burmese)":"my",
        "myanmar (barmština)":"my",
        "myanmar (burmesisk)":"my",
        "myanmar (birmees)":"my",
        "myanmar (burmese)...":"my",
        "myanmar (birma)":"my",
        "myanmar (burmalainen)":"my",
        "myanmar (birman)":"my",
        "myanmar (birmaansk)":"my",
        "მიანმარა (ბირმული)":"my",
        "myanmar (burmesisch)":"my",
        "myanmar (βιρμανία)":"my",
        "મ્યાનમાર (બર્મીઝ)":"my",
        "myanma (burmese)":"my",
        "madium (burmese)":"my",
        "honu":"my",
        "מיאנמר (בורמזי)":"my",
        "म्यांमार (बर्मी)":"my",
        "mianmar (burmai)":"my",
        "maenmar (burmais)":"my",
        "myanmar (birmano)":"my",
        "ミャンマー（ビルマ）":"my",
        "ಮ್ಯಾನ್ಮಾರ್ (ಬರ್ಮೀಸ್)":"my",
        "мьянма (бирма)":"my",
        "មីយ៉ាន់ម៉ា (burmese)":"my",
        "미얀마 (버마어)":"my",
        "myanmar":"my",
        "ມຽນມາ (burmese)":"my",
        "suspendisse (burmese)":"my",
        "mjanma (birmiešu)":"my",
        "mianmaras (birmos)":"my",
        "myanmar (birmanesch)":"my",
        "мијанмар":"myanmar",
        "മ്യാൻമർ (ബർമീസ്)":"my",
        "mjanmar (burmaż)":"my",
        "म्यानमार (बर्मीज)":"my",
        "мьянмар (бурмэс)":"my",
        "မြန်မာ (မြန်မာ)":"my",
        "म्यानमार (बर्मिज)":"my",
        "ମିଆଁମାର (ବର୍ମା)":"my",
        "میانمار (برمی)":"my",
        "میانمار (برمه ای)":"my",
        "myanmar (birmański)":"my",
        "myanmar (birmanês)":"my",
        "ਮਿਆਂਮਾਰ (ਬਰਮੀ)":"my",
        "myanmar (birmania)":"my",
        "мьянма (бирманская)":"my",
        "мјанмар (бурмански)":"my",
        "ميانمار (برمي)":"my",
        "මියන්මාරය (බුරුමය)":"my",
        "mjanmarsko (barmsky)":"my",
        "mjanmarica (burma)":"my",
        "myanmar (tukang basa)":"my",
        "myanmar (burmesiska)":"my",
        "мянмар (бирма)":"my",
        "மியான்மர் (பர்மிய)":"my",
        "మయన్మార్ (బర్మీస్)":"my",
        "เมียนมาร์ (พม่า)":"my",
        "myanmar (birmanya)":"my",
        "м'янма (бірма)":"my",
        "myanma (birma)":"my",
        "umyenam (burmese)":"my",
        "myanmar (בורמעזיש)":"my",
        "i-myanmar (burmese)":"my",
        "nepalees":"ne",
        "nepali":"ne",
        "ኔፓሊ":"ne",
        "النيبالية":"ne",
        "непалі":"ne",
        "নেপালি":"ne",
        "непалски":"ne",
        "nepalese":"ne",
        "nepalski":"ne",
        "nepalesisk":"ne",
        "nepala":"ne",
        "népalaise":"ne",
        "nepaleesk":"ne",
        "ნეპალი":"ne",
        "νεπαλί":"ne",
        "નેપાળી":"ne",
        "נפאלי":"ne",
        "नेपाली":"ne",
        "ziag no":"ne",
        "nepáli":"ne",
        "nepalska":"ne",
        "ネパール語":"ne",
        "ನೇಪಾಳಿ":"ne",
        "непалы":"ne",
        "네팔":"ne",
        "nepalî":"ne",
        "непаличе":"ne",
        "nepālietis":"ne",
        "nepalesesch":"ne",
        "непали":"ne",
        "നേപ്പാളി":"ne",
        "နီပေါ":"ne",
        "ନେପାଳୀ":"ne",
        "نیپالي":"ne",
        "نپالی":"ne",
        "ਨੇਪਾਲੀ":"ne",
        "nepaleză":"ne",
        "непальский":"ne",
        "nepalach":"ne",
        "chinepali":"ne",
        "نيپالي":"ne",
        "නෙපාලි":"ne",
        "nepálsky":"ne",
        "nepalí":"ne",
        "நேபாளி":"ne",
        "నేపాలి":"ne",
        "เนปาล":"ne",
        "nepalcedeki":"ne",
        "نیپالی":"ne",
        "נעפּאַליש":"ne",
        "norwegian":"no",
        "norvegjez":"no",
        "ኖርወይኛ":"no",
        "النرويجية":"no",
        "norveç":"no",
        "нарвежская":"no",
        "নরওয়েজীয়":"no",
        "norveški":"no",
        "норвежки":"no",
        "noruec":"no",
        "novegese":"no",
        "norština":"no",
        "norsk":"no",
        "noors":"no",
        "norvega":"no",
        "norra keeles":"no",
        "norjan kieli":"no",
        "norvégienne":"no",
        "noarsk":"no",
        "noruegués":"no",
        "ნორვეგიელი":"no",
        "norwegisch":"no",
        "νορβηγός":"no",
        "નોર્વેજીયન":"no",
        "nòvejyen":"no",
        "harshen koriya":"no",
        "nolewai":"no",
        "נורווגית":"no",
        "norvég":"no",
        "norsku":"no",
        "norwegia":"no",
        "norvegese":"no",
        "ノルウェー語":"no",
        "ನಾರ್ವೇಜಿಯನ್":"no",
        "норвегиялық":"no",
        "ន័រវែស":"no",
        "노르웨이 인":"no",
        "norwêcî":"no",
        "норвежче":"no",
        "ນອກແວ":"no",
        "norvēģi":"no",
        "norvegų":"no",
        "norweegesch":"no",
        "норвешки":"no",
        "norvejiana":"no",
        "നോർവീജിയൻ":"no",
        "norveġiż":"no",
        "नॉर्लियन":"no",
        "норвег":"no",
        "နော်ဝေ":"no",
        "नेदरल्याण्डियन":"no",
        "ନରୱେଜ୍":"no",
        "نارویژي":"no",
        "نروژی":"no",
        "norweski":"no",
        "norueguesa":"no",
        "ਨਾਰਵੇਲੀਅਨ":"no",
        "norvegian":"no",
        "норвежский":"no",
        "lochlannach":"no",
        "se-norway":"no",
        "chinorwegian":"no",
        "نارويجي":"no",
        "නෝර්වීජියානු":"no",
        "nórsky":"no",
        "norveška":"no",
        "noruega":"no",
        "kinorwe":"no",
        "norska":"no",
        "норвегӣ":"no",
        "நோர்வே":"no",
        "నార్వేజియన్":"no",
        "นอร์เวย์":"no",
        "norveççe":"no",
        "норвезька":"no",
        "نیدرلینائی":"no",
        "norvegcha":"no",
        "tiếng na uy":"no",
        "נאָרוועגיש":"no",
        "isinorway":"no",
        "odia":"or",
        "ኦሊያ":"or",
        "أوديا":"or",
        "одыя":"or",
        "ოდია":"or",
        "οδία":"or",
        "ઓડિયા":"or",
        "odya":"or",
        "אודיה":"or",
        "オディア":"or",
        "ಒಡಿಯಾ":"or",
        "одиа":"or",
        "오 디아":"or",
        "штаны":"or",
        "odija":"or",
        "одја":"or",
        "ഓഡിയ":"or",
        "ओडिया":"or",
        "နေ":"or",
        "ଓଡିଆ":"or",
        "اوډیا":"or",
        "اودیا":"or",
        "ਓਡੀਆ":"or",
        "اوديا":"or",
        "одия":"or",
        "ஓடியா":"or",
        "ఒడియా":"or",
        "одія":"or",
        "mùi hương":"or",
        "oorun":"or",
        "pasjtoe":"ps",
        "pashto":"ps",
        "الباشتو":"ps",
        "puştu":"ps",
        "пушто":"ps",
        "পুশতু":"ps",
        "paštu":"ps",
        "пущу":"ps",
        "pašto":"ps",
        "pastu":"ps",
        "pashtu":"ps",
        "პასტო":"ps",
        "παστώ":"ps",
        "પશ્તો":"ps",
        "ōlelo pashto":"ps",
        "פשטו":"ps",
        "पश्तो":"ps",
        "パシュトー語":"ps",
        "ಪಾಷ್ಟೋ":"ps",
        "пушту":"ps",
        "ផាសតូ":"ps",
        "파슈토":"ps",
        "peştûyî":"ps",
        "пуштунча":"ps",
        "ປາແດກ":"ps",
        "pastua":"ps",
        "puštu":"ps",
        "пафто":"ps",
        "പാഷ്ടോ":"ps",
        "пашто":"ps",
        "ပက်တို":"ps",
        "ପାଶ୍ଟୁ |":"ps",
        "پښتو":"ps",
        "پشتو":"ps",
        "paszto":"ps",
        "ਪਸ਼ਤੋ":"ps",
        "pasato":"ps",
        "пасхто":"ps",
        "pashito":"ps",
        "පැෂ්ටෝ":"ps",
        "paštčina":"ps",
        "пашту":"ps",
        "பாஷ்டோ":"ps",
        "పాష్టో":"ps",
        "isiphashto":"ps",
        "פּאַשטאָ":"ps",
        "persiese":"fa",
        "persian":"fa",
        "ፐርሽያን":"fa",
        "اللغة الفارسية":"fa",
        "fars":"fa",
        "персідскі":"fa",
        "পারসিক":"fa",
        "perzijski":"fa",
        "персийски":"fa",
        "persa":"fa",
        "kupitirira":"fa",
        "persianu":"fa",
        "persijski":"fa",
        "peršan":"fa",
        "persisk":"fa",
        "perzisch":"fa",
        "pärsia":"fa",
        "persialainen":"fa",
        "persane":"fa",
        "perzysk":"fa",
        "სპარსული":"fa",
        "persisch":"fa",
        "περσικός":"fa",
        "પર્સિયન":"fa",
        "pèsik":"fa",
        "tsani":"fa",
        "pelekia":"fa",
        "פַּרסִית":"fa",
        "फ़ारसी":"fa",
        "pheej":"fa",
        "perzsa":"fa",
        "persneskur":"fa",
        "tei":"fa",
        "orang persia":"fa",
        "persiana":"fa",
        "ペルシア語":"fa",
        "ಪರ್ಷಿಯನ್":"fa",
        "персия":"fa",
        "페르시아 인":"fa",
        "farsî":"fa",
        "парсча":"fa",
        "ເປີເຊຍ":"fa",
        "persici":"fa",
        "persiešu":"fa",
        "persų":"fa",
        "persesch":"fa",
        "персиски":"fa",
        "persianina":"fa",
        "പേർഷ്യൻ":"fa",
        "persjan":"fa",
        "पर्शियन":"fa",
        "перс":"fa",
        "ပါရှား":"fa",
        "पर्सियन":"fa",
        "farsi":"fa",
        "فارسي":"fa",
        "فارسی":"fa",
        "perski":"fa",
        "ਪਰਸੀਅਨ":"fa",
        "persană":"fa",
        "persianach":"fa",
        "перзијски":"fa",
        "chipersian":"fa",
        "පර්සියානු":"fa",
        "perzský":"fa",
        "mfuasi":"fa",
        "персид":"fa",
        "பெர்சியன்":"fa",
        "పెర్షియన్":"fa",
        "เปอร์เซีย":"fa",
        "farsça":"fa",
        "персидський":"fa",
        "فارس":"fa",
        "ba tư":"fa",
        "aṣa":"fa",
        "i-persian":"fa",
        "polish":"pl",
        "polonisht":"pl",
        "ፖሊሽ":"pl",
        "تلميع":"pl",
        "cilalamaq":"pl",
        "паліраваць":"pl",
        "পালিশ":"pl",
        "poljski":"pl",
        "лак":"pl",
        "polir":"pl",
        "kahamis":"pl",
        "kupukuta":"pl",
        "pulaccu":"pl",
        "polirati":"pl",
        "polština":"pl",
        "polere":"pl",
        "pools":"pl",
        "poluri":"pl",
        "poola":"pl",
        "kiillottaa":"pl",
        "polonais":"pl",
        "poalsk":"pl",
        "პოლონური":"pl",
        "polieren":"pl",
        "στίλβωση":"pl",
        "પોલિશ":"pl",
        "polonè":"pl",
        "goge baki":"pl",
        "pōlani":"pl",
        "פולני":"pl",
        "पोलिश":"pl",
        "txhuam":"pl",
        "fényesít":"pl",
        "pólskur":"pl",
        "polandia":"pl",
        "snas":"pl",
        "polacca":"pl",
        "研磨":"pl",
        "ಹೊಳಪು ಕೊಡು":"pl",
        "жылтырату":"pl",
        "ប៉ូលា":"pl",
        "광택":"pl",
        "polandî":"pl",
        "полякча":"pl",
        "ຂັດ":"pl",
        "poloniae":"pl",
        "pulēt":"pl",
        "lenkas":"pl",
        "polnesch":"pl",
        "полски":"pl",
        "poloney":"pl",
        "പോളിഷ്":"pl",
        "lustrar":"pl",
        "पॉलिश":"pl",
        "өнгөлөх":"pl",
        "အရောင်တင်သည်":"pl",
        "pusse":"pl",
        "ପଲିସ୍ |":"pl",
        "پولیش":"pl",
        "لهستانی":"pl",
        "polskie":"pl",
        "polonês":"pl",
        "ਪੋਲਿਸ਼":"pl",
        "lustrui":"pl",
        "полировать":"pl",
        "pòlainneach":"pl",
        "пољски":"pl",
        "polasetiki":"pl",
        "chipolish":"pl",
        "پالش":"pl",
        "පොලිෂ්":"pl",
        "lesk":"pl",
        "polaca":"pl",
        "hemir":"pl",
        "kipolishi":"pl",
        "putsa":"pl",
        "полиш":"pl",
        "lehçe":"pl",
        "шліфувати":"pl",
        "jilo":"pl",
        "đánh bóng":"pl",
        "sglein":"pl",
        "פּויליש":"pl",
        "pólándì":"pl",
        "songa":"pl",
        "portugees":"pt",
        "portugalisht":"pt",
        "ፖርቹጋልኛ":"pt",
        "البرتغالية":"pt",
        "portuqalca":"pt",
        "portuguese":"pt",
        "партугальская":"pt",
        "পর্তুগীজ":"pt",
        "portugalski":"pt",
        "португалски":"pt",
        "portuguès":"pt",
        "portuges":"pt",
        "chi portuguese":"pt",
        "portughese":"pt",
        "portugalština":"pt",
        "portugisisk":"pt",
        "portugalin kieli":"pt",
        "portugais":"pt",
        "portegeesk":"pt",
        "პორტუგალიური":"pt",
        "portugiesisch":"pt",
        "πορτογαλικά":"pt",
        "પોર્ટુગીઝ":"pt",
        "pòtigè":"pt",
        "pukikī":"pt",
        "פורטוגזית":"pt",
        "पुर्तगाली":"pt",
        "portugál":"pt",
        "portúgalska":"pt",
        "portugis":"pt",
        "portoghese":"pt",
        "ポルトガル語":"pt",
        "ಪೋರ್ಚುಗೀಸ್":"pt",
        "португал тілі":"pt",
        "ព័រទុយហ្កាល់":"pt",
        "포르투갈 인":"pt",
        "portekizî":"pt",
        "португалча":"pt",
        "ພາສາປອກຕຸຍການ":"pt",
        "portugāļi":"pt",
        "portugalų":"pt",
        "portugisesch":"pt",
        "portogey":"pt",
        "പോർച്ചുഗീസ്":"pt",
        "portugiż":"pt",
        "पोर्तुगीज":"pt",
        "португал хэлтэй":"pt",
        "ပေါ်တူဂီ":"pt",
        "पोर्तुगाली":"pt",
        "ପର୍ତ୍ତୁଗୀଜ୍":"pt",
        "پورتګالي":"pt",
        "پرتغالی":"pt",
        "portuguesa":"pt",
        "ਪੁਰਤਗਾਲੀ":"pt",
        "portugheză":"pt",
        "португальский":"pt",
        "portugalach":"pt",
        "chiputukezi":"pt",
        "پرتگالي":"pt",
        "පෘතුගීසි":"pt",
        "portugalský":"pt",
        "portugalščina":"pt",
        "portugisiska":"pt",
        "португалӣ":"pt",
        "போர்த்துகீசியம்":"pt",
        "โปรตุเกส":"pt",
        "portekizce":"pt",
        "португальська":"pt",
        "پرتگالی":"pt",
        "portugal tilida":"pt",
        "bồ đào nha":"pt",
        "isiphuthukezi":"pt",
        "פארטוגעזיש":"pt",
        "isi-portuguese":"pt",
        "punjabi":"pa",
        "ፑንጃቢ":"pa",
        "البنجابية":"pa",
        "панджабі":"pa",
        "পাঞ্জাবি":"pa",
        "пенджабски":"pa",
        "patar":"pa",
        "pendžabljanin":"pa",
        "pûndjaabsk":"pa",
        "პუნჯი":"pa",
        "પંજાબી":"pa",
        "ōlelo punajabi":"pa",
        "פנג'אבי":"pa",
        "पंजाबी":"pa",
        "pandzsábi":"pa",
        "パンジャブ語":"pa",
        "ಪಂಜಾಬಿ":"pa",
        "пунджаби":"pa",
        "ប៉ឺជ្កា":"pa",
        "펀자 브어":"pa",
        "pencabî":"pa",
        "пунжабиче":"pa",
        "romancica":"pa",
        "pundschabi":"pa",
        "панџаби":"pa",
        "പഞ്ചാബി":"pa",
        "пунжаби":"pa",
        "ပန်ဂျီ":"pa",
        "ପଞ୍ଜାବୀ |":"pa",
        "پنجابي":"pa",
        "پنجابی":"pa",
        "pendżabski":"pa",
        "ਪੰਜਾਬੀ":"pa",
        "панджаби":"pa",
        "punitapi":"pa",
        "пуњаби":"pa",
        "sepanish":"pa",
        "පන්ජාබි":"pa",
        "papi":"pa",
        "పంజాబీ":"pa",
        "ปัญจาบ":"pa",
        "pencap":"pa",
        "пенджабі":"pa",
        "panjabi":"pa",
        "trừng phạt":"pa",
        "isiphunjabi":"pa",
        "isipanish":"pa",
        "romanian":"ro",
        "rumun":"ro",
        "ሮማንያን":"ro",
        "روماني":"ro",
        "rumın":"ro",
        "румынская":"ro",
        "rumunski":"ro",
        "румънски":"ro",
        "romanès":"ro",
        "wachisomania":"ro",
        "rumenu":"ro",
        "rumunština":"ro",
        "rumænsk":"ro",
        "roemeense":"ro",
        "rumano":"ro",
        "rumeenlane":"ro",
        "romanialainen":"ro",
        "roumaine":"ro",
        "roemeensk":"ro",
        "რუმინული":"ro",
        "rumänisch":"ro",
        "ρουμανικός":"ro",
        "રોમન":"ro",
        "romaniyanci":"ro",
        "lomānia":"ro",
        "רומנית":"ro",
        "रोमानियाई":"ro",
        "román":"ro",
        "rúmensk":"ro",
        "romania":"ro",
        "rumania":"ro",
        "rómhánach":"ro",
        "rumena":"ro",
        "ルーマニア語":"ro",
        "ರೊಮೇನಿಯನ್":"ro",
        "румын":"ro",
        "រ៉ូម៉ានី":"ro",
        "루마니아 사람":"ro",
        "romanyayî":"ro",
        "румынча":"ro",
        "ໂລມາເນຍ":"ro",
        "rumāņu":"ro",
        "rumunų":"ro",
        "rumänesch":"ro",
        "романски":"ro",
        "romainina":"ro",
        "റൊമാനിയൻ":"ro",
        "rumeni":"ro",
        "रोमानियन":"ro",
        "румын хэл":"ro",
        "ရိုမေးနီးယား":"ro",
        "रोमान्टिक":"ro",
        "rumensk":"ro",
        "ରୋମାନିଆନ୍":"ro",
        "رومانیایی":"ro",
        "rumuński":"ro",
        "romena":"ro",
        "ਰੋਚਿੰਗ":"ro",
        "română":"ro",
        "румынский":"ro",
        "lomani":"ro",
        "romànianach":"ro",
        "румунски":"ro",
        "chiromanian":"ro",
        "رومانوي":"ro",
        "රොමේනියානු":"ro",
        "rumunský":"ro",
        "romunski":"ro",
        "rumana":"ro",
        "rumänska":"ro",
        "романӣ":"ro",
        "ரோமானியன்":"ro",
        "โรมาเนีย":"ro",
        "romen":"ro",
        "румунська":"ro",
        "چھٹی":"ro",
        "ruminiyalik":"ro",
        "rumani":"ro",
        "rhufeinig":"ro",
        "רומעניש":"ro",
        "ara ilu róòmù":"ro",
        "russiese":"ru",
        "rusisht":"ru",
        "ራሺያኛ":"ru",
        "الروسية":"ru",
        "rus":"ru",
        "russian":"ru",
        "руская":"ru",
        "রাশিয়ান":"ru",
        "ruski":"ru",
        "руски":"ru",
        "russu":"ru",
        "ruština":"ru",
        "russisk":"ru",
        "russisch":"ru",
        "ruso":"ru",
        "vene keeles":"ru",
        "venäjän kieli":"ru",
        "russe":"ru",
        "russysk":"ru",
        "რუსი":"ru",
        "ρωσική":"ru",
        "રશિયન":"ru",
        "ris":"ru",
        "rasha":"ru",
        "lukia":"ru",
        "רוּסִי":"ru",
        "रूसी":"ru",
        "lavxias teb sab":"ru",
        "orosz":"ru",
        "rússneskt":"ru",
        "ndị russia":"ru",
        "rusia":"ru",
        "rúisis":"ru",
        "russa":"ru",
        "ロシア":"ru",
        "ರಷ್ಯನ್":"ru",
        "орыс":"ru",
        "រូស្សី":"ru",
        "러시아인":"ru",
        "rûsî":"ru",
        "орусча":"ru",
        "ລັດເຊຍ":"ru",
        "krievu":"ru",
        "rusų":"ru",
        "russesch":"ru",
        "rosiana":"ru",
        "റഷ്യൻ":"ru",
        "रशियन":"ru",
        "орос":"ru",
        "ရုရှား":"ru",
        "रसियन":"ru",
        "russian ଷୀୟ":"ru",
        "روسي":"ru",
        "روسی":"ru",
        "rosyjski":"ru",
        "ਰਸ਼ੀਅਨ":"ru",
        "rusă":"ru",
        "русский":"ru",
        "lusia":"ru",
        "ruiseanach":"ru",
        "serussia":"ru",
        "chirussian":"ru",
        "රුසියානු":"ru",
        "ruský":"ru",
        "rusa":"ru",
        "kirusi":"ru",
        "ryska":"ru",
        "русй":"ru",
        "ரஷ்ய":"ru",
        "రష్యన్":"ru",
        "รัสเซีย":"ru",
        "rusça":"ru",
        "російський":"ru",
        "ruscha":"ru",
        "tiếng nga":"ru",
        "isirashiya":"ru",
        "רוסיש":"ru",
        "ara ilu russia":"ru",
        "samoa":"sm",
        "samoan":"sm",
        "ናታን":"sm",
        "ساموا":"sm",
        "samoako":"sm",
        "самоан":"sm",
        "সামোয়ান":"sm",
        "самоански":"sm",
        "samoà":"sm",
        "wokongola":"sm",
        "samoaans":"sm",
        "samoano":"sm",
        "სამოა":"sm",
        "samoaner":"sm",
        "σαμοάν":"sm",
        "સમોન":"sm",
        "סמואן":"sm",
        "सामोन":"sm",
        "サモア語":"sm",
        "ಸಮೋವನ್":"sm",
        "사모아":"sm",
        "saman":"sm",
        "самоа":"sm",
        "samoanis":"sm",
        "samoans":"sm",
        "samoanas":"sm",
        "самоана":"sm",
        "samoanina":"sm",
        "സമോവൻ":"sm",
        "ရှမ်း":"sm",
        "samoansk":"sm",
        "ସାମୋଆନ୍ |":"sm",
        "سماوان":"sm",
        "ساموون":"sm",
        "samoana":"sm",
        "самоанский":"sm",
        "سامانو":"sm",
        "සමෝවාන්":"sm",
        "samojština":"sm",
        "సమోవన్":"sm",
        "ซามัว":"sm",
        "samoalı":"sm",
        "سامون":"sm",
        "usaman":"sm",
        "isisamoa":"sm",
        "skotse gaelies":"gd",
        "copëza gaelike":"gd",
        "ስታትስቲክስ ጋለሊክ":"gd",
        "الغيلية الأسكتلندية":"gd",
        "skots gaelic":"gd",
        "scots gaelic":"gd",
        "шатландскі гэльскі":"gd",
        "স্কট গ্যালিক":"gd",
        "scots galski":"gd",
        "шотландски галски":"gd",
        "škotski galski":"gd",
        "skotský gaelský":"gd",
        "skotsk gælisk":"gd",
        "schots gaëlisch":"gd",
        "skotoj gaelic":"gd",
        "šoti gaeli":"gd",
        "skotti gaelinen":"gd",
        "gaélique écossais":"gd",
        "skotsk gaelic":"gd",
        "schottisch gälisch":"gd",
        "σκωτσέζικος γαελικός":"gd",
        "સ્કોટ્સ ગેલેક":"gd",
        "pye kalòt":"gd",
        "גאלית סקוטית":"gd",
        "स्कॉट्स गेलिक":"gd",
        "nkaub gaelic":"gd",
        "skót gael":"gd",
        "skoska gaelísk":"gd",
        "skotlandia gaelik":"gd",
        "gaelico scozzese":"gd",
        "スコットランドゲール語":"gd",
        "gatel gaelic":"gd",
        "ಸ್ಕಾಟ್ಸ್ ಗೇಲಿಕ್":"gd",
        "скотчтар":"gd",
        "sca gaelic":"gd",
        "스코틀랜드 게일":"gd",
        "scots гаэлик":"gd",
        "caledonica":"gd",
        "skotu gēlu":"gd",
        "škotų gaelika":"gd",
        "scots gaelesch":"gd",
        "скокови гаил":"gd",
        "സ്കോട്ട്സ് ഗാലിക്":"gd",
        "скотчууд":"gd",
        "स्कट्स गालील":"gd",
        "ସ୍କଟସ୍ ଗେଲିକ୍ |":"gd",
        "اسکاټ ګیلیک":"gd",
        "اسکات gaelic":"gd",
        "szkocki gaelicki":"gd",
        "gaélico escocês":"gd",
        "ਸਕਾਟਸ ਗੈਲਿਕ":"gd",
        "шотландский гэльский":"gd",
        "sikola gaeloa":"gd",
        "сцотс галски":"gd",
        "اسڪاٽس گئليڪڪ":"gd",
        "ස්කොට්ස් ගේලික්":"gd",
        "škótsky gaelský":"gd",
        "gaélico escocés":"gd",
        "karéta gaelic":"gd",
        "ஸ்காட்ஸ் கேலிக்":"gd",
        "స్కాట్స్ గేలిక్":"gd",
        "สก็อตเกลิค":"gd",
        "i̇skoç gaelic":"gd",
        "шотландський гель":"gd",
        "اسکاٹس گیلیک":"gd",
        "skots gaelik":"gd",
        "gaelic scots":"gd",
        "serbian":"sr",
        "serb":"sr",
        "ሰሪቢያን":"sr",
        "الصربية":"sr",
        "сербскі":"sr",
        "srpski":"sr",
        "сръбски":"sr",
        "serbi":"sr",
        "mserikali":"sr",
        "serbianu":"sr",
        "srbština":"sr",
        "serbisk":"sr",
        "servisch":"sr",
        "serba":"sr",
        "serbia keeles":"sr",
        "serbialainen":"sr",
        "serbe":"sr",
        "servysk":"sr",
        "სერბული":"sr",
        "serbisch":"sr",
        "σέρβος":"sr",
        "દુકાન":"sr",
        "sèb":"sr",
        "ōlelo serbia":"sr",
        "סרבית":"sr",
        "szerb":"sr",
        "serbneska":"sr",
        "ndị serbian":"sr",
        "orang serbia":"sr",
        "seirbis":"sr",
        "セルビア語":"sr",
        "ಸರ್ಬಿಯನ್":"sr",
        "серб":"sr",
        "សេរ៉ូម":"sr",
        "세르비아 사람":"sr",
        "sirbî":"sr",
        "сербче":"sr",
        "servica":"sr",
        "serbu":"sr",
        "serbų":"sr",
        "serbesch":"sr",
        "српски":"sr",
        "serbianina":"sr",
        "സെർബിയൻ":"sr",
        "serw":"sr",
        "दुकान":"sr",
        "ဆားဗီးယား":"sr",
        "पसल":"sr",
        "ସର୍ବିଆନ୍ |":"sr",
        "صربي":"sr",
        "صربی":"sr",
        "serbski":"sr",
        "sérvia":"sr",
        "ਦੁਕਾਨ":"sr",
        "sârb":"sr",
        "сербский":"sr",
        "serbianach":"sr",
        "seserbia":"sr",
        "chisebhiya":"sr",
        "سربيائي":"sr",
        "සර්බියානු":"sr",
        "srbský":"sr",
        "srbščina":"sr",
        "serbia":"sr",
        "seria":"sr",
        "சேர்பியன்":"sr",
        "సెర్బియన్":"sr",
        "เซอร์เบีย":"sr",
        "sırpça":"sr",
        "сербський":"sr",
        "دکان":"sr",
        "serbiya":"sr",
        "thành phố":"sr",
        "serbeg":"sr",
        "isisebhiya":"sr",
        "סערביש":"sr",
        "ara serbia":"sr",
        "i-serbian":"sr",
        "sotho":"st",
        "sesotho":"st",
        "سيسوتو":"st",
        "sesoto":"st",
        "сясота":"st",
        "সেসোথো":"st",
        "сесото":"st",
        "სესოტო":"st",
        "σεσότο":"st",
        "ששוטו":"st",
        "सेसोथो":"st",
        "セソト":"st",
        "ಸೆಸೊಥೊ":"st",
        "소토":"st",
        "സെസോതോ":"st",
        "နှမ်း":"st",
        "ସେସୋଥୋ |":"st",
        "سیسوتو":"st",
        "سسوتو":"st",
        "ਸੇਸੋਥੋ":"st",
        "сесотхо":"st",
        "سٿسو":"st",
        "సెసోతో":"st",
        "vừng":"st",
        "isesotho":"st",
        "shona":"sn",
        "ሻና":"sn",
        "الشونا":"sn",
        "şona":"sn",
        "шона":"sn",
        "শোনা":"sn",
        "ŝona":"sn",
        "შონა":"sn",
        "σόνα":"sn",
        "શોના":"sn",
        "שונה":"sn",
        "शोना":"sn",
        "ショナ":"sn",
        "ಶೋನಾ":"sn",
        "쇼나":"sn",
        "сранан-тонго":"sn",
        "šona":"sn",
        "ഷോന":"sn",
        "ଶୋନା |":"sn",
        "شونا":"sn",
        "ਸ਼ੋਨਾ":"sn",
        "схона":"sn",
        "ෂෝනා":"sn",
        "ஷோனா":"sn",
        "โชนา":"sn",
        "sindhi":"sd",
        "ስንድሂ":"sd",
        "السندية":"sd",
        "сіндзі":"sd",
        "সিন্ধি":"sd",
        "синдхи":"sd",
        "sindysk":"sd",
        "სინდური":"sd",
        "σίντι":"sd",
        "સિંધી":"sd",
        "kiniki":"sd",
        "סינדי":"sd",
        "सिंधी":"sd",
        "szindhi":"sd",
        "シンド語":"sd",
        "ಸಿಂಧಿ":"sd",
        "синди":"sd",
        "ស៊ីនឌី":"sd",
        "신디":"sd",
        "sindî":"sd",
        "синдиче":"sd",
        "sindhiana":"sd",
        "സിന്ധി":"sd",
        "စင်ဒီ":"sd",
        "सिन्धी":"sd",
        "ସିନ୍ଧି |":"sd",
        "سندي":"sd",
        "سندی":"sd",
        "sindi":"sd",
        "ਸਿੰਧੀ":"sd",
        "sindeach":"sd",
        "chisindhi":"sd",
        "සින්දි":"sd",
        "sindhčina":"sd",
        "சிந்தி":"sd",
        "సింధీ":"sd",
        "สินธุ":"sd",
        "синді":"sd",
        "سندھی":"sd",
        "سىندى":"sd",
        "sinhala":"si",
        "ሲንሃላ":"si",
        "السنهالية":"si",
        "сінгала":"si",
        "সিংহলী":"si",
        "синхалска":"si",
        "cinghalais":"si",
        "სინჰალა":"si",
        "singhalesisch":"si",
        "σινάλα":"si",
        "સિહલા":"si",
        "סינהלה":"si",
        "सिंहली":"si",
        "singalese":"si",
        "シンハラ語":"si",
        "ಸಿಂಹಳ":"si",
        "синхала":"si",
        "신 할라 어":"si",
        "сихала":"si",
        "സിംഹള":"si",
        "ဆင်ဟွာ":"si",
        "singalesiske":"si",
        "ସିହ୍ନା":"si",
        "سینهاله":"si",
        "سیناله":"si",
        "cingalês":"si",
        "سنهالا":"si",
        "සිංහල":"si",
        "sinhálčina":"si",
        "cingalés":"si",
        "சிங்கள":"si",
        "సింహళం":"si",
        "สิงหล":"si",
        "сингала":"si",
        "slovak":"sk",
        "sllovak":"sk",
        "ስሎቫክ":"sk",
        "السلوفاكية":"sk",
        "славацкі":"sk",
        "slovački":"sk",
        "словашки":"sk",
        "eslovac":"sk",
        "sluvaccu":"sk",
        "slowaaks":"sk",
        "slovaka":"sk",
        "slovakian":"sk",
        "slovaque":"sk",
        "slowaaksk":"sk",
        "სლოვაკური":"sk",
        "slowakisch":"sk",
        "σλοβάκος":"sk",
        "કેટલોગ":"sk",
        "kolowakia":"sk",
        "סלובקית":"sk",
        "teb chaws mekas":"sk",
        "szlovák":"sk",
        "slóvakía":"sk",
        "orang slovakia":"sk",
        "slovacca":"sk",
        "スロバキア語":"sk",
        "ಸ್ಲೋವಾಕ್":"sk",
        "словак":"sk",
        "ស្លូវ៉ាគី":"sk",
        "슬로바키아 사람":"sk",
        "slovakî":"sk",
        "словакча":"sk",
        "ສະໂລວາກີ":"sk",
        "moravica":"sk",
        "slovāks":"sk",
        "slovakas":"sk",
        "slowakesch":"sk",
        "словачки":"sk",
        "silaovaka":"sk",
        "സ്ലോവാക്":"sk",
        "slovakk":"sk",
        "झटपट":"sk",
        "ဆလိုဗက်ကီးယား":"sk",
        "प्यालास":"sk",
        "ସ୍ଲୋଭାକ୍":"sk",
        "سلواکي":"sk",
        "اسلواکی":"sk",
        "słowacki":"sk",
        "eslovaca":"sk",
        "ਕੈਟਲੋਜ਼":"sk",
        "slovacă":"sk",
        "словацкий":"sk",
        "slovacanach":"sk",
        "chislovak":"sk",
        "سلوويڪي":"sk",
        "slovenský":"sk",
        "slovaški":"sk",
        "ஸ்லோவாக்":"sk",
        "สโลวาเกีย":"sk",
        "словацький":"sk",
        "ذخیرے":"sk",
        "slovakia":"sk",
        "סלאָוואַקיש":"sk",
        "isiqubulo":"sk",
        "slovenian":"sl",
        "slloven":"sl",
        "ስሎቬንያን":"sl",
        "السلوفانية":"sl",
        "sloven":"sl",
        "славен":"sl",
        "slovenački":"sl",
        "словенски":"sl",
        "drac":"sl",
        "chilozi":"sl",
        "sluvenu":"sl",
        "slovenac":"sl",
        "sloveens":"sl",
        "tial":"sl",
        "sloveenlane":"sl",
        "slovène":"sl",
        "sloveensk":"sl",
        "ნიდერლანდური":"sl",
        "slowenisch":"sl",
        "σλοβενικά":"sl",
        "સંદેશ":"sl",
        "yar kasar slovenian":"sl",
        "kolewenia":"sl",
        "סלובנית":"sl",
        "szlovén":"sl",
        "slóvenía":"sl",
        "onye nke slovenian":"sl",
        "jorok":"sl",
        "slovena":"sl",
        "スロベニア語":"sl",
        "ಸ್ಲೊವೇನಿಯನ್":"sl",
        "словен":"sl",
        "슬로베니아":"sl",
        "slovenî":"sl",
        "словенияча":"sl",
        "carnica":"sl",
        "slovēņu":"sl",
        "slovėnų":"sl",
        "slowenesch":"sl",
        "словенечки":"sl",
        "slovenianina":"sl",
        "സ്ലൊവേനിയൻ":"sl",
        "għalhekk":"sl",
        "संदेश":"sl",
        "словени хэл":"sl",
        "ထောက်ပံ့":"sl",
        "ब्राउज":"sl",
        "ସ୍ଲୋଭେନିଆନ୍":"sl",
        "سلوانیایی":"sl",
        "اسلوونی":"sl",
        "słoweński":"sl",
        "eslovena":"sl",
        "ਸੰਗੀਤ":"sl",
        "словенский":"sl",
        "slobhenianach":"sl",
        "словеначки":"sl",
        "seromania":"ro",
        "chislovanian":"sl",
        "سلوويني":"sl",
        "slovinčina":"sl",
        "slovenščina":"sl",
        "kislovenia":"sl",
        "словенӣ":"sl",
        "ஸ்லோவேனியன்":"sl",
        "ภาษาสโลเวเนีย":"sl",
        "словенська":"sl",
        "بانٹیں":"sl",
        "سىلوۋېنىيە":"sl",
        "slovencha":"sl",
        "סלאוועניש":"sl",
        "alade":"sl",
        "isilozi":"sl",
        "somaliese":"so",
        "somali":"so",
        "ሶማሌ":"so",
        "الصومالية":"so",
        "somaliako":"so",
        "самалійскія":"so",
        "সোমালী":"so",
        "somalijski":"so",
        "сомалийски":"so",
        "somalianu":"so",
        "somalisch":"so",
        "somalysk":"so",
        "სომალი":"so",
        "σομαλοί":"so",
        "સોમાલી":"so",
        "dan somaliya":"so",
        "ōlelo somalia":"so",
        "סומאלי":"so",
        "सोमाली":"so",
        "szomáli":"so",
        "sómalíu":"so",
        "onye igbo":"so",
        "somala":"so",
        "ソマリ語":"so",
        "ಸೊಮಾಲಿ":"so",
        "сомали":"so",
        "소말리아":"so",
        "somalîkî":"so",
        "сомаличе":"so",
        "somalis":"so",
        "somalesch":"so",
        "സോമാലി":"so",
        "ဆိုမာလီ":"so",
        "ସୋମାଲି":"so",
        "سومالیایی":"so",
        "سومالی":"so",
        "ਸੋਮਾਲੀ":"so",
        "сомалийский":"so",
        "somari":"so",
        "صومالي":"so",
        "සෝමාලි":"so",
        "somálsky":"so",
        "somalí":"so",
        "сомалӣ":"so",
        "சோமாலி":"so",
        "సోమాలి":"so",
        "โซมาลี":"so",
        "сомалі":"so",
        "صومالی":"so",
        "tiếng somalia":"so",
        "somalïaidd":"so",
        "isisomali":"so",
        "spaans":"es",
        "spanjisht":"es",
        "ስፓንኛ":"es",
        "الأسبانية":"es",
        "ispan":"es",
        "gaztelania":"es",
        "іспанскі":"es",
        "স্পেনীয়":"es",
        "španski":"es",
        "испански":"es",
        "espanyol":"es",
        "spanish":"es",
        "spagnolu":"es",
        "španjolski":"es",
        "hispana":"es",
        "hispaania keeles":"es",
        "espanja":"es",
        "espagnol":"es",
        "spaansk":"es",
        "ესპანური":"es",
        "spanisch":"es",
        "ισπανικά":"es",
        "સ્પૅનિશ":"es",
        "panyòl":"es",
        "kepania":"es",
        "ספרדית":"es",
        "स्पेनिश":"es",
        "spanyol":"es",
        "spænska, spænskt":"es",
        "orang spanyol":"es",
        "spainnis":"es",
        "spagnola":"es",
        "スペイン語":"es",
        "ಸ್ಪ್ಯಾನಿಷ್":"es",
        "испан":"es",
        "ភាសាអេស្ប៉ាញ":"es",
        "스페인의":"es",
        "îspanyolî":"es",
        "испанча":"es",
        "ແອສປາໂຍນ":"es",
        "spāņu":"es",
        "ispanų":"es",
        "spuenesch":"es",
        "шпански":"es",
        "fikarohana":"es",
        "സ്പാനിഷ്":"es",
        "spanjol":"es",
        "स्पॅनिश":"es",
        "испани":"es",
        "စပိန်ဘာသာ":"es",
        "spansk":"es",
        "ସ୍ପାନିସ୍":"es",
        "هسپانیه ایی":"es",
        "اسپانیایی":"es",
        "hiszpański":"es",
        "espanhola":"es",
        "ਸਪੈਨਿਸ਼":"es",
        "spaniolă":"es",
        "испанский":"es",
        "sipaniolo":"es",
        "spàinneach":"es",
        "sepanishe":"es",
        "chispanish":"es",
        "اندلسي":"es",
        "ස්පාඤ්ඤ":"es",
        "španielsky":"es",
        "española":"es",
        "kihispania":"es",
        "spanska":"es",
        "испанӣ":"es",
        "ஸ்பானிஷ்":"es",
        "สเปน":"es",
        "i̇spanyol":"es",
        "іспанська":"es",
        "ہسپانوی":"es",
        "ئىسپانىيە":"es",
        "người tây ban nha":"es",
        "sbaen":"es",
        "שפּאַניש":"es",
        "sipaki":"es",
        "soendanees":"su",
        "sundanezisht":"su",
        "ሳንዲሽኛ":"su",
        "السندانية":"su",
        "sundanese":"su",
        "sundanera":"su",
        "суданскі":"su",
        "সুদানী":"su",
        "sundanski":"su",
        "сундански":"su",
        "sundanès":"su",
        "sundan":"su",
        "ma sundanese":"su",
        "sundanees":"su",
        "sunda":"su",
        "sundanais":"su",
        "სუნდური":"su",
        "sundanesisch":"su",
        "σουντάνικα":"su",
        "સુન્ડાનિઝ":"su",
        "luanaka":"su",
        "סנדנית":"su",
        "सुंडानी":"su",
        "sudanese":"su",
        "スンダ語":"su",
        "순 다어":"su",
        "сунданча":"su",
        "sundanica":"su",
        "saulėlydis":"su",
        "сундан":"su",
        "सुंडनीज":"su",
        "нардан":"su",
        "ဆူဒန်":"su",
        "सून्डानीज":"su",
        "ସୁନ୍ଦରୀ":"su",
        "سوډاني":"su",
        "ساندانی":"su",
        "sundańczyk":"su",
        "ਸਨਡੇਨੀਜ਼":"su",
        "sundaneză":"su",
        "суданский":"su",
        "satani":"su",
        "сунданесе":"su",
        "سنڊينيز":"su",
        "sundčina":"su",
        "sundanés":"su",
        "sundanesiska":"su",
        "சண்டானீஸ்":"su",
        "ซุนดา":"su",
        "сунданський":"su",
        "سنڈنیز":"su",
        "isundanese":"su",
        "ede sundanese":"su",
        "swahili":"sw",
        "ስዋሕሊ":"sw",
        "السواحيلية":"sw",
        "suahili":"sw",
        "злучыць":"sw",
        "সোয়াহিলি":"sw",
        "smeše":"sw",
        "суахили":"sw",
        "chiswahili":"sw",
        "svahila":"sw",
        "suahiili keel":"sw",
        "swahily":"sw",
        "სუაჰილი":"sw",
        "σουαχίλι":"sw",
        "દૈવી":"sw",
        "kawahili":"sw",
        "סוואלי":"sw",
        "sw sw":"sw",
        "szuahéli":"sw",
        "svahaílis":"sw",
        "スワヒリ語":"sw",
        "ಸ್ವಹಿಲಿ":"sw",
        "ស្វាហ៊ីលី":"sw",
        "스와힐리어":"sw",
        "swahîlîyî":"sw",
        "свахиличе":"sw",
        "sw swing":"sw",
        "svahili":"sw",
        "свахили":"sw",
        "സ്വാഹിലി":"sw",
        "कृती":"sw",
        "швахили хэл":"sw",
        "ဆွာဟီလီ":"sw",
        "मेसिन":"sw",
        "سواحلي":"sw",
        "سواحیلی":"sw",
        "suaíli":"sw",
        "ਪਕਵਾਨ":"sw",
        "swahilieach":"sw",
        "seswahili":"sw",
        "سواهلي":"sw",
        "ස්වහීලී":"sw",
        "mešanica":"sw",
        "kiswahili":"sw",
        "своҳили":"sw",
        "சுவாஹிலி":"sw",
        "ภาษาสวาฮิลี":"sw",
        "суміш":"sw",
        "مرکب":"sw",
        "suaxili":"sw",
        "đổ":"sw",
        "סאליש":"sw",
        "isi-swahili":"sw",
        "sweeds":"sv",
        "suedez":"sv",
        "ስዊድንኛ":"sv",
        "السويدية":"sv",
        "şved":"sv",
        "swedish":"sv",
        "шведская":"sv",
        "সুইডিশ":"sv",
        "švedski":"sv",
        "шведски":"sv",
        "suec":"sv",
        "nag-swedish":"sv",
        "chilengedwe":"sv",
        "svedese":"sv",
        "zweeds":"sv",
        "sveda":"sv",
        "rootsi":"sv",
        "ruotsin kieli":"sv",
        "suédoise":"sv",
        "sweedsk":"sv",
        "შვედური":"sv",
        "schwedisch":"sv",
        "σουηδικά":"sv",
        "સ્વીડિશ":"sv",
        "suedwa":"sv",
        "kuekene":"sv",
        "שוודית":"sv",
        "स्वीडिश":"sv",
        "svéd":"sv",
        "sænsku":"sv",
        "orang swedia":"sv",
        "スウェーデンの":"sv",
        "ಸ್ವಿಚ್":"sv",
        "швед":"sv",
        "스웨덴어":"sv",
        "swêdî":"sv",
        "шведче":"sv",
        "zviedri":"sv",
        "švedų":"sv",
        "schweedesch":"sv",
        "സ്വീഡിഷ്":"sv",
        "svediż":"sv",
        "шуугиантай":"sv",
        "ဆွီဒင်":"sv",
        "svensk":"sv",
        "ସ୍ୱିଡିଶ୍ |":"sv",
        "سوئدی":"sv",
        "szwedzki":"sv",
        "sueca":"sv",
        "ਸਿਡਿਸੀ":"sv",
        "шведский":"sv",
        "suaineach":"sv",
        "leholimo":"sv",
        "chiswedish":"sv",
        "سويڊني":"sv",
        "පැද්දීම":"sv",
        "švédsky":"sv",
        "ulimwengu":"sv",
        "svenska":"sv",
        "ஸ்விட்ச்":"sv",
        "สวีเดน":"sv",
        "i̇sveççe":"sv",
        "шведська":"sv",
        "سویڈش":"sv",
        "shved":"sv",
        "thụy điển":"sv",
        "שוועדיש":"sv",
        "izulu":"sv",
        "tajik":"tg",
        "taxhik":"tg",
        "ታጂክ":"tg",
        "طاجيك":"tg",
        "tacik":"tg",
        "таджыкскі":"tg",
        "তাজিক":"tg",
        "таджикски":"tg",
        "tadžički":"tg",
        "tadžik":"tg",
        "tadzhikistanin":"tg",
        "tadjik":"tg",
        "ტაჯიკი":"tg",
        "tadschikisch":"tg",
        "τατζίκ":"tg",
        "તાજિક":"tg",
        "טג'יק":"tg",
        "ताजिक":"tg",
        "tádzsik":"tg",
        "タジク語":"tg",
        "ತಾಜಿಕ್":"tg",
        "тәжік":"tg",
        "타직":"tg",
        "памирлик кыргыздар":"tg",
        "tadžiks":"tg",
        "tadžikų":"tg",
        "тајкик":"tg",
        "താജിക്":"tg",
        "तजिक":"tg",
        "тажик":"tg",
        "ତାଜିକ୍":"tg",
        "تاجيک":"tg",
        "تاجیک":"tg",
        "tadżycki":"tg",
        "tajique":"tg",
        "ਤਾਜਿਕ":"tg",
        "tadjică":"tg",
        "таджикский":"tg",
        "тајик":"tg",
        "tadžické":"tg",
        "tayika":"tg",
        "tadzjikiska":"tg",
        "точики":"tg",
        "தாஜிக்":"tg",
        "తజిక్":"tg",
        "ทาจิกิสถาน":"tg",
        "таджик":"tg",
        "تاجک":"tg",
        "تاجىك":"tg",
        "tojik":"tg",
        "tamil":"ta",
        "ታሚል":"ta",
        "التاميل":"ta",
        "таміл":"ta",
        "তামিল":"ta",
        "тамилски":"ta",
        "tamyl":"ta",
        "ტამილი":"ta",
        "ταμίλ":"ta",
        "તામિલ":"ta",
        "kamili":"ta",
        "טמיל":"ta",
        "タミル語":"ta",
        "ತಮಿಳು":"ta",
        "тамил":"ta",
        "타밀 사람":"ta",
        "tamîlî":"ta",
        "тамилче":"ta",
        "tamils":"ta",
        "tamilis":"ta",
        "തമിഴ്":"ta",
        "तमिळ":"ta",
        "တမာ":"ta",
        "तामिल":"ta",
        "تامیل":"ta",
        "tâmil":"ta",
        "ਤਾਮਿਲ":"ta",
        "тамильский":"ta",
        "tamileach":"ta",
        "chitamil":"ta",
        "تاملي":"ta",
        "දෙමළ":"ta",
        "தமிழ்":"ta",
        "తమిళ":"ta",
        "มิลักขะ":"ta",
        "تمل":"ta",
        "telugu":"te",
        "ተሉጉ":"te",
        "التيلجو":"te",
        "тэлугу":"te",
        "তেলুগু":"te",
        "телугу":"te",
        "telugua":"te",
        "ტელუგუ":"te",
        "τελούγκου":"te",
        "તેલુગુ":"te",
        "keluku":"te",
        "טלוגו":"te",
        "तेलुगू":"te",
        "ತೆಲುಗು":"te",
        "តេលូហ្គូ":"te",
        "텔루구 어":"te",
        "teluguyî":"te",
        "телугуча":"te",
        "телегу":"te",
        "തെലുങ്ക്":"te",
        "तेलगु":"te",
        "တယ်လီဂူ":"te",
        "तेलुगु":"te",
        "ତେଲୁଗୁ":"te",
        "تولیګو":"te",
        "تلوگو":"te",
        "ਤੇਲਗੂ":"te",
        "telugach":"te",
        "chitelugu":"te",
        "تيلوگو ٻولي":"te",
        "තෙළිඟු":"te",
        "தெலுங்கு":"te",
        "తెలుగు":"te",
        "กู":"te",
        "تلگو":"te",
        "thai":"th",
        "ታይ":"th",
        "التايلاندية":"th",
        "tay":"th",
        "тайская":"th",
        "থাই":"th",
        "tajlandski":"th",
        "тайландски":"th",
        "tailandès":"th",
        "thais":"th",
        "taja":"th",
        "tai":"th",
        "thaïlandais":"th",
        "taisk":"th",
        "ტაილანდური":"th",
        "thailändisch":"th",
        "ταϊλανδικά":"th",
        "થાઇ":"th",
        "kailani":"th",
        "תאילנדי":"th",
        "थाई":"th",
        "thaib":"th",
        "taílensku":"th",
        "タイ語":"th",
        "ಥಾಯ್":"th",
        "тай":"th",
        "ថៃ":"th",
        "타이":"th",
        "thayîkî":"th",
        "тайча":"th",
        "ໄທ":"th",
        "taizemietis":"th",
        "тајландски":"th",
        "തായ്":"th",
        "tajlandiż":"th",
        "ထိုင်း":"th",
        "ଥାଇ":"th",
        "تای":"th",
        "تایلندی":"th",
        "tajski":"th",
        "tailandesa":"th",
        "ਥਾਈ":"th",
        "tailandez":"th",
        "тайский":"th",
        "faʻa thai":"th",
        "thaidheach":"th",
        "chithai":"th",
        "ٿائي ٻولي":"th",
        "තායි":"th",
        "tajska":"th",
        "tongo":"th",
        "тй":"th",
        "தாய்":"th",
        "ไทย":"th",
        "tayland":"th",
        "тайський":"th",
        "تھائی":"th",
        "تاي":"th",
        "thái lan":"th",
        "turkish":"tr",
        "ቱሪክሽ":"tr",
        "اللغة التركية":"tr",
        "türk":"tr",
        "турэцкі":"tr",
        "তুর্কী":"tr",
        "turski":"tr",
        "турски":"tr",
        "turc":"tr",
        "chitonki":"tr",
        "turcu":"tr",
        "turks":"tr",
        "turka":"tr",
        "türgi":"tr",
        "turque":"tr",
        "turksk":"tr",
        "თურქული":"tr",
        "türkisch":"tr",
        "τούρκικος":"tr",
        "તુર્કી":"tr",
        "tik":"tr",
        "טורקי":"tr",
        "तुर्की":"tr",
        "török":"tr",
        "tyrkneska":"tr",
        "turki":"tr",
        "tuircis":"tr",
        "トルコ語":"tr",
        "turis":"tr",
        "ಟರ್ಕಿಶ್":"tr",
        "түрік":"tr",
        "ទួរគី":"tr",
        "터키어":"tr",
        "tirkî":"tr",
        "түркчө":"tr",
        "turcorum":"tr",
        "turku":"tr",
        "turkų":"tr",
        "tierkesch":"tr",
        "tiorka":"tr",
        "ടർക്കിഷ്":"tr",
        "torok":"tr",
        "турк":"tr",
        "တူရကီ":"tr",
        "टर्की":"tr",
        "tyrkisk":"tr",
        "ତୁର୍କୀ":"tr",
        "ترکي":"tr",
        "ترکی":"tr",
        "turecki":"tr",
        "turca":"tr",
        "ਤੁਰਕੀ":"tr",
        "турецкий":"tr",
        "turisi":"tr",
        "turcach":"tr",
        "seterekere":"tr",
        "ترڪي":"tr",
        "තුර්කි":"tr",
        "turecký":"tr",
        "turško":"tr",
        "kituruki":"tr",
        "turkiska":"tr",
        "туркӣ":"tr",
        "துருக்கிய":"tr",
        "ตุรกี":"tr",
        "турецька":"tr",
        "turkcha":"tr",
        "thổ nhĩ kỳ":"tr",
        "twrceg":"tr",
        "i-turkish":"tr",
        "טערקיש":"tr",
        "tọki":"tr",
        "ukrainian":"uk",
        "ukrainas":"uk",
        "ዩክሬንያን":"uk",
        "الأوكرانية":"uk",
        "ukraynalı":"uk",
        "ўкраінскі":"uk",
        "ukrajinski":"uk",
        "украински":"uk",
        "ucraïnès":"uk",
        "ukaragwayon":"uk",
        "kukhulupirira":"uk",
        "ucraina":"uk",
        "oekraïens":"uk",
        "ukraina":"uk",
        "ukraina keel":"uk",
        "ukrainien":"uk",
        "oekraynsk":"uk",
        "უკრაინული":"uk",
        "ukrainisch":"uk",
        "ουκρανός":"uk",
        "તપાસ":"uk",
        "ukraine":"uk",
        "ukakaki":"uk",
        "אוקראינית":"uk",
        "यूक्रेनी":"uk",
        "suav teb":"uk",
        "ukrán":"uk",
        "úkraínskt":"uk",
        "orang ukraina":"uk",
        "ウクライナ語":"uk",
        "ಉಕ್ರೇನಿಯನ್":"uk",
        "украин":"uk",
        "អ៊ុយក្រែន":"uk",
        "우크라이나 인":"uk",
        "ûkraynî":"uk",
        "украинче":"uk",
        "ອູແກຣນ":"uk",
        "ukraiņu":"uk",
        "ukrainiečių":"uk",
        "ukrainesch":"uk",
        "okrainiana":"uk",
        "ഉക്രേനിയൻ":"uk",
        "ukrajni":"uk",
        "तपासणी":"uk",
        "украйн":"uk",
        "ယူကရိန်း":"uk",
        "अनुसन्धान":"uk",
        "ukrainsk":"uk",
        "اوکرایني":"uk",
        "اوکراینی":"uk",
        "ukraiński":"uk",
        "ucraniana":"uk",
        "ਜਾਂਚ":"uk",
        "ucrainean":"uk",
        "украинец":"uk",
        "ukaraina":"uk",
        "украјински":"uk",
        "tumelo":"uk",
        "kutenda":"uk",
        "يوڪرينين":"uk",
        "යුක්රේන":"uk",
        "ukrajinský":"uk",
        "ukrajinsko":"uk",
        "ucrania":"uk",
        "imani":"uk",
        "ukrainska":"uk",
        "украинӣ":"uk",
        "உக்ரேனிய":"uk",
        "ఉక్రేనియన్":"uk",
        "ยูเครน":"uk",
        "ukrayna":"uk",
        "українська":"uk",
        "تحقیقات":"uk",
        "ukrainalik":"uk",
        "inkolelo":"uk",
        "אוקרייניש":"uk",
        "ti ukarain":"uk",
        "ukukholwa":"uk",
        "oerdoe":"ur",
        "urdu":"ur",
        "ኡርዱ":"ur",
        "الأردية":"ur",
        "урду":"ur",
        "উর্দু":"ur",
        "ourdou":"ur",
        "ურდუ":"ur",
        "אורדו":"ur",
        "उर्दू":"ur",
        "úrdú":"ur",
        "ウルドゥー語":"ur",
        "ಉರ್ದು":"ur",
        "우르두어":"ur",
        "ûrdûyî":"ur",
        "урдуча":"ur",
        "ഉർദു":"ur",
        "උර්දු":"ur",
        "ఉర్దూ":"ur",
        "ภาษาอูรดู":"ur",
        "urduca":"ur",
        "tiếng urdu":"ur",
        "uyghur":"ug",
        "ujgur":"ug",
        "ኡይግሁር":"ug",
        "الأويغور":"ug",
        "uyğur":"ug",
        "uigur":"ug",
        "уйгур":"ug",
        "উইগুর":"ug",
        "уйгурски":"ug",
        "ujgurski":"ug",
        "uragano":"ug",
        "uiguur":"ug",
        "ouïghour":"ug",
        "oejgoersk":"ug",
        "უიღურ":"ug",
        "uigurisch":"ug",
        "ōlelo uyghur":"ug",
        "אוג'ור":"ug",
        "उईघुर":"ug",
        "ウイグル":"ug",
        "ಉಯಿಘರ್":"ug",
        "ұйғыр":"ug",
        "អយហ្គឺរ":"ug",
        "위구르어":"ug",
        "uygurî":"ug",
        "уйгурча":"ug",
        "uiguru":"ug",
        "uigūras":"ug",
        "uiguresch":"ug",
        "ујгур":"ug",
        "युगुर":"ug",
        "ဟုတ်တယ်":"ug",
        "उइघुर":"ug",
        "uighur":"ug",
        "اویغور":"ug",
        "ਉਇਗੂਰ":"ug",
        "уйгурский":"ug",
        "uikaha":"ug",
        "уигхур":"ug",
        "ugwa":"ug",
        "يوغور":"ug",
        "උයිගර්":"ug",
        "ujgurov":"ug",
        "వైఘుర్":"ug",
        "อุยกูร์":"ug",
        "uygur":"ug",
        "یوغور":"ug",
        "uyg'ur":"ug",
        "isiuyghur":"ug",
        "oesbekies":"uz",
        "uzbek":"uz",
        "ኡዝቤክ":"uz",
        "узбек":"uz",
        "উজবেকীয়":"uz",
        "узбекски":"uz",
        "uzbečki":"uz",
        "oezbeeks":"uz",
        "uzbekaj":"uz",
        "usbeki":"uz",
        "ouzbek":"uz",
        "უზბეკური":"uz",
        "usbekisch":"uz",
        "ουζμπεκιστάν":"uz",
        "ઉઝબેક":"uz",
        "uzbekyen":"uz",
        "אוזבקית":"uz",
        "उज़बेक":"uz",
        "üzbég":"uz",
        "úsbek":"uz",
        "ウズベク語":"uz",
        "ಉಜ್ಬೆಕ್":"uz",
        "өзбек":"uz",
        "우즈벡":"uz",
        "ozbekî":"uz",
        "өзбекче":"uz",
        "ອູເບເບ":"uz",
        "uzbecorum":"uz",
        "uzbeku":"uz",
        "uzbekas":"uz",
        "usbekesch":"uz",
        "узбекистански":"uz",
        "उझबॅक":"uz",
        "မင်္ဂလာပါ":"uz",
        "उज्बेक":"uz",
        "usbekiske":"uz",
        "ازبکي":"uz",
        "ازبک":"uz",
        "uzbecki":"uz",
        "uzbeque":"uz",
        "ਉਜ਼ਬੇਕ":"uz",
        "uzbec":"uz",
        "ازبڪ":"uz",
        "uzbeka":"uz",
        "อุซเบก":"uz",
        "özbekçe":"uz",
        "vietnamese":"vi",
        "vietnamisht":"vi",
        "ቪትናሜሴ":"vi",
        "الفيتنامية":"vi",
        "vyetnam":"vi",
        "в'етнамская":"vi",
        "vijetnamski":"vi",
        "виетнамски":"vi",
        "vietnamita":"vi",
        "vietnamees":"vi",
        "vietnami keel":"vi",
        "vietnamienne":"vi",
        "fietnam":"vi",
        "ვიეტნამის":"vi",
        "vietnamesisch":"vi",
        "βιετναμέζικα":"vi",
        "વિયેટનામ":"vi",
        "vyetnamyen":"vi",
        "laia":"vi",
        "ויאטנמית":"vi",
        "वियतनामी":"vi",
        "nyab laj":"vi",
        "vietnami":"vi",
        "víetnamskt":"vi",
        "orang vietnam":"vi",
        "ベトナム語":"vi",
        "ವಿಯೆಟ್ನಾಮೀಸ್":"vi",
        "вьетнамдық":"vi",
        "ប្រទេសវៀតណាម":"vi",
        "베트남어":"vi",
        "vîetnamî":"vi",
        "вьетнамча":"vi",
        "ປະເທດຫວຽດນາມ":"vi",
        "vietnamica":"vi",
        "vjetnamiešu":"vi",
        "vietnamiečių":"vi",
        "vietnamesesch":"vi",
        "vietnamiana":"vi",
        "വിയറ്റ്നാമീസ്":"vi",
        "vjetnamiż":"vi",
        "व्हिएतनामी":"vi",
        "вьетнам хэлтэй":"vi",
        "ဗီယက်နမ်လူမျိုး":"vi",
        "भियतनामी":"vi",
        "vietnamesisk":"vi",
        "ଭିଏତନାମ":"vi",
        "ویتنامي":"vi",
        "ویتنامی":"vi",
        "wietnamski":"vi",
        "ਵੀਅਤਨਾਮੀ":"vi",
        "вьетнамский":"vi",
        "вијетнамски":"vi",
        "ويٽنامي":"vi",
        "vietnamský":"vi",
        "vietnamski":"vi",
        "ветй":"vi",
        "வியட்நாமிய":"vi",
        "เวียตนาม":"vi",
        "vietnam":"vi",
        "в’єтнамська":"vi",
        "vyetnamlik":"vi",
        "tiếng việt":"vi",
        "welsh":"cy",
        "ዋልሽ":"cy",
        "تهرب من دفع الرهان":"cy",
        "вал":"cy",
        "vel":"cy",
        "уелски":"cy",
        "significat":"cy",
        "win":"cy",
        "sinceru":"cy",
        "velški":"cy",
        "signifa":"cy",
        "kõmri":"cy",
        "gallois":"cy",
        "უელსური":"cy",
        "walisisch":"cy",
        "δεν πληρώνω τα οφειλόμενα":"cy",
        "વિચાર":"cy",
        "galeri":"cy",
        "וולשית":"cy",
        "walesi":"cy",
        "velska":"cy",
        "breatnais":"cy",
        "ウェールズ":"cy",
        "ಉತ್ತಮ":"cy",
        "велш":"cy",
        "វ៉ែល":"cy",
        "웨일스 말":"cy",
        "galerkî":"cy",
        "валлийче":"cy",
        "ແວວ":"cy",
        "cambrica":"cy",
        "velsietis":"cy",
        "valų":"cy",
        "велшки":"cy",
        "valesa":"cy",
        "നല്ല":"cy",
        "tifsira":"cy",
        "विरघळली":"cy",
        "гэлээ":"cy",
        "ဝီလီ":"cy",
        "घन":"cy",
        "walisisk":"cy",
        "ୱେଲ୍ସ |":"cy",
        "ولش":"cy",
        "ویلتی":"cy",
        "walijski":"cy",
        "galês":"cy",
        "ਘੋਲ":"cy",
        "velșă":"cy",
        "валлийский":"cy",
        "uelese":"cy",
        "cuimreach":"cy",
        "вел":"cy",
        "mofumahatsana":"cy",
        "ويلش":"cy",
        "වේල්ස්":"cy",
        "waleský":"cy",
        "galesa":"cy",
        "bwana":"cy",
        "เวลส์":"cy",
        "sözünü tutmamak":"cy",
        "غور":"cy",
        "yaxshi":"cy",
        "người xứ wales":"cy",
        "cymraeg":"cy",
        "umnumzana":"cy",
        "àwæn":"cy",
        "i-win":"cy",
        "xhosa":"xh",
        "xhose":"xh",
        "ዛይሆሳ":"xh",
        "خوسا":"xh",
        "জোসা":"xh",
        "ксоски":"xh",
        "ჟოზა":"xh",
        "ખોસા":"xh",
        "ōlelo xhosa":"xh",
        "षोसा":"xh",
        "コーサ語":"xh",
        "ហ្សូសា":"xh",
        "코사":"xh",
        "xhosayî":"xh",
        "хосача":"xh",
        "јоза":"xh",
        "झोसा":"xh",
        "ဇို":"xh",
        "ژوسا":"xh",
        "ژوزا":"xh",
        "кос":"xh",
        "siosa":"xh",
        "zhosa":"xh",
        "кхоса":"xh",
        "โซซา":"xh",
        "ژھوسا":"xh",
        "isixhosa":"xh",
        "jiddisj":"yi",
        "jidish":"yi",
        "ዪዲሽ":"yi",
        "اليديشية":"yi",
        "yəhudi":"yi",
        "yiddish":"yi",
        "ідыш":"yi",
        "jidiš":"yi",
        "идиш":"yi",
        "yidià":"yi",
        "yuscita":"yi",
        "jiddisch":"yi",
        "jida":"yi",
        "იდიში":"yi",
        "γερμανοεβραϊκή διάλεκτος":"yi",
        "યીદ્દીન":"yi",
        "ʻōleʻele":"yi",
        "אִידִישׁ":"yi",
        "yuag":"yi",
        "jiddis":"yi",
        "jiddíska":"yi",
        "yiddi":"yi",
        "giúdais":"yi",
        "イディッシュ語":"yi",
        "ಯಿಡ್ಡಿಷ್":"yi",
        "យូយូ":"yi",
        "이디시":"yi",
        "yîddîşî":"yi",
        "идишче":"yi",
        "y yiddish":"yi",
        "jidišs":"yi",
        "jiddesch":"yi",
        "јидски":"yi",
        "yizjdi":"yi",
        "येडी":"yi",
        "ကရီ":"yi",
        "यिद्दिस":"yi",
        "یدیش":"yi",
        "ییدیش":"yi",
        "jidysz":"yi",
        "iídiche":"yi",
        "ਯਿਦਿ":"yi",
        "idiş":"yi",
        "fiafia":"yi",
        "јидиш":"yi",
        "يِدش":"yi",
        "yídish":"yi",
        "ядиш":"yi",
        "இத்திஷ்":"yi",
        "ยิดดิช":"yi",
        "eskenazi dili":"yi",
        "ідиш":"yi",
        "یدید":"yi",
        "yahudiy":"yi",
        "yidi":"yi",
        "yoruba":"yo",
        "ዮሩባ":"yo",
        "اليوروبا":"yo",
        "ёруба":"yo",
        "ইওরুবা":"yo",
        "йоруба":"yo",
        "youba":"yo",
        "joruba":"yo",
        "იორუბა":"yo",
        "γιορούμπα":"yo",
        "યોરૂબા":"yo",
        "יורובה":"yo",
        "योरूबा":"yo",
        "jórúba":"yo",
        "ヨルバ":"yo",
        "ಯೊರುಬಾ":"yo",
        "요 루바":"yo",
        "yorûbayî":"yo",
        "йорубача":"yo",
        "јоруба":"yo",
        "യൊറുബ":"yo",
        "ଓଡ଼ିଆ":"yo",
        "یوروبا":"yo",
        "ioruba":"yo",
        "ਯੋਰੂਬਾ":"yo",
        "malo":"yo",
        "иоруба":"yo",
        "يوورابا":"yo",
        "යොරුබා":"yo",
        "jorubština":"yo",
        "யோருப்பா":"yo",
        "yenyuba":"yo",
        "yekauba":"yo",
        "zulu":"zu",
        "ዙሉ":"zu",
        "الزولو":"zu",
        "зулу":"zu",
        "জুলু":"zu",
        "zoulou":"zu",
        "ზულუ":"zu",
        "ζουλού":"zu",
        "ઝુલુ":"zu",
        "זולו":"zu",
        "ज़ुलु":"zu",
        "súlú":"zu",
        "ズールー":"zu",
        "ಜುಲು":"zu",
        "ហ្សូលូ":"zu",
        "줄루 족":"zu",
        "зулуча":"zu",
        "zuluensis":"zu",
        "സുലു":"zu",
        "żulu":"zu",
        "झुलू":"zu",
        "ଜୁଲୁ":"zu",
        "زولو":"zu",
        "zulus":"zu",
        "ਜ਼ੁਲੂ":"zu",
        "зулус":"zu",
        "zulú":"zu",
        "ஜூலு":"zu",
        "జులు":"zu",
        "พวกสูลู":"zu",
        "zulu dili":"zu",
        "南非语":"af",
        "南非語":"af",
        "阿尔巴尼亚语":"sq",
        "阿爾巴尼亞語":"sq",
        "阿姆哈拉语":"am",
        "阿姆哈拉語":"am",
        "阿拉伯":"ar",
        "亚美尼亚语":"hy",
        "亞美尼亞語":"hy",
        "阿塞拜疆":"az",
        "巴斯克":"eu",
        "白俄罗斯语":"be",
        "白俄羅斯語":"be",
        "孟加拉":"bn",
        "波斯尼亚语":"bs",
        "波斯尼亞語":"bs",
        "保加利亚语":"bg",
        "保加利亞語":"bg",
        "加泰罗尼亚语":"ca",
        "加泰羅尼亞語":"ca",
        "tara":"iw",
        "宿务":"ceb",
        "宿務":"ceb",
        "奇切瓦":"ny",
        "简体中文":"zh-CN",
        "簡體中文":"zh-CN",
        "中国传统的":"zh-TW",
        "中國傳統的":"zh-TW",
        "科西嘉语":"co",
        "科西嘉語":"co",
        "orang korsika":"co",
        "克罗地亚语":"hr",
        "克羅地亞語":"hr",
        "捷克语":"cs",
        "捷克語":"cs",
        "丹麦语":"da",
        "丹麥語":"da",
        "荷兰语":"nl",
        "荷蘭語":"nl",
        "英语":"en",
        "世界语":"eo",
        "世界語":"eo",
        "爱沙尼亚语":"et",
        "愛沙尼亞語":"et",
        "菲律宾语":"tl",
        "菲律賓語":"tl",
        "芬兰":"fi",
        "芬蘭":"fi",
        "法国语":"fr",
        "法國語":"fr",
        "弗里斯兰语":"fy",
        "弗里斯蘭語":"fy",
        "加利西亚语":"gl",
        "加利西亞語":"gl",
        "乔治亚风格":"ka",
        "喬治亞風格":"ka",
        "德语":"de",
        "德語":"de",
        "希腊语":"el",
        "希臘語":"el",
        "גריכיש":"el",
        "古吉拉特语":"gu",
        "古吉拉特語":"gu",
        "海地克里奥尔语":"ht",
        "海地克里奧爾語":"ht",
        "哈萨":"ha",
        "哈薩":"ha",
        "夏威夷语":"haw",
        "夏威夷語":"haw",
        "希伯来语":"iw",
        "希伯來語":"iw",
        "印地语":"hi",
        "印地語":"hi",
        "苗语":"hmn",
        "苗語":"hmn",
        "匈牙利":"hu",
        "冰岛的":"is",
        "冰島的":"is",
        "伊博":"ig",
        "punahu":"ig",
        "印度尼西亚":"id",
        "印度尼西亞":"id",
        "inia":"id",
        "爱尔兰语":"ga",
        "愛爾蘭語":"ga",
        "waihoki":"ga",
        "义大利文":"it",
        "義大利文":"it",
        "italyano":"it",
        "日本":"ja",
        "hapani":"ja",
        "爪哇语":"jw",
        "爪哇語":"jw",
        "卡纳达语":"kn",
        "卡納達語":"kn",
        "哈萨克语":"kk",
        "哈薩克語":"kk",
        "高棉":"km",
        "韩国语":"ko",
        "韓國語":"ko",
        "koreano":"ko",
        "kuuriyaan":"ko",
        "库尔德（kurmanji）":"ku",
        "庫爾德（kurmanji）":"ku",
        "吉尔吉斯":"ky",
        "吉爾吉斯":"ky",
        "老挝":"lo",
        "老撾":"lo",
        "拉丁":"la",
        "拉脱维亚语":"lv",
        "拉脫維亞語":"lv",
        "立陶宛语":"lt",
        "立陶宛語":"lt",
        "lcapian":"lt",
        "lithuaniyaan":"lt",
        "卢森堡":"lb",
        "盧森堡":"lb",
        "whakapaipai":"lb",
        "马其顿语":"mk",
        "馬其頓語":"mk",
        "马尔加什":"mg",
        "馬爾加什":"mg",
        "kepincangan":"mg",
        "马来语":"ms",
        "馬來語":"ms",
        "马拉雅拉姆语":"ml",
        "馬拉雅拉姆語":"ml",
        "马耳他的":"mt",
        "馬耳他的":"mt",
        "mangere":"mt",
        "毛利语":"mi",
        "毛利語":"mi",
        "մաորի":"mi",
        "马拉地语":"mr",
        "馬拉地語":"mr",
        "մարաթի":"mr",
        "蒙":"mn",
        "orang mongolia":"mn",
        "մոնղոլական":"mn",
        "缅甸语":"my",
        "緬甸語":"my",
        "myanmar (բիրմայերեն)":"my",
        "尼泊尔语":"ne",
        "尼泊爾語":"ne",
        "նեպալի":"ne",
        "挪威":"no",
        "norwejiga":"no",
        "orang norway":"no",
        "նորվեգերեն":"no",
        "奥迪亚":"or",
        "奧迪亞":"or",
        "օդիա":"or",
        "普什图语":"ps",
        "普什圖語":"ps",
        "պասթո":"ps",
        "波斯语":"fa",
        "波斯語":"fa",
        "dhejis":"fa",
        "parsi":"fa",
        "պարսկերեն":"fa",
        "抛光":"pl",
        "拋光":"pl",
        "hāneanea":"pl",
        "boolis":"pl",
        "menggilap":"pl",
        "լեհական":"pl",
        "polaco":"pl",
        "葡萄牙语":"pt",
        "葡萄牙語":"pt",
        "harawana":"pt",
        "պորտուգալերեն":"pt",
        "portugués":"pt",
        "旁遮普语":"pa",
        "旁遮普語":"pa",
        "փանջաջին":"pa",
        "罗马尼亚语":"ro",
        "羅馬尼亞語":"ro",
        "romaniga":"ro",
        "orang romania":"ro",
        "ռումինական":"ro",
        "romanés":"ro",
        "俄语":"ru",
        "俄語":"ru",
        "ruushka":"ru",
        "orang rusia":"ru",
        "ռուսերեն":"ru",
        "萨摩亚语":"sm",
        "薩摩亞語":"sm",
        "սամոան":"sm",
        "苏格兰盖尔语":"gd",
        "蘇格蘭蓋爾語":"gd",
        "karoti gaelic":"gd",
        "塞尔维亚":"sr",
        "塞爾維亞":"sr",
        "սերբ":"sr",
        "serbio":"sr",
        "塞索托":"st",
        "սեսոտո":"st",
        "绍娜":"sn",
        "紹娜":"sn",
        "շոնա":"sn",
        "辛迪":"sd",
        "սինդհի":"sd",
        "辛哈拉":"si",
        "սինհալա":"si",
        "singalesisk":"si",
        "斯洛伐克文":"sk",
        "paheke":"sk",
        "սլովակ":"sk",
        "eslovaco":"sk",
        "slovák":"sk",
        "斯洛文尼亚文":"sl",
        "斯洛文尼亞文":"sl",
        "he rūriana":"sl",
        "halyeeyga":"sl",
        "orang slovenia":"sl",
        "սլանկ":"sl",
        "calado":"sl",
        "slovinský":"sl",
        "slovensk":"sl",
        "索马里":"so",
        "索馬里":"so",
        "սոմալի":"so",
        "somálský":"so",
        "西班牙文":"es",
        "pānuitia":"es",
        "isbaanish":"es",
        "sepanyol":"es",
        "իսպանական":"es",
        "español":"es",
        "španělština":"es",
        "dan":"da",
        "riwai":"su",
        "bahasa sunda":"su",
        "sundánský":"su",
        "sundanesisk":"su",
        "斯瓦希里语":"sw",
        "斯瓦希里語":"sw",
        "սուահիլի":"sw",
        "svahilština":"sw",
        "瑞典":"sv",
        "taiharo":"sv",
        "iswiidhishka":"sv",
        "swedia":"sv",
        "շվեդերեն":"sv",
        "sueco":"sv",
        "švédský":"sv",
        "塔吉克":"tg",
        "տաջիկ":"tg",
        "泰米尔语":"ta",
        "泰米爾語":"ta",
        "pahara":"ta",
        "տամիլ":"ta",
        "泰卢固语":"te",
        "泰盧固語":"te",
        "տելուգու":"te",
        "泰国":"th",
        "泰國":"th",
        "orang thailand":"th",
        "թայերեն":"th",
        "tailandés":"th",
        "tailandese":"th",
        "thaimaalainen":"th",
        "土耳其":"tr",
        "orang turki":"tr",
        "թուրքերեն":"tr",
        "turco":"tr",
        "turečtina":"tr",
        "turkki":"tr",
        "乌克兰":"uk",
        "烏克蘭":"uk",
        "iukereiniana":"uk",
        "yukreeniyaan":"uk",
        "orang ukraine":"uk",
        "ուկրաիներեն":"uk",
        "ucraíno":"uk",
        "ukrajinština":"uk",
        "ukrainalainen":"uk",
        "乌尔都语":"ur",
        "烏爾都語":"ur",
        "ուրդու":"ur",
        "维吾尔语":"ug",
        "維吾爾語":"ug",
        "ույղուր":"ug",
        "uiguro":"ug",
        "uiguuri":"ug",
        "乌兹别克语":"uz",
        "烏茲別克語":"uz",
        "orang uzbekistan":"uz",
        "ուզբեկ":"uz",
        "uzbekki":"uz",
        "越南语":"vi",
        "越南語":"vi",
        "bahasa vietnam":"vi",
        "վիետնամական":"vi",
        "vietnamština":"vi",
        "וויעטנאַמעזיש":"vi",
        "威尔士语":"cy",
        "威爾士語":"cy",
        "ուելսերեն":"cy",
        "significado":"cy",
        "velština":"cy",
        "gallese":"cy",
        "walesin":"cy",
        "וואָליש":"cy",
        "科萨":"xh",
        "科薩":"xh",
        "依地语":"yi",
        "依地語":"yi",
        "ngatu":"yi",
        "orang yiddish":"yi",
        "քրքական":"yi",
        "xudeu":"yi",
        "jiddiš":"yi",
        "ייִדיש":"yi",
        "约鲁巴":"yo",
        "約魯巴":"yo",
        "յորուբա":"yo",
        "祖鲁语":"zu",
        "祖魯語":"zu",
        "զուլու":"zu",
        "zulù":"zu",
        "אוֹטוֹמָטִי":"auto",
        "סִינִית":"zh-CN",
        "הארי":"ht",
        "קריאולית":"ht",
        "כּוּרדִי":"kurdish",
        "מיאנמר":"myanmar",
        "בורמזי":"burmese",
        "סקוטים":"gd",
        "גאלית":"gd",
        "motor":"auto",
        "auto":"auto",
        "ራስ-ሰር":"auto",
        "تلقاءي":"auto",
        "ավտո":"auto",
        "avtomatik":"auto",
        "аўто":"auto",
        "স্বয়ংক্রিয়":"auto",
        "автоматичен":"auto",
        "awto":"auto",
        "汽车":"auto",
        "汽車":"auto",
        "aŭtomobilo":"auto",
        "awtomatiko":"auto",
        "ავტო":"auto",
        "αυτο":"auto",
        "ઓટો":"auto",
        "oto":"auto",
        "atomatik":"auto",
        "mīkini":"auto",
        "אוטומטי":"auto",
        "ऑटो":"auto",
        "nws pib":"auto",
        "kocsi":"auto",
        "farartæki":"auto",
        "akpaaka":"auto",
        "mobil":"auto",
        "uathoibríoch":"auto",
        "オート":"auto",
        "otomatis":"auto",
        "ಸ್ವಯಂ":"auto",
        "автоматты":"auto",
        "រថយន្ត":"auto",
        "자동":"auto",
        "otomatê de":"auto",
        "унаам":"auto",
        "ລົດໃຫຍ່":"auto",
        "automatinis":"auto",
        "авто":"auto",
        "fiara":"auto",
        "kereta":"auto",
        "യാന്ത്രികം":"auto",
        "motuka":"auto",
        "အော်တို":"auto",
        "स्वत:":"auto",
        "ଅଟୋ":"auto",
        "ګاډی":"auto",
        "خودکار":"auto",
        "automatyczny":"auto",
        "ਆਟੋ":"auto",
        "taavale":"auto",
        "fèin-ghluasadach":"auto",
        "ауто":"auto",
        "خودڪار":"auto",
        "ස්වයංක්\u200dරීය":"auto",
        "avto":"auto",
        "bil":"auto",
        "худкор":"auto",
        "ஆட்டோ":"auto",
        "దానంతట అదే":"auto",
        "รถยนต์":"auto",
        "آٹو":"auto",
        "tự động":"auto",
        "iimoto":"auto",
        "outomatiese":"auto",
        "automatik":"auto",
        "አውቶማቲክ":"auto",
        "تلقائي":"auto",
        "ավտոմատ":"auto",
        "automatiko":"auto",
        "аўтаматычны":"auto",
        "automatski":"auto",
        "automàtica":"auto",
        "basi":"auto",
        "自动":"auto",
        "自動":"auto",
        "automaticu":"auto",
        "automatický":"auto",
        "automatisk":"auto",
        "automatisch":"auto",
        "automatic":"auto",
        "aŭtomata":"auto",
        "automaatne":"auto",
        "automaattinen":"auto",
        "automatique":"auto",
        "automatysk":"auto",
        "automático":"auto",
        "ავტომატური":"auto",
        "αυτόματο":"auto",
        "સ્વચાલિત":"auto",
        "otomatik":"auto",
        "otomatoma":"auto",
        "स्वचालित":"auto",
        "tsis siv neeg":"auto",
        "automatikus":"auto",
        "sjálfvirkt":"auto",
        "akpaka":"auto",
        "automatico":"auto",
        "ಸ್ವಯಂಚಾಲಿತ":"auto",
        "ដោយស្វ័យប្រវត្តិ":"auto",
        "자동적 인":"auto",
        "otomatîkî":"auto",
        "автоматтык":"auto",
        "ອັດຕະໂນມັດ":"auto",
        "automātiska":"auto",
        "automatesch":"auto",
        "автоматски":"auto",
        "mandeha ho azy":"auto",
        "ഓട്ടോമാറ്റിക്":"auto",
        "awtomatiku":"auto",
        "aunoa":"auto",
        "स्वयंचलित":"auto",
        "автомат":"auto",
        "အလိုအလျောက်":"auto",
        "ସ୍ୱୟଂଚାଳିତ |":"auto",
        "اتوماتیک":"auto",
        "automática":"auto",
        "ਆਟੋਮੈਟਿਕ":"auto",
        "automat":"auto",
        "автоматический":"auto",
        "otometi":"auto",
        "аутоматски":"auto",
        "ka boiketsetso":"auto",
        "otomatiki":"auto",
        "samodejno":"auto",
        "otomatik ah":"auto",
        "moja kwa moja":"auto",
        "தானியங்கி":"auto",
        "ఆటోమేటిక్":"auto",
        "อัตโนมัติ":"auto",
        "автоматичний":"auto",
        "ئاپتوماتىك":"auto",
        "tự động":"auto",
        "awtomatig":"auto",
        "ngokuzenzekelayo":"auto",
        "אויטאָמאַטיש":"auto",
        "laifọwọyi":"auto",
        "okuzenzakalelayo":"auto",
        "opspoor outomaties":"auto",
        "zbuloni automatik":"auto",
        "ራስ-ሰር ያግኙ":"auto",
        "كشف تلقائي":"auto",
        "հայտնաբերել ավտոմատ":"auto",
        "avtomatik aşkar edin":"auto",
        "detektatu automatikoa":"auto",
        "выяўленне аўтаматычна":"auto",
        "স্বয়ংক্রিয় সনাক্ত":"auto",
        "otkrivanje automatski":"auto",
        "откриване автоматично":"auto",
        "detectar automàtica":"auto",
        "makit-an nga awtomatiko":"auto",
        "zindikirani zokha":"auto",
        "自动检测":"auto",
        "自動檢測":"auto",
        "detect automatico":"auto",
        "detektirati automatski":"auto",
        "detekovat automaticky":"auto",
        "registrere automatisk":"auto",
        "automatisch detecteren":"auto",
        "detect auto":"auto",
        "detekti aŭtomatan":"auto",
        "tuvastada automaatne":"auto",
        "awtomatikong tiktik":"auto",
        "havaita automaattinen":"auto",
        "détecter automatique":"auto",
        "automatysk detektearje":"auto",
        "detectar automático":"auto",
        "ავტომატური აღმოჩენა":"auto",
        "automatisch erkennen":"auto",
        "ανίχνευση αυτόματη":"auto",
        "આપોઆપ શોધો":"auto",
        "detekte otomatik":"auto",
        "gano atomatik":"auto",
        "ʻike maka":"auto",
        "לזהות אוטומטית":"auto",
        "स्वचालित पहचान करें":"auto",
        "kuaj xyuas auto":"auto",
        "érzékelni automatikus":"auto",
        "greina sjálfvirkt":"auto",
        "chọpụta akpaka":"auto",
        "deteksi otomatis":"auto",
        "uathoibríoch a bhrath":"auto",
        "rilevare automatico":"auto",
        "自動検出":"auto",
        "ndeteksi otomatis":"auto",
        "ಸ್ವಯಂಚಾಲಿತ ಪತ್ತೆ":"auto",
        "автоматты анықтау":"auto",
        "រកឃើញដោយស្វ័យប្រវត្តិ":"auto",
        "자동 감지":"auto",
        "otomatîk vedîtin":"auto",
        "автоматтык аныктоо":"auto",
        "ກວດພົບໂດຍອັດຕະໂນມັດ":"auto",
        "latae deprehendere":"auto",
        "noteikt automātisko":"auto",
        "aptikti automatinį":"auto",
        "detektéieren automatesch":"auto",
        "откривање на автоматско":"auto",
        "hitanao automatique":"auto",
        "mengesan automatik":"auto",
        "യാന്ത്രികം കണ്ടെത്തുക":"auto",
        "jiskopru awtomatiku":"auto",
        "kitea aunoa":"auto",
        "स्वयंचलितपणे शोधा":"auto",
        "автомат илрүүлэх":"auto",
        "အလိုအလျောက် detect":"auto",
        "स्वत: पत्ता लगाउनुहोस्":"auto",
        "oppdage automatisk":"auto",
        "ସ୍ୱୟଂଚାଳିତ ଚିହ୍ନଟ କରନ୍ତୁ |":"auto",
        "اتومات کشف کړئ":"auto",
        "تشخیص خودکار":"auto",
        "wykryj automatycznie":"auto",
        "ਆਟੋਮੈਟਿਕ ਖੋਜ":"auto",
        "detecta automat":"auto",
        "обнаружить автоматический":"auto",
        "iloa otometi":"auto",
        "lorg fèin-ghluasadach":"auto",
        "открива аутоматски":"auto",
        "lemoha ka boiketsetso":"auto",
        "ona otomatiki":"auto",
        "پنهنجو پاڻ سڃاڻڻ":"auto",
        "ස්වයංක්\u200dරීයව හඳුනා ගන්න":"auto",
        "detekovať automaticky":"auto",
        "zazna samodejno":"auto",
        "si toos ah u ogow":"auto",
        "detectar automática":"auto",
        "ngadeteksi otomatis":"auto",
        "gundua moja kwa moja":"auto",
        "upptäcka automatisk":"auto",
        "det худкор":"auto",
        "தானியங்கி கண்டறிய":"auto",
        "ఆటోమేటిక్ గుర్తించండి":"auto",
        "ตรวจจับอัตโนมัติ":"auto",
        "otomatik algılama":"auto",
        "виявити автоматично":"auto",
        "خودکار کا پتہ لگائیں":"auto",
        "ئاپتوماتىك بايقاش":"auto",
        "avtomatik aniqlash":"auto",
        "phát hiện tự động":"auto",
        "canfod awtomatig":"auto",
        "fumana ngokuzenzekelayo":"auto",
        "דיטעקט אָטאַמאַטיק":"auto",
        "ri adaṣe":"auto",
        "ukubona okuzenzakalelayo":"auto",
        "outomaties":"auto",
        "automatikisht":"auto",
        "በራስ-ሰር":"auto",
        "تلقائيا":"auto",
        "ինքնաբերաբար":"auto",
        "avtomatik olaraq":"auto",
        "automatikoki":"auto",
        "аўтаматычна":"auto",
        "স্বয়ংক্রিয়ভাবে":"auto",
        "автоматично":"auto",
        "automàticament":"auto",
        "自动地":"auto",
        "自動地":"auto",
        "automaticamente":"auto",
        "automatsko":"auto",
        "automaticky":"auto",
        "automatically":"auto",
        "aŭtomate":"auto",
        "automaatselt":"auto",
        "automaattisesti":"auto",
        "automatiquement":"auto",
        "ავტომატურად":"auto",
        "αυτομάτως":"auto",
        "આપમેળે":"auto",
        "otomatikman":"auto",
        "ta atomatik":"auto",
        "lolika":"auto",
        "באופן אוטומטי":"auto",
        "खुद ब खुद":"auto",
        "cia li tau":"auto",
        "automatikusan":"auto",
        "sjálfkrafa":"auto",
        "na-akpaghị aka":"auto",
        "secara otomatis":"auto",
        "go huathoibríoch":"auto",
        "自動的に":"auto",
        "kanthi otomatis":"auto",
        "ಸ್ವಯಂಚಾಲಿತವಾಗಿ":"auto",
        "автоматты түрде":"auto",
        "자동적으로":"auto",
        "bixweber":"auto",
        "жазуусу":"auto",
        "automatice":"auto",
        "automātiski":"auto",
        "automatiškai":"auto",
        "ho azy":"auto",
        "secara automatik":"auto",
        "ഓട്ടോമാറ്റിയ്ക്കായി":"auto",
        "awtomatikament":"auto",
        "आपोआप":"auto",
        "автоматаар":"auto",
        "ସ୍ୱୟଂଚାଳିତ ଭାବରେ |":"auto",
        "پخپله":"auto",
        "بطور خودکار":"auto",
        "automatycznie":"auto",
        "ਆਪਣੇ ਆਪ":"auto",
        "автоматически":"auto",
        "gu fèin-ghluasadach":"auto",
        "ka bohona":"auto",
        "پنهنجو پاڻ":"auto",
        "ස්වයංක්\u200dරීයව":"auto",
        "si otomaatig ah":"auto",
        "automáticamente":"auto",
        "automatiskt":"auto",
        "தானாக":"auto",
        "స్వయంచాలకంగా":"auto",
        "otomatik olarak":"auto",
        "خود بخود":"auto",
        "avtomatik ravishda":"auto",
        "yn awtomatig":"auto",
        "ngokuzenzakalelayo":"auto",
        "outomatiese opsporing":"auto",
        "zbulimi automatik":"auto",
        "ራስ-ሰር ምርመራ":"auto",
        "كشف أوتوماتيكي":"auto",
        "ավտոմատ հայտնաբերում":"auto",
        "avtomatik aşkarlama":"auto",
        "detekzio automatikoa":"auto",
        "аўтаматычнае выяўленне":"auto",
        "স্বয়ংক্রিয় সনাক্তকরণ":"auto",
        "automatsko otkrivanje":"auto",
        "автоматично откриване":"auto",
        "detecció automàtica":"auto",
        "awtomatik nga pagtuki":"auto",
        "kudziwika wokha":"auto",
        "rilevazione automatica":"auto",
        "automatická detekce":"auto",
        "automatisk detektion":"auto",
        "automatische detectie":"auto",
        "detection":"auto",
        "aŭtomata detekto":"auto",
        "automaatne tuvastamine":"auto",
        "awtomatikong pagtuklas":"auto",
        "automaattinen tunnistus":"auto",
        "détection automatique":"auto",
        "automatyske deteksje":"auto",
        "detección automática":"auto",
        "ავტომატური გამოვლენა":"auto",
        "automatische erkennung":"auto",
        "αυτόματη ανίχνευση":"auto",
        "સ્વચાલિત શોધ":"auto",
        "deteksyon otomatik":"auto",
        "ganowa ta atomatik":"auto",
        "ike maka":"auto",
        "גילוי אוטומטי":"auto",
        "स्वचालित पहचान":"auto",
        "auto nrhiav kom tau":"auto",
        "automatikus észlelés":"auto",
        "sjálfvirk uppgötvun":"auto",
        "nchọpụta akpaka":"auto",
        "braiteadh uathoibríoch":"auto",
        "rilevamento automatico":"auto",
        "ការរកឃើញដោយស្វ័យប្រវត្តិ":"auto",
        "tespîta otomatîk":"auto",
        "ການຊອກຄົ້ນຫາອັດຕະໂນມັດ":"auto",
        "latae deprehendatur":"auto",
        "automātiska noteikšana":"auto",
        "automatinis aptikimas":"auto",
        "automatesch detektioun":"auto",
        "автоматско откривање":"auto",
        "fahita otomana":"auto",
        "pengesanan automatik":"auto",
        "യാന്ത്രിക കണ്ടെത്തൽ":"auto",
        "sejbien awtomatiku":"auto",
        "te kitenga aunoa":"auto",
        "स्वयंचलित शोध":"auto",
        "အော်တိုထောက်လှမ်း":"auto",
        "स्वत: पत्ता लगाउने":"auto",
        "automatisk deteksjon":"auto",
        "ସ୍ୱୟଂଚାଳିତ ଚିହ୍ନଟ":"auto",
        "اتوماتیک کشف":"auto",
        "automatyczne wykrywanie":"auto",
        "detecção automática":"auto",
        "detectarea automată":"auto",
        "автоматическое обнаружение":"auto",
        "otometi iloa":"auto",
        "аутоматско откривање":"auto",
        "ho iponela":"auto",
        "otomatiki kuona":"auto",
        "پاڻمرادو ڳولڻ":"auto",
        "ස්වයංක්\u200dරීයව අනාවරණය කිරීම":"auto",
        "automatická detekcia":"auto",
        "avtomatsko zaznavanje":"auto",
        "ogaanshaha tooska ah":"auto",
        "kugunduliwa moja kwa moja":"auto",
        "automatisk upptäckt":"auto",
        "муайянкунии худкор":"auto",
        "தானியங்கி கண்டறிதல்":"auto",
        "ఆటోమేటిక్ డిటెక్షన్":"auto",
        "автоматичне виявлення":"auto",
        "خود کار طریقے سے پتہ لگانے":"auto",
        "tự động phát hiện":"auto",
        "canfod yn awtomatig":"auto",
        "ukubona ngokuzenzekelayo":"auto",
        "אָטאַמאַטיק דיטעקשאַן":"auto",
        "iwari aifọwọyi":"auto",
        "ukutholwa okuzenzakalelayo":"auto",
        "bespeur outomaties":"auto",
        "zbulohet automatikisht":"auto",
        "በራስ-ሰር ይወቁ":"auto",
        "كشف تلقائيا":"auto",
        "ինքնաբերաբար հայտնաբերել":"auto",
        "detektatu automatikoki":"auto",
        "выявіць аўтаматычна":"auto",
        "স্বয়ংক্রিয়ভাবে সনাক্ত":"auto",
        "otkrivaju automatski":"auto",
        "откриват автоматично":"auto",
        "detectar automàticament":"auto",
        "awtomatik nga namatikdan":"auto",
        "rileva automaticamente":"auto",
        "prepoznati automatski":"auto",
        "opdage automatisk":"auto",
        "automatic detection":"auto",
        "detekti aŭtomate":"auto",
        "tuvastada automaatselt":"auto",
        "tunnistaa automaattisesti":"auto",
        "détecter automatiquement":"auto",
        "detektearje automatysk":"auto",
        "detectar automaticamente":"auto",
        "ავტომატურად ამოცნობა":"auto",
        "ανιχνεύει αυτόματα":"auto",
        "આપમેળે શોધી કા .ો":"auto",
        "detekte otomatikman":"auto",
        "gano ta atomatik":"auto",
        "ʻike mau":"auto",
        "תגלה אוטומטית":"auto",
        "स्वचालित रूप से पता लगाएं":"auto",
        "ntes tau":"auto",
        "automatikusan felismeri":"auto",
        "greina sjálfkrafa":"auto",
        "ịchọpụta na akpaghị aka":"auto",
        "mendeteksi secara otomatis":"auto",
        "bhrath go huathoibríoch":"auto",
        "rilevare automaticamente":"auto",
        "自動的に検出":"auto",
        "ndeteksi kanthi otomatis":"auto",
        "ಸ್ವಯಂಚಾಲಿತವಾಗಿ ಪತ್ತೆ ಮಾಡಿ":"auto",
        "автоматты түрде анықтау":"auto",
        "bixwe çêdibe":"auto",
        "автоматтык түрдө аныктоо":"auto",
        "statim deprehendere":"auto",
        "noteikt automātiski":"auto",
        "aptikti automatiškai":"auto",
        "открие автоматски":"auto",
        "hitanao mandeha ho azy":"auto",
        "mengesan secara automatik":"auto",
        "യാന്ത്രികമായി കണ്ടെത്തുക":"auto",
        "jinduna awtomatikament":"auto",
        "автоматаар илрүүлэх":"auto",
        "ସ୍ୱୟଂଚାଳିତ ଭାବରେ ଚିହ୍ନଟ କରନ୍ତୁ |":"auto",
        "پخپله کشف":"auto",
        "به طور خودکار شناسایی شود":"auto",
        "wykryć automatycznie":"auto",
        "ਆਪਣੇ ਆਪ ਖੋਜ":"auto",
        "обнаруживать автоматически":"auto",
        "lorg gu fèin-ghluasadach":"auto",
        "откривају аутоматски":"auto",
        "lemoha ka bohona":"auto",
        "ziva pachako":"auto",
        "si otomaatig ah u ogow":"auto",
        "detectar automáticamente":"auto",
        "ngadeteksi sacara otomatis":"auto",
        "upptäcker automatiskt":"auto",
        "муайян худкор":"auto",
        "தானாகக் கண்டறியவும்":"auto",
        "స్వయంచాలకంగా గుర్తించండి":"auto",
        "ตรวจจับโดยอัตโนมัติ":"auto",
        "otomatik algıla":"auto",
        "خود بخود پتہ لگائیں":"auto",
        "avtomatik ravishda aniqlash":"auto",
        "דיטעקט אויטאָמאַטיש":"auto",
        "ri laifọwọyi":"auto",
        "bona ngokuzenzakalelayo":"auto",
        "chinese":"zh-CN",
        "kinez":"zh-CN",
        "صينى":"zh-CN",
        "txinatarra":"zh-CN",
        "চীনা":"zh-CN",
        "kineski":"zh-CN",
        "китайски":"zh-CN",
        "中文":"zh-CN",
        "čínština":"zh-CN",
        "kinesisk":"zh-CN",
        "ĉino":"zh-CN",
        "hiina":"zh-CN",
        "kiinalainen":"zh-CN",
        "chinoise":"zh-CN",
        "ჩინური":"zh-CN",
        "chinesisch":"zh-CN",
        "κινέζικα":"zh-CN",
        "ચાઇનીઝ":"zh-CN",
        "chinwa":"zh-CN",
        "kasar sin":"zh-CN",
        "pākē":"zh-CN",
        "चीनी":"zh-CN",
        "suav":"zh-CN",
        "kínai":"zh-CN",
        "kínverska":"zh-CN",
        "china":"zh-CN",
        "cina":"zh-CN",
        "sínis":"zh-CN",
        "中国の":"zh-CN",
        "ಚೈನೀಸ್":"zh-CN",
        "қытай":"zh-CN",
        "ភាសាចិន":"zh-CN",
        "중국말":"zh-CN",
        "çînî":"zh-CN",
        "кытайча":"zh-CN",
        "ຈີນ":"zh-CN",
        "seres":"zh-CN",
        "ķīniešu":"zh-CN",
        "kinų":"zh-CN",
        "chineesesch":"zh-CN",
        "кинески":"zh-CN",
        "sinoa":"zh-CN",
        "ചൈനീസ്":"zh-CN",
        "ċiniż":"zh-CN",
        "haehao":"zh-CN",
        "хятад":"zh-CN",
        "တရုတ်":"zh-CN",
        "चिनियाँ":"zh-CN",
        "kinesisk...":"zh-CN",
        "ଚାଇନିଜ୍...":"zh-CN",
        "چینی ها":"zh-CN",
        "chiński":"zh-CN",
        "chinesa":"zh-CN",
        "ਚੀਨੀ":"zh-CN",
        "chinez":"zh-CN",
        "китайский язык":"zh-CN",
        "saina":"zh-CN",
        "sìneach":"zh-CN",
        "chichinese":"zh-CN",
        "چيني":"zh-CN",
        "චීන":"zh-CN",
        "čínsky":"zh-CN",
        "kitajski":"zh-CN",
        "shiinaha":"zh-CN",
        "kichina":"zh-CN",
        "чинӣ":"zh-CN",
        "சீன":"zh-CN",
        "చైనీస్":"zh-CN",
        "ชาวจีน":"zh-CN",
        "çince":"zh-CN",
        "китайський":"zh-CN",
        "چینی":"zh-CN",
        "جۇڭگولۇق":"zh-CN",
        "xitoy":"zh-CN",
        "người trung quốc":"zh-CN",
        "tseiniaidd":"zh-CN",
        "isitshayina":"zh-CN",
        "isishayina":"zh-CN",
        "sjinees vereenvoudig":"zh-CN",
        "kineze e thjeshtuar":"zh-CN",
        "ቻይንኛ ቀለል ብሏል":"zh-CN",
        "الصينية المبسطة":"zh-CN",
        "չինական պարզեցված":"zh-CN",
        "çin sadələşdirilmiş":"zh-CN",
        "txinera sinplifikatu":"zh-CN",
        "кітайскі спрошчаны":"zh-CN",
        "সরলীকৃত চীনা":"zh-CN",
        "kineski pojednostavljen":"zh-CN",
        "опростен китайски":"zh-CN",
        "xinès simplificat":"zh-CN",
        "gipasimple sa mga babaye":"zh-CN",
        "chinese chosavuta":"zh-CN",
        "cinese simplificatu":"zh-CN",
        "pojednostavljeni kineski":"zh-CN",
        "zh-CN":"zh-CN",
        "simpligita ĉino":"zh-CN",
        "lihtsustatud hiina keel":"zh-CN",
        "pinasimple ng mga intsik":"zh-CN",
        "yksinkertaistettu kiina":"zh-CN",
        "sineesk ferienfâldige":"zh-CN",
        "simplificado chinés":"zh-CN",
        "გამარტივებული ჩინური":"zh-CN",
        "vereinfachtes chinesisch":"zh-CN",
        "απλοποιημένα κινέζικα":"zh-CN",
        "ચિની સરળ":"zh-CN",
        "chinwa senplifye":"zh-CN",
        "sauƙaƙe na sinanci":"zh-CN",
        "chinese maʻalahi":"zh-CN",
        "סינית מופשטת":"zh-CN",
        "सरलीकृत चीनी":"zh-CN",
        "suav yooj yim":"zh-CN",
        "kínai egyszerűsített":"zh-CN",
        "kínverji einfaldaður":"zh-CN",
        "china mfe":"zh-CN",
        "bahasa tiongkok yang disederhanakan":"zh-CN",
        "sínis simplithe":"zh-CN",
        "cinese semplificato":"zh-CN",
        "中国語（簡体字":"zh-CN",
        "wong cina disederhanakake":"zh-CN",
        "ಚೀನೀ ಸರಳೀಕರಿಸಲಾಗಿದೆ":"zh-CN",
        "қытай жеңілдетілген":"zh-CN",
        "ភាសាចិនសាមញ្ញ":"zh-CN",
        "중국어 (간체":"zh-CN",
        "çînî hêsan kir":"zh-CN",
        "кытай жөнөкөйлөтүлгөн":"zh-CN",
        "ຈີນລຽບງ່າຍ":"zh-CN",
        "ķīniešu vienkāršots":"zh-CN",
        "kinų supaprastinta":"zh-CN",
        "chinese vereinfacht":"zh-CN",
        "кинески поедноставено":"zh-CN",
        "vita sinoa":"zh-CN",
        "cina dipermudahkan":"zh-CN",
        "സുഗമമാക്കിയ ചൈനീസ്":"zh-CN",
        "ċiniż issimplifikat":"zh-CN",
        "hainamana whakatika":"zh-CN",
        "चीनी सरलीकृत":"zh-CN",
        "хятад хялбаршуулсан":"zh-CN",
        "တရုတ်ရိုးရှင်း":"zh-CN",
        "चिनियाँ सरलीकृत":"zh-CN",
        "forenklet kinesisk":"zh-CN",
        "ଚାଇନିଜ୍ ସରଳୀକୃତ |":"zh-CN",
        "چینایی ساده شوی":"zh-CN",
        "زبان چینی ساده شده":"zh-CN",
        "uproszczony chiński":"zh-CN",
        "chinês simplificado":"zh-CN",
        "ਚੀਨੀ ਸਧਾਰਨ":"zh-CN",
        "chineză simplificată":"zh-CN",
        "китайский упрощенный":"zh-CN",
        "faigofie saina":"zh-CN",
        "sìmpleachadh china":"zh-CN",
        "кинески поједностављен":"zh-CN",
        "se-chinese se nolofalitsoe":"zh-CN",
        "chinese chinorerutswa":"zh-CN",
        "چيني آسان ڪيل":"zh-CN",
        "චීන සරල":"zh-CN",
        "kitajsko poenostavljeno":"zh-CN",
        "shiinaha ayaa la fududeeyay":"zh-CN",
        "china simplificada":"zh-CN",
        "cina saderhana":"zh-CN",
        "kichina kilichorahisishwa":"zh-CN",
        "förenklad kinesiska":"zh-CN",
        "чинӣ содда карда шуд":"zh-CN",
        "சீன எளிமைப்படுத்தப்பட்டது":"zh-CN",
        "సులభమైన చైనా భాష":"zh-CN",
        "จีนตัวย่อ":"zh-CN",
        "basitleştirilmiş çince":"zh-CN",
        "китайський спрощений":"zh-CN",
        "آسان چینی زبان":"zh-CN",
        "جۇڭگو ئاددىيلاشتۇرۇلدى":"zh-CN",
        "xitoy soddalashtirilgan":"zh-CN",
        "tiếng trung giản thể":"zh-CN",
        "tsieineaidd wedi'i symleiddio":"zh-CN",
        "isi-chinese senziwe lula":"zh-CN",
        "סימפּליפיעד":"zh-CN",
        "ṣaina irọrun":"zh-CN",
        "vereenvoudigde sjinees":"zh-CN",
        "ቀለል ያለ ቻይንኛ":"zh-CN",
        "պարզեցված չինարեն":"zh-CN",
        "sadələşdirilmiş çin dili":"zh-CN",
        "txinera sinplifikatua":"zh-CN",
        "спрошчаны кітайскі":"zh-CN",
        "gipasimple nga intsik":"zh-CN",
        "vereenvoudigd chinees":"zh-CN",
        "pinasimple na chinese":"zh-CN",
        "ferienfâldige sineesk":"zh-CN",
        "chinés simplificado":"zh-CN",
        "સરળ ચીની":"zh-CN",
        "senplifye chinwa":"zh-CN",
        "mai sauƙin sinanci":"zh-CN",
        "simplish chinese":"zh-CN",
        "סינית פשוטה":"zh-CN",
        "simplified suav":"zh-CN",
        "egyszerűsített kínai":"zh-CN",
        "einfölduð kínverska":"zh-CN",
        "chinese dị mfe":"zh-CN",
        "cina disederhanakan":"zh-CN",
        "簡体字中国語":"zh-CN",
        "wong cina sing disederhanakake":"zh-CN",
        "ಸರಳೀಕೃತ ಚೈನೀಸ್":"zh-CN",
        "жеңілдетілген қытай":"zh-CN",
        "중국어 간체":"zh-CN",
        "çînî ya hêsan":"zh-CN",
        "жөнөкөйлөтүлгөн кытай":"zh-CN",
        "seres simplicior":"zh-CN",
        "vienkāršotā ķīniešu":"zh-CN",
        "supaprastinta kinų kalba":"zh-CN",
        "vereinfacht chinesesch":"zh-CN",
        "поедноставен кинески":"zh-CN",
        "sinoa tsotsotra":"zh-CN",
        "bahasa cina yang dipermudahkan":"zh-CN",
        "ലഘൂകരിച്ച ചൈനീസ്":"zh-CN",
        "ċiniż simplifikat":"zh-CN",
        "haapiha haafifi":"zh-CN",
        "सोपी चायनिज":"zh-CN",
        "хялбаршуулсан хятад":"zh-CN",
        "တရုတ်ဘာသာ":"zh-CN",
        "सरलीकृत चिनियाँ":"zh-CN",
        "ସରଳୀକୃତ ଚାଇନିଜ୍ |":"zh-CN",
        "ساده":"zh-CN",
        "چینی ساده شده":"zh-CN",
        "chiński uproszczony":"zh-CN",
        "ਸਧਾਰਨ ਚੀਨੀ":"zh-CN",
        "упрощенный китайский":"zh-CN",
        "sìneach simplichte":"zh-CN",
        "поједностављени кинески":"zh-CN",
        "se-chinese se nolofalitsoeng":"zh-CN",
        "chakareruka chinese":"zh-CN",
        "سليس چيني":"zh-CN",
        "සරල කළ චීන":"zh-CN",
        "poenostavljena kitajščina":"zh-CN",
        "shiinaha oo la fududeeyay":"zh-CN",
        "saderhana cina":"zh-CN",
        "чинии соддакардашуда":"zh-CN",
        "எளிமைப்படுத்தப்பட்ட சீன":"zh-CN",
        "సరళీకృత చైనీస్":"zh-CN",
        "спрощена китайська":"zh-CN",
        "آسان چینی":"zh-CN",
        "ئاددىيلاشتۇرۇلغان جۇڭگو":"zh-CN",
        "soddalashtirilgan xitoy":"zh-CN",
        "chinese eyenziwe lula":"zh-CN",
        "סימפּליפיעד כינעזיש":"zh-CN",
        "ṣaina ti dẹrọ":"zh-CN",
        "isi-chinese esenziwe lula":"zh-CN",
        "tradisionele sjinees":"zh-TW",
        "kineze tradicionale":"zh-TW",
        "ባህላዊ ቻይንኛ":"zh-TW",
        "الصينية التقليدية":"zh-TW",
        "ավանդական չինարեն":"zh-TW",
        "ənənəvi çin":"zh-TW",
        "txinatar tradizionala":"zh-TW",
        "традыцыйная кітайская":"zh-TW",
        "ঐতিহ্যবাহী চাইনিজ":"zh-TW",
        "tradicionalna kineska":"zh-TW",
        "традиционен китайски":"zh-TW",
        "xinés tradicional":"zh-TW",
        "tradisyonal nga chinese":"zh-TW",
        "zachikhalidwe zachikhalidwe":"zh-TW",
        "繁体中文":"zh-TW",
        "繁體中文":"zh-TW",
        "cinese tradiziunale":"zh-TW",
        "tradicionalni kineski":"zh-TW",
        "tradiční čínština":"zh-TW",
        "traditionelt kinesisk":"zh-TW",
        "traditioneel chinees":"zh-TW",
        "zh-TW":"zh-TW",
        "traditsiooniline hiina keel":"zh-TW",
        "tradisyunal na intsik":"zh-TW",
        "perinteinen kiina":"zh-TW",
        "chinois traditionnel":"zh-TW",
        "tradisjoneel sineesk":"zh-TW",
        "chinés tradicional":"zh-TW",
        "ტრადიციული ჩინური":"zh-TW",
        "traditionelles chinesisch":"zh-TW",
        "παραδοσιακά κινεζικά":"zh-TW",
        "પારંપરિક ચિની":"zh-TW",
        "chinwa tradisyonèl":"zh-TW",
        "gargajiya ta kasar sin":"zh-TW",
        "wahine kuʻuna":"zh-TW",
        "סינית מסורתית":"zh-TW",
        "परंपरागत चीनी":"zh-TW",
        "tsoos suav":"zh-TW",
        "tradicionális kínai":"zh-TW",
        "hefðbundinn kínverskur":"zh-TW",
        "ọdịnala ọdịnala":"zh-TW",
        "cina tradisional":"zh-TW",
        "sínis traidisiúnta":"zh-TW",
        "cinese tradizionale":"zh-TW",
        "繁体字中国語":"zh-TW",
        "tradisional cina":"zh-TW",
        "ಸಾಂಪ್ರದಾಯಿಕ ಚೈನೀಸ್":"zh-TW",
        "дәстүрлі қытай":"zh-TW",
        "ប្រពៃណីចិន":"zh-TW",
        "전통 중국어":"zh-TW",
        "çînî ya kevneşop":"zh-TW",
        "салттуу кытай":"zh-TW",
        "ປະເພນີຂອງຈີນ":"zh-TW",
        "traditional seres":"zh-TW",
        "tradicionālā ķīniešu":"zh-TW",
        "tradicinis kinietiškas":"zh-TW",
        "traditionell chineesesch":"zh-TW",
        "традиционален кинески":"zh-TW",
        "sinoa nentin-drazana":"zh-TW",
        "പരമ്പരാഗത ചൈനീസ്":"zh-TW",
        "ċiniż tradizzjonali":"zh-TW",
        "hainamana tuku iho":"zh-TW",
        "पारंपारिक चीनी":"zh-TW",
        "уламжлалт хятад":"zh-TW",
        "တရုတ်ရိုးရာ":"zh-TW",
        "परम्परागत चिनियाँ":"zh-TW",
        "tradisjonell kinesisk":"zh-TW",
        "ପାରମ୍ପାରିକ ଚାଇନିଜ୍ |":"zh-TW",
        "عنعنوي چینایي":"zh-TW",
        "چینی سنتی":"zh-TW",
        "tradycyjne chińskie":"zh-TW",
        "chinês tradicional":"zh-TW",
        "ਰਵਾਇਤੀ ਚੀਨੀ":"zh-TW",
        "chineză tradițională":"zh-TW",
        "традиционный китайский...":"zh-TW",
        "sìneach traidiseanta":"zh-TW",
        "традиционална кинеска":"zh-TW",
        "setso sa setso":"zh-TW",
        "chinese chinese":"zh-TW",
        "روايتي چيني":"zh-TW",
        "සාම්ප්රදායික චීන":"zh-TW",
        "tradičná čínština":"zh-TW",
        "tradicionalno kitajsko":"zh-TW",
        "shiinaha dhaqameed":"zh-TW",
        "chino tradicional":"zh-TW",
        "kichina cha jadi":"zh-TW",
        "traditionell kinesiska":"zh-TW",
        "хитои анъанавӣ":"zh-TW",
        "பாரம்பரிய சீன":"zh-TW",
        "సాంప్రదాయ చైనీస్":"zh-TW",
        "จีนตัวเต็ม":"zh-TW",
        "geleneksel çince":"zh-TW",
        "традиційний китайський":"zh-TW",
        "روایتی چینی":"zh-TW",
        "ئەنئەنىۋى جۇڭگو":"zh-TW",
        "an'anaviy xitoy":"zh-TW",
        "truyền thống trung quốc":"zh-TW",
        "tsieineaidd traddodiadol":"zh-TW",
        "ichinese yesintu":"zh-TW",
        "טראדיציאנעלן כינעזיש":"zh-TW",
        "ibile kannada":"zh-TW",
        "isishayina sendabuko":"zh-TW",
        "tradisionele chinese":"zh-TW",
        "tradita kineze":"zh-TW",
        "የቻይና ባህላዊ":"zh-TW",
        "تقاليد صينية":"zh-TW",
        "չինական ավանդական":"zh-TW",
        "çin ənənəvi":"zh-TW",
        "кітайскі традыцыйны":"zh-TW",
        "প্রথাগত চীনা":"zh-TW",
        "kineski tradicionalni":"zh-TW",
        "tradicional xinès":"zh-TW",
        "tradisyonal nga babaye":"zh-TW",
        "chinese zachikhalidwe":"zh-TW",
        "tradiziunale cinese":"zh-TW",
        "kinesko tradicionalno":"zh-TW",
        "čínské tradiční":"zh-TW",
        "kinesisk traditionel":"zh-TW",
        "chinese traditionele":"zh-TW",
        "tradisyonal na intsik":"zh-TW",
        "kiinalainen perinteinen":"zh-TW",
        "chinois (traditionnel":"zh-TW",
        "chinese tradisjoneel":"zh-TW",
        "tradicional chinés":"zh-TW",
        "ჩინური ტრადიციული":"zh-TW",
        "chinesische tradition":"zh-TW",
        "παραδοσιακά κινέζικα":"zh-TW",
        "ચિની પરંપરાગત":"zh-TW",
        "moʻomeheu kuʻuna":"zh-TW",
        "מסורת סינית":"zh-TW",
        "चीनी पारंपरिक":"zh-TW",
        "suav kev lig kev cai":"zh-TW",
        "kínai (hagyományos":"zh-TW",
        "hefðbundin kínverska":"zh-TW",
        "ọdịnala china":"zh-TW",
        "中国の伝統的な":"zh-TW",
        "ಚೀನೀ ಸಾಂಪ್ರದಾಯಿಕ":"zh-TW",
        "중국 전통":"zh-TW",
        "çînî kevneşop":"zh-TW",
        "кытай салттуу":"zh-TW",
        "ຂອງຈີນແບບດັ້ງເດີມ":"zh-TW",
        "ķīniešu tradicionālā":"zh-TW",
        "kinų tradicinis":"zh-TW",
        "chinese traditionell":"zh-TW",
        "кинески традиционален":"zh-TW",
        "ചൈനീസ് പാരമ്പര്യമായ":"zh-TW",
        "tradizzjonali ċiniża":"zh-TW",
        "hainamana tonu":"zh-TW",
        "хятадын уламжлалт":"zh-TW",
        "चिनियाँ परम्परागत":"zh-TW",
        "ଚାଇନିଜ୍ ପାରମ୍ପାରିକ |":"zh-TW",
        "چینایي دودیز":"zh-TW",
        "سنتی چینی":"zh-TW",
        "chiński tradycyjny":"zh-TW",
        "ਚੀਨੀ ਰਵਾਇਤੀ":"zh-TW",
        "tradițional chinezesc":"zh-TW",
        "китайский традиционный":"zh-TW",
        "saina tu masani":"zh-TW",
        "traidiseanta sìneach":"zh-TW",
        "традиционални кинески":"zh-TW",
        "chinese setso":"zh-TW",
        "چيني رواجي":"zh-TW",
        "චීන සාම්ප්\u200dරදායික":"zh-TW",
        "tradične čínske":"zh-TW",
        "kitajska tradicionalna":"zh-TW",
        "dhaqanka shiinaha":"zh-TW",
        "tradicional china":"zh-TW",
        "traditionell kinesisk":"zh-TW",
        "анъанавии хитоӣ":"zh-TW",
        "சீன பாரம்பரிய":"zh-TW",
        "చైనీస్ సాంప్రదాయ":"zh-TW",
        "จีนดั้งเดิม":"zh-TW",
        "çin geleneği":"zh-TW",
        "китайський традиційний":"zh-TW",
        "چینی روایتی":"zh-TW",
        "جۇڭگونىڭ ئەنئەنىۋى":"zh-TW",
        "xitoy an'anaviy":"zh-TW",
        "truyền thống trung hoa":"zh-TW",
        "i-chinese yemveli":"zh-TW",
        "כינעזיש טראדיציאנעלן":"zh-TW",
        "chinese yendabuko":"zh-TW",
        "koerdiese":"kurdish",
        "kurd":"ku",
        "ኩርዲሽ":"kurdish",
        "كردي":"kurdish",
        "քրդական":"kurdish",
        "kürd":"kurdish",
        "kurdu":"ku",
        "курд":"ku",
        "কুর্দি":"kurdish",
        "kurdish":"ku",
        "кюрдски":"ku",
        "assurd":"kurdish",
        "kursy":"kurdish",
        "kusanza":"kurdish",
        "库尔德":"kurdish",
        "庫爾德":"kurdish",
        "curdu":"kurdish",
        "kurdski":"ku",
        "kurdština":"ku",
        "kurdisk":"ku",
        "koerdisch":"ku",
        "ruza":"kurdish",
        "kurdi":"ku",
        "maputla":"kurdish",
        "kurdien":"kurdish",
        "kurde":"ku",
        "koerdysk":"kurdish",
        "ქურთული":"ku",
        "kurdisch":"kurdish",
        "κουρδικά":"ku",
        "કુર્દિશ":"kurdish",
        "kurdawa":"kurdish",
        "ōlelo kurdish":"kurdish",
        "कुर्द":"kurdish",
        "kúrdískt":"kurdish",
        "coirdis":"kurdish",
        "curda":"kurdish",
        "クルド":"kurdish",
        "ಕುರ್ದಿಶ್":"ku",
        "күрд":"kurdish",
        "쿠르드어":"ku",
        "kurdî":"kurdish",
        "lingua kurdica":"kurdish",
        "kurdas":"kurdish",
        "kurdesch":"kurdish",
        "курдски":"ku",
        "kiorda":"ku",
        "കുർദിഷ്":"kurdish",
        "kurure":"kurdish",
        "कुर्दिश":"ku",
        "ကူရှစ်":"kurdish",
        "କୁର୍ଡିସ୍":"kurdish",
        "کرديش":"kurdish",
        "کردی":"ku",
        "kurdyjski":"ku",
        "curdo":"ku",
        "ਕੁਰਦਿਸ਼":"kurdish",
        "kurdă":"ku",
        "курдский":"kurdish",
        "kutisa":"kurdish",
        "curdach":"kurdish",
        "курдисх":"kurdish",
        "chikedhi":"kurdish",
        "ڪردي":"kurdish",
        "කුර්දි":"kurdish",
        "kurdský":"kurdish",
        "kurdiyo":"kurdish",
        "kurda":"kurdish",
        "kurudisha nyuma":"kurdish",
        "குர்திஷ்":"kurdish",
        "เคิร์ด":"ku",
        "kürt":"kurdish",
        "курдський":"kurdish",
        "کردش":"ku",
        "người kurd":"kurdish",
        "cwrdeg":"kurdish",
        "isikhudish":"kurdish",
        "קורדיש":"kurdish",
        "kurukù":"kurdish",
        "hlanganisa":"kurdish",
        "kurmandi":"kurmandi",
        "ኩርሜዳይ":"kurmandi",
        "كرماندي":"kurmandi",
        "քուրմանդին":"kurmandi",
        "курмандзі":"kurmandi",
        "库尔曼迪":"kurmandi",
        "庫爾曼迪":"kurmandi",
        "ყურმანდი":"kurmandi",
        "κουρμάντι":"kurmandi",
        "કુરમંડી":"kurmandi",
        "קורמנדי":"kurmandi",
        "クルマンディ":"kurmandi",
        "ಕುರ್ಮಂಡಿ":"kurmandi",
        "құрманди":"kurmandi",
        "쿠르 만 디":"kurmandi",
        "курманди":"kurmandi",
        "കുർമാണ്ടി":"kurmandi",
        "कुर्मंडी":"kurmandi",
        "ကမာရွတ်":"kurmandi",
        "कुर्मन्डी":"kurmandi",
        "କୁର୍ମାଣ୍ଡି":"kurmandi",
        "کورمندي":"kurmandi",
        "کورمندی":"kurmandi",
        "ਕੁਰਮੰਡੀ":"kurmandi",
        "ڪرمندي":"kurmandi",
        "කුර්මන්ඩි":"kurmandi",
        "குர்மண்டி":"kurmandi",
        "курманді":"kurmandi",
        "قرمندی":"kurmandi",
        "birmaanse":"burmese",
        "birmanez":"burmese",
        "በርሚስ":"burmese",
        "البورمية":"my",
        "բիրմայական":"burmese",
        "burma":"my",
        "burmatarra":"burmese",
        "бірманскі":"burmese",
        "বর্মী":"burmese",
        "бирмански":"my",
        "burmià":"burmese",
        "kawayan":"burmese",
        "burashi":"burmese",
        "缅甸菜":"burmese",
        "緬甸菜":"burmese",
        "birmanu":"burmese",
        "burmanski":"my",
        "barmský":"burmese",
        "burmeser":"burmese",
        "birmees":"burmese",
        "burmese":"my",
        "birma":"my",
        "burmalainen":"burmese",
        "birmane":"burmese",
        "birmaansk":"burmese",
        "ბირმული":"my",
        "birmanisch":"my",
        "βιρμανός":"burmese",
        "બર્મીઝ":"my",
        "pulumi":"burmese",
        "बर्मी":"my",
        "burmai":"my",
        "burmais":"burmese",
        "birmana":"burmese",
        "ビルマ人":"burmese",
        "ಬರ್ಮೀಸ್":"my",
        "бурма":"burmese",
        "버마 사람":"burmese",
        "bîrmanî":"burmese",
        "бурмача":"burmese",
        "birmietis":"burmese",
        "birmanesch":"burmese",
        "бурмански":"my",
        "ബർമീസ്":"my",
        "burmiż":"burmese",
        "puremu":"burmese",
        "बर्मिझ":"burmese",
        "буриад":"burmese",
        "ဗမာ":"burmese",
        "burmesisk":"my",
        "ବର୍ମା":"burmese",
        "برمایی":"burmese",
        "برمه ای":"burmese",
        "birmańczyk":"burmese",
        "birmanesa":"burmese",
        "ਬਰਮੀਜ":"burmese",
        "бирманский":"my",
        "chiburmese":"burmese",
        "برمي":"burmese",
        "බුරුමය":"burmese",
        "barmská":"burmese",
        "burco":"burmese",
        "tukang burit":"burmese",
        "பர்மிய":"burmese",
        "బర్మీస్":"my",
        "พม่า":"myanmar",
        "birmanyalı":"burmese",
        "бурманський":"burmese",
        "برمی":"burmese",
        "tiếng chuông":"burmese",
        "בורמעסע":"burmese",
        "ማይንማር":"myanmar",
        "ميانمار":"myanmar",
        "իմանմար":"myanmar",
        "м'янма":"myanmar",
        "মায়ানমার":"myanmar",
        "mjanmar":"myanmar",
        "мианмар":"myanmar",
        "缅甸":"myanmar",
        "緬甸":"myanmar",
        "birmania":"myanmar",
        "მიანმარა":"myanmar",
        "μυανμάρ":"myanmar",
        "મ્યાનમાર":"myanmar",
        "myanma":"myanmar",
        "maianamara":"myanmar",
        "म्यांमार":"myanmar",
        "mianmarban":"myanmar",
        "madium":"myanmar",
        "maenmar":"myanmar",
        "ミャンマー":"myanmar",
        "ಮ್ಯಾನ್ಮಾರ್":"myanmar",
        "мьянма":"myanmar",
        "មីយ៉ាន់ម៉ា":"myanmar",
        "미얀마":"myanmar",
        "mîyanmar":"myanmar",
        "ມຽນມາ":"my",
        "suspendisse":"myanmar",
        "mjanma":"myanmar",
        "mianmaras":"myanmar",
        "മ്യാൻമർ":"myanmar",
        "il-mjanmar":"myanmar",
        "म्यानमार":"myanmar",
        "мьянмар улс":"myanmar",
        "မြန်မာ":"myanmar",
        "ମିଆଁମାର":"myanmar",
        "میانمار":"myanmar",
        "ਮਿਆਂਮਾਰ":"myanmar",
        "мјанмар":"myanmar",
        "mayanima":"myanmar",
        "මියන්මාරය":"myanmar",
        "mjanmarsko":"myanmar",
        "mjanmarski":"myanmar",
        "midin":"myanmar",
        "мянмар":"myanmar",
        "மியான்மர்":"myanmar",
        "మయన్మార్":"myanmar",
        "miyanimar":"myanmar",
        "bespeur taal":"auto",
        "azerbeidjaans":"az",
        "baskies":"eu",
        "belo-russies":"be",
        "birmaans":"my",
        "bosnies":"bs",
        "duits":"de",
        "estlands":"et",
        "filippyns":"tl",
        "fries":"fy",
        "galisies":"gl",
        "georgies":"ka",
        "gudjarati":"gu",
        "haïtiese kreools":"ht",
        "hawaies":"haw",
        "indonesies":"id",
        "japannees":"ja",
        "katalaans":"ca",
        "kinyarwanda":"rw",
        "koerdies":"ku",
        "kroaties":"hr",
        "letties":"lv",
        "litaus":"lt",
        "mahratti":"mr",
        "maleisies":"ms",
        "malgassies":"mg",
        "masedonies":"mk",
        "odia (oriya)":"or",
        "oeigoers":"ug",
        "oekraïne":"uk",
        "pandjab":"pa",
        "pasjto":"ps",
        "persies":"fa",
        "roemeens":"ro",
        "russies":"ru",
        "serwies":"sr",
        "singalees":"si",
        "skotse gallies":"gd",
        "sloweens":"sl",
        "somalies":"so",
        "tataars":"tt",
        "tsjeggies":"cs",
        "turkmeens":"tk",
        "viëtnamees":"vi",
        "wallies":"cy",
        "yslands":"is",
        "zoeloe":"zu",
        "zbulo gjuhën":"auto",
        "afrikanisht":"af",
        "amarikisht":"am",
        "arabisht":"ar",
        "armenisht":"hy",
        "azerisht":"az",
        "baskisht":"eu",
        "bengalisht":"bn",
        "birmanisht":"my",
        "boshnjakisht":"bs",
        "bullgarisht":"bg",
        "çekisht":"cs",
        "çiçeuaisht":"ny",
        "danisht":"da",
        "estonisht":"et",
        "filipinase":"tl",
        "finlandisht":"fi",
        "frizianisht":"fy",
        "galicianisht":"gl",
        "galishte skoceze":"gd",
        "greqisht":"el",
        "guxharati":"gu",
        "gjeorgjisht":"ka",
        "hauajane":"haw",
        "hebraisht":"iw",
        "hindisht":"hi",
        "holandisht":"nl",
        "hungarisht":"hu",
        "igboisht":"ig",
        "indonezisht":"id",
        "irlandisht":"ga",
        "islandisht":"is",
        "italisht":"it",
        "japonisht":"ja",
        "javanisht":"jw",
        "jidisht":"yi",
        "kanada":"kn",
        "katalonisht":"ca",
        "kazakisht":"kk",
        "kinezisht":"zh-CN",
        "kiniaruanda":"rw",
        "kirgizisht":"ky",
        "kmere":"km",
        "koreanisht":"ko",
        "korsikançe":"co",
        "kreolishte haitiane":"ht",
        "kroatisht":"hr",
        "laosisht":"lo",
        "latinisht":"la",
        "lituanisht":"lt",
        "luksemburgisht":"lb",
        "malagasisht":"mg",
        "malajalamisht":"ml",
        "malajzisht":"ms",
        "malteze":"mt",
        "maorisht":"mi",
        "maqedonisht":"mk",
        "maratisht":"mr",
        "mongolisht":"mn",
        "nepalisht":"ne",
        "norvegjisht":"no",
        "odiaisht (orijaisht)":"or",
        "panxhabisht":"pa",
        "persisht":"fa",
        "rumanisht":"ro",
        "samoanisht":"sm",
        "serbisht":"sr",
        "sesotoisht":"st",
        "sibuanoisht":"ceb",
        "sindisht":"sd",
        "sinhalisht":"si",
        "sllovakisht":"sk",
        "sllovenisht":"sl",
        "somalisht":"so",
        "suahilisht":"sw",
        "suedisht":"sv",
        "sundanisht":"su",
        "shonaisht":"sn",
        "shqip":"sq",
        "tajlandisht":"th",
        "tamilisht":"ta",
        "tatar":"tt",
        "taxhikisht":"tg",
        "telugisht":"te",
        "turkmenisht":"tk",
        "turqisht":"tr",
        "uellsisht":"cy",
        "ujgurisht":"ug",
        "ukrainisht":"uk",
        "uzbekisht":"uz",
        "kinezisht (e thjeshtuar)":"zh-CN",
        "kinezisht (tradicionale)":"zh-TW",
        "ቋንቋ  አግኝ":"auto",
        "ሀንጋሪኛ":"hu",
        "ሃዌይኛ":"haw",
        "ሃውስኛ":"ha",
        "ህንድኛ":"hi",
        "ሊትዌንኛ":"lt",
        "ላቲንኛ":"la",
        "ላትቪያኛ":"lv",
        "ሎክሶምቦርግኛ":"lb",
        "ማላያላምኛ":"ml",
        "ማላይኛ":"ms",
        "ማላጋስኛ":"mg",
        "ማልቲስኛ":"mt",
        "ማራቲኛ":"mr",
        "ማዮሪኛ":"mi",
        "ሜቄዶኒያኛ":"mk",
        "ሞንግ":"hmn",
        "ሞንጎሊያኛ":"mn",
        "ራሽያኛ":"ru",
        "ሮማኒያንኛ":"ro",
        "ሰርቢያኛ":"sr",
        "ሱማልኛ":"so",
        "ሱዳንኛ":"su",
        "ሲንድሂኛ":"sd",
        "ሳሞአንኛ":"sm",
        "ሴሶቶኛ":"st",
        "ሴቧኖኛ":"ceb",
        "ስሎቫክኛ":"sk",
        "ስሎቬንያኛ":"sl",
        "ስዋሂሊኛ":"sw",
        "ስፓኒሽኛ":"es",
        "ሾናኛ":"sn",
        "በርማኛ":"my",
        "ቡልጋሪያኛ":"bg",
        "ባስክኛ":"eu",
        "ቤላሩስኛ":"be",
        "ቤንጋሊኛ":"bn",
        "ቦስኒያኛ":"bs",
        "ቪትናምኛ":"vi",
        "ቱርክመንኛ":"tk",
        "ቱርክኛ":"tr",
        "ታሚልኛ":"ta",
        "ታታር":"tt",
        "ታይኛ":"th",
        "ታጂኪኛ":"tg",
        "ቴሉጉኛ":"te",
        "ቺቼዋኛ":"ny",
        "ቼክኛ":"cs",
        "ኔፓሊኛ":"ne",
        "ኖርዌጅያንኛ":"no",
        "አልባንያኛ":"sq",
        "አርመኒያኛ":"hy",
        "አዜርባይጃንኛ":"az",
        "አይስላንድኛ":"is",
        "አፍሪካንስኛ":"af",
        "ኡርዱኛ":"ur",
        "ኡዝቤክኛ":"uz",
        "ኢግቦኛ":"ig",
        "ኤስቶኒያኛ":"et",
        "ኤስፐራንቶ":"eo",
        "እንዶኔዢያኛ":"id",
        "ኦዲያ (ኦሪያ)":"or",
        "ኩርድሽኛ":"ku",
        "ኪርጊዝኛ":"ky",
        "ካታላንኛ":"ca",
        "ካናዳኛ":"kn",
        "ካዛክኛ":"kk",
        "ኬንያሩዋንድኛ":"rw",
        "ክመርኛ":"km",
        "ክሮኤሽያኛ":"hr",
        "ኮርሲካኛ":"co",
        "ዊጉርኛ":"ug",
        "ዌልሽ":"cy",
        "ዐረብኛ":"ar",
        "ዕብራይስጥ":"iw",
        "ዙሉኛ":"zu",
        "ዞሳኛ":"xh",
        "የሃይቲ ክረኦሌኛ":"ht",
        "የስኮት ጌልክኛ":"gd",
        "ዩክሬንኛ":"uk",
        "ዮሩባኛ":"yo",
        "ደችኛ":"nl",
        "ዴንሽኛ":"da",
        "ጃቫንኛ":"jw",
        "ጆርጂያኛ":"ka",
        "ጉጃራቲኛ":"gu",
        "ጋሊሺያኛ":"gl",
        "ፊሊፕንስኛ":"tl",
        "ፊኒሽኛ":"fi",
        "ፍሪስኛ":"fy",
        "ፐርሺያኛ":"fa",
        "ፓሽቶኛ":"ps",
        "ፓንጃቢኛ":"pa",
        "ፖሊሽኛ":"pl",
        "ፖርቱጋሊኛ":"pt",
        "ቻይንኛ (ቀላሉ)":"zh-CN",
        "ቻይንኛ (ባሕላዊው)":"zh-TW",
        "التعرّف التلقائي على اللغة":"auto",
        "الأذرية":"az",
        "الارمنية":"hy",
        "الإسبانية":"es",
        "الاسبرانتو":"eo",
        "الاسكتلندية الغالية":"gd",
        "الافريقانية":"af",
        "الألمانية":"de",
        "الإندونيسية":"id",
        "الأوديا (الأوريا)":"or",
        "الأوزبكية":"uz",
        "الأويغورية":"ug",
        "الإيطالية":"it",
        "الإيغبو":"ig",
        "الباسكية":"eu",
        "الباشتوية":"ps",
        "البولندية":"pl",
        "التاميلية":"ta",
        "التتارية":"tt",
        "التركمانية":"tk",
        "التركية":"tr",
        "التيلوجو":"te",
        "الخؤوصا":"xh",
        "الخميرية":"km",
        "الدانماركية":"da",
        "الرومانية":"ro",
        "الزولوية":"zu",
        "الساموانية":"sm",
        "الساندينيزية":"su",
        "السلوفينية":"sl",
        "السيبيوانية":"ceb",
        "السيسوتو":"st",
        "الصينية":"zh-CN",
        "الطاجيكي":"tg",
        "العبرية":"iw",
        "العربية":"ar",
        "الغوجراتية":"gu",
        "الفارسية":"fa",
        "الفرنسية":"fr",
        "القطلونية":"ca",
        "القيرغيزية":"ky",
        "الكازاكي":"kk",
        "الكردية":"ku",
        "الكورسيكي":"co",
        "الكينيارواندية":"rw",
        "اللاوو":"lo",
        "اللغة الكريولية الهايتية":"ht",
        "اللوكسمبورغية":"lb",
        "الليتوانية":"lt",
        "المالطيّة":"mt",
        "الماورية":"mi",
        "المدغشقرية":"mg",
        "الملايو":"ms",
        "المهراتية":"mr",
        "الهمونجية":"hmn",
        "الهنغارية":"hu",
        "الهوسا":"ha",
        "الهولندية":"nl",
        "الويلزية":"cy",
        "اليورباية":"yo",
        "الييدية":"yi",
        "تشيتشوا":"ny",
        "لغة هاواي":"haw",
        "ياباني":"ja",
        "الصينية (التقليدية)":"zh-TW",
        "الصينية (المبسطة)":"zh-CN",
        "ճանաչել լեզուն":"auto",
        "ադրբեջաներեն":"az",
        "ալբաներեն":"sq",
        "արաբերեն":"ar",
        "աֆրիկաանս":"af",
        "բելառուսերեն":"be",
        "բենգալերեն":"bn",
        "բիրմաներեն":"my",
        "բոսներեն":"bs",
        "գալիսերեն":"gl",
        "գերմաներեն":"de",
        "գուջարատերեն":"gu",
        "զուլուսերեն":"zu",
        "էստոներեն":"et",
        "թաթարերեն":"tt",
        "թամիլերեն":"ta",
        "թուրքմեներեն":"tk",
        "իգբո":"ig",
        "իդիշ":"yi",
        "իռլանդերեն":"ga",
        "իսպաներեն":"es",
        "իտալերեն":"it",
        "լաոսերեն":"lo",
        "լատվիերեն":"lv",
        "լեհերեն":"pl",
        "լիտվերեն":"lt",
        "լյուքսեմբուրգերեն":"lb",
        "խոշերեն":"xh",
        "կելտական շոտլանդերեն":"gd",
        "կորսիկերեն":"co",
        "կրեոլերեն (հայիթի)":"ht",
        "հավայերեն":"haw",
        "հոլանդերեն":"nl",
        "հունարեն":"el",
        "հունգարերեն":"hu",
        "ղազախերեն":"kk",
        "ղրղզերեն":"ky",
        "ճապոներեն":"ja",
        "ճավայերեն":"jw",
        "մալայալամ":"ml",
        "մակեդոներեն":"mk",
        "մոնղոլերեն":"mn",
        "յորուբերեն":"yo",
        "նեպալերեն":"ne",
        "ուզբեկերեն":"uz",
        "ույղուրերեն":"ug",
        "չինարեն":"zh-CN",
        "չիչևա":"ny",
        "ռումիներեն":"ro",
        "սամոաներեն":"sm",
        "սեբուաներեն":"ceb",
        "սերբերեն":"sr",
        "սլովակերեն":"sk",
        "սլովեներեն":"sl",
        "սոմալերեն":"so",
        "սունդաներեն":"su",
        "վալերեն":"cy",
        "վիետնամերեն":"vi",
        "տագալերեն":"tl",
        "տաջիկերեն":"tg",
        "փաշտուներեն":"ps",
        "փենջաբերեն":"pa",
        "քինյարվանդա":"rw",
        "քմերերեն":"km",
        "քրդերեն (քուրմանջի)":"ku",
        "օդիա (օրիյա)":"or",
        "ֆրիզերեն":"fy",
        "չինարեն (ավանդական)":"zh-TW",
        "չինարեն (պարզեցված)":"zh-CN",
        "dili seç":"auto",
        "afrikan":"af",
        "amarikcə":"am",
        "azərbaycan dili":"az",
        "belarusca":"be",
        "benqal":"bn",
        "bolqar":"bg",
        "bosniya dili":"bs",
        "çiçeva dili":"ny",
        "çin dilində":"zh-CN",
        "danimarka":"da",
        "fars dili":"fa",
        "fransız":"fr",
        "frisk":"fy",
        "gürcü dili":"ka",
        "haiti kreol dili":"ht",
        "havay":"haw",
        "hind":"hi",
        "hmonq dili":"hmn",
        "xorvat":"hr",
        "xosa dili":"xh",
        "i̇ndoneziya":"id",
        "i̇rland":"ga",
        "i̇sland":"is",
        "i̇sveç":"sv",
        "i̇vrit":"iw",
        "i̇vrit(yahudi dili)":"yi",
        "kebuano dili":"ceb",
        "kinyaruanda":"rw",
        "korsikaca":"co",
        "kürd dili (kurmanci)":"ku",
        "qırğızca":"ky",
        "qucarat":"gu",
        "latış":"lv",
        "litva":"lt",
        "loasca":"lo",
        "lüksemburq dili":"lb",
        "madaqaskarca":"mg",
        "makedoniya":"mk",
        "maoricə":"mi",
        "monqolca":"mn",
        "myanma (birma) dili":"my",
        "nepal":"ne",
        "odia (oriya dili)":"or",
        "özbək":"uz",
        "pəncab":"pa",
        "polyak":"pl",
        "portuqal":"pt",
        "puştu dili(əfqanıstan)":"ps",
        "samoa dili":"sm",
        "sesetoca(lesoto dili)":"st",
        "sinhala dili":"si",
        "somali dili":"so",
        "sonaca":"sn",
        "şotland (kelt)":"gd",
        "taqaloq":"tl",
        "tayca":"th",
        "teluqu":"te",
        "türkməncə":"tk",
        "uels":"cy",
        "uyğur dili":"ug",
        "yavaca":"jw",
        "yorubaca":"yo",
        "çin (ən'ənəvi)":"zh-TW",
        "çin dili (sadələşdirilmiş)":"zh-CN",
        "hauteman hizkuntza":"auto",
        "afrikaansa":"af",
        "albaniera":"sq",
        "amharera":"am",
        "arabiera":"ar",
        "armeniera":"hy",
        "azerbaijanera":"az",
        "bengalera":"bn",
        "bielorrusiera":"be",
        "birmaniera":"my",
        "bosniera":"bs",
        "bulgariera":"bg",
        "cebuanoera":"ceb",
        "chewera":"ny",
        "daniera":"da",
        "errumaniera":"ro",
        "errusiera":"ru",
        "eskoziako gaelera":"gd",
        "eslovakiera":"sk",
        "esloveniera":"sl",
        "esperantoa":"eo",
        "estoniera":"et",
        "filipinera":"tl",
        "frantsesa":"fr",
        "frisiera":"fy",
        "gaelera":"cy",
        "galiziera":"gl",
        "georgiera":"ka",
        "greziera":"el",
        "gujaratera":"gu",
        "hawaiiera":"haw",
        "hebreera":"iw",
        "hindia":"hi",
        "hmonga":"hmn",
        "hungariera":"hu",
        "igboera":"ig",
        "indonesiera":"id",
        "ingelesa":"en",
        "irlandera":"ga",
        "islandiera":"is",
        "italiera":"it",
        "japoniera":"ja",
        "jorubera":"yo",
        "kazakhera":"kk",
        "khmerera":"km",
        "koreera":"ko",
        "kreolera (haiti)":"ht",
        "kroaziera":"hr",
        "kurduera":"ku",
        "laosera":"lo",
        "letoniera":"lv",
        "lituaniera":"lt",
        "malabarera":"ml",
        "malaysiera":"ms",
        "malgaxea":"mg",
        "maltera":"mt",
        "maoriera":"mi",
        "marathera":"mr",
        "mazedoniera":"mk",
        "mongoliera":"mn",
        "nederlandera":"nl",
        "nepalera":"ne",
        "norvegiera":"no",
        "oriya":"or",
        "paxtunera":"ps",
        "persiera":"fa",
        "poloniera":"pl",
        "portugesa":"pt",
        "punjabera":"pa",
        "samoera":"sm",
        "serbiera":"sr",
        "sindhia":"sd",
        "somaliera":"so",
        "sothoera":"st",
        "suediera":"sv",
        "suomiera":"fi",
        "swahilia":"sw",
        "tajikera":"tg",
        "tamilera":"ta",
        "tatarera":"tt",
        "thaiera":"th",
        "turkiera":"tr",
        "turkmenera":"tk",
        "txekiera":"cs",
        "uigurrera":"ug",
        "ukrainera":"uk",
        "urdua":"ur",
        "uzbekera":"uz",
        "vietnamera":"vi",
        "xhosera":"xh",
        "yiddisha":"yi",
        "zuluera":"zu",
        "txinera (tradizionala)":"zh-TW",
        "выявіць мову":"auto",
        "азербайджанская":"az",
        "албанская":"sq",
        "амхарская":"am",
        "армянская":"hy",
        "баскская":"eu",
        "баснійская":"bs",
        "беларуская":"be",
        "валійская":"cy",
        "гаіцянская крэольская":"ht",
        "галісійская":"gl",
        "грузінская":"ka",
        "грэчаская":"el",
        "дацкая":"da",
        "іспанская":"es",
        "італьянская":"it",
        "казахская":"kk",
        "карсіканская":"co",
        "каталонская":"ca",
        "кітайская":"zh-CN",
        "коса":"xh",
        "курдская (курманджы)":"ku",
        "кхмерская":"km",
        "кiргiзская":"ky",
        "лаоская":"lo",
        "латышская":"lv",
        "лацінская":"la",
        "літоўская":"lt",
        "люксембургская":"lb",
        "м'янманская (бірманская)":"my",
        "маары":"mi",
        "малагасійская":"mg",
        "малайская":"ms",
        "мальтыйская":"mt",
        "непальская":"ne",
        "нямецкая":"de",
        "орыя":"or",
        "персідская":"fa",
        "польская":"pl",
        "руанда":"rw",
        "самаанская":"sm",
        "самалійская":"so",
        "себуанская":"ceb",
        "сербская":"sr",
        "сесота":"st",
        "сінгальская":"si",
        "сіндхі":"sd",
        "славацкая":"sk",
        "славенская":"sl",
        "суахілі":"sw",
        "суданская":"su",
        "таджыкская":"tg",
        "тамільская":"ta",
        "татарская":"tt",
        "туркменская":"tk",
        "турэцкая":"tr",
        "узбекская":"uz",
        "уйгурская":"ug",
        "украінская":"uk",
        "філіпіна":"tl",
        "фінская":"fi",
        "французская":"fr",
        "шатландская гэльская":"gd",
        "эстонская":"et",
        "яванская":"jw",
        "японская":"ja",
        "кітайская (спрошчаная)":"zh-CN",
        "кітайская (традыцыйная)":"zh-TW",
        "ভাষা শনাক্ত করুন":"auto",
        "আইরিশ":"ga",
        "আইসল্যান্ডীয়":"is",
        "আজের বাইজানীয়":"az",
        "আফ্রিকান":"af",
        "আমহারিয়":"am",
        "আরবী":"ar",
        "আর্মেনিয়ান":"hy",
        "আলবেনীয়":"sq",
        "ইউক্রেনীয়":"uk",
        "ইউঘুর":"ug",
        "ইউরোবা":"yo",
        "ইংরেজী":"en",
        "ইগবো":"ig",
        "ইতালীয়":"it",
        "ইদ্দিশ":"yi",
        "ইন্দোনেশিয়":"id",
        "উজবেক":"uz",
        "এস্তনীয়":"et",
        "ওডিয়া (ওড়িয়া)":"or",
        "ওয়েল্চ":"cy",
        "কজাখ":"kk",
        "করসিকেন":"co",
        "কাতালান":"ca",
        "কান্নাড়া":"kn",
        "কিনয়ারওয়ান্ডা":"rw",
        "কুর্দিশ":"ku",
        "কোরিয়ান":"ko",
        "ক্রোয়েশা":"hr",
        "গ্যালিশিয়":"gl",
        "গ্রীক্\u200c":"el",
        "চিচেওয়া":"ny",
        "চেক্\u200c":"cs",
        "জর্জিয়ান":"ka",
        "ড্যানিশ":"da",
        "তাতার":"tt",
        "তুর্কমেন":"tk",
        "নরওয়েজীয়":"no",
        "নেপালী":"ne",
        "পশতু":"ps",
        "পোলীশ":"pl",
        "ফার্সি":"fa",
        "ফিনিশ":"fi",
        "ফিলিপিনো":"tl",
        "ফ্রিজিয়ান":"fy",
        "বসনীয়":"bs",
        "বার্মিজ":"my",
        "বাস্ক":"eu",
        "বুলগেরীয়":"bg",
        "বেলারুশীয়":"be",
        "ভিয়েতনামিয়":"vi",
        "মংগ":"hmn",
        "মঙ্গোলিয়":"mn",
        "মায়োরি":"mi",
        "মালে":"ms",
        "মালেয়ালাম":"ml",
        "মাল্টিজ":"mt",
        "ম্যাসিডোনিয়ান":"mk",
        "রুশ":"ru",
        "রোমানীয়":"ro",
        "লাতভিয়ান":"lv",
        "লাতিন":"la",
        "লিথুয়ানীয়":"lt",
        "শোয়াইলি":"sw",
        "সামোয়া":"sm",
        "সার্বিয়ান":"sr",
        "সিংহলি":"si",
        "সুদানীজ":"su",
        "সোনা":"sn",
        "সোমালি":"so",
        "স্কচ্ গাইলি":"gd",
        "স্পেনীয়":"es",
        "স্পেরান্তো":"eo",
        "স্লোভাক":"sk",
        "স্লোভেনিয়":"sl",
        "হাইতিয়ান ক্রেওল":"ht",
        "হাওয়াইয়ান":"haw",
        "হাঙ্গেরীয়":"hu",
        "হিন্দি":"hi",
        "চীনা (ঐতিহ্যবাহী)":"zh-TW",
        "চীনা (সরলীকৃত)":"zh-CN",
        "odredi jezik":"auto",
        "azerbajdžanski":"az",
        "filipinski":"tl",
        "gudžarati":"gu",
        "haićanski kreolski":"ht",
        "indonežanski":"id",
        "kazaški":"kk",
        "kinjaruandski":"rw",
        "kmerski":"km",
        "laoski":"lo",
        "letonski":"lv",
        "malajalamski":"ml",
        "maorski":"mi",
        "odia (orijski)":"or",
        "pendžabi":"pa",
        "samoanski":"sm",
        "sebuano":"ceb",
        "sinhaleski":"si",
        "somalski":"so",
        "škotski gelski":"gd",
        "tamilski":"ta",
        "tatarski":"tt",
        "turkmenski":"tk",
        "kineski (pojednostavljeni)":"zh-CN",
        "kineski (tradicionalni)":"zh-TW",
        "разпознаване на езика":"auto",
        "африкаанс (бурски)":"af",
        "баски":"eu",
        "беларуски":"be",
        "киняруанда":"rw",
        "киргизки":"ky",
        "ксоса":"xh",
        "кхмерски":"km",
        "лаоски":"lo",
        "нидерландски":"nl",
        "одия (ория)":"or",
        "себуански":"ceb",
        "синхалски":"si",
        "татарски":"tt",
        "туркменски":"tk",
        "финландски":"fi",
        "хаитянски креолски":"ht",
        "шотландски келтски":"gd",
        "китайски (опростен)":"zh-CN",
        "китайски (традиционен)":"zh-TW",
        "detecta l’idioma":"auto",
        "albanès":"sq",
        "amhàric":"am",
        "armeni":"hy",
        "àzeri":"az",
        "bielorús":"be",
        "birmà":"my",
        "cambodjà":"km",
        "castellà":"es",
        "cebuà":"ceb",
        "cors":"co",
        "crioll d'haití":"ht",
        "eslovè":"sl",
        "frisó":"fy",
        "gaèlic escocès":"gd",
        "gal·lès":"cy",
        "georgià":"ka",
        "indonesi":"id",
        "islandès":"is",
        "laosià":"lo",
        "letó":"lv",
        "lituà":"lt",
        "macedònic":"mk",
        "malaiàlam":"ml",
        "malgaix":"mg",
        "neerlandès":"nl",
        "nepalès":"ne",
        "paixtu":"ps",
        "polonès":"pl",
        "quirguís":"ky",
        "ruandès":"rw",
        "sessoto":"st",
        "singalès":"si",
        "tagal":"tl",
        "tàmil":"ta",
        "tàtar":"tt",
        "turcman":"tk",
        "urdú":"ur",
        "xixewa":"ny",
        "xona":"sn",
        "gimatikud ang sinultian":"auto",
        "aleman":"de",
        "griyego":"el",
        "hinapon":"ja",
        "inintsik":"zh-CN",
        "kinatsila":"es",
        "turkmen":"tk",
        "inintsik (gipasimple)":"zh-CN",
        "inintsik (tradisyonal)":"zh-TW",
        "fufuzani chilankhulo":"auto",
        "chi sikoti chachigayeliki":"gd",
        "chiafirikanzi":"af",
        "chialubaniyani":"sq",
        "chiamuhariki":"am",
        "chiarabiki":"ar",
        "chiarumeniyani":"hy",
        "chiayirishi":"ga",
        "chiayisilandiki":"is",
        "chiazebajani":"az",
        "chibasiki":"eu",
        "chibelarashani":"be",
        "chiboziniyani":"bs",
        "chibulugariani":"bg",
        "chidanishi":"da",
        "chidatchi":"nl",
        "chiesiperanto":"eo",
        "chiesitoniani":"et",
        "chifilipino":"tl",
        "chifirisiyani":"fy",
        "chifulenchi":"fr",
        "chigalishani":"gl",
        "chihangariani":"hu",
        "chihawayani":"haw",
        "chiheberi":"iw",
        "chihimong'i":"hmn",
        "chiibo":"ig",
        "chiindoneziyani":"id",
        "chijapanizi":"ja",
        "chijavanizi":"jw",
        "chijeremani":"de",
        "chijojiyani":"ka",
        "chikanada":"kn",
        "chikazaki":"kk",
        "chikhima":"km",
        "chikhosa":"xh",
        "chikirigizi":"ky",
        "chikiriyore cha ku haiti":"ht",
        "chikoliani":"ko",
        "chikolusikani":"co",
        "chikudishi (kurmanji)":"ku",
        "chikuroweshani":"hr",
        "chikwebuano":"ceb",
        "chilao":"lo",
        "chilatini":"la",
        "chilativia":"lv",
        "chilithuwania":"lt",
        "chilukusembogishi":"lb",
        "chimalagasi":"mg",
        "chimalayalamu":"ml",
        "chimalayi":"ms",
        "chimalutizi":"mt",
        "chimaori":"mi",
        "chimarathi":"mr",
        "chimasedoniyani":"mk",
        "chimongoliyani":"mn",
        "chimyanima (chibuma)":"my",
        "chinoruwejani":"no",
        "chipashito":"ps",
        "chiperezi":"fa",
        "chipolishi":"pl",
        "chipunjabi":"pa",
        "chipwitikizi":"pt",
        "chirashani":"ru",
        "chiromaniani":"ro",
        "chisamoa":"sm",
        "chiserubiani":"sr",
        "chishona":"sn",
        "chisilovaki":"sk",
        "chisiloveniyani":"sl",
        "chisindi":"sd",
        "chisinihala":"si",
        "chisipanishi":"es",
        "chisomali":"so",
        "chisotho":"st",
        "chisundanizi":"su",
        "chiswideni":"sv",
        "chitajiki":"tg",
        "chitaliyana":"it",
        "chitamilu":"ta",
        "chitatari":"tt",
        "chitchaina":"zh-CN",
        "chitcheki":"cs",
        "chitekimani":"tk",
        "chitekishi":"tr",
        "chiurudu":"ur",
        "chiuzubeki":"uz",
        "chiviyetinamizi":"vi",
        "chiwelushi":"cy",
        "chiyidishi":"yi",
        "chiyoruba":"yo",
        "chiyukireniyani":"uk",
        "chizulu":"zu",
        "chitchaina (chamakolo)":"zh-TW",
        "chitchaina (chosuluka)":"zh-CN",
        "检测语言":"auto",
        "阿拉伯语":"ar",
        "阿塞拜疆语":"az",
        "奥里亚语(奥里亚文)":"or",
        "巴斯克语":"eu",
        "冰岛语":"is",
        "波兰语":"pl",
        "布尔语(南非荷兰语)":"af",
        "鞑靼语":"tt",
        "法语":"fr",
        "芬兰语":"fi",
        "弗里西语":"fy",
        "高棉语":"km",
        "格鲁吉亚语":"ka",
        "韩语":"ko",
        "豪萨语":"ha",
        "吉尔吉斯语":"ky",
        "库尔德语":"ku",
        "拉丁语":"la",
        "老挝语":"lo",
        "卢森堡语":"lb",
        "卢旺达语":"rw",
        "马尔加什语":"mg",
        "马耳他语":"mt",
        "蒙古语":"mn",
        "孟加拉语":"bn",
        "南非科萨语":"xh",
        "南非祖鲁语":"zu",
        "挪威语":"no",
        "齐切瓦语":"ny",
        "日语":"ja",
        "瑞典语":"sv",
        "塞尔维亚语":"sr",
        "塞索托语":"st",
        "僧伽罗语":"si",
        "斯洛伐克语":"sk",
        "斯洛文尼亚语":"sl",
        "宿务语":"ceb",
        "索马里语":"so",
        "塔吉克语":"tg",
        "泰语":"th",
        "土耳其语":"tr",
        "土库曼语":"tk",
        "乌克兰语":"uk",
        "西班牙语":"es",
        "信德语":"sd",
        "匈牙利语":"hu",
        "修纳语":"sn",
        "伊博语":"ig",
        "意大利语":"it",
        "意第绪语":"yi",
        "印尼巽他语":"su",
        "印尼语":"id",
        "印尼爪哇语":"jw",
        "约鲁巴语":"yo",
        "中文(简体)":"zh-CN",
        "中文(繁体)":"zh-TW",
        "偵測語言":"auto",
        "土耳其文":"tr",
        "土庫曼文":"tk",
        "丹麥文":"da",
        "巴斯克文":"eu",
        "日文":"ja",
        "毛利文":"mi",
        "爪哇文":"jw",
        "加里西亞文":"gl",
        "加泰羅尼亞文":"ca",
        "卡納達文":"kn",
        "尼泊爾文":"ne",
        "布爾文":"af",
        "弗利然文":"fy",
        "白俄羅斯文":"be",
        "立陶宛文":"lt",
        "伊博文":"ig",
        "冰島文":"is",
        "匈牙利文":"hu",
        "印尼文":"id",
        "印尼巽他文":"su",
        "印度文":"hi",
        "印度古哈拉地文":"gu",
        "吉爾吉斯文":"ky",
        "克羅埃西亞文":"hr",
        "希伯來文":"iw",
        "希臘文":"el",
        "亞美尼亞文":"hy",
        "亞塞拜然文":"az",
        "奇切瓦文":"ny",
        "孟加拉文":"bn",
        "帕施圖文":"ps",
        "拉丁文":"la",
        "拉脫維亞文":"lv",
        "法文":"fr",
        "波士尼亞文":"bs",
        "波斯文":"fa",
        "波蘭文":"pl",
        "芬蘭文":"fi",
        "阿姆哈拉文":"am",
        "阿拉伯文":"ar",
        "阿爾巴尼亞文":"sq",
        "俄文":"ru",
        "保加利亞文":"bg",
        "信德文":"sd",
        "南非柯薩文":"xh",
        "南非祖魯文":"zu",
        "哈薩克文":"kk",
        "威爾斯文":"cy",
        "科西嘉文":"co",
        "苗文":"hmn",
        "英文":"en",
        "夏威夷文":"haw",
        "庫德文":"ku",
        "挪威文":"no",
        "旁遮普文":"pa",
        "泰文":"th",
        "泰米爾文":"ta",
        "泰盧固文":"te",
        "海地克里奧文":"ht",
        "烏克蘭文":"uk",
        "烏茲別克文":"uz",
        "烏爾都文":"ur",
        "索馬里文":"so",
        "馬耳他文":"mt",
        "馬來文":"ms",
        "馬其頓文":"mk",
        "馬拉加斯文":"mg",
        "馬拉地文":"mr",
        "馬拉雅拉姆文":"ml",
        "高棉文":"km",
        "宿霧文":"ceb",
        "捷克文":"cs",
        "紹納文":"sn",
        "荷蘭文":"nl",
        "喬治亞文":"ka",
        "斯瓦希里文":"sw",
        "斯洛維尼亞文":"sl",
        "菲律賓文":"tl",
        "越南文":"vi",
        "塔吉克文":"tg",
        "塞爾維亞文":"sr",
        "意第緒文":"yi",
        "愛沙尼亞文":"et",
        "愛爾蘭文":"ga",
        "瑞典文":"sv",
        "瑟索托文":"st",
        "葡萄牙文":"pt",
        "維吾爾文":"ug",
        "蒙古文":"mn",
        "豪沙文":"ha",
        "寮文":"lo",
        "德文":"de",
        "歐利亞文 (奧里雅文)":"or",
        "緬甸文":"my",
        "盧安達文":"rw",
        "盧森堡文":"lb",
        "錫蘭文":"si",
        "優魯巴文":"yo",
        "韓文":"ko",
        "薩摩亞文":"sm",
        "羅馬尼亞文":"ro",
        "蘇格蘭的蓋爾文":"gd",
        "韃靼文":"tt",
        "中文 (繁體)":"zh-TW",
        "中文 (簡體)":"zh-CN",
        "détecter la langue":"auto",
        "allemand":"de",
        "arménien":"hy",
        "azerbaïdjanais":"az",
        "bengalais":"bn",
        "danois":"da",
        "finlandais":"fi",
        "galicien":"gl",
        "géorgien":"ka",
        "goudjrati":"gu",
        "hébreu":"iw",
        "hollandais":"nl",
        "hongrois":"hu",
        "indonésien":"id",
        "irlandais":"ga",
        "italien":"it",
        "japonais":"ja",
        "laotien":"lo",
        "lituanien":"lt",
        "malais":"ms",
        "marathe":"mr",
        "népalais":"ne",
        "norvégien":"no",
        "pachto":"ps",
        "pendjabi":"pa",
        "persan":"fa",
        "portuguais":"pt",
        "roumain":"ro",
        "slovénien":"sl",
        "somalien":"so",
        "soudanais":"su",
        "suédois":"sv",
        "tagalog":"tl",
        "tamoul":"ta",
        "télougou":"te",
        "turkmène":"tk",
        "vietnamien":"vi",
        "chinese (simplificatu)":"zh-CN",
        "chinese (tradiziunale)":"zh-TW",
        "otkrij jezik":"auto",
        "armenijski":"hy",
        "galski":"gl",
        "haićansko-kreolski":"ht",
        "hindu":"hi",
        "kirgistanski":"ky",
        "latvijski/letonski":"lv",
        "malezijski":"ms",
        "malgaški":"mg",
        "odijski (orijski)":"or",
        "rumunjski":"ro",
        "sahona":"sn",
        "sesotski":"st",
        "singaleski":"si",
        "slovenski":"sl",
        "škotski keltski":"gd",
        "uzbekistanski":"uz",
        "rozpoznat jazyk":"auto",
        "albánština":"sq",
        "amharština":"am",
        "arménština":"hy",
        "ázerbájdžánština":"az",
        "barmština":"my",
        "baskičtina":"eu",
        "běloruština":"be",
        "bengálština":"bn",
        "bosenština":"bs",
        "bulharština":"bg",
        "cebuánština":"ceb",
        "čičevština":"ny",
        "filipínština":"tl",
        "finština":"fi",
        "fríština":"fy",
        "galicijština":"gl",
        "gruzínština":"ka",
        "gudžarátština":"gu",
        "haitská kreolština":"ht",
        "hauština":"ha",
        "havajština":"haw",
        "hmongština":"hmn",
        "holandština":"nl",
        "chorvatština":"hr",
        "igboština":"ig",
        "islandština":"is",
        "japonština":"ja",
        "javánština":"jw",
        "kannadština":"kn",
        "kazaština":"kk",
        "khmerština":"km",
        "korsičtina":"co",
        "kyrgyzština":"ky",
        "laoština":"lo",
        "litevština":"lt",
        "lotyština":"lv",
        "lucemburština":"lb",
        "maďarština":"hu",
        "makedonština":"mk",
        "malajálamština":"ml",
        "malajština":"ms",
        "malgaština":"mg",
        "maorština":"mi",
        "marátština":"mr",
        "mongolština":"mn",
        "němčina":"de",
        "nepálština":"ne",
        "pandžábština":"pa",
        "paštština":"ps",
        "perština":"fa",
        "rwandština":"rw",
        "řečtina":"el",
        "samojská polynéština":"sm",
        "sesothština":"st",
        "sindhijština":"sd",
        "sinhálština":"si",
        "skotská gaelština":"gd",
        "slovenština":"sk",
        "slovinština":"sl",
        "somálština":"so",
        "sundánština":"su",
        "šonština":"sn",
        "švédština":"sv",
        "tádžičtina":"tg",
        "tamilština":"ta",
        "tatarština":"tt",
        "telužština":"te",
        "thajština":"th",
        "turkmenština":"tk",
        "ujgurština":"ug",
        "urdština":"ur",
        "urijština":"or",
        "uzbečtina":"uz",
        "xhoština":"xh",
        "čínština (zjednodušená)":"zh-CN",
        "registrer sprog":"auto",
        "galicisk":"gl",
        "haitisk kreolsk":"ht",
        "hawaiiansk":"haw",
        "hollandsk":"nl",
        "kirgisk":"ky",
        "laotisk":"lo",
        "malagassisk":"mg",
        "malajisk":"ms",
        "polsk":"pl",
        "slovakisk":"sk",
        "somalisk":"so",
        "tadsjikisk":"tg",
        "tatarisk":"tt",
        "thailandsk":"th",
        "turkmensk":"tk",
        "uighursk":"ug",
        "usbekisk":"uz",
        "kinesisk (forenklet)":"zh-CN",
        "kinesisk (traditionelt)":"zh-TW",
        "taal herkennen":"auto",
        "azerbeidzjaans":"az",
        "haïtiaans creools":"ht",
        "hawaïaans":"haw",
        "kirgizisch":"ky",
        "latijn":"la",
        "schots keltisch":"gd",
        "slovaaks":"sk",
        "tadzjieks":"tg",
        "wels":"cy",
        "chinees (traditioneel)":"zh-TW",
        "chinees (vereenvoudigd)":"zh-CN",
        "detect language":"auto",
        "tuvasta keel":"auto",
        "afrikaani":"af",
        "albaania":"sq",
        "amhaari":"am",
        "armeenia":"hy",
        "bosna":"bs",
        "bulgaaria":"bg",
        "eesti":"et",
        "galeegi":"gl",
        "haitikreooli":"ht",
        "heebrea":"iw",
        "hispaania":"es",
        "hollandi":"nl",
        "horvaadi":"hr",
        "iiri":"ga",
        "indoneesia":"id",
        "jidiši":"yi",
        "kasahhi":"kk",
        "katalaani":"ca",
        "koosa":"xh",
        "kreeka":"el",
        "ladina":"la",
        "leedu":"lt",
        "letseburgi":"lb",
        "läti":"lv",
        "malagassi":"mg",
        "malajalaami":"ml",
        "maoori":"mi",
        "nepaali":"ne",
        "norra":"no",
        "odia (oria)":"or",
        "pandžaabi":"pa",
        "pilipino":"tl",
        "portugali":"pt",
        "prantsuse":"fr",
        "ruanda":"rw",
        "rumeenia":"ro",
        "saksa":"de",
        "singali":"si",
        "slovaki":"sk",
        "sloveeni":"sl",
        "somaali":"so",
        "soome":"fi",
        "suahiili":"sw",
        "sundani":"su",
        "suulu":"zu",
        "šoti":"gd",
        "taani":"da",
        "tadžiki":"tg",
        "tamiili":"ta",
        "tatari":"tt",
        "tšitševa":"ny",
        "turkmeeni":"tk",
        "uelsi":"cy",
        "ungari":"hu",
        "urdi":"ur",
        "valgevene":"be",
        "vene":"ru",
        "lihtsustatud hiina":"zh-CN",
        "traditsiooniline hiina":"zh-TW",
        "kilalanin ang wika":"auto",
        "tsino":"zh-CN",
        "ukranian":"uk",
        "chinese (pinasimple)":"zh-CN",
        "chinese (tradisyunal)":"zh-TW",
        "tunnista kieli":"auto",
        "arabia":"ar",
        "cebu":"ceb",
        "haitinkreoli":"ht",
        "havaiji":"haw",
        "heprea":"iw",
        "hollanti":"nl",
        "islanti":"is",
        "japani":"ja",
        "kazakki":"kk",
        "kiina":"zh-CN",
        "kreikka":"el",
        "kroatia":"hr",
        "kymri":"cy",
        "liettua":"lt",
        "njandža":"ny",
        "norja":"no",
        "odia (orija)":"or",
        "persia":"fa",
        "puola":"pl",
        "ranska":"fr",
        "ruotsi":"sv",
        "sinhali":"si",
        "skottigaeli":"gd",
        "slovenia":"sl",
        "sundaneesi":"su",
        "suomi":"fi",
        "tadžikki":"tg",
        "tamili":"ta",
        "tanska":"da",
        "tataari":"tt",
        "tsekki":"cs",
        "unkari":"hu",
        "venäjä":"ru",
        "viro":"et",
        "kiina (perinteinen)":"zh-TW",
        "kiina (yksinkertaistettu)":"zh-CN",
        "anglais":"en",
        "azéri":"az",
        "birman":"my",
        "cingalais":"si",
        "finnois":"fi",
        "gaélique (écosse)":"gd",
        "haoussa":"ha",
        "kirghiz":"ky",
        "malaisien":"ms",
        "néerlandais":"nl",
        "ouïgour":"ug",
        "pachtô":"ps",
        "sindhî":"sd",
        "soundanais":"su",
        "thaï":"th",
        "yorouba":"yo",
        "taal werkenne":"auto",
        "azerbeidzjaansk":"az",
        "cebuanoosk":"ceb",
        "chichewaansk":"ny",
        "estsk":"et",
        "filippynsk":"tl",
        "fjetnameesk":"vi",
        "frysk":"fy",
        "galisysk":"gl",
        "gujaraty":"gu",
        "haïtiaansk-kreoalsk":"ht",
        "hebrieusk":"iw",
        "hindy":"hi",
        "hmongsk":"hmn",
        "iislânsk":"is",
        "italjaansk":"it",
        "jiddysk":"yi",
        "khmersk":"km",
        "koerdysk (kurmanji)":"ku",
        "laosk":"lo",
        "maleisysk":"ms",
        "maraty":"mr",
        "mongoalysk":"mn",
        "myanmar (birmeesk)":"my",
        "oeigoersk":"ug",
        "oerdû":"ur",
        "oesbeeksk":"uz",
        "portugeesk":"pt",
        "pûnjaby":"pa",
        "samoaansk":"sm",
        "siameesk":"th",
        "sloweensk":"sl",
        "soendaneesk":"su",
        "sûlû":"zu",
        "tataarsk":"tt",
        "telûgû":"te",
        "turkmeensk":"tk",
        "ukraynsk":"uk",
        "welsk":"cy",
        "yorubaalsk":"yo",
        "detectar idioma":"auto",
        "acerbaixano":"az",
        "africáner":"af",
        "albanés":"sq",
        "armenio":"hy",
        "bielorruso":"be",
        "birmano":"my",
        "camboxano":"km",
        "canarés":"kn",
        "casaco":"kk",
        "dinamarqués":"da",
        "esloveno":"sl",
        "estoniano":"et",
        "éuscaro":"eu",
        "frisón":"fy",
        "galés":"cy",
        "guxaratí":"gu",
        "islandés":"is",
        "kiñaruanda":"rw",
        "laosiano":"lo",
        "lituano":"lt",
        "luxemburgués":"lb",
        "macedonio":"mk",
        "malaio":"ms",
        "neerlandés":"nl",
        "odiá (odiá)":"or",
        "panxabí":"pa",
        "paxtún":"ps",
        "tártaro":"tt",
        "taxico":"tg",
        "telugú":"te",
        "turkmeno":"tk",
        "uzbeko":"uz",
        "ენის განსაზღვრა":"auto",
        "აზერბაიჯანული":"az",
        "აფრიკაანსი":"af",
        "ბელორუსული":"be",
        "ბენგალური":"bn",
        "გალური":"gl",
        "ვიეტნამური":"vi",
        "თათრული":"tt",
        "თურქმენული":"tk",
        "იავური":"jw",
        "იაპონური":"ja",
        "იგბო":"ig",
        "ირლანდიური":"ga",
        "ისლანდიური":"is",
        "კატალანური":"ca",
        "კინიარუანდული":"rw",
        "კორსიკული":"co",
        "ლაოსური":"lo",
        "ლატვიური":"lv",
        "ლიტვური":"lt",
        "მალაგასიური":"mg",
        "მალაიალამი":"ml",
        "მალაიური":"ms",
        "მარათჰი":"mr",
        "ნეპალური":"ne",
        "ნორვეგიული":"no",
        "ორია":"or",
        "პენჯაბური":"pa",
        "პუშტუ":"ps",
        "რუსული":"ru",
        "სებუანური":"ceb",
        "სესოთო":"st",
        "სინჰალური":"si",
        "სლოვენური":"sl",
        "ტაგალოგური":"tl",
        "ტამილური":"ta",
        "ტაჯიკური":"tg",
        "უიღურული":"ug",
        "ფრიზიული":"fy",
        "ქმერული":"km",
        "ქსოზა":"xh",
        "ყაზახური":"kk",
        "ყირგიზული":"ky",
        "შოტლანდიური":"gd",
        "ჩევა":"ny",
        "ხორვატიული":"hr",
        "ჰავაური":"haw",
        "ჰაიტიური კრეოლი":"ht",
        "ჩინური (გამარტივებული)":"zh-CN",
        "sprache erkennen":"auto",
        "albanisch":"sq",
        "aserbaidschanisch":"az",
        "bengalisch":"bn",
        "deutsch":"de",
        "friesisch":"fy",
        "haitianisch":"ht",
        "kasachisch":"kk",
        "kurdisch (kurmandschi)":"ku",
        "lateinisch":"la",
        "malaysisch":"ms",
        "nepalesisch":"ne",
        "paschtu":"ps",
        "polnisch":"pl",
        "samoanisch":"sm",
        "schottisch-gälisch":"gd",
        "suaheli":"sw",
        "tatarisch":"tt",
        "turkmenisch":"tk",
        "weißrussisch":"be",
        "chinesisch (traditionell)":"zh-TW",
        "chinesisch (vereinfacht)":"zh-CN",
        "αναγνώριση γλώσσας":"auto",
        "αζερμπαϊτζανικά":"az",
        "αλβανικά":"sq",
        "αμχαρικά":"am",
        "αραβικά":"ar",
        "αρμενικά":"hy",
        "αφρικάανς":"af",
        "βασκικά":"eu",
        "βεγγαλική":"bn",
        "βιετναμεζικά":"vi",
        "βιρμανικά":"my",
        "βοσνιακά":"bs",
        "βουλγαρικά":"bg",
        "γαελικά σκοτίας":"gd",
        "γαλικιακά":"gl",
        "γαλλικά":"fr",
        "γερμανικά":"de",
        "γεωργιανά":"ka",
        "γίντις":"yi",
        "γκουτζαρατικά":"gu",
        "δανικά":"da",
        "ζόσα":"xh",
        "ίγκμπο":"ig",
        "ιρλανδικά":"ga",
        "ισλανδικά":"is",
        "ιταλικά":"it",
        "καζακστανικά":"kk",
        "κινιαρουάντα":"rw",
        "κιργιζιανά":"ky",
        "κορεατικά":"ko",
        "κορσικανικά":"co",
        "κρεόλ αϊτής":"ht",
        "κροατικά":"hr",
        "λουξεμβουργιανά":"lb",
        "μαλαγάσι":"mg",
        "μαλέι":"ms",
        "μαλτεζικά":"mt",
        "μαορί":"mi",
        "μαραθικά":"mr",
        "μογγολικά":"mn",
        "νεπαλικά":"ne",
        "νορβηγικά":"no",
        "ολλανδικά":"nl",
        "όντια (ορίγια)":"or",
        "ουαλικά":"cy",
        "ουγγρικά":"hu",
        "ουζμπεκικά":"uz",
        "ουιγούρ":"ug",
        "ουκρανικά":"uk",
        "ουρντού":"ur",
        "παντζάμπι":"pa",
        "πάστο":"ps",
        "περσικά":"fa",
        "πολωνικά":"pl",
        "ρουμανικά":"ro",
        "ρωσικά":"ru",
        "σαμοανικά":"sm",
        "σεμπουάνο":"ceb",
        "σερβικά":"sr",
        "σινχάλα":"si",
        "σλαβομακεδονικά":"mk",
        "σλοβακικά":"sk",
        "σομαλικά":"so",
        "σούντα":"su",
        "ταζικιστανικά":"tg",
        "ταϊλανδεζικά":"th",
        "ταταρικά":"tt",
        "τζαβανεζικά":"jw",
        "τούρκικα":"tr",
        "τουρκμενικά":"tk",
        "τσεχικά":"cs",
        "τσιτσέουα":"ny",
        "φιλιπινεζικά":"tl",
        "φινλανδικά":"fi",
        "φριζιανά":"fy",
        "χαβαϊκά":"haw",
        "χάουσα":"ha",
        "χμονγκ":"hmn",
        "κινεζικά (απλοποιημένα)":"zh-CN",
        "κινεζικά (παραδοσιακά)":"zh-TW",
        "ભાષા શોધો":"auto",
        "આઇસલૅન્ડિક":"is",
        "આફ્રિકી":"af",
        "આયરિશ":"ga",
        "આર્મેનિયન":"hy",
        "આલ્બેનિયન":"sq",
        "ઇન્ડોનેશિયન":"id",
        "ઉડિયા (ઓડિયા)":"or",
        "ઉર્દુ":"ur",
        "ઍઝરબૈજાની":"az",
        "ઍમ્હારિક":"am",
        "ઍસ્પૅરેન્તો":"eo",
        "એસ્ટોનિયન":"et",
        "કઝાક":"kk",
        "કતલાન":"ca",
        "કિન્યારવાંડા":"rw",
        "કુર્ડિશ":"ku",
        "કોરીયન":"ko",
        "ક્રોએશિયન":"hr",
        "ગૅલિશિયન":"gl",
        "ચિની":"zh-CN",
        "જાવાનીઝ":"jw",
        "જ્યોર્જિયન":"ka",
        "ડૅનિશ":"da",
        "તજિક":"tg",
        "તમિલ":"ta",
        "તાતાર":"tt",
        "તુર્કમેન":"tk",
        "નોર્વેજિયન":"no",
        "પર્શિયન":"fa",
        "પાશ્તુન":"ps",
        "ફિન્નિશ":"fi",
        "ફિલિપિનો":"tl",
        "ફ્રીઝીઅન":"fy",
        "બંગાળી":"bn",
        "બલ્ગેરિયન":"bg",
        "બાસ્ક":"eu",
        "બેલારૂશિયન":"be",
        "બૉઝ્નિયન":"bs",
        "માલાગાસી":"mg",
        "માલ્ટિઝ":"mt",
        "મેસેડોનિયન":"mk",
        "મૉન્ગ":"hmn",
        "મોંગોલિયન":"mn",
        "યિદ્દિશ":"yi",
        "યુક્રેનિયન":"uk",
        "રોમૅનિયન":"ro",
        "લક્ઝમબર્ગિશ":"lb",
        "લાતવી":"lv",
        "લિથુઆનિયન":"lt",
        "વિયેતનામી":"vi",
        "વીગર":"ug",
        "વેલ્શ":"cy",
        "સમોઅન":"sm",
        "સર્બિયન":"sr",
        "સિંહલી":"si",
        "સુદાનિઝ":"su",
        "સેસોથો":"st",
        "સ્કોટ્સ ગેલિક":"gd",
        "સ્પૅનીશ":"es",
        "સ્લોવૅક":"sk",
        "સ્લોવેનિયન":"sl",
        "સ્વાહિલી":"sw",
        "હંગેરિયન":"hu",
        "હવાઇયન":"haw",
        "હાઇટિઇન ક્રેઓલ":"ht",
        "હીબ્રૂ":"iw",
        "detekte lang":"auto",
        "afriken":"af",
        "albanyen":"sq",
        "amenyen":"hy",
        "aousa":"ha",
        "awayen":"haw",
        "azèbajani":"az",
        "belarisyen":"be",
        "bilgaryen":"bg",
        "chona":"sn",
        "ebre":"iw",
        "endou":"hi",
        "fenlandè":"fi",
        "filipyen":"tl",
        "gaelik ekosè":"gd",
        "galisyen":"gl",
        "goujarasi":"gu",
        "ikrenyen":"uk",
        "islandè":"is",
        "izbèk":"uz",
        "javanwa":"jw",
        "jorjyen":"ka",
        "khmer wouj":"km",
        "kirjiz":"ky",
        "koreyen":"ko",
        "kòsiken":"co",
        "ksosa":"xh",
        "kurde (kurmandji)":"ku",
        "lang oudou":"ur",
        "lang tik":"tk",
        "laten":"la",
        "lawosyen":"lo",
        "letonyen":"lv",
        "liksanboujwa":"lb",
        "malè":"ms",
        "malgach":"mg",
        "malt":"mt",
        "masedonyen":"mk",
        "mongolyen":"mn",
        "olandè, neyèlandè":"nl",
        "onngaryen":"hu",
        "pèsyen":"fa",
        "romanyen":"ro",
        "rwanda":"rw",
        "samoyen":"sm",
        "sinhalese":"si",
        "slovenyen":"sl",
        "somalyen":"so",
        "soudanè":"su",
        "swayili":"sw",
        "syedwa":"sv",
        "tata":"tt",
        "tuk":"tr",
        "tyèk":"cs",
        "yidich":"yi",
        "yowouba":"yo",
        "chinwa (senp)":"zh-CN",
        "tsinkayo harshe":"auto",
        "basulake":"sk",
        "faransanci":"fr",
        "harshen afirkanci":"af",
        "harshen albaniya":"sq",
        "harshen amharik":"am",
        "harshen armeniyanci":"hy",
        "harshen azerbaijanci":"az",
        "harshen basque":"eu",
        "harshen belarushiyanci":"be",
        "harshen bengali":"bn",
        "harshen bosniyanci":"bs",
        "harshen bulgariyanci":"bg",
        "harshen cebuano":"ceb",
        "harshen chichewa":"ny",
        "harshen creole na haiti":"ht",
        "harshen croatia":"hr",
        "harshen czech":"cs",
        "harshen danish":"da",
        "harshen dutch":"nl",
        "harshen esperanto":"eo",
        "harshen farisanci":"fa",
        "harshen filipino":"tl",
        "harshen finnish":"fi",
        "harshen firsi":"fy",
        "harshen gaelic na scots":"gd",
        "harshen galic":"gl",
        "harshen girka":"el",
        "harshen gujarati":"gu",
        "harshen hawaii":"haw",
        "harshen hebrew":"iw",
        "harshen hmong":"hmn",
        "harshen hongeriyanchi":"hu",
        "harshen icelandic":"is",
        "harshen indiyanci":"hi",
        "harshen indonesiya":"id",
        "harshen irish":"ga",
        "harshen istoniyanchi":"et",
        "harshen javanisanci":"jw",
        "harshen jojiyanci":"ka",
        "harshen kannada":"kn",
        "harshen karzakh":"kk",
        "harshen kataloniyanchi":"ca",
        "harshen khmer":"km",
        "harshen kinyarwandanci":"rw",
        "harshen kirgizanci":"ky",
        "harshen kosika":"co",
        "harshen laotian":"lo",
        "harshen latbiyanchi":"lv",
        "harshen latin":"la",
        "harshen lituweniyanchi":"lt",
        "harshen luxembourg":"lb",
        "harshen malagasy":"mg",
        "harshen malay":"ms",
        "harshen maleyalam":"ml",
        "harshen maltese":"mt",
        "harshen maori":"mi",
        "harshen marathi":"mr",
        "harshen masedoniya":"mk",
        "harshen mongolia":"mn",
        "harshen myanmar (burma)":"my",
        "harshen nepal":"ne",
        "harshen norway":"no",
        "harshen pashtanci":"ps",
        "harshen polish":"pl",
        "harshen portugal":"pt",
        "harshen punjabi":"pa",
        "harshen romaniyanchi":"ro",
        "harshen samoa":"sm",
        "harshen serbia":"sr",
        "harshen sesotanci":"st",
        "harshen sinanci":"zh-CN",
        "harshen sindiyanci":"sd",
        "harshen somaliya":"so",
        "harshen sudan":"su",
        "harshen sulobeniya":"sl",
        "harshen swahili":"sw",
        "harshen swedish":"sv",
        "harshen shona":"sn",
        "harshen tajik":"tg",
        "harshen tamil":"ta",
        "harshen tatar":"tt",
        "harshen tayanci":"th",
        "harshen telugu":"te",
        "harshen turanci":"en",
        "harshen turkiyya":"tr",
        "harshen ukrain":"uk",
        "harshen urdu":"ur",
        "harshen uzbek":"uz",
        "harshen vietnamese":"vi",
        "harshen welsh":"cy",
        "harshen xhosa":"xh",
        "harshen yiddish":"yi",
        "harshen zulu":"zu",
        "jafananchi":"ja",
        "jamusanci":"de",
        "koriyanci":"ko",
        "rashiyanchi":"ru",
        "sifaniyanci":"es",
        "tukmenistanci":"tk",
        "yarabanchi":"yo",
        "yaren odia (oriya)":"or",
        "harshen sinanci (a saukake)":"zh-CN",
        "harshen sinanci (na gargajiya)":"zh-TW",
        "זיהוי שפה":"auto",
        "אודיה (אוריה)":"or",
        "אויגור":"ug",
        "אזרית":"az",
        "איגדו":"ig",
        "איטלקית":"it",
        "אירית":"ga",
        "אסטונית":"et",
        "אספרנטו":"eo",
        "אפריקאנס":"af",
        "ארמנית":"hy",
        "באסקית":"eu",
        "בוסנית":"bs",
        "בורמזית":"my",
        "בנגאלית":"bn",
        "ג'אווה":"jw",
        "גאורגית":"ka",
        "גוג'אראטי":"gu",
        "גרמנית":"de",
        "דנית":"da",
        "האוסה":"ha",
        "הוואית":"haw",
        "הולנדית":"nl",
        "הונגרית":"hu",
        "הינדי":"hi",
        "וייטנאמית":"vi",
        "טג'יקית":"tg",
        "טורקית":"tr",
        "טורקמנית":"tk",
        "טטארית":"tt",
        "טמילית":"ta",
        "יוונית":"el",
        "יידיש":"yi",
        "יפנית":"ja",
        "כורדית":"ku",
        "לטווית":"lv",
        "לטינית":"la",
        "מאורית":"mi",
        "מאראתי":"mr",
        "מונגולית":"mn",
        "מלאיאלאם":"ml",
        "מלאית":"ms",
        "מלגשית":"mg",
        "מלטית":"mt",
        "נפאלית":"ne",
        "סבואנו":"ceb",
        "סוואהילית":"sw",
        "סומלית":"so",
        "סונדית":"su",
        "סינדהי":"sd",
        "סינהלית":"si",
        "סינית":"zh-CN",
        "סמואית":"sm",
        "ססוטו":"st",
        "סקוטית גאלית":"gd",
        "עברית":"iw",
        "ערבית":"ar",
        "פאשטו":"ps",
        "פולנית":"pl",
        "פונג'אבית":"pa",
        "פיליפינית":"tl",
        "פינית":"fi",
        "פרסית":"fa",
        "צרפתית":"fr",
        "קאנאדה":"kn",
        "קוסה":"xh",
        "קורסיקאית":"co",
        "קזאחית":"kk",
        "קינירואנדה":"rw",
        "קירגיזית":"ky",
        "קרואטית":"hr",
        "קריאולית האיטית":"ht",
        "רוסית":"ru",
        "תאית":"th",
        "סינית (מסורתית)":"zh-TW",
        "\u200fסינית (פשוטה)":"zh-CN",
        "भाषा का पता लगाएं":"auto",
        "अंग्रेज़ी":"en",
        "अज़रबैजानी":"az",
        "अफ़्रीकांस":"af",
        "अल्बेनियन":"sq",
        "आइसलैंडिक":"is",
        "आर्मेनियन":"hy",
        "इटैलियन":"it",
        "उज़्बेक":"uz",
        "एस्तोनियन":"et",
        "एस्पेरांटो":"eo",
        "ऐम्हेरिक":"am",
        "ओडिया (उड़िया)":"or",
        "कज़ाख़":"kk",
        "कन्नड़":"kn",
        "किनयारवांडा":"rw",
        "कुर्दिश (करमंजी)":"ku",
        "कैटेलन":"ca",
        "कोसा":"xh",
        "क्रोएशियन":"hr",
        "गैलिशियन":"gl",
        "जैवेनीज़":"jw",
        "जॉर्जियन":"ka",
        "डैनिश":"da",
        "तमिल":"ta",
        "तातार":"tt",
        "तुर्क":"tr",
        "तुर्कमेन":"tk",
        "नॉर्वेजियन":"no",
        "फारसी":"fa",
        "फ़िनिश":"fi",
        "फ़िलिपीनो":"tl",
        "फ़्रिसियन":"fy",
        "फ़्रेंच":"fr",
        "बांग्ला":"bn",
        "बुल्गारियन":"bg",
        "बेलारूसीयन":"be",
        "बैस्क":"eu",
        "बोस्नियन":"bs",
        "माऔरी":"mi",
        "माल्टी":"mt",
        "मेलागासी":"mg",
        "मेसीडोनियन":"mk",
        "यिडिश":"yi",
        "यूक्रेनियन":"uk",
        "योरुबा":"yo",
        "रोमेनियन":"ro",
        "लक्ज़मबर्गिश":"lb",
        "लातवियन":"lv",
        "लिथुआनियन":"lt",
        "वीगर":"ug",
        "वेल्श":"cy",
        "संडनीज़":"su",
        "समोआई":"sm",
        "सर्बियाई":"sr",
        "सिंहला":"si",
        "सेबुआनो":"ceb",
        "स्पैनिश":"es",
        "स्लोवाक":"sk",
        "स्लोवेनियन":"sl",
        "स्वाहिली":"sw",
        "हंगरियन":"hu",
        "हमॉन्ग":"hmn",
        "हवायन":"haw",
        "हीब्रू":"iw",
        "हैतियन क्रिओल":"ht",
        "चीनी (पारंपरिक)":"zh-TW",
        "चीनी (सरल)":"zh-CN",
        "nyelvfelismerés":"auto",
        "bosnyák":"bs",
        "lengyel":"pl",
        "macedón":"mk",
        "malagaszi":"mg",
        "malajálam":"ml",
        "maráthi":"mr",
        "skót-gael":"gd",
        "szamoai":"sm",
        "szinhala":"si",
        "szoto":"st",
        "szundanéz":"su",
        "tadzsik":"tg",
        "tatár":"tt",
        "türkmén":"tk",
        "greina tungumál":"auto",
        "afríkanska":"af",
        "amharísku":"am",
        "armenska":"hy",
        "aserska":"az",
        "bengalska":"bn",
        "búrmíska":"my",
        "chicewa":"ny",
        "danska":"da",
        "eistneska":"et",
        "esperantó":"eo",
        "galisíska":"gl",
        "georgísku":"ka",
        "haítískt kreólamál":"ht",
        "havaíska":"haw",
        "hása":"ha",
        "hindí":"hi",
        "hollenska":"nl",
        "igbó":"ig",
        "indónesíska":"id",
        "íslenska":"is",
        "japanska":"ja",
        "javíska":"jw",
        "jorúba":"yo",
        "kasakstanska":"kk",
        "kinjarvanda":"rw",
        "kirgisíska":"ky",
        "kúrdíska":"ku",
        "litháíska":"lt",
        "lúxemborgska":"lb",
        "malagasíska":"mg",
        "malajíska":"ms",
        "maoríska":"mi",
        "maratí":"mr",
        "mongólska":"mn",
        "odía (oriya)":"or",
        "persneska":"fa",
        "pólska":"pl",
        "rúmenska":"ro",
        "rússneska":"ru",
        "samóska":"sm",
        "sebúanó":"ceb",
        "sesótó":"st",
        "sindhí":"sd",
        "skosk-gelíska":"gd",
        "slóvakíska":"sk",
        "slóvenska":"sl",
        "sómalska":"so",
        "spænska":"es",
        "súndíska":"su",
        "svahílí":"sw",
        "sænska":"sv",
        "tadsjikíska":"tg",
        "taílenska":"th",
        "tamílska":"ta",
        "tatarska":"tt",
        "tékkneska":"cs",
        "túrkmenska":"tk",
        "ungverska":"hu",
        "úkraínska":"uk",
        "úsbekíska":"uz",
        "víetnamska":"vi",
        "þýska":"de",
        "chọpụta asụsụ":"auto",
        "asụsụ bekee":"en",
        "asụsụ chiniiz":"zh-CN",
        "asụsụ zosa":"xh",
        "asụsụ china (simplified)":"zh-CN",
        "asụsụ china (traditional)":"zh-TW",
        "deteksi bahasa":"auto",
        "afrikans":"af",
        "belarussia":"be",
        "denmark":"da",
        "frisia":"fy",
        "gaelig":"ga",
        "gaelik skotlandia":"gd",
        "galisia":"gl",
        "georgia":"ka",
        "islan":"is",
        "katala":"ca",
        "lituania":"lt",
        "luksemburg":"lb",
        "prancis":"fr",
        "swensk":"sv",
        "wales":"cy",
        "china (aks. sederhana)":"zh-CN",
        "china (aks. tradisional)":"zh-TW",
        "aimsigh teanga":"auto",
        "afracáinis":"af",
        "airméinis":"hy",
        "albáinis":"sq",
        "amárais":"am",
        "asarbaiseáinis":"az",
        "bascais":"eu",
        "beangáilis":"bn",
        "boisnis":"bs",
        "casaicis":"kk",
        "ciméiris":"km",
        "ciniaruaindis":"rw",
        "cirgisis":"ky",
        "coirdis (curmainsis)":"ku",
        "corsaicis":"co",
        "cósais":"xh",
        "criól háítí":"ht",
        "cróitis":"hr",
        "danmhairgis":"da",
        "eabhrais":"iw",
        "eastóinis":"et",
        "filipínis":"tl",
        "fionlainnis":"fi",
        "freaslainnis":"fy",
        "gaeilge na halban":"gd",
        "gailísis":"gl",
        "gúisearáitis":"gu",
        "hásais":"ha",
        "haváis":"haw",
        "hiondúis":"hi",
        "iarúibis":"yo",
        "íogbóis":"ig",
        "ioruais":"no",
        "laitvis":"lv",
        "laoisis":"lo",
        "liotuáinis":"lt",
        "lucsambuirgis":"lb",
        "macadóinis":"mk",
        "mailéalaimis":"ml",
        "malaeis":"ms",
        "malagáisis":"mg",
        "máltais":"mt",
        "maorais":"mi",
        "maraitis":"mr",
        "mongais":"hmn",
        "mongóilis":"mn",
        "neipeailis":"ne",
        "odia (oirísis)":"or",
        "paistis":"ps",
        "peirsis":"fa",
        "polainnis":"pl",
        "portaingéilis":"pt",
        "puinseáibis":"pa",
        "rómáinis":"ro",
        "samóis":"sm",
        "seabúáinis":"ceb",
        "seapáinis":"ja",
        "seasóitis":"st",
        "seicis":"cs",
        "seoinis":"sn",
        "seoirsis":"ka",
        "sindis":"sd",
        "siolóinis":"si",
        "siséivis":"ny",
        "slóivéinis":"sl",
        "slóvaicis":"sk",
        "somáilis":"so",
        "spáinnis":"es",
        "sualainnis":"sv",
        "súdáinis":"su",
        "súlúis":"zu",
        "taidsícis":"tg",
        "tamailis":"ta",
        "tatairis":"tt",
        "téalainnis":"th",
        "teileagúis":"te",
        "tuircméinis":"tk",
        "úcráinis":"uk",
        "uigiúiris":"ug",
        "úisbéiceastáinis":"uz",
        "ungáiris":"hu",
        "urdais":"ur",
        "vítneaimis":"vi",
        "rileva lingua":"auto",
        "amarico":"am",
        "armeno":"hy",
        "bielorusso":"be",
        "bosniaco":"bs",
        "bulgaro":"bg",
        "catalano":"ca",
        "ceco":"cs",
        "croato":"hr",
        "ebraico":"iw",
        "filippino":"tl",
        "frisone":"fy",
        "greco":"el",
        "indonesiano":"id",
        "kazako":"kk",
        "kirghiso":"ky",
        "latino":"la",
        "malgascio":"mg",
        "mongolo":"mn",
        "persiano":"fa",
        "polacco":"pl",
        "rumeno":"ro",
        "russo":"ru",
        "serbo":"sr",
        "slovacco":"sk",
        "sloveno":"sl",
        "somalo":"so",
        "spagnolo":"es",
        "tagiko":"tg",
        "tataro":"tt",
        "tedesco":"de",
        "ucraino":"uk",
        "uzbeco":"uz",
        "cinese (semplificato)":"zh-CN",
        "cinese (tradizionale)":"zh-TW",
        "言語を検出する":"auto",
        "イボ語":"ig",
        "ウイグル語":"ug",
        "ウェールズ語":"cy",
        "ウルドゥ語":"ur",
        "エスペラント語":"eo",
        "オランダ語":"nl",
        "オリヤ語":"or",
        "カザフ語":"kk",
        "カタルーニャ語":"ca",
        "キニヤルワンダ語":"rw",
        "キルギス語":"ky",
        "グジャラト語":"gu",
        "クメール語":"km",
        "クルド語":"ku",
        "コルシカ語":"co",
        "ジョージア(グルジア)語":"ka",
        "ショナ語":"sn",
        "スウェーデン語":"sv",
        "ズールー語":"zu",
        "スコットランド ゲール語":"gd",
        "セブアノ語":"ceb",
        "ソト語":"st",
        "タガログ語":"tl",
        "タタール語":"tt",
        "チェワ語":"ny",
        "テルグ語":"te",
        "トルクメン語":"tk",
        "ハイチ語":"ht",
        "ハウサ語":"ha",
        "パシュト語":"ps",
        "ハワイ語":"haw",
        "ベラルーシ語":"be",
        "ペルシャ語":"fa",
        "ポーランド語":"pl",
        "マオリ語":"mi",
        "マケドニア語":"mk",
        "マラガシ語":"mg",
        "ミャンマー語":"my",
        "ヨルバ語":"yo",
        "ラオ語":"lo",
        "ラテン語":"la",
        "ロシア語":"ru",
        "中国語":"zh-CN",
        "中国語(簡体)":"zh-CN",
        "中国語(繁体)":"zh-TW",
        "deteksi basa":"auto",
        "bahasa kurdi (kurmanji)":"ku",
        "basa afrikaans":"af",
        "basa albania":"sq",
        "basa amharik":"am",
        "basa arab":"ar",
        "basa armenia":"hy",
        "basa azerbaijan":"az",
        "basa basque":"eu",
        "basa belarusia":"be",
        "basa bengali":"bn",
        "basa bosnia":"bs",
        "basa bulgaria":"bg",
        "basa cebuano":"ceb",
        "basa ceko":"cs",
        "basa chichewa":"ny",
        "basa cina":"zh-CN",
        "basa denmark":"da",
        "basa esperanto":"eo",
        "basa estonia":"et",
        "basa farisi":"fy",
        "basa finlandia":"fi",
        "basa galisia":"gl",
        "basa georgia":"ka",
        "basa gujarat":"gu",
        "basa haiti kreol":"ht",
        "basa hausa":"ha",
        "basa hawai":"haw",
        "basa hmong":"hmn",
        "basa hungaria":"hu",
        "basa ibrani":"iw",
        "basa igbo":"ig",
        "basa india":"hi",
        "basa indonesia":"id",
        "basa inggris":"en",
        "basa islandia":"is",
        "basa italia":"it",
        "basa jawa":"jw",
        "basa jepang":"ja",
        "basa jerman":"de",
        "basa kannada":"kn",
        "basa katala":"ca",
        "basa kazakhstan":"kk",
        "basa khmer":"km",
        "basa kirgiz":"ky",
        "basa korea":"ko",
        "basa korsika":"co",
        "basa kroasia":"hr",
        "basa laos":"lo",
        "basa latin":"la",
        "basa latvia":"lv",
        "basa lituania":"lt",
        "basa londo":"nl",
        "basa luksembourg":"lb",
        "basa makedonia":"mk",
        "basa malagasi":"mg",
        "basa malayalam":"ml",
        "basa malaysia":"ms",
        "basa malta":"mt",
        "basa maori":"mi",
        "basa marathi":"mr",
        "basa mongol":"mn",
        "basa myanmar (burma)":"my",
        "basa nepal":"ne",
        "basa norwegia":"no",
        "basa pashto":"ps",
        "basa persia":"fa",
        "basa polandia":"pl",
        "basa portugis":"pt",
        "basa prancis":"fr",
        "basa punjabi":"pa",
        "basa romawi":"ro",
        "basa rusia":"ru",
        "basa samoa":"sm",
        "basa scots gaelik":"gd",
        "basa serbia":"sr",
        "basa sesotho":"st",
        "basa shona":"sn",
        "basa sindhi":"sd",
        "basa sinhala":"si",
        "basa slovakia":"sk",
        "basa slovenia":"sl",
        "basa somalia":"so",
        "basa spanyol":"es",
        "basa sunda":"su",
        "basa swahili":"sw",
        "basa swedia":"sv",
        "basa tagalog":"tl",
        "basa tajik":"tg",
        "basa tamil":"ta",
        "basa tatar.":"tt",
        "basa telugu":"te",
        "basa thailand":"th",
        "basa turki":"tr",
        "basa turkmen":"tk",
        "basa ukrania":"uk",
        "basa urdu":"ur",
        "basa uzbekistan":"uz",
        "basa vietnam":"vi",
        "basa wales":"cy",
        "basa xhosa":"xh",
        "basa yahudi":"yi",
        "basa yoruba":"yo",
        "basa yunani":"el",
        "basa zulu":"zu",
        "basa.kinyarwanda.":"rw",
        "basa.uyghur.":"ug",
        "basa cina (anyaran)":"zh-CN",
        "basa cina (kuna)":"zh-TW",
        "ಭಾಷೆ ಗುರುತಿಸು":"auto",
        "ಅಜರ್ಬೈಜಾನಿ":"az",
        "ಅಮಹಾರಿಕ್":"am",
        "ಅರಬ್ಬಿ":"ar",
        "ಆರ್ಮೇನಿಯನ್":"hy",
        "ಆಲ್ಬೇನಿಯನ್":"sq",
        "ಇಂಗ್ಲಿಷ್\u200c\u200c":"en",
        "ಇಗ್ಬೋ":"ig",
        "ಉಯ್\u200cಗರ್":"ug",
        "ಎಸ್ಪೆರಾಂಟೋ":"eo",
        "ಐರಿಷ್":"ga",
        "ಐಸ್\u200cಲ್ಯಾಂಡಿಕ್\u200c":"is",
        "ಒಡಿಯಾ (ಒರಿಯಾ)":"or",
        "ಕಝಕ್":"kk",
        "ಕೀನ್ಯಾರುವಾಂಡಾ":"rw",
        "ಕೊರ್ಸಿಕನ್":"co",
        "ಕ್ಯಾಟಲನ್":"ca",
        "ಕ್ಷೋಸ":"xh",
        "ಖಮೆರ್":"km",
        "ಗ್ಯಾಲೀಷಿಯನ್":"gl",
        "ಗ್ರೀಕ್":"el",
        "ಚೀನಿ":"zh-CN",
        "ಜಪಾನಿ":"ja",
        "ಝೆಕ್\u200c":"cs",
        "ಟರ್ಕಿಷ್":"tr",
        "ಟರ್ಕ್\u200cಮೆನ್":"tk",
        "ಟಾಟರ್":"tt",
        "ಡ್ಯಾನಿಷ್":"da",
        "ತಜಿಕ್":"tg",
        "ನಾರ್ವೇಜಿಯನ್\u200c":"no",
        "ಪಶ್ತೊ":"ps",
        "ಪೋಲಿಷ್":"pl",
        "ಫಾರ್ಸಿ":"fa",
        "ಫ್ರಿಸಿಯನ್":"fy",
        "ಬಂಗಾಳಿ":"bn",
        "ಮಾವೋರಿ":"mi",
        "ಮ್ಯಾಸೆಡೋನಿಯನ್":"mk",
        "ಯಿಡ್ಡಿಶ್":"yi",
        "ಯುಕ್ರೇನಿಯನ್":"uk",
        "ರಷಿಯನ್":"ru",
        "ಲಕ್ಸಂಬರ್ಗಿಶ್":"lb",
        "ಲಾವೋ":"lo",
        "ಲ್ಯಾಟ್ವಿಯನ್\u200c":"lv",
        "ವಿಯೆಟ್ನಾಮಿ":"vi",
        "ವೆಲ್ಶ್":"cy",
        "ಸಮೋನ್":"sm",
        "ಸಿಂಹಳಿ":"si",
        "ಸಿಬ್ಯುವಾನೊ":"ceb",
        "ಸುಂಡಾನೀಸ್\u200c":"su",
        "ಸೆಸೊತೊ":"st",
        "ಸ್ಕಾಟ್ಸ್ ಗ್ಯಾಲಿಕ್":"gd",
        "ಸ್ಲೊವಾಕ್":"sk",
        "ಸ್ಲೊವೆನಿಯನ್":"sl",
        "ಸ್ವಾಹಿಲಿ":"sw",
        "ಸ್ವೀಡಿಷ್":"sv",
        "ಹಮಾಂಗ್":"hmn",
        "ಹಯಥಿಯನ್\u200c ಕ್ರಿಯೋಲ್\u200c":"ht",
        "ಹಿಂದಿ":"hi",
        "ಚೀನಿ (ಸರಳೀಕೃತ)":"zh-CN",
        "ಚೀನಿ (ಸಾಂಪ್ರದಾಯಿಕ)":"zh-TW",
        "тілді анықтау":"auto",
        "ағылшын":"en",
        "албан":"sq",
        "әзiрбайжан":"az",
        "беларусь":"be",
        "бенгал":"bn",
        "бирма (мьянма)":"my",
        "бур":"af",
        "валлий":"cy",
        "венгр":"hu",
        "вьетнам":"vi",
        "гавай":"haw",
        "галисия":"gl",
        "голланд":"nl",
        "грузин":"ka",
        "индонезия":"id",
        "исланд":"is",
        "итальян":"it",
        "киньяруанда":"rw",
        "корсика":"co",
        "креоль (гаити)":"ht",
        "латыш":"lv",
        "литва":"lt",
        "люксембург":"lb",
        "македон":"mk",
        "малайялам":"ml",
        "мальта":"mt",
        "непал":"ne",
        "панджаб":"pa",
        "парсы":"fa",
        "поляк":"pl",
        "португал":"pt",
        "сингал":"si",
        "судан":"su",
        "татар":"tt",
        "түрікмен":"tk",
        "филиппин":"tl",
        "фрис":"fy",
        "хоса":"xh",
        "шотланд (гaэль)":"gd",
        "ява":"jw",
        "កំណត់\u200bភាសា\u200bដោយ\u200bស្វ័យ\u200bប្រវត្តិ":"auto",
        "កាតាឡង់":"ca",
        "កាន់ណាដា":"kn",
        "កាហ្សាក់ស្តង់":"kk",
        "កូសីកា":"co",
        "ក្រូអាត":"hr",
        "ក្រេអូលី\u200bហៃទី":"ht",
        "ខ្មែរ":"km",
        "គីនយ៉ារវ៉ាន់ដា":"rw",
        "គីស៊ី":"ky",
        "ឃឺដ (គូម៉ាន់ជី)":"ku",
        "ចិន":"zh-CN",
        "ឆេក":"cs",
        "ជប៉ុន":"ja",
        "ជ្វា":"jw",
        "ឈិចិវា":"ny",
        "ដាណឺម៉ាក":"da",
        "តាដហ្ស៊ីគីស្តង់":"tg",
        "តាតា":"tt",
        "តាមីល":"ta",
        "តេលុគុ":"te",
        "ទួកគី":"tr",
        "ទួគមេនីស្តង់":"tk",
        "នេប៉ាល់":"ne",
        "បង់ក្លាដែស":"bn",
        "បាស្កេ":"eu",
        "បាស្តូ":"ps",
        "បឹនជាពិ":"pa",
        "ប៊ុលហ្ការី":"bg",
        "បូស្នី":"bs",
        "ប៉ូឡូញ":"pl",
        "បេឡារុស្ស":"be",
        "ព័រទុយហ្គាល់":"pt",
        "ភឺសៀន":"fa",
        "ម៉ាដាហ្កាសការ":"mg",
        "ម៉ារាទី":"mr",
        "ម៉ាល់តា":"mt",
        "ម៉ាសេដូនី":"mk",
        "ម៉ាឡាយ៉ាឡាម":"ml",
        "ម៉ាឡេស៊ី":"ms",
        "មីយ៉ាន់ម៉ា (ភូមា)":"my",
        "ម៉ុង":"hmn",
        "ម៉ុងហ្គោលី":"mn",
        "ម៉ោរី":"mi",
        "យីឌីស":"yi",
        "យូរុយបា":"yo",
        "រុស្ស៊ី":"ru",
        "រូម៉ានី":"ro",
        "លីទុយអានី":"lt",
        "លុចហ្សំបួរ":"lb",
        "វីហ្គើ":"ug",
        "វៀតណាម":"vi",
        "វេល":"cy",
        "សាមូអា":"sm",
        "ស៊ី\u200bន\u200bហា\u200bឡា":"si",
        "ស៊ីន្តី":"sd",
        "សឺប៊ូអាណូ":"ceb",
        "ស៊ុយអែត":"sv",
        "ស៊ូដង់":"su",
        "សូណា":"sn",
        "សូម៉ាលី":"so",
        "សូលូ":"zu",
        "សេសូធូ":"st",
        "ស៊ែប៊ី":"sr",
        "ស្កុតហ្គាលីក":"gd",
        "ស្លូវ៉ានី":"sl",
        "ហាវ៉ៃ":"haw",
        "ហិណ្ឌី":"hi",
        "ហុងគ្រី":"hu",
        "ហូសា":"ha",
        "ហូ\u200bស្សា":"xh",
        "ហូឡង់":"nl",
        "ហ្កុយ៉ារាទី":"gu",
        "ហ្គាលីស្យាន":"gl",
        "ហ្រីសង់":"fy",
        "ហ្វីលីពីន":"tl",
        "ហ្សក\u200bហ្ស៊ី":"ka",
        "ឡាតវីយ៉ា":"lv",
        "អង់គ្លេស":"en",
        "អាមហារីច":"am",
        "អារមេនី":"hy",
        "អាល្លឺម៉ង់":"de",
        "អាហ៊្សែបៃហ្សង់":"az",
        "ឥណ្ឌូណេស៊ី":"id",
        "អ៊ីកបូ":"ig",
        "អ៊ីស្រាអែល":"iw",
        "អ៊ីស្លង់":"is",
        "អូឌៀ (អូរីយា)":"or",
        "អ៊ូរឌូ":"ur",
        "អ៊ូហ្សបេគីស្តង់":"uz",
        "អៀរឡង់":"ga",
        "អេស្តូនី":"et",
        "អេស្ប៉ាញ":"es",
        "អេស្ពេរ៉ាន់តូ":"eo",
        "ចិន (អក្សរកាត់)":"zh-CN",
        "ចិន (អក្សរ\u200bពេញ)":"zh-TW",
        "언어 감지":"auto",
        "구자라트어":"gu",
        "그리스어":"el",
        "네덜란드어":"nl",
        "네팔어":"ne",
        "노르웨이어":"no",
        "덴마크어":"da",
        "독일어":"de",
        "라오어":"lo",
        "라트비아어":"lv",
        "라틴어":"la",
        "러시아어":"ru",
        "루마니아어":"ro",
        "룩셈부르크어":"lb",
        "리투아니아어":"lt",
        "마라티어":"mr",
        "마오리어":"mi",
        "마케도니아어":"mk",
        "말라가시어":"mg",
        "말라얄람어":"ml",
        "말레이어":"ms",
        "몰타어":"mt",
        "몽골어":"mn",
        "몽어":"hmn",
        "미얀마어 (버마어)":"my",
        "바스크어":"eu",
        "벨라루스어":"be",
        "벵골어":"bn",
        "보스니아어":"bs",
        "불가리아어":"bg",
        "사모아어":"sm",
        "세르비아어":"sr",
        "세부아노":"ceb",
        "세소토어":"st",
        "소말리아어":"so",
        "쇼나어":"sn",
        "순다어":"su",
        "스코틀랜드 게일어":"gd",
        "스페인어":"es",
        "슬로바키아어":"sk",
        "슬로베니아어":"sl",
        "신디어":"sd",
        "신할라어":"si",
        "아랍어":"ar",
        "아르메니아어":"hy",
        "아이슬란드어":"is",
        "아이티 크리올어":"ht",
        "아일랜드어":"ga",
        "아제르바이잔어":"az",
        "아프리칸스어":"af",
        "알바니아어":"sq",
        "암하라어":"am",
        "에스토니아어":"et",
        "에스페란토어":"eo",
        "오리야어":"or",
        "요루바어":"yo",
        "우즈베크어":"uz",
        "우크라이나어":"uk",
        "웨일즈어":"cy",
        "이그보어":"ig",
        "이디시어":"yi",
        "이탈리아어":"it",
        "인도네시아어":"id",
        "조지아어":"ka",
        "줄루어":"zu",
        "중국어":"zh-CN",
        "체와어":"ny",
        "체코어":"cs",
        "카탈로니아어":"ca",
        "코르시카어":"co",
        "코사어":"xh",
        "크로아티아어":"hr",
        "크메르어":"km",
        "키냐르완다어":"rw",
        "키르기스어":"ky",
        "타갈로그어":"tl",
        "타밀어":"ta",
        "타지크어":"tg",
        "타타르어":"tt",
        "태국어":"th",
        "텔루구어":"te",
        "투르크멘어":"tk",
        "파슈토어":"ps",
        "펀자브어":"pa",
        "페르시아어":"fa",
        "포르투갈어":"pt",
        "폴란드어":"pl",
        "프랑스어":"fr",
        "프리지아어":"fy",
        "하와이어":"haw",
        "하우사어":"ha",
        "헝가리어":"hu",
        "히브리어":"iw",
        "힌디어":"hi",
        "중국어(간체)":"zh-CN",
        "중국어(번체)":"zh-TW",
        "dili algıla":"auto",
        "afrika dili":"af",
        "arnavutça":"sq",
        "azerice":"az",
        "baskça":"eu",
        "belarusça":"be",
        "bengalce":"bn",
        "boşnakça":"bs",
        "bulgarca":"bg",
        "burmaca":"my",
        "cava dili":"jw",
        "çekçe":"cs",
        "danca":"da",
        "endonezya dili":"id",
        "ermenice":"hy",
        "esperantoca":"eo",
        "estonyaca":"et",
        "felemenkçe":"nl",
        "filipince":"tl",
        "frizon dili":"fy",
        "galce":"cy",
        "galiçyaca":"gl",
        "gücerat dili":"gu",
        "gürcüce":"ka",
        "habeşçe":"am",
        "haiti creole dili":"ht",
        "hausa dili":"ha",
        "havai dili":"haw",
        "hırvatça":"hr",
        "hmong dili":"hmn",
        "hosa":"xh",
        "i̇gbo dili":"ig",
        "i̇ngilizce":"en",
        "i̇rlandaca":"ga",
        "i̇spanyolca":"es",
        "i̇talyanca":"it",
        "kamboçyaca":"km",
        "katalanca":"ca",
        "kazakça":"kk",
        "kırgızca":"ky",
        "korece":"ko",
        "korsika dili":"co",
        "kuzey i̇skoç dili":"gd",
        "kürtçe":"ku",
        "laoca":"lo",
        "letonca":"lv",
        "litvanca":"lt",
        "lüksemburgca":"lb",
        "madagaskar dili":"mg",
        "makedonca":"mk",
        "malezya dili":"ms",
        "malta dili":"mt",
        "maori dili":"mi",
        "nepalce":"ne",
        "odiya (oriya)":"or",
        "pencap dili":"pa",
        "peştuca":"ps",
        "romence":"ro",
        "ruandaca":"rw",
        "samoaca":"sm",
        "sesotho dili":"st",
        "seylanca":"si",
        "sint":"sd",
        "slovakça":"sk",
        "slovence":"sl",
        "somalice":"so",
        "sundanizce":"su",
        "svahili dili":"sw",
        "tacikce":"tg",
        "tatarca":"tt",
        "tay dili":"th",
        "telugu dili":"te",
        "türkçe":"tr",
        "türkmence":"tk",
        "ukraynaca":"uk",
        "uygurca":"ug",
        "vietnamca":"vi",
        "yidce":"yi",
        "yunanca":"el",
        "çince (basitleştirilmiş)":"zh-CN",
        "çince (geleneksel)":"zh-TW",
        "тилди аныктоо":"auto",
        "африкаанча":"af",
        "бенгаличе":"bn",
        "бирманча":"my",
        "боснияча":"bs",
        "гаитилик креолчо":"ht",
        "галисийче":"gl",
        "ивритче":"iw",
        "игбочо":"ig",
        "исландча":"is",
        "италиянча":"it",
        "корсикача":"co",
        "курманжиче":"ku",
        "кхмерче":"km",
        "кхосача":"xh",
        "лаосчо":"lo",
        "латышча":"lv",
        "македончо":"mk",
        "малагасиче":"mg",
        "малайаламча":"ml",
        "мальтача":"mt",
        "маратхиче":"mr",
        "непалча":"ne",
        "одияча (ория)":"or",
        "пуштуча":"ps",
        "руандача":"rw",
        "самоача":"sm",
        "себуанча":"ceb",
        "сесоточо":"st",
        "сингалча":"si",
        "синдхиче":"sd",
        "словенче":"sl",
        "суахиличе":"sw",
        "тажикче":"tg",
        "татарча":"tt",
        "түркмөнчө":"tk",
        "фарсча":"fa",
        "филиппинче":"tl",
        "французча":"fr",
        "фризче":"fy",
        "чичевача":"ny",
        "шонача":"sn",
        "шотландиялык кельтче":"gd",
        "яванча":"jw",
        "кытайча (жөнөкөйлөштүрүлгөн)":"zh-CN",
        "кытайча (салттуу)":"zh-TW",
        "ກວດສອບພາສາ":"auto",
        "ກຣີກ":"el",
        "ກາລິຊຽນ":"gl",
        "ກີກີສ":"ky",
        "ກູຈາຣາຕີ":"gu",
        "ຂະແມ":"km",
        "ຄໍສິແຄນ":"co",
        "ຄັນນາດາ":"kn",
        "ຄາຊັກ":"kk",
        "ຄາຕາແລນ":"ca",
        "ຄິນຢາວັນດາ":"rw",
        "ເຄີດິສ":"ku",
        "ໂຄຣເອທຽນ":"hr",
        "ຈໍຈຽນ":"ka",
        "ຈາວານີສ":"jw",
        "ສະກັອດ ແກລິກ":"gd",
        "ສະແປນນິຊ":"es",
        "ສະໂລເວນຽນ":"sl",
        "ສະໂລແວັກ":"sk",
        "ສະວີດິຊ":"sv",
        "\u200bສິງ\u200bຫາ\u200bລາ":"si",
        "ສິນທິ":"sd",
        "ຊວາຮີລີ":"sw",
        "ຊັນດານນີສ":"su",
        "ຊາໂມນ":"sm",
        "ຊິເຊວາ":"ny",
        "ຊີບົວໂນ":"ceb",
        "ຊູລູ":"zu",
        "ເຊກ":"cs",
        "ເຊໂຊໂທ":"st",
        "ເຊີບຽນ":"sr",
        "ໂຊຊາ":"xh",
        "ໂຊນາ":"sn",
        "ໂຊມາລີ":"so",
        "ດັດຊ໌":"nl",
        "ແດນນິຊ":"da",
        "ຕວຽກເມັນ":"tk",
        "ເຕລູກູ":"te",
        "ເຕີກິສ":"tr",
        "ທາຈິກ":"tg",
        "ທາທາ":"tt",
        "ທາມິລ":"ta",
        "ນໍເວກຽນ":"no",
        "ເນປານລີ":"ne",
        "ບອສນຽນ":"bs",
        "ບັງກາຣຽນ":"bg",
        "ເບລາຣັສຊຽນ":"be",
        "ເບັງກາລີ":"bn",
        "ແບກສເກິ":"eu",
        "ປໍຕູກີສ":"pt",
        "ປັນຈາບິ":"pa",
        "ເປີຊຽນ":"fa",
        "ໂປລິຊ":"pl",
        "ພາສໂທ":"ps",
        "ພາສາອຸຍເກີ":"ug",
        "ຟຣິຊຽນ":"fy",
        "ຟິນນິສ":"fi",
        "ຟິລິບປິນໂນ":"tl",
        "ມອງໂກລຽນ":"mn",
        "ມາກາລາຊີ":"mg",
        "ມາເຊໂດນຽນ":"mk",
        "ມານທິສ":"mt",
        "ມາຣາທີ":"mr",
        "ມາເລ":"ms",
        "ມາເລຢາລາມ":"ml",
        "ເມົາຣີ":"mi",
        "ຢໍຣູບາ":"yo",
        "ຢິດດິສ":"yi",
        "ຢູເຄຣນຽນ":"uk",
        "ເຢຍລະມັນ":"de",
        "ຣັດຊຽນ":"ru",
        "ໂຣມານຽນ":"ro",
        "ລັກເຊມເບີກກິສ":"lb",
        "ລັດວຽນ":"lv",
        "ລິທົວນຽນ":"lt",
        "ເວວ":"cy",
        "ຫວຽດນາມ":"vi",
        "ອະເຊີໄບຈານິ":"az",
        "ອັລບານຽນ":"sq",
        "ອາຟຣິການ":"af",
        "ອາເມນຽນ":"hy",
        "ອາຣດູ":"ur",
        "ອາຣາບິກ":"ar",
        "ອຳຮາຣິກ":"am",
        "ອິກໂບ":"ig",
        "ອິຕາລຽນ":"it",
        "ອິນໂດເນຊຽນ":"id",
        "ອຸສເບກ":"uz",
        "ເອສໂຕນຽນ":"et",
        "ເອສເປີຣັນໂຕ":"eo",
        "ໂອເດຍ (ໂອຣິຍາ)":"or",
        "ໄອສແລນດິດ":"is",
        "ໄອຣິຊ":"ga",
        "ຮັງກາຣຽນ":"hu",
        "ຮາວາຍອຽນ":"haw",
        "ຮິນດິ":"hi",
        "ຮີບຣິວ":"iw",
        "ເຮົາຊາ":"ha",
        "ໄຮທຽນ ຄຣີໂອ":"ht",
        "ຈີນ (ແບບງ່າຍ)":"zh-CN",
        "noteikt valodu":"auto",
        "afrikāņu":"af",
        "albāņu":"sq",
        "amharu":"am",
        "bengāļu":"bn",
        "birmiešu":"my",
        "bosniešu":"bs",
        "ebreju (ivrits)":"iw",
        "ebreju (jidišs)":"yi",
        "filipīniešu":"tl",
        "franču":"fr",
        "frīzu":"fy",
        "galisiešu":"gl",
        "gudžaratu":"gu",
        "hausu":"ha",
        "havajiešu":"haw",
        "hmongu":"hmn",
        "indonēziešu":"id",
        "īslandiešu":"is",
        "itāļu":"it",
        "javiešu":"jw",
        "jorubiešu":"yo",
        "kazahu":"kk",
        "khosu":"xh",
        "kiņaruanda":"rw",
        "korsikāņu":"co",
        "kreolu (haiti)":"ht",
        "laosiešu":"lo",
        "latviešu":"lv",
        "lietuviešu":"lt",
        "luksemburgiešu":"lb",
        "maķedoniešu":"mk",
        "malagasu":"mg",
        "malajalamiešu":"ml",
        "malajiešu":"ms",
        "maratu":"mr",
        "nepāliešu":"ne",
        "norvēģu":"no",
        "oriju valoda":"or",
        "pandžabu":"pa",
        "poļu":"pl",
        "portugāļu":"pt",
        "samoāņu":"sm",
        "sebuāņu":"ceb",
        "sindžu":"sd",
        "singāļu":"si",
        "slovāku":"sk",
        "somāļu":"so",
        "sundaniešu":"su",
        "svahilu":"sw",
        "tadžiku":"tg",
        "taju":"th",
        "tamilu":"ta",
        "tatāru valoda":"tt",
        "turkmēņu valoda":"tk",
        "uiguru valoda":"ug",
        "ungāru":"hu",
        "vācu":"de",
        "velsiešu":"cy",
        "zviedru":"sv",
        "ķīniešu (vienkāršotā)":"zh-CN",
        "nustatyti kalbą":"auto",
        "afrikanso":"af",
        "albanų":"sq",
        "amharų":"am",
        "arabų":"ar",
        "baltarusių":"be",
        "bengalų":"bn",
        "birmiečių":"my",
        "bosnių":"bs",
        "danų":"da",
        "galisų":"gl",
        "graikų":"el",
        "gruzinų":"ka",
        "gudžaratų":"gu",
        "haičio kreolų":"ht",
        "hausų":"ha",
        "havajiečių":"haw",
        "hebrajų":"iw",
        "hmongų":"hmn",
        "igbų":"ig",
        "indoneziečių":"id",
        "islandų":"is",
        "italų":"it",
        "javiečių":"jw",
        "jidiš (žydų)":"yi",
        "jorubų":"yo",
        "kanadų":"kn",
        "kataloniečių":"ca",
        "kazachų":"kk",
        "kirgizų":"ky",
        "korsikiečių":"co",
        "kosų":"xh",
        "kurdų":"ku",
        "laosiečių":"lo",
        "latvių":"lv",
        "lenkų":"pl",
        "lietuvių":"lt",
        "liuksemburgiečių":"lb",
        "lotynų":"la",
        "makedoniečių":"mk",
        "malagasių":"mg",
        "malajalių":"ml",
        "malajiečių":"ms",
        "nepaliečių":"ne",
        "odijų (orijų)":"or",
        "olandų":"nl",
        "pandžabų":"pa",
        "prancūzų":"fr",
        "puštunų (afganų)":"ps",
        "samojiečių":"sm",
        "sebuanų":"ceb",
        "sesuto":"st",
        "sindų":"sd",
        "sinhalų":"si",
        "slovakų":"sk",
        "somaliečių":"so",
        "sundų":"su",
        "svahilių":"sw",
        "škotų (gėlų)":"gd",
        "šonų":"sn",
        "tagalų":"tl",
        "tajų":"th",
        "tamilų":"ta",
        "telugų":"te",
        "totorių":"tt",
        "turkmėnų":"tk",
        "uigūrų k.":"ug",
        "urdų":"ur",
        "uzbekų":"uz",
        "vokiečių":"de",
        "zulusų":"zu",
        "kinų (tradicinė)":"zh-TW",
        "откриј го јазикот":"auto",
        "азербејџански":"az",
        "белоруски":"be",
        "галициски":"gl",
        "германски":"de",
        "гуџарати":"gu",
        "јавански":"jw",
        "јорупски":"yo",
        "казашки":"kk",
        "киргиски":"ky",
        "кмерски":"km",
        "лаошки":"lo",
        "латвиски":"lv",
        "одија (орија)":"or",
        "паштунски":"ps",
        "руандски":"rw",
        "сомалиски":"so",
        "сото":"st",
        "сундски":"su",
        "таџички":"tg",
        "узбечки":"uz",
        "ујгурски":"ug",
        "фризиски":"fy",
        "хаитски креолски":"ht",
        "хиндиски":"hi",
        "шкотски галски":"gd",
        "haminany fiteny":"auto",
        "afrikana":"af",
        "alibaniana":"sq",
        "amharika":"am",
        "azerbaijanina":"az",
        "biolgariana":"bg",
        "birmanina":"my",
        "bosniana":"bs",
        "ekaosey gaelika":"gd",
        "espanola":"es",
        "farisiana":"fy",
        "finlandey":"fi",
        "galisiana":"gl",
        "galoà":"cy",
        "grika":"el",
        "haoaiana":"haw",
        "haolandey":"nl",
        "hongoroà":"hu",
        "iokreniana":"uk",
        "islandey":"is",
        "japoney":"ja",
        "kaorisa":"co",
        "kiniarohandà":"rw",
        "kreol haisiana":"ht",
        "letoniana":"lv",
        "litoaniana":"lt",
        "maleziana":"ms",
        "maltey":"mt",
        "norveziana":"no",
        "oigoro":"ug",
        "ordò":"ur",
        "ozbeka":"uz",
        "paortigey":"pt",
        "pashtò":"ps",
        "ponjaby":"pa",
        "romaniana":"ro",
        "saondaney":"su",
        "slovaky":"sk",
        "sloveniana":"sl",
        "soahili":"sw",
        "soedoà":"sv",
        "somaliana":"so",
        "tamily":"ta",
        "tatary":"tt",
        "telogò":"te",
        "tseky":"cs",
        "turkmena":"tk",
        "yorobà":"yo",
        "zolò":"zu",
        "zorziana":"ka",
        "sinoa (nentindrazana)":"zh-TW",
        "sinoa (notsorina)":"zh-CN",
        "kesan bahasa":"auto",
        "bahasa melayu":"ms",
        "croatia":"hr",
        "gaelic scotland":"gd",
        "gujerat":"gu",
        "inggeris":"en",
        "ireland":"ga",
        "kurdistan":"ku",
        "luxembourg":"lb",
        "norway":"no",
        "poland":"pl",
        "sweden":"sv",
        "cina (mudah)":"zh-CN",
        "ഭാഷ കണ്ടെത്തുക":"auto",
        "അമാറിക്":"am",
        "ആഫ്രിക്കാൻസ്":"af",
        "ഇഗ്\u200cബൊ":"ig",
        "ഉയ്\u200cഗർ":"ug",
        "ഉസ്ബെക്ക്":"uz",
        "ഉറുദു":"ur",
        "എക്സോസ":"xh",
        "എസ്\u200cപെരന്തോ":"eo",
        "ഒഡിയ (ഒറിയ)":"or",
        "കന്നട":"kn",
        "കസാക്ക്":"kk",
        "കാറ്റലൻ":"ca",
        "കിന്യാര്\u200dവാണ്ട":"rw",
        "കുർദ്ദിഷ്":"ku",
        "കൊറിയൻ":"ko",
        "ചിച്ചേവാ":"ny",
        "ജാപ്പനീസ്\u200c":"ja",
        "ജോർജ്ജിയൻ":"ka",
        "ടാറ്റർ":"tt",
        "തുർക്ക്മെൻ":"tk",
        "പഷ്തോ":"ps",
        "ഫ്രിസ്യൻ":"fy",
        "ഫ്രെഞ്ച്":"fr",
        "ബാസ്ക്":"eu",
        "ബെലാറുഷ്യൻ":"be",
        "മലയ്":"ms",
        "മറാഠി":"mr",
        "മാസഡോണിയൻ":"mk",
        "മൗറി":"mi",
        "യിദ്ദിഷ്":"yi",
        "യോറുബ":"yo",
        "ലക്\u200cസംബർഗിഷ്":"lb",
        "ലാറ്റ്\u200cവിയൻ":"lv",
        "ലിത്വേനിയൻ":"lt",
        "വെൽഷ്":"cy",
        "ഷോണ":"sn",
        "സുഡാനീസ്":"su",
        "സുളു":"zu",
        "സെബുവാനോ":"ceb",
        "സൊമാലി":"so",
        "സ്കോട്ട്സ് ഗ്യാലിക്":"gd",
        "സ്ലോവേനിയൻ":"sl",
        "ഹമോംഗ്":"hmn",
        "ഹെയ്തിയൻ ക്രയോൾ":"ht",
        "ഹൌസ":"ha",
        "റൊമേനിയൻ":"ro",
        "ചൈനീസ് (പരമ്പരാഗതം)":"zh-TW",
        "ചൈനീസ് (ലഘൂകരിച്ചത്)":"zh-CN",
        "induna bil-lingwa":"auto",
        "albaniż":"sq",
        "amħari":"am",
        "ażerbajġani":"az",
        "belarussu":"be",
        "bożnijak":"bs",
        "ċek":"cs",
        "creole haiti":"ht",
        "ebrajk":"iw",
        "frisjan":"fy",
        "ġeorġjan":"ka",
        "gaelic tal-iskoċċiżi":"gd",
        "galizjan":"gl",
        "guġarati":"gu",
        "ħindi":"hi",
        "ingli&#380;":"en",
        "islandiż":"is",
        "laosjan":"lo",
        "latvjan":"lv",
        "litwen":"lt",
        "lussemburgiż":"lb",
        "maċedonjan":"mk",
        "malasjan":"ms",
        "malti":"mt",
        "mongoljan":"mn",
        "nepaliż":"ne",
        "paxto":"ps",
        "pollakk":"pl",
        "punġabi":"pa",
        "rumen":"ro",
        "samojan":"sm",
        "sinħaliż":"si",
        "somalu":"so",
        "sundaniż":"su",
        "swaħili":"sw",
        "taġik":"tg",
        "tork":"tr",
        "ukren":"uk",
        "użbek":"uz",
        "x&#295;osani&#380;":"xh",
        "tautuhi reo":"auto",
        "ahepaitani":"az",
        "airihi":"ga",
        "amariki":"am",
        "amēniana":"hy",
        "arapeinia":"sq",
        "awherikāna":"af",
        "eperānato":"eo",
        "etōnia":"et",
        "hainamana":"zh-CN",
        "hāmoa":"sm",
        "hanekeria":"hu",
        "hapanihi":"ja",
        "hauha":"ha",
        "hāwanihi":"jw",
        "hehoto":"st",
        "hepuano":"ceb",
        "herepia":"sr",
        "hihewa":"ny",
        "himōngo":"hmn",
        "hinerangi":"fi",
        "hīni":"hi",
        "hinihara":"si",
        "hinihi":"sd",
        "hiperu":"iw",
        "hona":"sn",
        "hōriāna":"ka",
        "horowākia":"sk",
        "horowinia":"sl",
        "huitene":"sv",
        "hūmārie":"so",
        "huru":"zu",
        "hutanihi":"su",
        "iatihi":"yi",
        "ikipō":"ig",
        "initonīhia":"id",
        "iorupa":"yo",
        "itāriana":"it",
        "kanata":"kn",
        "karihia":"gl",
        "kataka":"kk",
        "katarāna":"ca",
        "kereore haiti":"ht",
        "kiaki":"ky",
        "kīma":"km",
        "kiniawānata":"rw",
        "kiriki":"el",
        "kohikana":"co",
        "kohōta":"xh",
        "kōreana":"ko",
        "koroātiana":"hr",
        "korukoru":"tr",
        "kūrihi":"ku",
        "kutarati":"gu",
        "makerōnia":"mk",
        "māori":"mi",
        "marakāhi":"mg",
        "māratihi":"mt",
        "marei":"ms",
        "mareiarama":"ml",
        "mongōriana":"mn",
        "nepōri":"ne",
        "nōwei":"no",
        "pahitū":"ps",
        "pākihi":"eu",
        "pāniora":"es",
        "pēma (purumīhi)":"my",
        "pēnekari":"bn",
        "peraruhia":"be",
        "perēhia":"fa",
        "pōngiana":"bs",
        "pōrana":"pl",
        "potukīhi":"pt",
        "punatāpi":"pa",
        "purukāriana":"bg",
        "rakapuō":"lb",
        "rāoho":"lo",
        "rātini":"la",
        "rāwhiana":"lv",
        "rituānia":"lt",
        "romānia":"ro",
        "rūhia":"ru",
        "takiri":"tg",
        "tamiro":"ta",
        "tatā":"tt",
        "tati":"nl",
        "tenemāka":"da",
        "teruku":"te",
        "tiamana":"de",
        "tieke":"cs",
        "tiorangi":"is",
        "tuauri kotarangi":"gd",
        "tukumana":"tk",
        "uhipeke":"uz",
        "ūkareiana":"uk",
        "ūru":"ur",
        "warehiri":"sw",
        "wēra":"cy",
        "whirihia":"fy",
        "whiripino":"tl",
        "whitināmu":"vi",
        "wīwī":"fr",
        "haina (onamata)":"zh-TW",
        "hainamana (kua whakamāmātia)":"zh-CN",
        "भाषा शोधा":"auto",
        "अझरबैजानी":"az",
        "अफ्रिकान्स":"af",
        "अर्मेनियन":"hy",
        "आइसलँडिक":"is",
        "उईग":"ug",
        "उझ्बेक":"uz",
        "एस्टोनियन":"et",
        "एस्परँटो":"eo",
        "ओडिया (ओरिया)":"or",
        "कझाक":"kk",
        "किन्यारवांडा":"rw",
        "किरगीझ":"ky",
        "कुर्दिश (कुर्मांजी)":"ku",
        "कॅटलान":"ca",
        "खोसा":"xh",
        "गुजराथी":"gu",
        "गॅलिशियन":"gl",
        "जावानीज":"jw",
        "झुलु":"zu",
        "झेक":"cs",
        "तेलगू":"te",
        "नेपाळी":"ne",
        "फिलिपिनो":"tl",
        "फ्रिशियन":"fy",
        "बल्गेरियन":"bg",
        "बास्क":"eu",
        "बेलारुशियन":"be",
        "मालागासे":"mg",
        "माल्टीज":"mt",
        "मॅसेडोनियन":"mk",
        "यिद्दिश":"yi",
        "युक्रेनियन":"uk",
        "लक्झेंबर्गिश":"lb",
        "लाट्वियन":"lv",
        "समोअन":"sm",
        "सर्बियन":"sr",
        "सिसोठो":"st",
        "सुदानी":"su",
        "स्लोव्हाक":"sk",
        "स्लोव्हेनियन":"sl",
        "हंगेरियन":"hu",
        "हैतीयन क्रेओल":"ht",
        "ह्मॉन्ग":"hmn",
        "चीनी (पारंपारिक)":"zh-TW",
        "хэл таних":"auto",
        "англи":"en",
        "афган":"ps",
        "балба":"ne",
        "бенгаль":"bn",
        "бирм":"my",
        "босни":"bs",
        "гаити креол":"ht",
        "гаэл":"gd",
        "герман":"de",
        "гүрж":"ka",
        "иддиш":"yi",
        "кинярванда":"rw",
        "кипр":"iw",
        "малави хэл":"ny",
        "малайлам":"ml",
        "малти":"mt",
        "норвеги":"no",
        "пенжаб":"pa",
        "польш":"pl",
        "португаль":"pt",
        "себу":"ceb",
        "серби":"sr",
        "словени":"sl",
        "тагало":"tl",
        "туркмен":"tk",
        "тэлүгү":"te",
        "унгар":"hu",
        "уэльс":"cy",
        "финлянд":"fi",
        "фризи":"fy",
        "хавай":"haw",
        "эстони":"et",
        "хятад (уламжлалт)":"zh-TW",
        "хятад хэл (хялбаршуулсан)":"zh-CN",
        "ဘာသာစကားကိုဖော်ထုတ်ရန်":"auto",
        "ကနာဒါ":"kn",
        "ကာဂျစ်":"ky",
        "ကာဇတ်":"kk",
        "ကာ့ဒ် (ကာမန်ဂျီ)":"ku",
        "ကော်ဆီကန်":"co",
        "ကက်တလန်":"ca",
        "ကင်ရာဝန်ဒါ":"rw",
        "ခမာ":"km",
        "ခရိုအေးရှား":"hr",
        "ချီချယ်ဝါ":"ny",
        "ဂူဂျရာတီ":"gu",
        "ဂယ်လိရှ":"gl",
        "ဂျာ\u200bဗား\u200b":"jw",
        "ဂျော်ဂျီယား":"ka",
        "စကော့ ဂေးလစ်":"gd",
        "စပိန်":"es",
        "စီဘူအာနို":"ceb",
        "ဆလိုဗေးနီးယား":"sl",
        "ဆလိုဗက်":"sk",
        "ဆာမိုအန်":"sm",
        "ဆားဘီးယား":"sr",
        "ဆက်ဆိုတို":"st",
        "ဆင်ဒီ":"sd",
        "ဆင်ဟာလာ":"si",
        "ဇူးလူး":"zu",
        "တ\u200bမီးလ်\u200b":"ta",
        "တာဂျစ်":"tg",
        "တာတာ":"tt",
        "တာ့ခ်မင်နစ္စတန်":"tk",
        "တူ\u200bရ\u200bကီ":"tr",
        "တယ်လူဂူ":"te",
        "ပါရှန်":"fa",
        "ပိုလန်":"pl",
        "ပတ်ရှ်တို":"ps",
        "ပန်\u200bဂျာ\u200bဘီ\u200b":"pa",
        "ဖရစ်ရှန်":"fy",
        "ဖိ\u200bလစ်\u200bပိုင်\u200b":"tl",
        "ဗီယက်နမ်":"vi",
        "ဘော့စနီးယား":"bs",
        "ဘင်္ဂါလီ":"bn",
        "ဘာစ်ခ်":"eu",
        "ဘယ်လာရုစ်":"be",
        "မလေယာလမ်":"ml",
        "မာရာသီ":"mr",
        "မာလာဂါစီ":"mg",
        "မော်ရီ":"mi",
        "မော်လတာ":"mt",
        "မက်ဆီဒိုးနီးယား":"mk",
        "မုံ":"hmn",
        "မွန်ဂိုလီးယား":"mn",
        "ယီဒစ်ရှ်":"yi",
        "ယူ\u200bက\u200bရိန်း\u200b":"uk",
        "ယောရူးဘာ":"yo",
        "ရှိုနာ":"sn",
        "လစ်သူယေးနီးယား":"lt",
        "လတ်ဗီယာ":"lv",
        "ဝီဂါ":"ug",
        "ဝေလ":"cy",
        "ဟာဝေယံ":"haw",
        "ဟီဘရူး":"iw",
        "ဟေတီ ခရီအိုး":"ht",
        "ဟိုးဆာ":"xh",
        "ဟင်ဒီ":"hi",
        "ဟောင်စာ":"ha",
        "ဟန်ဂေရီ":"hu",
        "အာမေးနီးယား":"hy",
        "အာရေဗျ":"ar",
        "ဥဇဘက်":"uz",
        "အူရဒူ":"ur",
        "အိုဒီရာ (အိုရီရာ)":"or",
        "အက်စ်ပဲရန်တို":"eo",
        "အိုက်စလန်":"is",
        "အိုင်းရစ်ရှ်":"ga",
        "အစ်ဘို":"ig",
        "အမ်ဟဲရစ်ခ်":"am",
        "အယ်ဖရိကန်းစ်":"af",
        "အယ်လ်ဘေးနီးယား":"sq",
        "တရုတ် (ရိုးရာ)":"zh-TW",
        "भाषा पत्ता लगाउनुहोस्":"auto",
        "अजरबैजानी":"az",
        "अफ्रिकान्स्":"af",
        "अर्मेनियाली":"hy",
        "अल्बेनियाली":"sq",
        "आइरिश":"ga",
        "आइसल्यान्डिक":"is",
        "आमहारिक":"am",
        "इन्डोनेसियाली":"id",
        "इस्टोनियाली":"et",
        "उइग":"ug",
        "एस्पेरान्तो":"eo",
        "ओडिया (उडिया)":"or",
        "कजाक":"kk",
        "किनयावान्डा":"rw",
        "क्याटालान":"ca",
        "क्रोएसियाली":"hr",
        "गालिसियाली":"gl",
        "चिनीया":"zh-CN",
        "जर्जियाली":"ka",
        "जाभानिज":"jw",
        "जुलू":"zu",
        "टाटर":"tt",
        "तुर्किश":"tr",
        "नर्वेली":"no",
        "पञ्जाबी":"pa",
        "पाश्तो":"ps",
        "फिलिपिनी":"tl",
        "फ्रान्सेली":"fr",
        "बर्मेली":"my",
        "बुल्गेरियाली":"bg",
        "बेलारूसी":"be",
        "बोस्नियाली":"bs",
        "मङ्गोलियन":"mn",
        "मलागासी":"mg",
        "मलाया":"ms",
        "मलायालम":"ml",
        "माल्टिज":"mt",
        "मोङ्":"hmn",
        "म्यासेडोनियन":"mk",
        "यिड्डिस्":"yi",
        "युक्रेनी":"uk",
        "रोमानियाली":"ro",
        "लक्जेम्बर्गिश":"lb",
        "लात्भियाली":"lv",
        "लिथुआनियाली":"lt",
        "समोअ":"sm",
        "सर्बियाली":"sr",
        "सिन्हाला":"si",
        "सुडानी":"su",
        "स्कट्स गेलिक्":"gd",
        "स्पेनी":"es",
        "स्लोभाक":"sk",
        "स्लोभेनियाली":"sl",
        "स्विडिश":"sv",
        "हङ्गेरियन":"hu",
        "हाइटियन क्रेओल":"ht",
        "हाउसा":"ha",
        "हिब्रु":"iw",
        "चिनियाँ(परम्परागत)":"zh-TW",
        "चिनियाँ(सरलीकृत)":"zh-CN",
        "gjenkjenn språk":"auto",
        "galisisk":"gl",
        "hawaiisk":"haw",
        "hviterussisk":"be",
        "jiddisk":"yi",
        "kreol (haiti)":"ht",
        "madagassisk":"mg",
        "malayisk":"ms",
        "nepalsk":"ne",
        "uigurisk":"ug",
        "kinesisk (tradisjonell)":"zh-TW",
        "د ژبې موندل":"auto",
        "أذربائجاني":"az",
        "ارمني":"hy",
        "اسټوني":"et",
        "افريقايي":"af",
        "اګبو":"ig",
        "ألماني":"de",
        "انډونېشيايي":"id",
        "انګريزي":"en",
        "اوډیا (اوریا)":"or",
        "اوزبکي":"uz",
        "ایټالوي":"it",
        "ایرلنډي":"ga",
        "اېسپرانتو":"eo",
        "أيسلېنډي":"is",
        "باسکي":"eu",
        "بلغاري":"bg",
        "بنګالي":"bn",
        "بوسني":"bs",
        "بېلاروسي":"be",
        "پاړسي":"fa",
        "پرتګالي":"pt",
        "پولېنډي":"pl",
        "تاتار":"tt",
        "تاجکي":"tg",
        "تايلېنډي":"th",
        "ترکمني":"tk",
        "تېليګو":"te",
        "جاوايې":"jw",
        "چيچيوا":"ny",
        "چېک":"cs",
        "چينايي":"zh-CN",
        "رومانیایي":"ro",
        "سربیایي":"sr",
        "سکاټ ګایلیک":"gd",
        "سلوواکي":"sk",
        "سلووانیایي":"sl",
        "سماؤن":"sm",
        "سواهېلي":"sw",
        "سومالي":"so",
        "سونداني":"su",
        "سوېدي":"sv",
        "سيبويانو":"ceb",
        "سینهالا":"si",
        "فرانسيسي":"fr",
        "فريزي":"fy",
        "فلیپیني":"tl",
        "فنلېندي":"fi",
        "قرغیز":"ky",
        "کټلاني":"ca",
        "کرواټي":"hr",
        "کنادي":"kn",
        "کوردي (کورمنجي)":"ku",
        "کورسيکاني":"co",
        "کوريائي":"ko",
        "کینواندا":"rw",
        "ګالیسیایي":"gl",
        "ګورجستاني":"ka",
        "لاتینې":"la",
        "لاوتين":"lo",
        "لګزمبرګش":"lb",
        "ليتواني":"lt",
        "لېټواني":"lv",
        "مالايي":"ms",
        "مالټي":"mt",
        "مولاکاسی":"mg",
        "ميانمر (برميز)":"my",
        "ناروېژي":"no",
        "نېپالي":"ne",
        "هالېنډي":"nl",
        "هاواییوان":"haw",
        "هاوزا":"ha",
        "هایتي کریول":"ht",
        "هسپانوي":"es",
        "همونږ":"hmn",
        "وایګا":"ug",
        "وېتنامي":"vi",
        "ويلشي":"cy",
        "يديشي":"yi",
        "يوروبا":"yo",
        "چیني (دوديزه)":"zh-TW",
        "چيني (ساده)":"zh-CN",
        "شناسایی زبان":"auto",
        "آذرباﻳﺠﺎﻧﻰ":"az",
        "ازبکی":"uz",
        "استونيايی":"et",
        "اسلونیایی":"sl",
        "افریکانس":"af",
        "اکراينی":"uk",
        "امهری":"am",
        "اندونزيايی":"id",
        "انگلیسی":"en",
        "اودیه (اوریه)":"or",
        "اویغوری":"ug",
        "ايسلندی":"is",
        "برمه\u200cای":"my",
        "بلاروسی":"be",
        "تاميلی":"ta",
        "تايلندی":"th",
        "ترکمنی":"tk",
        "ترکی استانبولی":"tr",
        "جاوه\u200cای":"jw",
        "چک":"cs",
        "چوایی":"ny",
        "خمری":"km",
        "خوسایی":"xh",
        "رومانيايی":"ro",
        "ساموایی":"sm",
        "سبوانو":"ceb",
        "سواهيلی":"sw",
        "سوتو":"st",
        "سودانی":"su",
        "سینهالی":"si",
        "عبری":"iw",
        "فريسی":"fy",
        "فیلیپینی":"tl",
        "قرقیزی":"ky",
        "کاتالان":"ca",
        "کانارا":"kn",
        "کرئول هائیتی":"ht",
        "كرسی":"co",
        "کره\u200cای":"ko",
        "کینیارواندا":"rw",
        "گالیسی":"gl",
        "گاليک اسکاتلندی":"gd",
        "لائوسی":"lo",
        "لاتين":"la",
        "لتونيايی":"lv",
        "لوگزامبورگی":"lb",
        "ليتوانيايی":"lt",
        "مالاگاسی":"mg",
        "مالایالمی":"ml",
        "مالايی":"ms",
        "مجاری":"hu",
        "مراتی":"mr",
        "مغولی":"mn",
        "مقدونيه\u200cای":"mk",
        "ولزی":"cy",
        "ويتنامی":"vi",
        "همونگ":"hmn",
        "یدیشی":"yi",
        "یوروبایی":"yo",
        "يونانی":"el",
        "چینی (ساده\u200cشده)":"zh-CN",
        "wykryj język":"auto",
        "angielski":"en",
        "azerski":"az",
        "birmański":"my",
        "cebuański":"ceb",
        "czeski":"cs",
        "cziczewa":"ny",
        "japoński":"ja",
        "khmerski":"km",
        "kreolski (haiti)":"ht",
        "laotański":"lo",
        "łaciński":"la",
        "niderlandzki":"nl",
        "orija":"or",
        "polski":"pl",
        "ruanda-rundi":"rw",
        "samoański":"sm",
        "sundajski":"su",
        "syngaleski":"si",
        "turkmeński":"tk",
        "węgierski":"hu",
        "włoski":"it",
        "chiński (tradycyjny)":"zh-TW",
        "chiński (uproszczony)":"zh-CN",
        "africâner":"af",
        "alemão":"de",
        "azerbaijano":"az",
        "bielo-russo":"be",
        "birmanês":"my",
        "canarês":"kn",
        "catalão":"ca",
        "chicheua":"ny",
        "chinês":"zh-CN",
        "espanhol":"es",
        "finlandês":"fi",
        "francês":"fr",
        "frísio":"fy",
        "guzerate":"gu",
        "hauçá":"ha",
        "havaiano":"haw",
        "hebraico":"iw",
        "holandês":"nl",
        "indonésio":"id",
        "irlandês":"ga",
        "japonês":"ja",
        "javanês":"jw",
        "letão":"lv",
        "macedônio":"mk",
        "malaiala":"ml",
        "maltês":"mt",
        "marata":"mr",
        "nepalês":"ne",
        "norueguês":"no",
        "oriá":"or",
        "português":"pt",
        "romeno":"ro",
        "sérvio":"sr",
        "suaíle":"sw",
        "sundanês":"su",
        "tadjique":"tg",
        "tailandês":"th",
        "tcheco":"cs",
        "telugo":"te",
        "turcomano":"tk",
        "ucraniano":"uk",
        "chinês (simplificado)":"zh-CN",
        "chinês (tradicional)":"zh-TW",
        "ਭਾਸ਼ਾ ਖੋਜੋ":"auto",
        "ਉਇਗੁਰ":"ug",
        "ਉਜ਼ਬੇਕ":"uz",
        "ਉਰਦੂ":"ur",
        "ਉੜੀਆ":"or",
        "ਅੰਗਰੇਜ਼ੀ":"en",
        "ਅਜ਼ਰਬਾਈਜਾਨੀ":"az",
        "ਅਫ਼ਰੀਕੀ":"af",
        "ਅਰਮੇਨੀਅਨ":"hy",
        "ਅਲਬੇਨੀਅਨ":"sq",
        "ਆਇਰਸ਼":"ga",
        "ਆਈਸਲੈਂਡੀ":"is",
        "ਐਸਪਰੇਂਟੋ":"eo",
        "ਇਸਟੌਨੀਅਨ":"et",
        "ਇੰਡੋਨੇਸ਼ੀਆਈ":"id",
        "ਸਕੌਟਸ ਗੈਲਿਕ":"gd",
        "ਸੰਡਨੀਜ":"su",
        "ਸਪੈਨਿਸ਼":"es",
        "ਸਮੋਈ":"sm",
        "ਸਰਬੀਆਈ":"sr",
        "ਸਲੋਵਾਕ":"sk",
        "ਸਲੋਵੀਨੀਅਨ":"sl",
        "ਸਵਾਹਿਲੀ":"sw",
        "ਸਵੀਡਿਸ਼":"sv",
        "ਸਿਨਹਾਲਾ":"si",
        "ਸੈਸੋਥੋ":"st",
        "ਹੰਗੇਰੀਅਨ":"hu",
        "ਹਮੋਂਗ":"hmn",
        "ਹਿਬਰੀ":"iw",
        "ਹੈਤੀਆਈ ਕਰਯੋਲ":"ht",
        "ਹੌਸਾ":"ha",
        "ਕਜ਼ਾਖ":"kk",
        "ਕੰਨੜ":"kn",
        "ਕ੍ਰੋਸ਼ੀਅਨ":"hr",
        "ਕਿਨਯਾਰਵਾਂਡਾ":"rw",
        "ਕਿਰਗਿਜ":"ky",
        "ਕੁਰਦੀ (ਕੁਰਮਾਂਜੀ)":"ku",
        "ਕੈਟਾਲਨ":"ca",
        "ਕੋਰਸੀਕਨ":"co",
        "ਕੋਰੀਆਈ":"ko",
        "ਖੋਸਾ":"xh",
        "ਗੁਜਰਾਤੀ":"gu",
        "ਗੈਲੀਸ਼ੀਅਨ":"gl",
        "ਚਿਚੇਵਾ":"ny",
        "ਚੈੱਕ":"cs",
        "ਜਵਾਨੀਜ਼":"jw",
        "ਜਾਪਾਨੀ":"ja",
        "ਜਾਰਜੀਆਈ":"ka",
        "ਡੈਨਿਸ਼":"da",
        "ਤਤਾਰ":"tt",
        "ਤਮਿਲ":"ta",
        "ਤੁਰਕਮੈਨ":"tk",
        "ਨਾਰਵੇਜੀਅਨ":"no",
        "ਪਸ਼ਤੋ":"ps",
        "ਪੋਲੈਂਡੀ":"pl",
        "ਫਰਾਂਸੀਸੀ":"fr",
        "ਫ੍ਰੀਸ਼ੀਅਨ":"fy",
        "ਫਾਰਸੀ":"fa",
        "ਫਿਨਿਸ਼":"fi",
        "ਫਿਲੀਪੀਨੋ":"tl",
        "ਬਾਸਕ":"eu",
        "ਬੁਲਗੇਰੀਅਨ":"bg",
        "ਬੇਲਾਰੂਸੀ":"be",
        "ਮਲਯ":"ms",
        "ਮਾਲਟੀਜ਼":"mt",
        "ਮਾਲਾਗਾਸੀ":"mg",
        "ਮੈਸੇਡੋਨੀਅਨ":"mk",
        "ਯਿਦੀਸ਼":"yi",
        "ਯੂਕਰੇਨੀਅਨ":"uk",
        "ਰੂਸੀ":"ru",
        "ਰੋਮਾਨੀਅਨ":"ro",
        "ਲਕਸਮਬਰਗੀ":"lb",
        "ਲਾਤਵੀਅਨ":"lv",
        "ਲਿਥੁਆਨੀਅਨ":"lt",
        "ਵੈਲਸ਼":"cy",
        "ਚੀਨੀ (ਸਰਲੀਕਿਰਤ)":"zh-CN",
        "selectați limba":"auto",
        "albaneză":"sq",
        "arabă":"ar",
        "armeană":"hy",
        "azerbaidjană":"az",
        "bielorusă":"be",
        "birmană":"my",
        "bosniacă":"bs",
        "catalană":"ca",
        "cebuană":"ceb",
        "cehă":"cs",
        "chineză":"zh-CN",
        "creolă haitiană":"ht",
        "croată":"hr",
        "daneză":"da",
        "estonă":"et",
        "franceză":"fr",
        "frizonă":"fy",
        "galeză":"cy",
        "galica scoțiană":"gd",
        "germană":"de",
        "gruzină":"ka",
        "hawaiiană":"haw",
        "idiș":"yi",
        "indoneziană":"id",
        "irlandeză":"ga",
        "islandeză":"is",
        "japoneză":"ja",
        "kirghiză":"ky",
        "laoțiană":"lo",
        "latină":"la",
        "lituaniană":"lt",
        "macedoneană":"mk",
        "malaeză":"ms",
        "malteză":"mt",
        "mongolă":"mn",
        "neerlandeză":"nl",
        "norvegiană":"no",
        "poloneză":"pl",
        "samoană":"sm",
        "sârbă":"sr",
        "shonă":"sn",
        "singhaleză":"si",
        "slovenă":"sl",
        "suedeză":"sv",
        "tamilă":"ta",
        "tătară":"tt",
        "thailandeză":"th",
        "turcă":"tr",
        "turkmenă":"tk",
        "ucraineană":"uk",
        "uigură":"ug",
        "uzbecă":"uz",
        "vietnameză":"vi",
        "chineză (simplificată)":"zh-CN",
        "chineză (tradițională)":"zh-TW",
        "определить язык":"auto",
        "азербайджанский":"az",
        "армянский":"hy",
        "венгерский":"hu",
        "датский":"da",
        "ирландский":"ga",
        "казахский":"kk",
        "каталанский":"ca",
        "китайский":"zh-CN",
        "корейский":"ko",
        "корсиканский":"co",
        "креольский (гаити)":"ht",
        "курманджи":"ku",
        "лаосский":"lo",
        "малагасийский":"mg",
        "нидерландский":"nl",
        "ория":"or",
        "персидский":"fa",
        "польский":"pl",
        "себуанский":"ceb",
        "сингальский":"si",
        "татарский":"tt",
        "туркменский":"tk",
        "узбекский":"uz",
        "украинский":"uk",
        "финский":"fi",
        "французский":"fr",
        "чева":"ny",
        "шотландский (гэльский)":"gd",
        "японский":"ja",
        "китайский (традиционный)":"zh-TW",
        "китайский (упрощенный)":"zh-CN",
        "mothaich dhan chànan":"auto",
        "afraganais":"af",
        "airmeinis":"hy",
        "albàinis":"sq",
        "amtharais":"am",
        "arabais":"ar",
        "asarbaideànais":"az",
        "basgais":"eu",
        "bealaruisis":"be",
        "beangailis":"bn",
        "beurla":"en",
        "bhiet-namais":"vi",
        "bosnais":"bs",
        "bulgarais":"bg",
        "cairtbheilis":"ka",
        "cànan hawaiʻi":"haw",
        "cànan nan tàidh":"th",
        "casachais":"kk",
        "catalanais":"ca",
        "chicheŵa":"ny",
        "cìorgasais":"ky",
        "cmèar":"km",
        "coirèanais":"ko",
        "corsais":"co",
        "crìtheol haidhti":"ht",
        "cròthaisis":"hr",
        "cuimris":"cy",
        "cùrdais (kurmanji)":"ku",
        "deàbhanais":"jw",
        "duitsis":"nl",
        "eabhra":"iw",
        "eadailtis":"it",
        "eastoinis":"et",
        "filipinis":"tl",
        "fionnlannais":"fi",
        "fraingis":"fr",
        "frìoslannais":"fy",
        "gàidhlig":"gd",
        "gailìsis":"gl",
        "gearmailtis":"de",
        "grèigis":"el",
        "hindis":"hi",
        "innd-innsis":"id",
        "innis-tìlis":"is",
        "iùdhais":"yi",
        "laideann":"la",
        "laitbheis":"lv",
        "làtho":"lo",
        "liotuainis":"lt",
        "lugsamburgais":"lb",
        "malagasais":"mg",
        "malaidhis":"ms",
        "masadonais":"mk",
        "miànmar (burmais)":"my",
        "mongolais":"mn",
        "neapàlais":"ne",
        "nirribhis":"no",
        "pòlainnis":"pl",
        "portagailis":"pt",
        "romàinis":"ro",
        "ruisis":"ru",
        "samothais":"sm",
        "seacais":"cs",
        "seapanais":"ja",
        "sèirbis":"sr",
        "sìnis":"zh-CN",
        "slòbhacais":"sk",
        "slòbhainis":"sl",
        "somàilis":"so",
        "spàinntis":"es",
        "suainis":"sv",
        "taidigis":"tg",
        "taimilis":"ta",
        "tatarais":"tt",
        "turcais":"tr",
        "turcmanais":"tk",
        "ucràinis":"uk",
        "ùigiurais":"ug",
        "ungairis":"hu",
        "ùrdu":"ur",
        "usbagais":"uz",
        "sìonais (seann-nòsach)":"zh-TW",
        "sìonais (sìmplichte)":"zh-CN",
        "откриј језик":"auto",
        "африкански":"af",
        "баскијски":"eu",
        "бенгласки":"bn",
        "галски":"gl",
        "грузијски":"ka",
        "енглески":"en",
        "индонежански":"id",
        "јерменски":"hy",
        "казахстански":"kk",
        "кињаруанда":"rw",
        "креолски (хаити)":"ht",
        "летонски":"lv",
        "персијски":"fa",
        "пунџаби":"pa",
        "сомалски":"so",
        "тагалог":"tl",
        "тајски":"th",
        "кинески (поједностављени)":"zh-CN",
        "кинески (традиционални)":"zh-TW",
        "fumana puo":"auto",
        "se xhosa":"xh",
        "se-albanian":"sq",
        "se-amhari":"am",
        "se-azerbaijani":"az",
        "se-basque":"eu",
        "se-belarusia":"be",
        "se-bengali":"bn",
        "se-bosnia":"bs",
        "se-bulgaria":"bg",
        "se-burmese":"my",
        "se-catalia":"ca",
        "se-cebuano":"ceb",
        "se-chichewa":"ny",
        "se-creole sa haiti":"ht",
        "se-croatia":"hr",
        "se-czech":"cs",
        "se-esperanto":"eo",
        "se-estonia":"et",
        "se-frisia":"fy",
        "se-galicia":"gl",
        "se-geogia":"ka",
        "se-gujarati":"gu",
        "se-hawaii":"haw",
        "se-hmong":"hmn",
        "se-hungaria":"hu",
        "se-iceland":"is",
        "se-igbo":"ig",
        "se-indonesia":"id",
        "se-irish":"ga",
        "se-javane":"jw",
        "se-kannada":"kn",
        "se-kazakh":"kk",
        "se-khmer":"km",
        "se-kurdish":"ku",
        "se-kyrgyz":"ky",
        "se-lao":"lo",
        "se-latino":"la",
        "se-latvia":"lv",
        "se-lithuania":"lt",
        "se-luxembourgish":"lb",
        "se-malagasy":"mg",
        "se-malay":"ms",
        "se-malayalam":"ml",
        "se-maltese":"mt",
        "se-mongolia":"mn",
        "se-pashto":"ps",
        "se-persia":"fa",
        "se-punjabi":"pa",
        "se-samoan":"sm",
        "se-scots gaelic":"gd",
        "se-serbian":"sr",
        "se-sindhi":"sd",
        "se-slovak":"sk",
        "se-slovania":"sl",
        "se-sundanese":"su",
        "se-tajik":"tg",
        "se-tamil":"ta",
        "se-tatar":"tt",
        "se-telegu":"te",
        "se-theki":"tr",
        "se-ukrania":"uk",
        "se-urdu":"ur",
        "se-uzbek":"uz",
        "se-vietnam":"vi",
        "se-welsh":"cy",
        "se-yiddish":"yi",
        "se-yoruba":"yo",
        "se-zulu":"zu",
        "searab":"ar",
        "searmenia":"hy",
        "seburu":"af",
        "sechaena":"zh-CN",
        "sedache":"nl",
        "sedanishe":"sv",
        "sedenishe":"da",
        "sefilipino":"tl",
        "sefora":"fr",
        "segerike":"el",
        "sehausa":"ha",
        "seheberu":"iw",
        "sehindi":"hi",
        "sejapane":"ja",
        "sejeremane":"de",
        "sekinyaroanta":"rw",
        "sekorea":"ko",
        "sekosika":"co",
        "semaori":"mi",
        "semarathi":"mr",
        "semasedonia":"mk",
        "senepali":"ne",
        "senyesemane":"en",
        "sepolishe":"pl",
        "sepotokise":"pt",
        "seshona":"sn",
        "sesomali":"so",
        "sespain":"es",
        "sethai":"th",
        "seuyghur":"ug",
        "sechaena (nolofaditswe)":"zh-CN",
        "ziva zita remutauro":"auto",
        "chekuiceland":"is",
        "chiafurikanzi":"af",
        "chialbania":"sq",
        "chiarabhu":"ar",
        "chiarmenia":"hy",
        "chiazabhaijani":"az",
        "chibelarusia":"be",
        "chibengari":"bn",
        "chiboziniya":"bs",
        "chibulgaria":"bg",
        "chicatalan":"ca",
        "chicebuano":"ceb",
        "chicheki":"cs",
        "chichina":"zh-CN",
        "chicreole chekuhaiti":"ht",
        "chicroatia":"hr",
        "chiesperanto":"eo",
        "chiestonia":"et",
        "chifiripino":"tl",
        "chifrisia":"fy",
        "chifurenji":"fr",
        "chigalicia":"gl",
        "chihawai":"haw",
        "chihebheru":"iw",
        "chihungaria":"hu",
        "chiigbo":"ig",
        "chiindonesia":"id",
        "chijojia":"ka",
        "chikhmer":"km",
        "chikoriya":"ko",
        "chikosiki":"co",
        "chikurdish (kurmanji)":"ku",
        "chilatvia":"lv",
        "chilithuania":"lt",
        "chiluxembourg":"lb",
        "chimakedhoniya":"mk",
        "chimalayam":"ml",
        "chimaragasi":"mg",
        "chimongolia":"mn",
        "chimyanmar (chekuburma)":"my",
        "chinepari":"ne",
        "chinorweji":"no",
        "chipashto":"ps",
        "chipezhiya":"fa",
        "chiporishi":"pl",
        "chirashiya":"ru",
        "chiratini":"la",
        "chiromania":"ro",
        "chisikoti":"gd",
        "chisinhala":"si",
        "chisiwidhi":"sv",
        "chislovenia":"sl",
        "chisundani":"su",
        "chisutu":"st",
        "chiswahilli":"sw",
        "chitariyana":"it",
        "chiturkey":"tr",
        "chiturkmen":"tk",
        "chiukrain":"uk",
        "chiurdu":"ur",
        "chiuzbek":"uz",
        "chivietnam":"vi",
        "chiwereshi":"cy",
        "chiyidhi":"yi",
        "mu xhosa":"xh",
        "chichina (chakarerutswa)":"zh-CN",
        "chichina (chechinyakare)":"zh-TW",
        "ٻولي کوجيو":"auto",
        "آرمينين":"hy",
        "آزربائجاني":"az",
        "اٽيلين":"it",
        "اَزبيڪ":"uz",
        "اسپينش":"es",
        "اِسٽونين":"et",
        "اسڪاٽس گئلِڪ":"gd",
        "اگبو":"ig",
        "انڊونيشين":"id",
        "اوڊيا (اوريا)":"or",
        "ايسپرينٽو":"eo",
        "ايمھارڪ":"am",
        "باسڪ":"eu",
        "بلارشين":"be",
        "بُلگارين":"bg",
        "بوسنين":"bs",
        "پرتگيزي":"pt",
        "پولش":"pl",
        "تاجڪ":"tg",
        "تامل":"ta",
        "ترڪ":"tr",
        "تُرڪمن":"tk",
        "تيلگوُ":"te",
        "ٽاتر":"tt",
        "ٿائي":"th",
        "جيارجين":"ka",
        "جيوّينيز":"jw",
        "چيڪ":"cs",
        "چیچیوا":"ny",
        "خمير":"km",
        "ڊچ":"nl",
        "ڊينش":"da",
        "رشين":"ru",
        "رومانين":"ro",
        "زھوسا":"xh",
        "سائبيرين":"sr",
        "ساموآن":"sm",
        "سِسوٿو":"st",
        "سلووَّڪ":"sk",
        "سلووينين":"sl",
        "سنڌي":"sd",
        "سھونا":"sn",
        "سوئيڊش":"sv",
        "سواھِليِ":"sw",
        "سوڊاني":"su",
        "سيبوآني":"ceb",
        "فريشن":"fy",
        "فلپائني":"tl",
        "فنش":"fi",
        "قزاک":"kk",
        "ڪارسيڪن":"co",
        "ڪُردش (ڪورمانجي)":"ku",
        "ڪِرگيِز":"ky",
        "ڪروئيشين":"hr",
        "ڪناڊا":"kn",
        "ڪنيارواندا":"rw",
        "ڪيٽيلين":"ca",
        "گئلشين":"gl",
        "لائوٿيئن":"lo",
        "لِٿُئَنين":"lt",
        "لگزمبرگي":"lb",
        "ليٽوينيائي":"lv",
        "مئلئي":"ms",
        "مالاگاسي malagasy":"mg",
        "مليالم":"ml",
        "ميسيڊونين":"mk",
        "نورويئن":"no",
        "هائوسا hausa":"ha",
        "همنگ":"hmn",
        "هيٽي ڪريول":"ht",
        "ھندي":"hi",
        "ھنگيرين":"hu",
        "ھوائين":"haw",
        "ويٽناميز":"vi",
        "يِدِش":"yi",
        "چيني (سولي)":"zh-CN",
        "භාෂාව අනාවරණය කර ගන්න":"auto",
        "අසර්බයිජානු":"az",
        "ඇම්හැරික්":"am",
        "ඉංග්\u200dරීසි":"en",
        "ඉග්බෝ":"ig",
        "උයිඝුර්":"ug",
        "උස්බෙකිස්ථානු":"uz",
        "එස්පැරන්ටෝ":"eo",
        "ඔඩියා (ඔරියා)":"or",
        "කණ්ණඩ":"kn",
        "කශාහ්":"kk",
        "කාම්බෝජියානු":"km",
        "කින්යාර්වන්ඩා":"rw",
        "කුර්දිශ්":"ku",
        "කෝර්සිකානු":"co",
        "ක්\u200dරෝයේශියානු":"hr",
        "ජන්ජාබ්":"pa",
        "ජාවා":"jw",
        "ටජික්":"tg",
        "ටටාර්":"tt",
        "ටර්මෙන්":"tk",
        "ඩෙන්මාර්ක":"da",
        "තෙලිඟු":"te",
        "නේපාල":"ne",
        "නෝර්වේජියානු":"no",
        "පෂ්ටෝ":"ps",
        "පෝලන්ත":"pl",
        "බර්මීස්":"my",
        "බෙලරුසියානු":"be",
        "බොස්කෝ":"eu",
        "මරාටි":"mr",
        "මලගාසි":"mg",
        "මාවොරි":"mi",
        "මැසඩෝනියානු":"mk",
        "මොංගෝලියානු":"mn",
        "මොල්ටිස්":"mt",
        "යුක්රේනියානු":"uk",
        "යුදෙව්":"yi",
        "යොරූබා":"yo",
        "රුමේනියානු":"ro",
        "ලංදේසි":"nl",
        "ලක්සැම්බර්ග්":"lb",
        "ලාඕතියානු":"lo",
        "වියට්නාම්":"vi",
        "වෙල්ස්":"cy",
        "ශෝසා":"xh",
        "සන්ඩන්ස්":"su",
        "සමෝන්":"sm",
        "සර්බීයානු":"sr",
        "සින්ධි":"sd",
        "සුලු":"zu",
        "සෙබුආනෝ":"ceb",
        "සෙසොතෝ":"st",
        "ස්කොට්ස් ගැලික්":"gd",
        "ස්ලෝවැක්":"sk",
        "ස්ලෝවේනියානු":"sl",
        "ස්වාහිලි":"sw",
        "ස්වෙඩිශ්":"sv",
        "හන්ගේරියානු":"hu",
        "හමොන්ග්":"hmn",
        "හයිටි භාෂාව":"ht",
        "හීබෲ":"iw",
        "හෝසා":"ha",
        "ෆිනිශ්":"fi",
        "ෆ්\u200dරීසියානු":"fy",
        "rozpoznaný jazyk":"auto",
        "albánčina":"sq",
        "arménčina":"hy",
        "azerbajdžančina":"az",
        "barmčina":"my",
        "bengálčina":"bn",
        "bieloruština":"be",
        "bosniančina":"bs",
        "bulharčina":"bg",
        "cebuánčina":"ceb",
        "dánčina":"da",
        "estónčina":"et",
        "filipínčina":"tl",
        "fínčina":"fi",
        "francúzština":"fr",
        "galícijčina":"gl",
        "gréčtina":"el",
        "gruzínčina":"ka",
        "gudžarátčina":"gu",
        "haitská kreolčina":"ht",
        "havajčina":"haw",
        "hmongčina":"hmn",
        "holandčina":"nl",
        "chorvátčina":"hr",
        "indonézština":"id",
        "írčina":"ga",
        "islandčina":"is",
        "japončina":"ja",
        "jávčina":"jw",
        "jorubčina":"yo",
        "kannadčina":"kn",
        "khmérčina":"km",
        "kirgizština":"ky",
        "kórejčina":"ko",
        "korzičtina":"co",
        "kurdčina":"ku",
        "litovčina":"lt",
        "luxemburčina":"lb",
        "macedónčina":"mk",
        "maďarčina":"hu",
        "malagština":"mg",
        "malajámčina":"ml",
        "malajčina":"ms",
        "maorijčina":"mi",
        "maratčina":"mr",
        "mongolčina":"mn",
        "ňandža":"ny",
        "nemčina":"de",
        "nepálčina":"ne",
        "nórčina":"no",
        "pandžábčina":"pa",
        "perzština":"fa",
        "poľština":"pl",
        "portugalčina":"pt",
        "rumunčina":"ro",
        "rwandčina":"rw",
        "samojčina":"sm",
        "sindčina":"sd",
        "sinhalčina":"si",
        "slovenčina":"sk",
        "somálčina":"so",
        "sothčina":"st",
        "srbčina":"sr",
        "svahilčina":"sw",
        "škótska gaelčina":"gd",
        "španielčina":"es",
        "švédčina":"sv",
        "tadžičtina":"tg",
        "taliančina":"it",
        "tamilčina":"ta",
        "tatárčina":"tt",
        "telugčina":"te",
        "thajčina":"th",
        "turkménčina":"tk",
        "ujgurčina":"ug",
        "ukrajinčina":"uk",
        "urdčina":"ur",
        "uríjčina":"or",
        "vietnamčina":"vi",
        "waleština":"cy",
        "zuluština":"zu",
        "čínština (tradičná)":"zh-TW",
        "zaznaj jezik":"auto",
        "afrikanščina":"af",
        "albanščina":"sq",
        "amharščina":"am",
        "arabščina":"ar",
        "armenščina":"hy",
        "azerbajdžanščina":"az",
        "baskovščina":"eu",
        "beloruščina":"be",
        "bengalščina":"bn",
        "bosanščina":"bs",
        "burmanščina":"my",
        "češčina":"cs",
        "čevščina":"ny",
        "danščina":"da",
        "estonščina":"et",
        "finščina":"fi",
        "francoščina":"fr",
        "frizijščina":"fy",
        "galicijščina":"gl",
        "grščina":"el",
        "gruzinščina":"ka",
        "gudžaratščina":"gu",
        "haitijska kreolščina":"ht",
        "havajščina":"haw",
        "havščina":"ha",
        "hindijščina":"hi",
        "hmonščina":"hmn",
        "igboščina":"ig",
        "irščina":"ga",
        "islandščina":"is",
        "italijanščina":"it",
        "japonščina":"ja",
        "jorubščina":"yo",
        "kanareščina":"kn",
        "katalonščina":"ca",
        "kazaščina":"kk",
        "kinjarvandščina":"rw",
        "kirgiščina":"ky",
        "kitajščina":"zh-CN",
        "kmerščina":"km",
        "korejščina":"ko",
        "korziščina":"co",
        "koščina":"xh",
        "kurdščina":"ku",
        "laoščina":"lo",
        "latvijščina":"lv",
        "litovščina":"lt",
        "luksemburščina":"lb",
        "madžarščina":"hu",
        "makedonščina":"mk",
        "malajalščina":"ml",
        "malajščina":"ms",
        "malteščina":"mt",
        "maorščina":"mi",
        "maratščina":"mr",
        "mongolščina":"mn",
        "nemščina":"de",
        "nepalščina":"ne",
        "nizozemščina":"nl",
        "norveščina":"no",
        "odijščina (orijščina)":"or",
        "pandžabščina":"pa",
        "perzijščina":"fa",
        "poljščina":"pl",
        "romunščina":"ro",
        "ruščina":"ru",
        "samoanščina":"sm",
        "sebuanščina":"ceb",
        "sesotščina":"st",
        "sindščina":"sd",
        "singalščina":"si",
        "slovaščina":"sk",
        "somalščina":"so",
        "sundanščina":"su",
        "svahilščina":"sw",
        "škotska gelščina":"gd",
        "šonščina":"sn",
        "španščina":"es",
        "švedščina":"sv",
        "tadžiščina":"tg",
        "tagaloščina":"tl",
        "tajščina":"th",
        "tamilščina":"ta",
        "tatarščina":"tt",
        "teluščina":"te",
        "turkmenščina":"tk",
        "turščina":"tr",
        "ujgurščina":"ug",
        "ukrajinščina":"uk",
        "urdujščina":"ur",
        "uzbeščina":"uz",
        "valižanščina":"cy",
        "vietnamščina":"vi",
        "zulujščina":"zu",
        "kitajščina (poenostavljena)":"zh-CN",
        "kitajščina (tradicionalna)":"zh-TW",
        "garo luuqada":"auto",
        "af daynish":"da",
        "af lugsanbeerig":"lb",
        "af malgaash":"mg",
        "af samaawaan":"sm",
        "af suuluu":"zu",
        "af turki":"tr",
        "albaaniyaan":"sq",
        "amxaari":"am",
        "armeeniyaan":"hy",
        "asarbayjaan":"az",
        "ayrish":"ga",
        "ayslandays":"is",
        "baarmiis":"my",
        "baashtu":"ps",
        "baaski":"eu",
        "bangaali":"bn",
        "beleruusiyaan":"be",
        "boolish":"pl",
        "boosniyaan":"bs",
        "bulgeeriyaan":"bg",
        "bunjaabi":"pa",
        "burtuqiis":"pt",
        "cibri":"iw",
        "faarsi":"fa",
        "fiinlaandees":"fi",
        "fiitnaamays":"vi",
        "firiisiyaan":"fy",
        "galiisiyaan":"gl",
        "giriik":"el",
        "gujaraati":"gu",
        "hangaariyaan":"hu",
        "hawaaiyaan":"haw",
        "heyshiyaan kiriyool":"ht",
        "holandays":"nl",
        "hoosa":"xh",
        "indunuusiyaan":"id",
        "isberento":"eo",
        "iskot giilik":"gd",
        "islofeeniyaan":"sl",
        "isloofaak":"sk",
        "istooniyaan":"et",
        "iswiidhish":"sv",
        "jabaaniis":"ja",
        "jafaaniis":"jw",
        "jarmal":"de",
        "jeek":"cs",
        "jijiwa":"ny",
        "joorijiyaan":"ka",
        "kamboodhiyaan":"km",
        "kannadays":"kn",
        "katalaan":"ca",
        "kirgiis":"ky",
        "koro'eeshiyaan":"hr",
        "kurdishka":"ku",
        "laatfiyaan":"lv",
        "laatiin":"la",
        "lituwaanays":"lt",
        "maarati":"mr",
        "malaay":"ms",
        "maltiis":"mt",
        "mangooli":"mn",
        "masadooniyaan":"mk",
        "nebaali":"ne",
        "noorweejiyaan":"no",
        "raashiyaan":"ru",
        "roomaani":"ro",
        "sawaaxili":"sw",
        "seerbiyaan":"sr",
        "sesooto":"st",
        "shiine":"zh-CN",
        "sinhaala":"si",
        "soomaali":"so",
        "sugbaano":"ceb",
        "suudaaniis":"su",
        "taaylandays":"th",
        "talyaani":"it",
        "tamiil":"ta",
        "tataar":"tt",
        "teluugu":"te",
        "turkumaanish":"tk",
        "urduu":"ur",
        "usbakis":"uz",
        "shiine (caadi ah)":"zh-TW",
        "shiine (la fududeeyay)":"zh-CN",
        "afrikáans":"af",
        "amhárico":"am",
        "azerí":"az",
        "camboyano":"km",
        "chino":"zh-CN",
        "euskera":"eu",
        "finlandés":"fi",
        "gallego":"gl",
        "griego":"el",
        "japonés":"ja",
        "javanés":"jw",
        "kazajo":"kk",
        "kirguís":"ky",
        "kurdo":"ku",
        "noruego":"no",
        "panyabí":"pa",
        "pastún":"ps",
        "suajili":"sw",
        "tagalo":"tl",
        "tayiko":"tg",
        "yidis":"yi",
        "chino (simplificado)":"zh-CN",
        "chino (tradicional)":"zh-TW",
        "détéksi basa":"auto",
        "basa afrika":"af",
        "basa amharic":"am",
        "basa arménia":"hy",
        "basa basqi":"eu",
        "basa bélarusia":"be",
        "basa béngali":"bn",
        "basa catalan":"ca",
        "basa cébuano":"ceb",
        "basa céko":"cs",
        "basa chichéwa":"ny",
        "basa dénmark":"da",
        "basa éstonia":"et",
        "basa filipina":"tl",
        "basa frisia":"fy",
        "basa haiti kréolé":"ht",
        "basa hébru":"iw",
        "basa hindi":"hi",
        "basa indonésia":"id",
        "basa jérman":"de",
        "basa kanada":"kn",
        "basa kazakh":"kk",
        "basa khmér":"km",
        "basa kinyarwanda":"rw",
        "basa kirgiztan":"ky",
        "basa koréa":"ko",
        "basa kurdi (kurmanji)":"ku",
        "basa laoth":"lo",
        "basa luxembourg":"lb",
        "basa maltis":"mt",
        "basa masédonia":"mk",
        "basa melayu":"ms",
        "basa mongolia":"mn",
        "basa népal":"ne",
        "basa norwégia":"no",
        "basa perancis":"fr",
        "basa pérsia":"fa",
        "basa punjab":"pa",
        "basa rumania":"ro",
        "basa sésotho":"st",
        "basa skot gaélik":"gd",
        "basa slovénia":"sl",
        "basa somali":"so",
        "basa swédia":"sv",
        "basa thailan":"th",
        "basa turkmenistan":"tk",
        "basa ukraina":"uk",
        "basa uyghur":"ug",
        "basa uzbékistan":"uz",
        "basa viétnam":"vi",
        "basa walanda":"nl",
        "basa wélsh":"cy",
        "basa yiddis":"yi",
        "mandarin (sederhana)":"zh-CN",
        "mandarin (tradisional)":"zh-TW",
        "tambua lugha":"auto",
        "kiafrikana":"af",
        "kiaislandi":"is",
        "kiajemi":"fa",
        "kialbania":"sq",
        "kiamhariki":"am",
        "kiarabu":"ar",
        "kiayalandi":"ga",
        "kiazebaijani":"az",
        "kibaski":"eu",
        "kibelarusi":"be",
        "kibengali":"bn",
        "kibosnia":"bs",
        "kibulgaria":"bg",
        "kiburma":"my",
        "kicheki":"cs",
        "kichewa":"ny",
        "kidenmaki":"da",
        "kiebrania":"iw",
        "kiesperanto":"eo",
        "kifilipino":"tl",
        "kifrisia":"fy",
        "kigaeli-skoti":"gd",
        "kigalisia":"gl",
        "kigiriki":"el",
        "kigujarati":"gu",
        "kihausa":"ha",
        "kihawaii":"haw",
        "kihindi":"hi",
        "kihmong":"hmn",
        "kiholanzi":"nl",
        "kihungari":"hu",
        "kiigbo":"ig",
        "kiindonesia":"id",
        "kiitaliano":"it",
        "kijava":"jw",
        "kijerumani":"de",
        "kijiojia":"ka",
        "kikambodia":"km",
        "kikannada":"kn",
        "kikazakh":"kk",
        "kikirgizi":"ky",
        "kikorsika":"co",
        "kikroeshia":"hr",
        "kikurdi":"ku",
        "kilao":"lo",
        "kilasembagi":"lb",
        "kilatini":"la",
        "kilatvia":"lv",
        "kilithuania":"lt",
        "kimalagasi":"mg",
        "kimalayalam":"ml",
        "kimalesia":"ms",
        "kimalta":"mt",
        "kimaori":"mi",
        "kimarathi":"mr",
        "kimasedonia":"mk",
        "kimongolia":"mn",
        "kinepali":"ne",
        "kipashto":"ps",
        "kipolandi":"pl",
        "kipunjabi":"pa",
        "kireno":"pt",
        "kiromania":"ro",
        "kisamoa":"sm",
        "kisebuano":"ceb",
        "kiserbia":"sr",
        "kishona":"sn",
        "kisindhi":"sd",
        "kisinhala":"si",
        "kislovakia":"sk",
        "kisomali":"so",
        "kisotho":"st",
        "kisunda":"su",
        "kiswidi":"sv",
        "kitajiki":"tg",
        "kitamil":"ta",
        "kitatari":"tt",
        "kitelugu":"te",
        "kithai":"th",
        "kiturukimeni":"tk",
        "kiuiguri":"ug",
        "kiukrani":"uk",
        "kiurdu":"ur",
        "kiuzbeki":"uz",
        "kivietnam":"vi",
        "kiwelshi":"cy",
        "kixhosa":"xh",
        "kiyidi":"yi",
        "kiyoruba":"yo",
        "kizulu":"zu",
        "krioli ya haiti":"ht",
        "kichina (cha kitamaduni)":"zh-TW",
        "kichina (rahisi)":"zh-CN",
        "identifiera språk":"auto",
        "amhariska":"am",
        "arabiska":"ar",
        "armeniska":"hy",
        "azerbajdzjanska":"az",
        "baskiska":"eu",
        "bosniska":"bs",
        "bulgariska":"bg",
        "burmesiska":"my",
        "engelska":"en",
        "filippinska":"tl",
        "gaeliska":"gd",
        "galiciska":"gl",
        "georgiska":"ka",
        "grekiska":"el",
        "haitiska":"ht",
        "hawaiianska":"haw",
        "hebreiska":"iw",
        "irländska":"ga",
        "isländska":"is",
        "italienska":"it",
        "javanesiska":"jw",
        "kanaresiska":"kn",
        "katalanska":"ca",
        "kazakiska":"kk",
        "kinesiska":"zh-CN",
        "kirgiziska":"ky",
        "korsiska":"co",
        "kroatiska":"hr",
        "kurdiska":"ku",
        "laotiska":"lo",
        "lettiska":"lv",
        "litauiska":"lt",
        "luxemburgska":"lb",
        "malagassiska":"mg",
        "malaysiska":"ms",
        "maltesiska":"mt",
        "nederländska":"nl",
        "oriya (odia)":"or",
        "persiska":"fa",
        "polska":"pl",
        "samoanska":"sm",
        "serbiska":"sr",
        "singalesiska":"si",
        "slovakiska":"sk",
        "slovenska":"sl",
        "somaliska":"so",
        "tatariska":"tt",
        "thailändska":"th",
        "tjeckiska":"cs",
        "turkmeniska":"tk",
        "tyska":"de",
        "uiguriska":"ug",
        "uzbekiska":"uz",
        "vietnamesiska":"vi",
        "walesiska":"cy",
        "kinesiska (förenklad)":"zh-CN",
        "kinesiska (traditionell)":"zh-TW",
        "муайян кардани забон":"auto",
        "aлбанӣ":"sq",
        "aрабӣ":"ar",
        "bиетномӣ":"vi",
        "cербӣ":"sr",
        "cесотоӣ":"st",
        "cиндӣ":"sd",
        "cловакӣ":"sk",
        "cловенӣ":"sl",
        "cомалиягӣ":"so",
        "hорвегӣ":"no",
        "kореӣ":"ko",
        "mалайӣ":"ms",
        "mаратҳӣ":"mr",
        "oлмонӣ":"de",
        "pуминӣ":"ro",
        "pусӣ":"ru",
        "tайӣ":"th",
        "tуркӣ":"tr",
        "tуркманӣ":"tk",
        "xузoӣ":"xh",
        "амхорӣ":"am",
        "арманӣ":"hy",
        "африқоӣ":"af",
        "белорусӣ":"be",
        "бенгалӣ":"bn",
        "бирманӣ":"my",
        "босниявӣ":"bs",
        "булғорӣ":"bg",
        "велсӣ":"cy",
        "голикиёӣ":"gl",
        "гурҷӣ":"ka",
        "гуҷаратӣ":"gu",
        "даниягӣ":"da",
        "ёрубоӣ":"yo",
        "жопунӣ":"ja",
        "ибо":"ig",
        "инглисӣ":"en",
        "ирлондӣ":"ga",
        "исландӣ":"is",
        "итoлёӣ":"it",
        "каталанӣ":"ca",
        "керуотӣ":"hr",
        "кинёрвондӣ":"rw",
        "корсикӣ":"co",
        "креолии ҳаитигӣ":"ht",
        "курдӣ":"ku",
        "қазоқӣ":"kk",
        "қирғизӣ":"ky",
        "лаосӣ":"lo",
        "латвиягӣ":"lv",
        "лаҳистонӣ":"pl",
        "литвонӣ":"lt",
        "люксембургӣ":"lb",
        "мақдунӣ":"mk",
        "малагасигӣ":"mg",
        "малтавӣ":"mt",
        "маорӣ":"mi",
        "маҷорӣ":"hu",
        "муғулӣ":"mn",
        "непалӣ":"ne",
        "озарӣ":"az",
        "пaшту":"ps",
        "панҷобӣ":"pa",
        "пуртуғолӣ":"pt",
        "самоагӣ":"sm",
        "сингалӣ":"si",
        "судонӣ":"su",
        "суъидӣ":"sv",
        "тамилӣ":"ta",
        "тоторӣ":"tt",
        "тоҷикӣ":"tg",
        "уйғӯрӣ":"ug",
        "укройнӣ":"uk",
        "фaрoнсавӣ":"fr",
        "филиппинӣ":"tl",
        "финнӣ":"fi",
        "форсӣ":"fa",
        "фризӣ":"fy",
        "хмерӣ":"km",
        "ҳавайигӣ":"haw",
        "ҳауса":"ha",
        "ҳиндӣ":"hi",
        "ҳмонг":"hmn",
        "ҳолландӣ":"nl",
        "чехӣ":"cs",
        "ҷовонӣ":"jw",
        "шотландӣ-галикӣ":"gd",
        "эсперантӣ":"eo",
        "юнонӣ":"el",
        "яҳудӣ":"iw",
        "чинӣ (анъанавӣ)":"zh-TW",
        "чинӣ (содда гардонидашуда)":"zh-CN",
        "மொழியைக் கண்டறி":"auto",
        "அரபிக்":"ar",
        "அல்பேனியன்":"sq",
        "ஆஃப்ரிக்கான்ஸ்":"af",
        "இக்போ":"ig",
        "இத்தாலியன்":"it",
        "இந்தோனேஷியன்":"id",
        "உக்ரைனியன்":"uk",
        "உருது":"ur",
        "உஸ்பெக்":"uz",
        "எஸ்பரேன்டோ":"eo",
        "ஐஸ்லாந்தியன்":"is",
        "ஒடியா (ஒரியா)":"or",
        "ஃப்ரிஷன்":"fy",
        "ஃபிரெஞ்சு":"fr",
        "ஃபிலிப்பினோ":"tl",
        "ஃபின்னிஷ்":"fi",
        "க்ஸ்ஹோசா":"xh",
        "கலீசியன்":"gl",
        "கன்னடம்":"kn",
        "கஸாக்":"kk",
        "கார்சிகன்":"co",
        "கிண்யர்வான்டா":"rw",
        "கிமேர்":"km",
        "கிர்கீஸ்":"ky",
        "கிரேக்கம்":"el",
        "குர்திஷ் (குர்மாஞ்சி)":"ku",
        "கேட்டலன்":"ca",
        "சாமோவான்":"sm",
        "சிங்களம்":"si",
        "சிசேவா":"ny",
        "சீனம்":"zh-CN",
        "சுந்தனீஸ்":"su",
        "செபுவானோ":"ceb",
        "செர்பியன்":"sr",
        "சேசோத்தோ":"st",
        "டர்க்மென்":"tk",
        "டாடர்":"tt",
        "டேனிஷ்":"da",
        "துருக்கியம்":"tr",
        "நார்வீஜியன்":"no",
        "நேபாளம்":"ne",
        "பஞ்சாபி":"pa",
        "பாரசீகம்":"fa",
        "பாஸ்க்":"eu",
        "பெலாருஷ்யன்":"be",
        "போர்ச்சுகீஸ்":"pt",
        "போலிஷ்":"pl",
        "மால்ட்டீஸ்":"mt",
        "மாவோரி":"mi",
        "மாஸிடோனியன்":"mk",
        "மியான்மர் (பர்மீஸ்)":"my",
        "யித்திஷ்":"yi",
        "யூகுர்":"ug",
        "யோருபா":"yo",
        "ரஷ்யன்":"ru",
        "ருமேனியன்":"ro",
        "லக்ஸெம்பர்கிஷ்":"lb",
        "லாத்வியன்":"lv",
        "வங்காளம்":"bn",
        "வியட்னாமீஸ்":"vi",
        "வெல்ஷ்":"cy",
        "ஜாப்பனிஸ்":"ja",
        "ஜாவனீஸ்":"jw",
        "ஜூலூ":"zu",
        "ஸ்வாஹிலி":"sw",
        "ஸ்வீடிஷ்":"sv",
        "ஹ்மொங்":"hmn",
        "ஹங்கேரியன்":"hu",
        "ஹவாயன்":"haw",
        "ஹைத்தியன் கிரியோல்":"ht",
        "ஹௌசா":"ha",
        "சீனம் (எளிய வரிவடிவம்)":"zh-CN",
        "சீனம் (பாரம்பரிய வரிவடிவம்)":"zh-TW",
        "భాషను కనుగొను":"auto",
        "అజర్\u200cబైజాని":"az",
        "అర్మేనియన్":"hy",
        "అల్బేనియన్":"sq",
        "ఆంగ్లము":"en",
        "ఆఫ్రికాన్స్":"af",
        "ఆమ్హారిక్":"am",
        "ఆరబిక్":"ar",
        "ఇండొనేసియన్":"id",
        "ఉజ్బెక్":"uz",
        "ఎస్పెరాంటో":"eo",
        "ఏస్టోనియన్":"et",
        "ఐరిష్":"ga",
        "ఐస్ లాండిక్":"is",
        "ఒడియా (ఒరియా)":"or",
        "కజాఖ్":"kk",
        "కన్నడ":"kn",
        "కర్డిష్":"ku",
        "కిన్యర్వాండ":"rw",
        "కిర్గ్స్":"ky",
        "కొరియన్":"ko",
        "క్యాటలాన్":"ca",
        "క్రొయేషియన్":"hr",
        "ఖోస":"xh",
        "గాలిసియన్":"gl",
        "గుజరాతి":"gu",
        "గ్రీక్":"el",
        "చిచేవా":"ny",
        "చెక్":"cs",
        "చైనీసు":"zh-CN",
        "జపనీస్":"ja",
        "జార్జియన్":"ka",
        "జావానీస్":"jw",
        "టర్కిష్":"tr",
        "టర్క్\u200cమెన్":"tk",
        "టాటర్":"tt",
        "డచ్":"nl",
        "డానిష్":"da",
        "తమిళం":"ta",
        "థాయ్":"th",
        "నార్విజియన్":"no",
        "నేపాలీ":"ne",
        "పర్షియన్":"fa",
        "పోర్చుగీస్":"pt",
        "పోలిష్":"pl",
        "ఫిన్నిష్":"fi",
        "ఫిలిపినో":"tl",
        "ఫ్రీసియన్":"fy",
        "బల్గేరియన్":"bg",
        "బాస్క్":"eu",
        "బెలారష్యన్":"be",
        "మంగోలియన్":"mn",
        "మలయాళం":"ml",
        "మలాగాసి":"mg",
        "మాంగ్":"hmn",
        "మాలై":"ms",
        "మాల్టీస్":"mt",
        "మాసిడోనియన్":"mk",
        "యిడ్డిష్":"yi",
        "యుక్రేనియన్":"uk",
        "యొరుబా":"yo",
        "రొమేనియన్":"ro",
        "లక్సెంబర్గిష్":"lb",
        "లాట్వియన్":"lv",
        "లిథువేనియన్":"lt",
        "విగర్":"ug",
        "వియత్నామీస్":"vi",
        "వెల్ష్":"cy",
        "షోనా":"sn",
        "సమోవాన్":"sm",
        "సుండనీస్":"su",
        "సెబువానో":"ceb",
        "సెసోథో":"st",
        "స్పానిష్":"es",
        "స్లోవాక్":"sk",
        "స్లోవేనియన్":"sl",
        "స్వాహిలి":"sw",
        "స్వీడిష్":"sv",
        "హంగేరియన్":"hu",
        "హవాయియన్":"haw",
        "హీబ్రూ":"iw",
        "హైయేటియన్ క్రియోల్":"ht",
        "హౌస":"ha",
        "చైనీస్ (సరళమైన)":"zh-CN",
        "చైనీస్ (సాంప్రదాయమైన)":"zh-TW",
        "ตรวจหาภาษา":"auto",
        "กันนาดา":"kn",
        "กาลิเชียน":"gl",
        "เกลิกสกอต":"gd",
        "เขมร":"km",
        "คอร์สิกา":"co",
        "คาซัค":"kk",
        "คินยารวันดา":"rw",
        "คีร์กิซ":"ky",
        "โคซา":"xh",
        "จีน":"zh-CN",
        "ชวา":"jw",
        "ชิเชวา":"ny",
        "เช็ก":"cs",
        "ซีบัวโน":"ceb",
        "ซูลู":"zu",
        "เซโซโท":"st",
        "เซอร์เบียน":"sr",
        "เตลูกู":"te",
        "เติร์กเมน":"tk",
        "ทมิฬ":"ta",
        "ทาจิก":"tg",
        "ทาทาร์":"tt",
        "บาสก์":"eu",
        "เบงกอล":"bn",
        "ปัญจาป":"pa",
        "โปแลนด์":"pl",
        "พาชตู":"ps",
        "ฟริเชียน":"fy",
        "มัลทีส":"mt",
        "มาซีโดเนีย":"mk",
        "มาราฐี":"mr",
        "มาลากาซี":"mg",
        "มาเลย์":"ms",
        "เมารี":"mi",
        "เมียนมา (พม่า)":"my",
        "โยรูบา":"yo",
        "ลิทัวเนีย":"lt",
        "เวียดนาม":"vi",
        "สโลวัก":"sk",
        "สโลวีเนีย":"sl",
        "สวาฮิลี":"sw",
        "สินธี":"sd",
        "อัมฮาริก":"am",
        "อาร์เซอร์ไบจัน":"az",
        "อาหรับ":"ar",
        "อิกโบ":"ig",
        "อินโดนีเซีย":"id",
        "อุสเบกิสถาน":"uz",
        "อูรดู":"ur",
        "เอสโทเนีย":"et",
        "เอสเปอแรนโต":"eo",
        "แอฟริกา":"af",
        "โอเดีย (โอริยา)":"or",
        "ฮัวซา":"ha",
        "ฮินดี":"hi",
        "ฮีบรู":"iw",
        "เฮติครีโอล":"ht",
        "จีน (ตัวเต็ม)":"zh-TW",
        "визначити мову":"auto",
        "азербайджанська":"az",
        "амхарська":"am",
        "баскська":"eu",
        "бірманська":"my",
        "боснійська":"bs",
        "валлійська":"cy",
        "вірменська":"hy",
        "гавайська":"haw",
        "гаїтянська креольська":"ht",
        "гінді":"hi",
        "грецька":"el",
        "ґалісійська":"gl",
        "ґуджаратська":"gu",
        "данська":"da",
        "естонська":"et",
        "ігбо (ібо)":"ig",
        "ірландська":"ga",
        "ісландська":"is",
        "італійська":"it",
        "казахська":"kk",
        "камбоджійська":"km",
        "каталанська":"ca",
        "киргизька":"ky",
        "китайська":"zh-CN",
        "корейська":"ko",
        "корсиканська":"co",
        "курдська":"ku",
        "лаоська":"lo",
        "латинська":"la",
        "латиська":"lv",
        "литовська":"lt",
        "люксембурзька":"lb",
        "македонська":"mk",
        "малагасійська":"mg",
        "малайська":"ms",
        "непальська":"ne",
        "нідерландська":"nl",
        "орія":"or",
        "панджабська":"pa",
        "перська":"fa",
        "польська":"pl",
        "російська":"ru",
        "руандійська":"rw",
        "самоанська":"sm",
        "сербська":"sr",
        "сингальська":"si",
        "словацька":"sk",
        "сунданська":"su",
        "таджицька":"tg",
        "тайська":"th",
        "тамільська":"ta",
        "татарська":"tt",
        "телуґу":"te",
        "туркменська":"tk",
        "угорська":"hu",
        "узбецька":"uz",
        "уйгурська":"ug",
        "філіппінська":"tl",
        "фінська":"fi",
        "французька":"fr",
        "шотландська (ґельська)":"gd",
        "яванська":"jw",
        "японська":"ja",
        "китайська (традиційна)":"zh-TW",
        "زبان کی شناخت کریں":"auto",
        "اڑیہ (اوریہ)":"or",
        "ازبیک":"uz",
        "اسپیرانٹو":"eo",
        "اسکاٹس گیلک":"gd",
        "افریقی":"af",
        "اِگبو":"ig",
        "البانیائی":"sq",
        "امہاری":"am",
        "انڈونیشیائی":"id",
        "ایسٹونیائی":"et",
        "آذربائیجانی":"az",
        "آرمینیائی":"hy",
        "آئرستانی":"ga",
        "آئس لینڈک":"is",
        "بسق":"eu",
        "بلغاریائی":"bg",
        "بوسنیائی":"bs",
        "بیلاروسی":"be",
        "ترکش":"tr",
        "ترکمانی":"tk",
        "تیلگو":"te",
        "جارجیائی":"ka",
        "جاوانیز":"jw",
        "رومانیائی":"ro",
        "سربیائی":"sr",
        "سلوواک":"sk",
        "سلووینیائی":"sl",
        "سنڈانیز":"su",
        "سنہالا":"si",
        "سواحلی":"sw",
        "سیسوتھو":"st",
        "شي شوا":"ny",
        "عبرانی":"iw",
        "فریسین":"fy",
        "فلپینو":"tl",
        "قزاخ":"kk",
        "کروشیائی":"hr",
        "کنّڑ":"kn",
        "کوریائی":"ko",
        "کیٹیلان":"ca",
        "کینیا روانڈا":"rw",
        "گیلیشیائی":"gl",
        "لتھوانیائی":"lt",
        "لٹویائی":"lv",
        "لگژمبرگی":"lb",
        "مالٹیز":"mt",
        "مالے":"ms",
        "ماؤری":"mi",
        "مقدونیائی":"mk",
        "منگولیائی":"mn",
        "میلاگاسی":"mg",
        "نارویجین":"no",
        "ویلش":"cy",
        "ہنگریائی":"hu",
        "ہوائی":"haw",
        "ہؤسا":"ha",
        "ہیشین کریول":"ht",
        "یدّش":"yi",
        "یوکرینیائی":"uk",
        "یوئگہر":"ug",
        "چینی  (آسان)":"zh-CN",
        "amxar":"am",
        "arman":"hy",
        "bolgar":"bg",
        "fors":"fa",
        "fransuz":"fr",
        "gaiti-kreol":"ht",
        "galisiy":"gl",
        "gavayi":"haw",
        "golland":"nl",
        "gruzin":"ka",
        "gujarot":"gu",
        "ibroniy":"iw",
        "indonez":"id",
        "ingliz":"en",
        "irland":"ga",
        "island":"is",
        "kurd (kurmonji)":"ku",
        "kxosa":"xh",
        "latish":"lv",
        "makedon":"mk",
        "maltiy":"mt",
        "maratxi":"mr",
        "mo‘g‘ul":"mn",
        "norveg":"no",
        "panjob":"pa",
        "portugal":"pt",
        "pushtu":"ps",
        "qirg‘iz":"ky",
        "rumin":"ro",
        "sebuan":"ceb",
        "sindxi":"sd",
        "singal":"si",
        "turk":"tr",
        "turkman":"tk",
        "ukrain":"uk",
        "uygʻur":"ug",
        "valliy":"cy",
        "venger":"hu",
        "xausa":"ha",
        "xmong":"hmn",
        "yidish":"yi",
        "o‘zbek":"uz",
        "shotland-gel":"gd",
        "xitoy (an’anaviy)":"zh-TW",
        "xitoy (soddalashgan)":"zh-CN",
        "phát hiện ngôn ngữ":"auto",
        "ả rập":"ar",
        "anh":"en",
        "ba lan":"pl",
        "bantu":"xh",
        "corsi":"co",
        "creole (haiti)":"ht",
        "do thái":"iw",
        "đan mạch":"da",
        "đức":"de",
        "gael scotland":"gd",
        "george":"ka",
        "gujarat":"gu",
        "hà lan (nam phi)":"af",
        "hàn":"ko",
        "hy lạp":"el",
        "lào":"lo",
        "latinh":"la",
        "na uy":"no",
        "nga":"ru",
        "nhật":"ja",
        "pháp":"fr",
        "punjab":"pa",
        "quốc tế ngữ":"eo",
        "tây ban nha":"es",
        "thái":"th",
        "trung":"zh-CN",
        "việt":"vi",
        "xứ wales":"cy",
        "ý":"it",
        "trung (giản thể)":"zh-CN",
        "trung (phồn thể)":"zh-TW",
        "synhwyro iaith":"auto",
        "affricaneg":"af",
        "albaneg":"sq",
        "almaeneg":"de",
        "armeneg":"hy",
        "aserbaijaneg":"az",
        "bengaleg":"bn",
        "bosnieg":"bs",
        "bwlgaraidd":"bg",
        "catalaneg":"ca",
        "ciniarwanda":"rw",
        "corsiceg":"co",
        "creol haiti":"ht",
        "croateg":"hr",
        "cyrdeg (kurmandji)":"ku",
        "cyrgis":"ky",
        "chmereg":"km",
        "daneg":"da",
        "eidaleg":"it",
        "estoneg":"et",
        "fietnameg":"vi",
        "ffineg":"fi",
        "fflemeg":"nl",
        "ffrisieg":"fy",
        "gaeleg yr alban":"gd",
        "galisaidd":"gl",
        "georgeg":"ka",
        "groeg":"el",
        "gwjarati":"gu",
        "hawäieg":"haw",
        "hawseg":"ha",
        "hebraeg":"iw",
        "hwngareg":"hu",
        "iaith corea":"ko",
        "iddeweg":"yi",
        "indonesieg":"id",
        "iorwba":"yo",
        "islandeg":"is",
        "iwcraineg":"uk",
        "jafanaeg":"jw",
        "japaneg":"ja",
        "kazaceg":"kk",
        "laoteg":"lo",
        "latfieg":"lv",
        "lithwaneg":"lt",
        "lwcsembwrgeg":"lb",
        "macedoneg":"mk",
        "malagaseg":"mg",
        "malteseg":"mt",
        "mongoleg":"mn",
        "myanmar (byrma)":"my",
        "norwyeg":"no",
        "odia (orïa)":"or",
        "perseg":"fa",
        "portiwgaleg":"pt",
        "pwnjabi":"pa",
        "pwyleg":"pl",
        "rwmaneg":"ro",
        "rwsieg":"ru",
        "samöeg":"sm",
        "sbaeneg":"es",
        "sindieg":"sd",
        "sinhaleg":"si",
        "siona":"sn",
        "slofac":"sk",
        "slofenia":"sl",
        "somaleg":"so",
        "sundanes":"su",
        "swedeg":"sv",
        "swlw":"zu",
        "tajiceg":"tg",
        "tatareg":"tt",
        "tsieceg":"cs",
        "tsieineeg":"zh-CN",
        "tyrcmeneg":"tk",
        "usbec":"uz",
        "wigwreg":"ug",
        "tsieineeg (traddodiadol)":"zh-TW",
        "tsieineeg (wedi symleiddio)":"zh-CN",
        "fumana ulwimi":"auto",
        "amatshayina":"zh-CN",
        "icreole yasehaiti":"ht",
        "isi-albania":"sq",
        "isi-arabic":"ar",
        "isi-armenian":"hy",
        "isi-belarusian":"be",
        "isi-bosnia":"bs",
        "isi-croatia":"hr",
        "isi-czech":"cs",
        "isi-danish":"da",
        "isi-esperanto":"eo",
        "isi-estonian":"et",
        "isi-finnish":"fi",
        "isi-frisian":"fy",
        "isi-gujarati":"gu",
        "isi-hungarian":"hu",
        "isi-icelandic":"is",
        "isi-igbo":"ig",
        "isi-indonesian":"id",
        "isi-irish":"ga",
        "isi-italian":"it",
        "isi-korean":"ko",
        "isi-malay":"ms",
        "isi-norwegian":"no",
        "isi-persia":"fa",
        "isi-polish":"pl",
        "isi-romanian":"ro",
        "isi-russian":"ru",
        "isi-serbia":"sr",
        "isi-slovak":"sk",
        "isi-slovenian":"sl",
        "isi-spanish":"es",
        "isi-swedish":"sv",
        "isi-taglog":"tl",
        "isi-ukranian":"uk",
        "isi-uyghur":"ug",
        "isi-uzbek":"uz",
        "isibasque":"eu",
        "isibengali":"bn",
        "isibulgaria":"bg",
        "isiburmese":"my",
        "isicalatan":"ca",
        "isicambodia":"km",
        "isicebuano":"ceb",
        "isichichewa":"ny",
        "isicorsican":"co",
        "isigalician":"gl",
        "isigeorgia":"ka",
        "isigreek":"el",
        "isihausa":"ha",
        "isihindi":"hi",
        "isihmong":"hmn",
        "isijapanese":"ja",
        "isijavanese":"jw",
        "isikannada":"kn",
        "isikinyarwanda":"rw",
        "isilatin":"la",
        "isilatvian":"lv",
        "isiluxembourgish":"lb",
        "isimacedenian":"mk",
        "isimalagasy":"mg",
        "isimalayalam":"ml",
        "isimaltese":"mt",
        "isimaori":"mi",
        "isimongolian":"mn",
        "isinepali":"ne",
        "isinhala":"si",
        "isipunjabi":"pa",
        "isisamoan":"sm",
        "isiscots gaelic":"gd",
        "isishona":"sn",
        "isisindhi":"sd",
        "isisomaliya":"so",
        "isisudanese":"su",
        "isisuthu":"st",
        "isiswahili":"sw",
        "isitajik":"tg",
        "isitamil":"ta",
        "isitatar":"tt",
        "isitelegu":"te",
        "isithai":"th",
        "isiturkish":"tr",
        "isiturkmen":"tk",
        "isivietnamese":"vi",
        "isiwelsh":"cy",
        "isiyoruba":"yo",
        "isizulu":"zu",
        "isitshayina (esenziwe lula)":"zh-CN",
        "isitshayina (esiqhelekileyo)":"zh-TW",
        "ארפינד שפראך":"auto",
        "אָדיִאַ (אָריִיאאַ)":"or",
        "אוּגהוּר":"ug",
        "אוּזבעקיש":"uz",
        "אוּקרײניש":"uk",
        "אוּרדוּ":"ur",
        "אַזערבײַדזשאַניש":"az",
        "אײַריש":"ga",
        "אַמהאַריש":"am",
        "אַפֿריקאַנס":"af",
        "אַרמעניש":"hy",
        "באָזניש":"bs",
        "באַסקיש":"eu",
        "בוּלגאַריש":"bg",
        "בעלאָרוּסיש":"be",
        "בענגאַלי":"bn",
        "גאַליציאַניש":"gl",
        "גוּדזשאַראַטי":"gu",
        "גרוזיניש":"ka",
        "דײַטש":"de",
        "האַװײַאַן":"haw",
        "האַוּסאַ":"ha",
        "האָלאַנדיש":"nl",
        "הוּנגעריש":"hu",
        "הײַטיאַן קרעאָלע":"ht",
        "המאָנג":"hmn",
        "העברעיִש":"iw",
        "װיעטנאַמעזיש":"vi",
        "וועלש":"cy",
        "זוּלוּ":"zu",
        "טאַדזשיק":"tg",
        "טאַטאַר":"tt",
        "טאַמיל":"ta",
        "טוּרקיש":"tr",
        "טורקמען":"tk",
        "טײַלענדיש":"th",
        "טעלוּגוּ":"te",
        "טשיטשעהוּאַ":"ny",
        "טשעכיש":"cs",
        "יאַוואַנעזיש":"jw",
        "יאָרוּבאַ":"yo",
        "כמער":"km",
        "לאַאָטיש":"lo",
        "לאַטין":"la",
        "לוּקסעמבוּרגיש":"lb",
        "לעטיש":"lv",
        "מאַאָרי":"mi",
        "מאַלאַגאַסיש":"mg",
        "מאַלטעזיש":"mt",
        "מאַלײַאיש":"ms",
        "מאַלייאַלאַם":"ml",
        "מאָנגאָליש":"mn",
        "מאַראַטי":"mr",
        "מיאַנמאַר (בוּרמעזיש)":"my",
        "סאַמאָאַן":"sm",
        "סאָמאַלי":"so",
        "סוואַהילי":"sw",
        "סוּנדאַנעזיש":"su",
        "סינהאַלאַ":"si",
        "סלאָװאַקיש":"sk",
        "סלאָוועניש":"sl",
        "סעבוּאַנאָ":"ceb",
        "סעסאָטאָ":"st",
        "סקאָטס געליש":"gd",
        "עספּעראַנטאָ":"eo",
        "פּאָרטוּגעײש":"pt",
        "פּױליש":"pl",
        "פּוּנזשאַבי":"pa",
        "פּערסיש":"fa",
        "פֿיליפּינאאָ":"tl",
        "פֿראַנצױזיש":"fr",
        "פֿריזיש":"fy",
        "קאַזאַק":"kk",
        "קאַטאַלאַניש":"ca",
        "קאַנאַדאַ":"kn",
        "קאָרסיקאַניש":"co",
        "קהאָסע":"xh",
        "קוּרדיש (קוּרמאַנדזשי)":"ku",
        "קיניאַרװאַנדאַ":"rw",
        "קראָאַטיש":"hr",
        "רוּמעניש":"ro",
        "רוּסיש":"ru",
        "שאָנאַ":"sn",
        "שװעדיש":"sv",
        "ṣawari ede":"auto",
        "èdè afrikani":"af",
        "èdè airiṣi":"ga",
        "èdè albania":"sq",
        "èdè amẹnia":"hy",
        "èdè amharic":"am",
        "èdè azerbaijani":"az",
        "èdè baski":"eu",
        "èdè belarusi":"be",
        "èdè bengali":"bn",
        "èdè bosnia":"bs",
        "èdè bulgaria":"bg",
        "èdè catala":"ca",
        "èdè cebuano":"ceb",
        "èdè chichewa":"ny",
        "èdè chinesi":"zh-CN",
        "èdè danish":"da",
        "èdè dutch":"nl",
        "èdè esperanto":"eo",
        "èdè estonia":"et",
        "èdè faranse":"fr",
        "èdè filipini":"tl",
        "èdè finland":"fi",
        "èdè frisia":"fy",
        "èdè gaelik ti ilu scotland":"gd",
        "èdè galicia":"gl",
        "èdè georgia":"ka",
        "èdè gẹẹsi":"en",
        "èdè giriki":"el",
        "èdè gujarati":"gu",
        "èdè haitian creole":"ht",
        "ede hausa":"ha",
        "èdè hawaiian":"haw",
        "ede heberu":"iw",
        "èdè hindu":"hi",
        "èdè hmongi":"hmn",
        "èdè hungaria":"hu",
        "èdè icelandic":"is",
        "èdè igbo":"ig",
        "èdè indonesia":"id",
        "èdè italiani":"it",
        "èdè jamani":"de",
        "èdè japanisi":"ja",
        "èdè javana":"jw",
        "èdè kannada":"kn",
        "èdè kasaki":"kk",
        "èdè khima":"km",
        "èdè kinyarwanda":"rw",
        "ede koriani":"ko",
        "èdè kosikaani":"co",
        "èdè kroatia":"hr",
        "èdè kurdish (kurmanji)":"ku",
        "èdè kyrgyz":"ky",
        "èdè laos":"lo",
        "èdè larubawa":"ar",
        "èdè latini":"la",
        "èdè latvianu":"lv",
        "èdè lithuania":"lt",
        "èdè luxembourgish":"lb",
        "èdè makedonia":"mk",
        "ede malagasi":"mg",
        "èdè malaya":"ms",
        "èdè malayalami":"ml",
        "èdè malta":"mt",
        "èdè mangoli":"mn",
        "èdè maori":"mi",
        "èdè marathi":"mr",
        "èdè mianma (bumiisi)":"my",
        "èdè nepali":"ne",
        "èdè norway":"no",
        "èdè pashto":"ps",
        "èdè persia":"fa",
        "ede polandi":"pl",
        "èdè portugi":"pt",
        "èdè punjabi":"pa",
        "èdè romania":"ro",
        "èdè roosia":"ru",
        "èdè samoan":"sm",
        "èdè serbia":"sr",
        "èdè sesoto":"st",
        "èdè sinhala":"si",
        "èdè slovaki":"sk",
        "èdè slovenia":"sl",
        "èdè somali":"so",
        "èdè sona":"sn",
        "èdè spanish":"es",
        "èdè sudani":"su",
        "èdè sulu":"zu",
        "èdè suwidiisi":"sv",
        "èdè swahili":"sw",
        "èdè tajiki":"tg",
        "èdè tamili":"ta",
        "èdè tata":"tt",
        "èdè telugu":"te",
        "èdè thai":"th",
        "èdè tọkii":"tr",
        "èdè tseki":"cs",
        "èdè turkmen":"tk",
        "èdè ukrani":"uk",
        "èdè urdu":"ur",
        "èdè uzbek":"uz",
        "èdè vietnamu":"vi",
        "èdè welshi":"cy",
        "èdè xhosa":"xh",
        "èdè yiddish":"yi",
        "èdè yorùbá":"yo",
        "èdè chine (àtôwödöwö)":"zh-TW",
        "èdè chine (rọ)":"zh-CN",
        "hlonza ulimi":"auto",
        "isi-afrikaans":"af",
        "isi-basque":"eu",
        "isi-bengali":"bn",
        "isi-bosnian":"bs",
        "isi-bulgarian":"bg",
        "isi-burmese":"my",
        "isi-catalan":"ca",
        "isi-cebuano":"ceb",
        "isi-chichewa":"ny",
        "isi-chinese":"zh-CN",
        "isi-corsican":"co",
        "isi-croatian":"hr",
        "isi-dutch":"nl",
        "isi-english":"en",
        "isi-filipino":"tl",
        "isi-frasian":"fy",
        "isi-french":"fr",
        "isi-galician":"gl",
        "isi-georgian":"ka",
        "isi-german":"de",
        "isi-greek":"el",
        "isi-haitian creole":"ht",
        "isi-hangarian":"hu",
        "isi-hausa":"ha",
        "isi-hawaiin":"haw",
        "isi-hebrew":"iw",
        "isi-hindi":"hi",
        "isi-hmong":"hmn",
        "isi-japanese":"ja",
        "isi-javanese":"jw",
        "isi-kannada":"kn",
        "isi-kazakh":"kk",
        "isi-khmer":"km",
        "isi-kinyarwanda":"rw",
        "isi-kurdish":"ku",
        "isi-kyrgyz":"ky",
        "isi-lao":"lo",
        "isi-latin":"la",
        "isi-luxembourgish":"lb",
        "isi-macedonian":"mk",
        "isi-malagasy":"mg",
        "isi-maltese":"mt",
        "isi-maori":"mi",
        "isi-marathi":"mr",
        "isi-mongolian":"mn",
        "isi-nepali":"ne",
        "isi-odia (oriya)":"or",
        "isi-pashto":"ps",
        "isi-persian":"fa",
        "isi-punjabi":"pa",
        "isi-samoan":"sm",
        "isi-scots gaelic":"gd",
        "isi-serbian":"sr",
        "isi-shona":"sn",
        "isi-sindhi":"sd",
        "isi-sinhala":"si",
        "isi-somali":"so",
        "isi-sundanese":"su",
        "isi-tajik":"tg",
        "isi-tatar":"tt",
        "isi-telugu":"te",
        "isi-thai":"th",
        "isi-thamil":"ta",
        "isi-turkish":"tr",
        "isi-turkmen":"tk",
        "isi-ukrainian":"uk",
        "isi-urdu":"ur",
        "isi-vietnamese":"vi",
        "isi-welsh":"cy",
        "isi-yiddish":"yi",
        "isi-yoruba":"yo",
        "isi-chinese (simplified)":"zh-CN",
        "isi-chinese (traditional)":"zh-TW"
    }
    return data_dict


def google_translate_domains_data():
    """
    All the Google Translate's domain names.\n
    Credit to py-googletrans by ssut (constants.py)
    """
    data_list = [
        'translate.google.ac',
        'translate.google.ad',
        'translate.google.ae',
        'translate.google.al',
        'translate.google.am',
        'translate.google.as',
        'translate.google.at',
        'translate.google.az',
        'translate.google.ba',
        'translate.google.be',
        'translate.google.bf',
        'translate.google.bg',
        'translate.google.bi',
        'translate.google.bj',
        'translate.google.bs',
        'translate.google.bt',
        'translate.google.by',
        'translate.google.ca',
        'translate.google.cat',
        'translate.google.cc',
        'translate.google.cd',
        'translate.google.cf',
        'translate.google.cg',
        'translate.google.ch',
        'translate.google.ci',
        'translate.google.cl',
        'translate.google.cm',
        'translate.google.cn',
        'translate.google.co.ao',
        'translate.google.co.bw',
        'translate.google.co.ck',
        'translate.google.co.cr',
        'translate.google.co.id',
        'translate.google.co.il',
        'translate.google.co.in',
        'translate.google.co.jp',
        'translate.google.co.ke',
        'translate.google.co.kr',
        'translate.google.co.ls',
        'translate.google.co.ma',
        'translate.google.co.mz',
        'translate.google.co.nz',
        'translate.google.co.th',
        'translate.google.co.tz',
        'translate.google.co.ug',
        'translate.google.co.uk',
        'translate.google.co.uz',
        'translate.google.co.ve',
        'translate.google.co.vi',
        'translate.google.co.za',
        'translate.google.co.zm',
        'translate.google.co.zw',
        'translate.google.co',
        'translate.google.com.af',
        'translate.google.com.ag',
        'translate.google.com.ai',
        'translate.google.com.ar',
        'translate.google.com.au',
        'translate.google.com.bd',
        'translate.google.com.bh',
        'translate.google.com.bn',
        'translate.google.com.bo',
        'translate.google.com.br',
        'translate.google.com.bz',
        'translate.google.com.co',
        'translate.google.com.cu',
        'translate.google.com.cy',
        'translate.google.com.do',
        'translate.google.com.ec',
        'translate.google.com.eg',
        'translate.google.com.et',
        'translate.google.com.fj',
        'translate.google.com.gh',
        'translate.google.com.gi',
        'translate.google.com.gt',
        'translate.google.com.hk',
        'translate.google.com.jm',
        'translate.google.com.kh',
        'translate.google.com.kw',
        'translate.google.com.lb',
        'translate.google.com.lc',
        'translate.google.com.ly',
        'translate.google.com.mm',
        'translate.google.com.mt',
        'translate.google.com.mx',
        'translate.google.com.my',
        'translate.google.com.na',
        'translate.google.com.ng',
        'translate.google.com.ni',
        'translate.google.com.np',
        'translate.google.com.om',
        'translate.google.com.pa',
        'translate.google.com.pe',
        'translate.google.com.pg',
        'translate.google.com.ph',
        'translate.google.com.pk',
        'translate.google.com.pr',
        'translate.google.com.py',
        'translate.google.com.qa',
        'translate.google.com.sa',
        'translate.google.com.sb',
        'translate.google.com.sg',
        'translate.google.com.sl',
        'translate.google.com.sv',
        'translate.google.com.tj',
        'translate.google.com.tr',
        'translate.google.com.tw',
        'translate.google.com.ua',
        'translate.google.com.uy',
        'translate.google.com.vc',
        'translate.google.com.vn',
        'translate.google.com',
        'translate.google.cv',
        'translate.google.cx',
        'translate.google.cz',
        'translate.google.de',
        'translate.google.dj',
        'translate.google.dk',
        'translate.google.dm',
        'translate.google.dz',
        'translate.google.ee',
        'translate.google.es',
        'translate.google.eu',
        'translate.google.fi',
        'translate.google.fm',
        'translate.google.fr',
        'translate.google.ga',
        'translate.google.ge',
        'translate.google.gf',
        'translate.google.gg',
        'translate.google.gl',
        'translate.google.gm',
        'translate.google.gp',
        'translate.google.gr',
        'translate.google.gy',
        'translate.google.hn',
        'translate.google.hr',
        'translate.google.ht',
        'translate.google.hu',
        'translate.google.ie',
        'translate.google.im',
        'translate.google.io',
        'translate.google.iq',
        'translate.google.is',
        'translate.google.it',
        'translate.google.je',
        'translate.google.jo',
        'translate.google.kg',
        'translate.google.ki',
        'translate.google.kz',
        'translate.google.la',
        'translate.google.li',
        'translate.google.lk',
        'translate.google.lt',
        'translate.google.lu',
        'translate.google.lv',
        'translate.google.md',
        'translate.google.me',
        'translate.google.mg',
        'translate.google.mk',
        'translate.google.ml',
        'translate.google.mn',
        'translate.google.ms',
        'translate.google.mu',
        'translate.google.mv',
        'translate.google.mw',
        'translate.google.ne',
        'translate.google.nf',
        'translate.google.nl',
        'translate.google.no',
        'translate.google.nr',
        'translate.google.nu',
        'translate.google.pl',
        'translate.google.pn',
        'translate.google.ps',
        'translate.google.pt',
        'translate.google.ro',
        'translate.google.rs',
        'translate.google.ru',
        'translate.google.rw',
        'translate.google.sc',
        'translate.google.se',
        'translate.google.sh',
        'translate.google.si',
        'translate.google.sk',
        'translate.google.sm',
        'translate.google.sn',
        'translate.google.so',
        'translate.google.sr',
        'translate.google.st',
        'translate.google.td',
        'translate.google.tg',
        'translate.google.tk',
        'translate.google.tl',
        'translate.google.tm',
        'translate.google.tn',
        'translate.google.to',
        'translate.google.tt',
        'translate.google.us',
        'translate.google.vg',
        'translate.google.vu',
        'translate.google.ws'
    ]
    return data_list
