# Copyright 2020 DeepMind Technologies Limited. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""TensorFlow stubs.

NOTE: This file is generated from templates/tensorflow.pyi
      using a Google-internal tool.
"""

# BEGIN: tensor_annotations annotations
from typing import Any, TypeVar, Tuple, overload
from typing_extensions import Literal

from tensor_annotations.axes import Axis
from tensor_annotations.tensorflow import Tensor0, Tensor1, Tensor2, Tensor3, Tensor4, Tensor5


A1 = TypeVar('A1', bound=Axis)
A2 = TypeVar('A2', bound=Axis)
A3 = TypeVar('A3', bound=Axis)
A4 = TypeVar('A4', bound=Axis)
A5 = TypeVar('A5', bound=Axis)

TRUE = Literal[True]
FALSE = Literal[False]

L0 = Literal[0]
L1 = Literal[1]
L2 = Literal[2]
L3 = Literal[3]
L4 = Literal[4]

Shape1 = Tuple[int]
Shape2 = Tuple[int, int]
Shape3 = Tuple[int, int, int]
Shape4 = Tuple[int, int, int, int]
Shape5 = Tuple[int, int, int, int, int]
# END: tensor_annotations annotations

from typing import Any

def __getattr__(name) -> Any: ...

_HAS_DYNAMIC_ATTRIBUTES = True


# BEGIN: tensor_annotations annotations for abs(...)
@overload
def abs(x: Tensor0, name=...) -> Tensor0: ...

@overload
def abs(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def abs(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def abs(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def abs(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def abs(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def abs(x, name=...) -> Any: ...
# END: tensor_annotations annotations for abs(...)

def accumulate_n(inputs, shape=..., tensor_dtype=..., name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for acos(...)
@overload
def acos(x: Tensor0, name=...) -> Tensor0: ...

@overload
def acos(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def acos(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def acos(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def acos(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def acos(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def acos(x, name=...) -> Any: ...
# END: tensor_annotations annotations for acos(...)


# BEGIN: tensor_annotations annotations for acosh(...)
@overload
def acosh(x: Tensor0, name=...) -> Tensor0: ...

@overload
def acosh(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def acosh(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def acosh(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def acosh(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def acosh(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def acosh(x, name=...) -> Any: ...
# END: tensor_annotations annotations for acosh(...)

def add(x, y, name=...) -> Any: ...
def add_n(inputs, name=...) -> Any: ...
def angle(input, name=...) -> Any: ...
def argmax(input, axis=..., output_type=..., name=...) -> Any: ...
def argmin(input, axis=..., output_type=..., name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for asin(...)
@overload
def asin(x: Tensor0, name=...) -> Tensor0: ...

@overload
def asin(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def asin(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def asin(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def asin(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def asin(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def asin(x, name=...) -> Any: ...
# END: tensor_annotations annotations for asin(...)


# BEGIN: tensor_annotations annotations for asinh(...)
@overload
def asinh(x: Tensor0, name=...) -> Tensor0: ...

@overload
def asinh(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def asinh(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def asinh(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def asinh(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def asinh(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def asinh(x, name=...) -> Any: ...
# END: tensor_annotations annotations for asinh(...)


# BEGIN: tensor_annotations annotations for atan(...)
@overload
def atan(x: Tensor0, name=...) -> Tensor0: ...

@overload
def atan(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def atan(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def atan(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def atan(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def atan(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def atan(x, name=...) -> Any: ...
# END: tensor_annotations annotations for atan(...)

def atan2(y, x, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for atanh(...)
@overload
def atanh(x: Tensor0, name=...) -> Tensor0: ...

@overload
def atanh(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def atanh(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def atanh(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def atanh(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def atanh(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def atanh(x, name=...) -> Any: ...
# END: tensor_annotations annotations for atanh(...)

def bessel_i0(x, name=...) -> Any: ...
def bessel_i0e(x, name=...) -> Any: ...
def bessel_i1(x, name=...) -> Any: ...
def bessel_i1e(x, name=...) -> Any: ...
def betainc(a, b, x, name=...) -> Any: ...
def bincount(arr, weights=..., minlength=..., maxlength=..., dtype=..., name=..., axis=..., binary_output=...) -> Any: ...
def ceil(x, name=...) -> Any: ...
def confusion_matrix(labels, predictions, num_classes=..., weights=..., dtype=..., name=...) -> Any: ...
def conj(x, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for cos(...)
@overload
def cos(x: Tensor0, name=...) -> Tensor0: ...

@overload
def cos(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def cos(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def cos(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def cos(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def cos(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def cos(x, name=...) -> Any: ...
# END: tensor_annotations annotations for cos(...)


# BEGIN: tensor_annotations annotations for cosh(...)
@overload
def cosh(x: Tensor0, name=...) -> Tensor0: ...

@overload
def cosh(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def cosh(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def cosh(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def cosh(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def cosh(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def cosh(x, name=...) -> Any: ...
# END: tensor_annotations annotations for cosh(...)

def count_nonzero(input, axis=..., keepdims=..., dtype=..., name=...) -> Any: ...
def cumprod(x, axis=..., exclusive=..., reverse=..., name=...) -> Any: ...
def cumsum(x, axis=..., exclusive=..., reverse=..., name=...) -> Any: ...
def cumulative_logsumexp(x, axis=..., exclusive=..., reverse=..., name=...) -> Any: ...
def digamma(x, name=...) -> Any: ...
def divide(x, y, name=...) -> Any: ...
def divide_no_nan(x, y, name=...) -> Any: ...
def equal(x, y, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for erf(...)
@overload
def erf(x: Tensor0, name=...) -> Tensor0: ...

@overload
def erf(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def erf(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def erf(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def erf(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def erf(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def erf(x, name=...) -> Any: ...
# END: tensor_annotations annotations for erf(...)


# BEGIN: tensor_annotations annotations for erfc(...)
@overload
def erfc(x: Tensor0, name=...) -> Tensor0: ...

@overload
def erfc(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def erfc(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def erfc(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def erfc(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def erfc(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def erfc(x, name=...) -> Any: ...
# END: tensor_annotations annotations for erfc(...)

def erfcinv(x, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for erfinv(...)
@overload
def erfinv(x: Tensor0, name=...) -> Tensor0: ...

@overload
def erfinv(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def erfinv(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def erfinv(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def erfinv(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def erfinv(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def erfinv(x, name=...) -> Any: ...
# END: tensor_annotations annotations for erfinv(...)


# BEGIN: tensor_annotations annotations for exp(...)
@overload
def exp(x: Tensor0, name=...) -> Tensor0: ...

@overload
def exp(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def exp(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def exp(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def exp(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def exp(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def exp(x, name=...) -> Any: ...
# END: tensor_annotations annotations for exp(...)


# BEGIN: tensor_annotations annotations for expm1(...)
@overload
def expm1(x: Tensor0, name=...) -> Tensor0: ...

@overload
def expm1(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def expm1(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def expm1(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def expm1(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def expm1(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def expm1(x, name=...) -> Any: ...
# END: tensor_annotations annotations for expm1(...)


# BEGIN: tensor_annotations annotations for floor(...)
@overload
def floor(x: Tensor0, name=...) -> Tensor0: ...

@overload
def floor(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def floor(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def floor(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def floor(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def floor(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def floor(x, name=...) -> Any: ...
# END: tensor_annotations annotations for floor(...)

def floordiv(x, y, name=...) -> Any: ...
def floormod(x, y, name=...) -> Any: ...
def greater(x, y, name=...) -> Any: ...
def greater_equal(x, y, name=...) -> Any: ...
def igamma(a, x, name=...) -> Any: ...
def igammac(a, x, name=...) -> Any: ...
def imag(input, name=...) -> Any: ...
def in_top_k(targets, predictions, k, name=...) -> Any: ...
def invert_permutation(x, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for is_finite(...)
@overload
def is_finite(x: Tensor0, name=...) -> Tensor0: ...

@overload
def is_finite(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def is_finite(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def is_finite(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def is_finite(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def is_finite(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def is_finite(x, name=...) -> Any: ...
# END: tensor_annotations annotations for is_finite(...)


# BEGIN: tensor_annotations annotations for is_inf(...)
@overload
def is_inf(x: Tensor0, name=...) -> Tensor0: ...

@overload
def is_inf(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def is_inf(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def is_inf(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def is_inf(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def is_inf(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def is_inf(x, name=...) -> Any: ...
# END: tensor_annotations annotations for is_inf(...)


# BEGIN: tensor_annotations annotations for is_nan(...)
@overload
def is_nan(x: Tensor0, name=...) -> Tensor0: ...

@overload
def is_nan(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def is_nan(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def is_nan(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def is_nan(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def is_nan(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def is_nan(x, name=...) -> Any: ...
# END: tensor_annotations annotations for is_nan(...)

def is_non_decreasing(x, name=...) -> Any: ...
def is_strictly_increasing(x, name=...) -> Any: ...
def l2_normalize(x, axis=..., epsilon=..., name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for lbeta(...)
@overload
def lbeta(x: Tensor0, name=...) -> Tensor0: ...

@overload
def lbeta(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def lbeta(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def lbeta(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def lbeta(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def lbeta(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def lbeta(x, name=...) -> Any: ...
# END: tensor_annotations annotations for lbeta(...)

def less(x, y, name=...) -> Any: ...
def less_equal(x, y, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for lgamma(...)
@overload
def lgamma(x: Tensor0, name=...) -> Tensor0: ...

@overload
def lgamma(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def lgamma(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def lgamma(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def lgamma(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def lgamma(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def lgamma(x, name=...) -> Any: ...
# END: tensor_annotations annotations for lgamma(...)


# BEGIN: tensor_annotations annotations for log(...)
@overload
def log(x: Tensor0, name=...) -> Tensor0: ...

@overload
def log(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def log(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def log(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def log(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def log(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def log(x, name=...) -> Any: ...
# END: tensor_annotations annotations for log(...)


# BEGIN: tensor_annotations annotations for log1p(...)
@overload
def log1p(x: Tensor0, name=...) -> Tensor0: ...

@overload
def log1p(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def log1p(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def log1p(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def log1p(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def log1p(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def log1p(x, name=...) -> Any: ...
# END: tensor_annotations annotations for log1p(...)


# BEGIN: tensor_annotations annotations for log_sigmoid(...)
@overload
def log_sigmoid(x: Tensor0, name=...) -> Tensor0: ...

@overload
def log_sigmoid(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def log_sigmoid(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def log_sigmoid(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def log_sigmoid(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def log_sigmoid(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def log_sigmoid(x, name=...) -> Any: ...
# END: tensor_annotations annotations for log_sigmoid(...)

def log_softmax(logits, axis=..., name=...) -> Any: ...
def logical_and(x, y, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for logical_not(...)
@overload
def logical_not(x: Tensor0, name=...) -> Tensor0: ...

@overload
def logical_not(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def logical_not(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def logical_not(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def logical_not(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def logical_not(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def logical_not(x, name=...) -> Any: ...
# END: tensor_annotations annotations for logical_not(...)

def logical_or(x, y, name=...) -> Any: ...
def logical_xor(x, y, name=...) -> Any: ...
def maximum(x, y, name=...) -> Any: ...
def minimum(x, y, name=...) -> Any: ...
def mod(x, y, name=...) -> Any: ...
def multiply(x, y, name=...) -> Any: ...
def multiply_no_nan(x, y, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for ndtri(...)
@overload
def ndtri(x: Tensor0, name=...) -> Tensor0: ...

@overload
def ndtri(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def ndtri(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def ndtri(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def ndtri(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def ndtri(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def ndtri(x, name=...) -> Any: ...
# END: tensor_annotations annotations for ndtri(...)


# BEGIN: tensor_annotations annotations for negative(...)
@overload
def negative(x: Tensor0, name=...) -> Tensor0: ...

@overload
def negative(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def negative(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def negative(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def negative(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def negative(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def negative(x, name=...) -> Any: ...
# END: tensor_annotations annotations for negative(...)

def nextafter(x1, x2, name=...) -> Any: ...
def not_equal(x, y, name=...) -> Any: ...
def polygamma(a, x, name=...) -> Any: ...
def polyval(coeffs, x, name=...) -> Any: ...
def pow(x, y, name=...) -> Any: ...
def real(input, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for reciprocal(...)
@overload
def reciprocal(x: Tensor0, name=...) -> Tensor0: ...

@overload
def reciprocal(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def reciprocal(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def reciprocal(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def reciprocal(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def reciprocal(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def reciprocal(x, name=...) -> Any: ...
# END: tensor_annotations annotations for reciprocal(...)


# BEGIN: tensor_annotations annotations for reciprocal_no_nan(...)
@overload
def reciprocal_no_nan(x: Tensor0, name=...) -> Tensor0: ...

@overload
def reciprocal_no_nan(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def reciprocal_no_nan(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def reciprocal_no_nan(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def reciprocal_no_nan(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def reciprocal_no_nan(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def reciprocal_no_nan(x, name=...) -> Any: ...
# END: tensor_annotations annotations for reciprocal_no_nan(...)

def reduce_all(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_any(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_euclidean_norm(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_logsumexp(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_max(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_mean(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_min(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_prod(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_std(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_sum(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...
def reduce_variance(input_tensor, axis=..., keepdims=..., name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for rint(...)
@overload
def rint(x: Tensor0, name=...) -> Tensor0: ...

@overload
def rint(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def rint(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def rint(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def rint(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def rint(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def rint(x, name=...) -> Any: ...
# END: tensor_annotations annotations for rint(...)


# BEGIN: tensor_annotations annotations for round(...)
@overload
def round(x: Tensor0, name=...) -> Tensor0: ...

@overload
def round(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def round(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def round(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def round(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def round(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def round(x, name=...) -> Any: ...
# END: tensor_annotations annotations for round(...)


# BEGIN: tensor_annotations annotations for rsqrt(...)
@overload
def rsqrt(x: Tensor0, name=...) -> Tensor0: ...

@overload
def rsqrt(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def rsqrt(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def rsqrt(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def rsqrt(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def rsqrt(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def rsqrt(x, name=...) -> Any: ...
# END: tensor_annotations annotations for rsqrt(...)

def scalar_mul(scalar, x, name=...) -> Any: ...
def segment_max(data, segment_ids, name=...) -> Any: ...
def segment_mean(data, segment_ids, name=...) -> Any: ...
def segment_min(data, segment_ids, name=...) -> Any: ...
def segment_prod(data, segment_ids, name=...) -> Any: ...
def segment_sum(data, segment_ids, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for sigmoid(...)
@overload
def sigmoid(x: Tensor0, name=...) -> Tensor0: ...

@overload
def sigmoid(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def sigmoid(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def sigmoid(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def sigmoid(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def sigmoid(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def sigmoid(x, name=...) -> Any: ...
# END: tensor_annotations annotations for sigmoid(...)


# BEGIN: tensor_annotations annotations for sign(...)
@overload
def sign(x: Tensor0, name=...) -> Tensor0: ...

@overload
def sign(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def sign(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def sign(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def sign(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def sign(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def sign(x, name=...) -> Any: ...
# END: tensor_annotations annotations for sign(...)


# BEGIN: tensor_annotations annotations for sin(...)
@overload
def sin(x: Tensor0, name=...) -> Tensor0: ...

@overload
def sin(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def sin(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def sin(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def sin(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def sin(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def sin(x, name=...) -> Any: ...
# END: tensor_annotations annotations for sin(...)


# BEGIN: tensor_annotations annotations for sinh(...)
@overload
def sinh(x: Tensor0, name=...) -> Tensor0: ...

@overload
def sinh(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def sinh(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def sinh(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def sinh(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def sinh(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def sinh(x, name=...) -> Any: ...
# END: tensor_annotations annotations for sinh(...)

def sobol_sample(dim, num_results, skip=..., dtype=..., name=...) -> Any: ...
def softmax(logits, axis=..., name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for softplus(...)
@overload
def softplus(x: Tensor0, name=...) -> Tensor0: ...

@overload
def softplus(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def softplus(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def softplus(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def softplus(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def softplus(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def softplus(x, name=...) -> Any: ...
# END: tensor_annotations annotations for softplus(...)


# BEGIN: tensor_annotations annotations for softsign(...)
@overload
def softsign(x: Tensor0, name=...) -> Tensor0: ...

@overload
def softsign(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def softsign(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def softsign(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def softsign(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def softsign(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def softsign(x, name=...) -> Any: ...
# END: tensor_annotations annotations for softsign(...)


# BEGIN: tensor_annotations annotations for sqrt(...)
@overload
def sqrt(x: Tensor0, name=...) -> Tensor0: ...

@overload
def sqrt(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def sqrt(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def sqrt(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def sqrt(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def sqrt(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def sqrt(x, name=...) -> Any: ...
# END: tensor_annotations annotations for sqrt(...)


# BEGIN: tensor_annotations annotations for square(...)
@overload
def square(x: Tensor0, name=...) -> Tensor0: ...

@overload
def square(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def square(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def square(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def square(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def square(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def square(x, name=...) -> Any: ...
# END: tensor_annotations annotations for square(...)

def squared_difference(x, y, name=...) -> Any: ...
def subtract(x, y, name=...) -> Any: ...

# BEGIN: tensor_annotations annotations for tan(...)
@overload
def tan(x: Tensor0, name=...) -> Tensor0: ...

@overload
def tan(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def tan(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def tan(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def tan(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def tan(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def tan(x, name=...) -> Any: ...
# END: tensor_annotations annotations for tan(...)


# BEGIN: tensor_annotations annotations for tanh(...)
@overload
def tanh(x: Tensor0, name=...) -> Tensor0: ...

@overload
def tanh(x: Tensor1[A1], name=...) -> Tensor1[A1]: ...

@overload
def tanh(x: Tensor2[A1, A2], name=...) -> Tensor2[A1, A2]: ...

@overload
def tanh(x: Tensor3[A1, A2, A3], name=...) -> Tensor3[A1, A2, A3]: ...

@overload
def tanh(x: Tensor4[A1, A2, A3, A4], name=...) -> Tensor4[A1, A2, A3, A4]: ...

@overload
def tanh(x: Tensor5[A1, A2, A3, A4, A5], name=...) -> Tensor5[A1, A2, A3, A4, A5]: ...

@overload
def tanh(x, name=...) -> Any: ...
# END: tensor_annotations annotations for tanh(...)

def top_k(input, k=..., sorted=..., name=...) -> Any: ...
def truediv(x, y, name=...) -> Any: ...
def unsorted_segment_max(data, segment_ids, num_segments, name=...) -> Any: ...
def unsorted_segment_mean(data, segment_ids, num_segments, name=...) -> Any: ...
def unsorted_segment_min(data, segment_ids, num_segments, name=...) -> Any: ...
def unsorted_segment_prod(data, segment_ids, num_segments, name=...) -> Any: ...
def unsorted_segment_sqrt_n(data, segment_ids, num_segments, name=...) -> Any: ...
def unsorted_segment_sum(data, segment_ids, num_segments, name=...) -> Any: ...
def xdivy(x, y, name=...) -> Any: ...
def xlog1py(x, y, name=...) -> Any: ...
def xlogy(x, y, name=...) -> Any: ...
def zero_fraction(value, name=...) -> Any: ...
def zeta(x, q, name=...) -> Any: ...