# Upper Bound Theorem 1


```python
import ema as em
import matplotlib.pyplot as plt
import numpy as np
%config InlineBackend.figure_format = 'svg' # used to make plots look nicerbb
```


```python
#Remove
mdl = em.Model(2,3)
n = mdl.dnodes
e = mdl.delems

mdl.node('1',  0.0, 0.0)
mdl.node('2',  6.0, 0.0)
mdl.node('3',  6.0, 4.0)
mdl.node('4', 12.0, 4.0)

mdl.beam('a', n['1'], n['2'])
mdl.beam('b', n['2'], n['3'])
mdl.beam('c', n['3'], n['4'])

mdl.fix(n['1'], ['x', 'y', 'rz'])
mdl.fix(n['4'], ['y'])

mdl.numDOF()
```




    [[9, 10, 11], [1, 2, 3], [4, 5, 6], [7, 12, 8]]




```python
# Define plastic capacity
e['a'].Qp['+']['1'] = e['a'].Qp['-']['1'] = 500
e['a'].Qp['+']['2'] = e['a'].Qp['-']['2'] = 200
e['a'].Qp['+']['3'] = e['a'].Qp['-']['3'] = 200
e['c'].Qp['+']['1'] = e['c'].Qp['-']['1'] = 500
e['c'].Qp['+']['2'] = e['c'].Qp['-']['2'] = 200
e['c'].Qp['+']['3'] = e['c'].Qp['-']['3'] = 200
e['b'].Qp['+']['1'] = e['b'].Qp['-']['1'] = 500
e['b'].Qp['+']['2'] = e['b'].Qp['-']['2'] = 240
e['b'].Qp['+']['3'] = e['b'].Qp['-']['3'] = 240
```


```python
em.analysis.characterize(mdl)
```




    (0, 1)




```python
fig, ax = plt.subplots(1,1)
em.plot_structure(mdl, ax)
```


![svg](output_5_0.svg)



```python
A = em.A_matrix(mdl)
A.f
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>$1$</th>
      <th>$2$</th>
      <th>$3$</th>
      <th>$4$</th>
      <th>$5$</th>
      <th>$6$</th>
      <th>$7$</th>
      <th>$8$</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>$a_1$</th>
      <td>1.00</td>
      <td>0.000000</td>
      <td>0.0</td>
      <td>0.00</td>
      <td>0.000000</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$a_2$</th>
      <td>0.00</td>
      <td>-0.166667</td>
      <td>0.0</td>
      <td>0.00</td>
      <td>0.000000</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$a_3$</th>
      <td>0.00</td>
      <td>-0.166667</td>
      <td>1.0</td>
      <td>0.00</td>
      <td>0.000000</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$b_1$</th>
      <td>-0.00</td>
      <td>-1.000000</td>
      <td>0.0</td>
      <td>0.00</td>
      <td>1.000000</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$b_2$</th>
      <td>-0.25</td>
      <td>0.000000</td>
      <td>1.0</td>
      <td>0.25</td>
      <td>-0.000000</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$b_3$</th>
      <td>-0.25</td>
      <td>0.000000</td>
      <td>0.0</td>
      <td>0.25</td>
      <td>-0.000000</td>
      <td>1.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$c_1$</th>
      <td>0.00</td>
      <td>0.000000</td>
      <td>0.0</td>
      <td>-1.00</td>
      <td>-0.000000</td>
      <td>0.0</td>
      <td>1.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$c_2$</th>
      <td>0.00</td>
      <td>0.000000</td>
      <td>0.0</td>
      <td>-0.00</td>
      <td>0.166667</td>
      <td>1.0</td>
      <td>0.0</td>
      <td>0.0</td>
    </tr>
    <tr>
      <th>$c_3$</th>
      <td>0.00</td>
      <td>0.000000</td>
      <td>0.0</td>
      <td>-0.00</td>
      <td>0.166667</td>
      <td>0.0</td>
      <td>0.0</td>
      <td>1.0</td>
    </tr>
  </tbody>
</table>



### Vertical mechanism


```python
n['3'].p['y'] = -30
n['3'].p['x'] =  0.
lambdac, Q = em.analysis.PlasticAnalysis_wLBT(mdl)
Q
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>$Q_{{}}$</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>$a_1$</th>
      <td>0.000000</td>
    </tr>
    <tr>
      <th>$a_2$</th>
      <td>200.000000</td>
    </tr>
    <tr>
      <th>$a_3$</th>
      <td>200.000000</td>
    </tr>
    <tr>
      <th>$b_1$</th>
      <td>-66.666667</td>
    </tr>
    <tr>
      <th>$b_2$</th>
      <td>-200.000000</td>
    </tr>
    <tr>
      <th>$b_3$</th>
      <td>200.000000</td>
    </tr>
    <tr>
      <th>$c_1$</th>
      <td>0.000000</td>
    </tr>
    <tr>
      <th>$c_2$</th>
      <td>-200.000000</td>
    </tr>
    <tr>
      <th>$c_3$</th>
      <td>0.000000</td>
    </tr>
  </tbody>
</table>




```python
lambdac
```




    3.3333333333333353



### Horizontal mechanism


```python
n['3'].p['y'] = 0
n['3'].p['x'] = 30
lambdac, Q = em.analysis.PlasticAnalysis_wLBT(mdl)
Q
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>$Q_{{}}$</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>$a_1$</th>
      <td>1.000000e+02</td>
    </tr>
    <tr>
      <th>$a_2$</th>
      <td>-4.800000e-13</td>
    </tr>
    <tr>
      <th>$a_3$</th>
      <td>-2.000000e+02</td>
    </tr>
    <tr>
      <th>$b_1$</th>
      <td>3.333333e+01</td>
    </tr>
    <tr>
      <th>$b_2$</th>
      <td>2.000000e+02</td>
    </tr>
    <tr>
      <th>$b_3$</th>
      <td>2.000000e+02</td>
    </tr>
    <tr>
      <th>$c_1$</th>
      <td>0.000000e+00</td>
    </tr>
    <tr>
      <th>$c_2$</th>
      <td>-2.000000e+02</td>
    </tr>
    <tr>
      <th>$c_3$</th>
      <td>0.000000e+00</td>
    </tr>
  </tbody>
</table>




```python
lambdac
```




    3.333333333333333



### Combined mechanism


```python
n['3'].p['y'] = -30
n['3'].p['x'] = 30
lambdac, Q = em.analysis.PlasticAnalysis_wLBT(mdl)
Q
```




<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>$Q_{{}}$</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>$a_1$</th>
      <td>60.000000</td>
    </tr>
    <tr>
      <th>$a_2$</th>
      <td>200.000000</td>
    </tr>
    <tr>
      <th>$a_3$</th>
      <td>-40.000000</td>
    </tr>
    <tr>
      <th>$b_1$</th>
      <td>-26.666667</td>
    </tr>
    <tr>
      <th>$b_2$</th>
      <td>40.000000</td>
    </tr>
    <tr>
      <th>$b_3$</th>
      <td>200.000000</td>
    </tr>
    <tr>
      <th>$c_1$</th>
      <td>0.000000</td>
    </tr>
    <tr>
      <th>$c_2$</th>
      <td>-200.000000</td>
    </tr>
    <tr>
      <th>$c_3$</th>
      <td>0.000000</td>
    </tr>
  </tbody>
</table>




```python
lambdac
```




    2.0000000000000018


