# Generated by Django 3.0.6 on 2020-05-27 22:33

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('comment', '0005_auto_20200521_1301'),
    ]

    operations = [
        migrations.CreateModel(
            name='Flag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('count', models.PositiveIntegerField(default=0)),
                ('state', models.SmallIntegerField(choices=[(1, 'flagged'), (2, 'flag rejected by moderator'), (3, 'creator notified'), (4, 'content removed by creator'), (5, 'content removed by owner')], default=1)),
                ('comment', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='comment.Comment')),
            ],
        ),
        migrations.CreateModel(
            name='FlagInstance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('info', models.TextField(blank=True, null=True)),
                ('date_flagged', models.DateTimeField(auto_now=True)),
                ('reason', models.SmallIntegerField(choices=[(1, 'Spam | Exists only to promote a service'), (2, 'Abusive | Intended at promoting hatred'), (100, 'Something else')], default=1)),
                ('flag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='flags', to='comment.Flag')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='flags', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('date_flagged',),
                'unique_together': {('flag', 'user')},
            },
        ),
    ]
