/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaserMediumEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaserMediumEnumHandler.class);
    private static final Hashtable<String, String> patterns = LaserMediumEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Cu\\s*", "Cu");
        p.put("^\\s*Ag\\s*", "Ag");
        p.put("^\\s*ArFl\\s*", "ArFl");
        p.put("^\\s*ArCl\\s*", "ArCl");
        p.put("^\\s*KrFl\\s*", "KrFl");
        p.put("^\\s*KrCl\\s*", "KrCl");
        p.put("^\\s*XeFl\\s*", "XeFl");
        p.put("^\\s*XeCl\\s*", "XeCl");
        p.put("^\\s*XeBr\\s*", "XeBr");
        p.put("^\\s*N\\s*", "N");
        p.put("^\\s*Ar\\s*", "Ar");
        p.put("^\\s*Kr\\s*", "Kr");
        p.put("^\\s*Xe\\s*", "Xe");
        p.put("^\\s*HeNe\\s*", "HeNe");
        p.put("^\\s*HeCd\\s*", "HeCd");
        p.put("^\\s*CO\\s*", "CO");
        p.put("^\\s*CO2\\s*", "CO2");
        p.put("^\\s*H2O\\s*", "H2O");
        p.put("^\\s*HFl\\s*", "HFl");
        p.put("^\\s*NdGlass\\s*", "NdGlass");
        p.put("^\\s*NdYAG\\s*", "NdYAG");
        p.put("^\\s*ErGlass\\s*", "ErGlass");
        p.put("^\\s*ErYAG\\s*", "ErYAG");
        p.put("^\\s*HoYLF\\s*", "HoYLF");
        p.put("^\\s*HoYAG\\s*", "HoYAG");
        p.put("^\\s*Ruby\\s*", "Ruby");
        p.put("^\\s*TiSapphire\\s*", "TiSapphire");
        p.put("^\\s*Alexandrite\\s*", "Alexandrite");
        p.put("^\\s*Rhodamine6G\\s*", "Rhodamine6G");
        p.put("^\\s*CoumarinC30\\s*", "CoumarinC30");
        p.put("^\\s*GaAs\\s*", "GaAs");
        p.put("^\\s*GaAlAs\\s*", "GaAlAs");
        p.put("^\\s*EMinus\\s*", "EMinus");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return LaserMedium.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"LaserMedium", (Object)value);
        return LaserMedium.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return LaserMedium.class;
    }
}

