# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mkgendocs']

package_data = \
{'': ['*']}

install_requires = \
['astor', 'mako', 'pyyaml', 'six']

entry_points = \
{'console_scripts': ['gendocs = mkgendocs.gendocs:main']}

setup_kwargs = {
    'name': 'mkgendocs',
    'version': '0.7',
    'description': 'mkgendocs is a Python tool to automate the generation of documentation from docstrings in markdown',
    'long_description': '## mkgendocs\nA Python package for automatically generating documentation pages in markdown for \nPython source files by parsing **Google style docstring**. The markdown output makes it\nideal to combine with [mkdocs](https://www.mkdocs.org/). \n\nInstead of executing the python code (using the `inspect` package to access signatures and docstrings), we extract the information directly from the source files by parsing them into Abstract Syntax Trees (AST) using the `ast` package. \n\nThe `astor` (AST observe/rewrite) package is also used to convert function or class signatures from AST nodes back into source code strings.\n \n![mkgendocs](mkgendocs.png)\n\n## Installation\nInstall mkgendocs from [PyPI](https://pypi.org/project/mkgendocs/)\n\n```python\npip install mkgendocs\n```\n\n## Usage\n\n```\ngendocs --config mkgendocs.yml\n```\n\nA sources directory is created with the documentation that was automatically generated.\nAny examples in a "examples" directory are automatically copied over to the documentation, \nthe module level docstrings of any example source files are also copied and converted to markdown. \n\n\n### Configuration Example\n\n````yaml\nsources_dir: docs/sources\ntemplates_dir: docs/templates\n\npages:\n  - page: "train/model.md"\n    source: "tensorx/train/model.py"\n    methods:\n      - Model:\n          - train\n          - set_optimizer\n  - page: "layers/core.md"\n    source: \'tensorx/layers.py\'\n    classes:\n      - Linear\n      - Module\n  - page: "math.md"\n    source: \'tensorx/math.py\'\n    functions:\n      - sparse_multiply_dense\n````\n\n* **sources_dir**: directory where the resulting markdown files are created\n* **templates_dir**: directory where template files can be stored. All the folders and files are \ncopied to the sources directory. Any markdown files are used as templates with the \ntag `{{autogenerated}}` in the template files being replaced by the generated documentation.\n* **pages**: list of pages to be automatically generated from the respective source files and templates:\n    * **page**: path for page template / sources dir for the resulting page;\n    * **source**: path to source file from which the page is to be genrated;\n    * **methods**: list of class to method name dictionaries;\n    * **classes**: list of classes to be fully documented;\n    * **functions**: list of functions to be documented.\n\n## Buy me a coffee\nIf you find any of this useful, consider getting me some coffee, coffee is great!\n<br/><br/>\n<a href=\'https://ko-fi.com/Y8Y0RZO6\' target=\'_blank\'><img height=\'36\' style=\'border:0px;height:36px;\' src=\'https://az743702.vo.msecnd.net/cdn/kofi3.png?v=0\' border=\'0\' alt=\'Buy Me a Coffee at ko-fi.com\' /></a>\n',
    'author': 'Davide Nunes',
    'author_email': 'davidelnunes@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/davidenunes/mkgendocs',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
