"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BashExecFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @stability stable
 */
class BashExecFunction extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        if ((props === null || props === void 0 ? void 0 : props.dockerfile) && fs.existsSync(props === null || props === void 0 ? void 0 : props.dockerfile)) {
            // Copy your Dockerfile to Dockerfile.custom.
            fs.copyFileSync(props === null || props === void 0 ? void 0 : props.dockerfile, path.join(__dirname, '../docker.d/Dockerfile.custom'));
        }
        const dockerDirPath = path.join(__dirname, '../docker.d');
        const scriptPath = props.script;
        // copy the user script to the docker.d directory as main.sh so we can bundle it up into a new docker image
        const mainFile = path.join(dockerDirPath, '/main.sh');
        fs.copyFileSync(scriptPath, mainFile);
        this.handler = new lambda.DockerImageFunction(this, 'BashExecFunction', {
            code: lambda.DockerImageCode.fromImageAsset(dockerDirPath, {
                file: (props === null || props === void 0 ? void 0 : props.dockerfile) && fs.existsSync(props === null || props === void 0 ? void 0 : props.dockerfile) ? 'Dockerfile.custom' : undefined,
            }),
            timeout: (_b = props.timeout) !== null && _b !== void 0 ? _b : core_1.Duration.seconds(60),
            logRetention: logs.RetentionDays.ONE_DAY,
            environment: props.environment,
            role: props.role,
        });
        new core_1.CfnOutput(this, 'LogGroup', { value: this.handler.logGroup.logGroupName });
    }
    /**
     * @stability stable
     */
    run(ops = {}) {
        const onEvent = new lambda.DockerImageFunction(this, 'OnEventHandler', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../docker.d'), {
                cmd: ['function.sh.onEvent'],
            }),
            environment: {
                LAMBDA_FUNCTION_ARN: this.handler.functionArn,
            },
            timeout: core_1.Duration.seconds(60),
        });
        const myProvider = new cr.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
        });
        const staging = new core_1.AssetStaging(this, 'Staging', {
            sourcePath: path.join(__dirname, '../docker.d'),
        });
        const resource = new core_1.CustomResource(this, 'RunLambdaBash', {
            resourceType: 'Custom::RunLambdaBash',
            serviceToken: myProvider.serviceToken,
            properties: {
                assetHash: ops.runOnUpdate ? staging.assetHash : undefined,
            },
        });
        this.handler.grantInvoke(onEvent.grantPrincipal);
        return resource;
    }
}
exports.BashExecFunction = BashExecFunction;
_a = JSII_RTTI_SYMBOL_1;
BashExecFunction[_a] = { fqn: "cdk-lambda-bash.BashExecFunction", version: "0.5.149" };
//# sourceMappingURL=data:application/json;base64,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