from setuptools import setup, Extension
from Cython.Build import cythonize
import numpy

extensions = [
    Extension('covid19_model.models', sources=['covid19_model/models.pyx'], include_dirs=[numpy.get_include()], define_macros=[("NPY_NO_DEPRECATED_API", "NPY_1_7_API_VERSION")]),
    Extension('covid19_model.solver', sources=['covid19_model/solver.pyx'], include_dirs=[numpy.get_include()], define_macros=[("NPY_NO_DEPRECATED_API", "NPY_1_7_API_VERSION")])
]

setup(
    ext_modules=cythonize(extensions, language_level=3),
    include_package_data=True
)
