# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Pipeline']


class Pipeline(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 docker: Optional[pulumi.Input[pulumi.InputType['DockerExecutorArgs']]] = None,
                 input_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineParameterArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineParameterArgs']]]]] = None,
                 pipeline_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[pulumi.InputType['PipelineResourcesArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a pipeline that can be run later. Create takes a Pipeline that has all fields other than `pipelineId` populated, and then returns the same pipeline with `pipelineId` populated. This id can be used to run the pipeline. Caller must have WRITE permission to the project.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: User-specified description.
        :param pulumi.Input[pulumi.InputType['DockerExecutorArgs']] docker: Specifies the docker run information.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineParameterArgs']]]] input_parameters: Input parameters of the pipeline.
        :param pulumi.Input[str] name: Required. A user specified pipeline name that does not have to be unique. This name can be used for filtering Pipelines in ListPipelines.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineParameterArgs']]]] output_parameters: Output parameters of the pipeline.
        :param pulumi.Input[str] pipeline_id: Unique pipeline id that is generated by the service when CreatePipeline is called. Cannot be specified in the Pipeline used in the CreatePipelineRequest, and will be populated in the response to CreatePipeline and all subsequent Get and List calls. Indicates that the service has registered this pipeline.
        :param pulumi.Input[str] project_id: Required. The project in which to create the pipeline. The caller must have WRITE access.
        :param pulumi.Input[pulumi.InputType['PipelineResourcesArgs']] resources: Required. Specifies resource requirements for the pipeline run. Required fields: * minimumCpuCores * minimumRamGb
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['docker'] = docker
            __props__['input_parameters'] = input_parameters
            __props__['name'] = name
            __props__['output_parameters'] = output_parameters
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__['pipeline_id'] = pipeline_id
            __props__['project_id'] = project_id
            __props__['resources'] = resources
        super(Pipeline, __self__).__init__(
            'gcp-native:genomics/v1alpha2:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = None
        __props__["docker"] = None
        __props__["input_parameters"] = None
        __props__["name"] = None
        __props__["output_parameters"] = None
        __props__["pipeline_id"] = None
        __props__["project_id"] = None
        __props__["resources"] = None
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        User-specified description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def docker(self) -> pulumi.Output['outputs.DockerExecutorResponse']:
        """
        Specifies the docker run information.
        """
        return pulumi.get(self, "docker")

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> pulumi.Output[Sequence['outputs.PipelineParameterResponse']]:
        """
        Input parameters of the pipeline.
        """
        return pulumi.get(self, "input_parameters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Required. A user specified pipeline name that does not have to be unique. This name can be used for filtering Pipelines in ListPipelines.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputParameters")
    def output_parameters(self) -> pulumi.Output[Sequence['outputs.PipelineParameterResponse']]:
        """
        Output parameters of the pipeline.
        """
        return pulumi.get(self, "output_parameters")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[str]:
        """
        Unique pipeline id that is generated by the service when CreatePipeline is called. Cannot be specified in the Pipeline used in the CreatePipelineRequest, and will be populated in the response to CreatePipeline and all subsequent Get and List calls. Indicates that the service has registered this pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Required. The project in which to create the pipeline. The caller must have WRITE access.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output['outputs.PipelineResourcesResponse']:
        """
        Required. Specifies resource requirements for the pipeline run. Required fields: * minimumCpuCores * minimumRamGb
        """
        return pulumi.get(self, "resources")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

