# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Registration']


class Registration(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 contact_settings: Optional[pulumi.Input[pulumi.InputType['ContactSettingsArgs']]] = None,
                 dns_settings: Optional[pulumi.Input[pulumi.InputType['DnsSettingsArgs']]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 management_settings: Optional[pulumi.Input[pulumi.InputType['ManagementSettingsArgs']]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 registrations_id: Optional[pulumi.Input[str]] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None,
                 yearly_price: Optional[pulumi.Input[pulumi.InputType['MoneyArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Registers a new domain name and creates a corresponding `Registration` resource. Call `RetrieveRegisterParameters` first to check availability of the domain name and determine parameters like price that are needed to build a call to this method. A successful call creates a `Registration` resource in state `REGISTRATION_PENDING`, which resolves to `ACTIVE` within 1-2 minutes, indicating that the domain was successfully registered. If the resource ends up in state `REGISTRATION_FAILED`, it indicates that the domain was not registered successfully, and you can safely delete the resource and retry registration.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_notices: The list of contact notices that the caller acknowledges. The notices needed here depend on the values specified in `registration.contact_settings`.
        :param pulumi.Input[pulumi.InputType['ContactSettingsArgs']] contact_settings: Required. Settings for contact information linked to the `Registration`. You cannot update these with the `UpdateRegistration` method. To update these settings, use the `ConfigureContactSettings` method.
        :param pulumi.Input[pulumi.InputType['DnsSettingsArgs']] dns_settings: Settings controlling the DNS configuration of the `Registration`. You cannot update these with the `UpdateRegistration` method. To update these settings, use the `ConfigureDnsSettings` method.
        :param pulumi.Input[str] domain_name: Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_notices: The list of domain notices that you acknowledge. Call `RetrieveRegisterParameters` to see the notices that need acknowledgement.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of labels associated with the `Registration`.
        :param pulumi.Input[pulumi.InputType['ManagementSettingsArgs']] management_settings: Settings for management of the `Registration`, including renewal, billing, and transfer. You cannot update these with the `UpdateRegistration` method. To update these settings, use the `ConfigureManagementSettings` method.
        :param pulumi.Input[bool] validate_only: When true, only validation will be performed, without actually registering the domain. Follows: https://cloud.google.com/apis/design/design_patterns#request_validation
        :param pulumi.Input[pulumi.InputType['MoneyArgs']] yearly_price: Required. Yearly price to register or renew the domain. The value that should be put here can be obtained from RetrieveRegisterParameters or SearchDomains calls.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['contact_notices'] = contact_notices
            __props__['contact_settings'] = contact_settings
            __props__['dns_settings'] = dns_settings
            __props__['domain_name'] = domain_name
            __props__['domain_notices'] = domain_notices
            __props__['labels'] = labels
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__['locations_id'] = locations_id
            __props__['management_settings'] = management_settings
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            if registrations_id is None and not opts.urn:
                raise TypeError("Missing required property 'registrations_id'")
            __props__['registrations_id'] = registrations_id
            __props__['validate_only'] = validate_only
            __props__['yearly_price'] = yearly_price
            __props__['create_time'] = None
            __props__['expire_time'] = None
            __props__['issues'] = None
            __props__['name'] = None
            __props__['pending_contact_settings'] = None
            __props__['state'] = None
            __props__['supported_privacy'] = None
        super(Registration, __self__).__init__(
            'gcp-native:domains/v1beta1:Registration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Registration':
        """
        Get an existing Registration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["contact_settings"] = None
        __props__["create_time"] = None
        __props__["dns_settings"] = None
        __props__["domain_name"] = None
        __props__["expire_time"] = None
        __props__["issues"] = None
        __props__["labels"] = None
        __props__["management_settings"] = None
        __props__["name"] = None
        __props__["pending_contact_settings"] = None
        __props__["state"] = None
        __props__["supported_privacy"] = None
        return Registration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contactSettings")
    def contact_settings(self) -> pulumi.Output['outputs.ContactSettingsResponse']:
        """
        Required. Settings for contact information linked to the `Registration`. You cannot update these with the `UpdateRegistration` method. To update these settings, use the `ConfigureContactSettings` method.
        """
        return pulumi.get(self, "contact_settings")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation timestamp of the `Registration` resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> pulumi.Output['outputs.DnsSettingsResponse']:
        """
        Settings controlling the DNS configuration of the `Registration`. You cannot update these with the `UpdateRegistration` method. To update these settings, use the `ConfigureDnsSettings` method.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[str]:
        """
        The expiration timestamp of the `Registration`.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def issues(self) -> pulumi.Output[Sequence[str]]:
        """
        The set of issues with the `Registration` that require attention.
        """
        return pulumi.get(self, "issues")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Set of labels associated with the `Registration`.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="managementSettings")
    def management_settings(self) -> pulumi.Output['outputs.ManagementSettingsResponse']:
        """
        Settings for management of the `Registration`, including renewal, billing, and transfer. You cannot update these with the `UpdateRegistration` method. To update these settings, use the `ConfigureManagementSettings` method.
        """
        return pulumi.get(self, "management_settings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the `Registration` resource, in the format `projects/*/locations/*/registrations/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pendingContactSettings")
    def pending_contact_settings(self) -> pulumi.Output['outputs.ContactSettingsResponse']:
        """
        Pending contact settings for the `Registration`. Updates to the `contact_settings` field that change its `registrant_contact` or `privacy` fields require email confirmation by the `registrant_contact` before taking effect. This field is set only if there are pending updates to the `contact_settings` that have not yet been confirmed. To confirm the changes, the `registrant_contact` must follow the instructions in the email they receive.
        """
        return pulumi.get(self, "pending_contact_settings")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the `Registration`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportedPrivacy")
    def supported_privacy(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of options for the `contact_settings.privacy` field that this `Registration` supports.
        """
        return pulumi.get(self, "supported_privacy")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

