# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['AgentTestCase']


class AgentTestCase(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agents_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 last_test_result: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowCxV3beta1TestCaseResultArgs']]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 test_case_conversation_turns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowCxV3beta1ConversationTurnArgs']]]]] = None,
                 test_cases_id: Optional[pulumi.Input[str]] = None,
                 test_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowCxV3beta1TestConfigArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a test case for the given agent.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Required. The human-readable name of the test case, unique within the agent. Limit of 200 characters.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowCxV3beta1TestCaseResultArgs']] last_test_result: The latest test result.
        :param pulumi.Input[str] name: The unique identifier of the test case. TestCases.CreateTestCase will populate the name automatically. Otherwise use format: `projects//locations//agents/ /testCases/`.
        :param pulumi.Input[str] notes: Additional freeform notes about the test case. Limit of 400 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags are short descriptions that users may apply to test cases for organizational and filtering purposes. Each tag should start with "#" and has a limit of 30 characters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowCxV3beta1ConversationTurnArgs']]]] test_case_conversation_turns: The conversation turns uttered when the test case was created, in chronological order. These include the canonical set of agent utterances that should occur when the agent is working properly.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowCxV3beta1TestConfigArgs']] test_config: Config for the test case.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if agents_id is None and not opts.urn:
                raise TypeError("Missing required property 'agents_id'")
            __props__['agents_id'] = agents_id
            __props__['display_name'] = display_name
            __props__['last_test_result'] = last_test_result
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__['locations_id'] = locations_id
            __props__['name'] = name
            __props__['notes'] = notes
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            __props__['tags'] = tags
            __props__['test_case_conversation_turns'] = test_case_conversation_turns
            if test_cases_id is None and not opts.urn:
                raise TypeError("Missing required property 'test_cases_id'")
            __props__['test_cases_id'] = test_cases_id
            __props__['test_config'] = test_config
            __props__['creation_time'] = None
        super(AgentTestCase, __self__).__init__(
            'gcp-native:dialogflow/v3beta1:AgentTestCase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AgentTestCase':
        """
        Get an existing AgentTestCase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["creation_time"] = None
        __props__["display_name"] = None
        __props__["last_test_result"] = None
        __props__["name"] = None
        __props__["notes"] = None
        __props__["tags"] = None
        __props__["test_case_conversation_turns"] = None
        __props__["test_config"] = None
        return AgentTestCase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        When the test was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Required. The human-readable name of the test case, unique within the agent. Limit of 200 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="lastTestResult")
    def last_test_result(self) -> pulumi.Output['outputs.GoogleCloudDialogflowCxV3beta1TestCaseResultResponse']:
        """
        The latest test result.
        """
        return pulumi.get(self, "last_test_result")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique identifier of the test case. TestCases.CreateTestCase will populate the name automatically. Otherwise use format: `projects//locations//agents/ /testCases/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[str]:
        """
        Additional freeform notes about the test case. Limit of 400 characters.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Tags are short descriptions that users may apply to test cases for organizational and filtering purposes. Each tag should start with "#" and has a limit of 30 characters.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="testCaseConversationTurns")
    def test_case_conversation_turns(self) -> pulumi.Output[Sequence['outputs.GoogleCloudDialogflowCxV3beta1ConversationTurnResponse']]:
        """
        The conversation turns uttered when the test case was created, in chronological order. These include the canonical set of agent utterances that should occur when the agent is working properly.
        """
        return pulumi.get(self, "test_case_conversation_turns")

    @property
    @pulumi.getter(name="testConfig")
    def test_config(self) -> pulumi.Output['outputs.GoogleCloudDialogflowCxV3beta1TestConfigResponse']:
        """
        Config for the test case.
        """
        return pulumi.get(self, "test_config")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

