# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Agent']


class Agent(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agents_id: Optional[pulumi.Input[str]] = None,
                 avatar_uri: Optional[pulumi.Input[str]] = None,
                 default_language_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[bool]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input[str]] = None,
                 speech_to_text_settings: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowCxV3SpeechToTextSettingsArgs']]] = None,
                 start_flow: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an agent in the specified location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] avatar_uri: The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted [Web Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo) integration.
        :param pulumi.Input[str] default_language_code: Immutable. The default language of the agent as a language tag. See [Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list of the currently supported language codes. This field cannot be set by the Agents.UpdateAgent method.
        :param pulumi.Input[str] description: The description of the agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[str] display_name: Required. The human-readable name of the agent, unique within the location.
        :param pulumi.Input[bool] enable_spell_correction: Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[bool] enable_stackdriver_logging: Indicates if stackdriver logging is enabled for the agent.
        :param pulumi.Input[str] name: The unique identifier of the agent. Required for the Agents.UpdateAgent method. Agents.CreateAgent populates the name automatically. Format: `projects//locations//agents/`.
        :param pulumi.Input[str] security_settings: Name of the SecuritySettings reference for the agent. Format: `projects//locations//securitySettings/`.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowCxV3SpeechToTextSettingsArgs']] speech_to_text_settings: Speech recognition related settings.
        :param pulumi.Input[str] start_flow: Immutable. Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: `projects//locations//agents//flows/`.
        :param pulumi.Input[str] time_zone: Required. The time zone of the agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if agents_id is None and not opts.urn:
                raise TypeError("Missing required property 'agents_id'")
            __props__['agents_id'] = agents_id
            __props__['avatar_uri'] = avatar_uri
            __props__['default_language_code'] = default_language_code
            __props__['description'] = description
            __props__['display_name'] = display_name
            __props__['enable_spell_correction'] = enable_spell_correction
            __props__['enable_stackdriver_logging'] = enable_stackdriver_logging
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__['locations_id'] = locations_id
            __props__['name'] = name
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            __props__['security_settings'] = security_settings
            __props__['speech_to_text_settings'] = speech_to_text_settings
            __props__['start_flow'] = start_flow
            __props__['time_zone'] = time_zone
        super(Agent, __self__).__init__(
            'gcp-native:dialogflow/v3:Agent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Agent':
        """
        Get an existing Agent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["avatar_uri"] = None
        __props__["default_language_code"] = None
        __props__["description"] = None
        __props__["display_name"] = None
        __props__["enable_spell_correction"] = None
        __props__["enable_stackdriver_logging"] = None
        __props__["name"] = None
        __props__["security_settings"] = None
        __props__["speech_to_text_settings"] = None
        __props__["start_flow"] = None
        __props__["time_zone"] = None
        return Agent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="avatarUri")
    def avatar_uri(self) -> pulumi.Output[str]:
        """
        The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted [Web Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo) integration.
        """
        return pulumi.get(self, "avatar_uri")

    @property
    @pulumi.getter(name="defaultLanguageCode")
    def default_language_code(self) -> pulumi.Output[str]:
        """
        Immutable. The default language of the agent as a language tag. See [Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list of the currently supported language codes. This field cannot be set by the Agents.UpdateAgent method.
        """
        return pulumi.get(self, "default_language_code")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Required. The human-readable name of the agent, unique within the location.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> pulumi.Output[bool]:
        """
        Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> pulumi.Output[bool]:
        """
        Indicates if stackdriver logging is enabled for the agent.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique identifier of the agent. Required for the Agents.UpdateAgent method. Agents.CreateAgent populates the name automatically. Format: `projects//locations//agents/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Output[str]:
        """
        Name of the SecuritySettings reference for the agent. Format: `projects//locations//securitySettings/`.
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="speechToTextSettings")
    def speech_to_text_settings(self) -> pulumi.Output['outputs.GoogleCloudDialogflowCxV3SpeechToTextSettingsResponse']:
        """
        Speech recognition related settings.
        """
        return pulumi.get(self, "speech_to_text_settings")

    @property
    @pulumi.getter(name="startFlow")
    def start_flow(self) -> pulumi.Output[str]:
        """
        Immutable. Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: `projects//locations//agents//flows/`.
        """
        return pulumi.get(self, "start_flow")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        Required. The time zone of the agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
        """
        return pulumi.get(self, "time_zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

